SHINKEN.TOOLS.TEST_AUTO_UI_VISU_WIDGET_SLA = (function ( self ) {
    self.DOM                       = {};
    self.TEST                      = {};
    self.ACTION                    = {};
    self.CONST                     = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getWeekDetailPercents = function ( widget_id ) {
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_WIDGET.DOM.getWidget( widget_id ).querySelectorAll( ".td-sla-widget .graph-container-table .shinken-week-detail-td .week-detail-percent-container" );
    };
    self.DOM.getWeekNoDataIcon     = function ( widget_id ) {
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_WIDGET.DOM.getWidget( widget_id ).querySelector( ".week .shinken-no-data-cell" );
    };
    self.DOM.getTodayNoDataIcon    = function ( widget_id ) {
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_WIDGET.DOM.getWidget( widget_id ).querySelector( ".day .shinken-percent-no-data-cell" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.dataDetailForWeek     = function ( timeout, widget_id, data_for_week ) {
        setTimeout( function () {
            var _sla_details = self.DOM.getWeekDetailPercents( widget_id );
            for ( var i = 0; i < _sla_details.length; i++ ) {
                switch ( data_for_week[ i ] ) {
                    case null:
                        if ( !_sla_details[ i ].querySelector( ".week-detail-percent-no-data" ) ) {
                            SHINKEN.TOOLS.TEST_AUTO.addError( "There is data in the SLA for the day " + (i + 1), data_for_week[ i ] );
                        }
                        break;
                    default:
                        if ( _sla_details[ i ].querySelector( ".week-detail-percent-no-data" ) ) {
                            SHINKEN.TOOLS.TEST_AUTO.addError( "There is data in the SLA for the day " + (i + 1), data_for_week[ i ] );
                        }
                        break;
                }
            }
        }, timeout );
        return 200;
    };
    self.TEST.hasIconNoDataForWeek  = function ( timeout, widget_id, inverted ) {
        setTimeout( function () {
            if ( inverted ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.DOM.getWeekNoDataIcon( widget_id ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.getWeekNoDataIcon( widget_id ) );
            }
        }, timeout );
        return 200;
    };
    self.TEST.hasIconNoDataForToday = function ( timeout, widget_id, inverted ) {
        setTimeout( function () {
            if ( inverted ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.DOM.getTodayNoDataIcon( widget_id ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.getTodayNoDataIcon( widget_id ) );
            }
        }, timeout );
        return 200;
    };
    //********************************************  ACTION   **************************************************//
    
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_WIDGET_SLA || {} );

