//__lib__ lib_common
'use strict';

COMPONENT.InterfaceListSelect_V2           = function () {
};
COMPONENT.InterfaceListSelect_V2.prototype = {
    init: function () {
    },
    //***********************************************   GETTER SETTER   ****************************************************//
    setState   : function ( state ) {
        this.state = state;
        return this.state;
    },
    toggleState: function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceListSelect_V2, SHINKEN.OBJECT.ShinkenObjectContainerHtml );

COMPONENT.ListSelectFromData_V2           = function () {
    this.init();
};
COMPONENT.ListSelectFromData_V2.prototype = {
    init: function () {
        this.initContents();
        this.state = COMPONENT.CONST.BTN_STATE.OFF;
    },
    //***********************************************   GETTER SETTER   ****************************************************//
    addFromString: function ( key_name, label ) {
        var _to_return = new COMPONENT.ListSelectElementFromData_V2( key_name, label );
        this.add( _to_return );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-select" } ) );
        this.dom_element_select_content = DOM.Service.createElement( "div", { class: "list-select-content shinken-user-select-none" } );
        this.addDomElement( this.dom_element_select_content );
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            _current.computeHtml();
            DOM.Service.addElementTo( _current.getDomElement(), this.dom_element_select_content );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ListSelectFromData_V2, COMPONENT.InterfaceListSelect_V2 );