'use strict';

SHINKEN_LIST.SetFromDataWithPagination           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromDataWithPagination.prototype = {
    init               : function () {
    },
    setPagination      : function ( to_set ) {
        this.pagination = to_set;
    },
    setPageSize        : function ( to_set ) {
        this.pagination.setPageSize( to_set );
    },
    computeSpecificHtml: function () {
        this.pagination.setTotalElement( this.lines.getSize() );
        this.pagination.computeHtml();
        this.addDomElement( this.pagination.getDomElement() );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionBefore      : function ( event_name, param ) {
    },
    doActionAfter      : function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_item_selector":
                if ( param.specific_event_name === "pagination_click_on_selector" ) {
                    this.pagination.doActionAfter( event_name, param );
                    this.computeLinesHtml();
                }
                break;
            default:
                this._doActionAfter( event_name, param );
                break;
        }
    },
    applyFilter        : function () {
        var _filters_active = this.filters.getActiveFilters();
        this.doActionBefore("apply_filter", _filters_active)
        this.lines.applyFilter( _filters_active );
        this.pagination.setTotalElement( this.lines.getSizeNotFiltered() );
        this.computeLinesHtml();
        this.setSelectAllStatus();
    },
    clickOnSelector    : function ( event, param ) {
        switch ( param ) {
            case "pagination_click_on_selector":
                this.pagination.clickOnSelector( event, param );
                break;
            default:
                this._clickOnSelector( event, param );
                break;
        }
    },
    clickOnItemSelector: function ( event, parent_name, element ) {
        if ( element ) {
            this.pagination.clickOnItemSelector( element.dataset.keyName, this );
        }
        this._clickOnItemSelector( event, parent_name, element );
    },
    onClick            : function ( event ) {
        this.pagination.onClick( event );
        this._onClick( event );
    },
    //********************************************  HTML  *****************************************************//
    computeLinesHtml: function () {
        this.lines.computeHtml( this.pagination );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithPagination, SHINKEN_LIST.SetFromDataWithFixHeaderFilter );
