//priority 21
//__lib__ lib_common
'use strict';


SHINKEN.OBJECT.Dropdown = {};

SHINKEN.OBJECT.Dropdown._interface           = function () {
};
SHINKEN.OBJECT.Dropdown._interface.prototype = {
    init: function ( dom_element_target, dom_element_content, placement ) {
        this.initPhase();
        this.dom_element_target  = dom_element_target;
        this.dom_element_content = dom_element_content;
        this.placement           = placement || SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
        this.uuid                = SHINKEN.TOOLS.STRING.buildUUID();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID  : function () {
        return this.uuid;
    },
    getMaxTry: function () {
        return SHINKEN.OBJECT.Dropdown.CONST.MAX_TRY_IN_SCREEN;
    },
    getClass : function () {
        return "shinken-dropdown-container";
    },
    show     : function () {
        if ( !this.getDomElement() ) {
            this.initDomElement();
        }
        this._show();
        
    },
    _show    : function () {
        this.try = 0;
        this.getSize();
        this.setPosition();
    },
    
    initDomElement: function () {
        this.setDomElement( DOM.Service.createElement( "div", { "id": this.getUUID(), "class": this.getClass() }, SHINKEN.OBJECT.Dropdown.CONST.HTML ) );
        this.setPhaseDomElement( this.getDomElement() );
        DOM.BodyService.addChild( this.getDomElement() );
        DOM.Service.addElementTo( this.dom_element_content, this.getDomElement().querySelector( ".shi-tip-text" ) );
        this.doActionAfter( "do_action_after_init_dom_element" );
    },
    
    getSize               : function () {
        var _sizes  = this.getDomElement().getBoundingClientRect();
        this.width  = _sizes.width;
        this.height = _sizes.height;
    },
    doPlacementArrow      : function () {
    },
    setPosition           : function () {
        var _rect = this.dom_element_target.getBoundingClientRect();
        
        this.computePosition( _rect, _rect.width );
        
        if ( this.isInScreen() ) {
            if ( this.try > this.getMaxTry() ) {
                this.computePosition( _rect, _rect.width );
            }
            var self         = this;
            this.timeout_pop = setTimeout( function () {
                self.getDomElement().style.top  = self.pos_top + 'px';
                self.getDomElement().style.left = self.pos_left + 'px';
                DOM.Service.setDataSet( self.getDomElement(), "dataPlacement", self.placement );
                self.getDomElement().classList.remove( "shinken-no-opacity" );
                self.doPlacementArrow();
            }, 10 );
        }
        else {
            this.setPosition();
        }
    },
    setPositionAfterResize: function () {
        var _rect = this.dom_element_target.getBoundingClientRect();
        this.computePosition( _rect, _rect.width );
        if ( this.isInScreen() ) {
            this.getDomElement().style.top  = this.pos_top + 'px';
            this.getDomElement().style.left = this.pos_left + 'px';
        }
        else {
            this.setPosition();
        }
    },
    computeAfterResize    : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            this.setPositionAfterResize();
        }
    },
    computePosition       : function ( _rect, _width_rect ) {
        switch ( this.placement ) {
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                this.pos_top  = (_rect.top - this.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = (_rect.left + _width_rect / 2 - this.width / 2);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                this.pos_top  = (_rect.top - this.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = _rect.left - this.width + _width_rect + 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                this.pos_top  = (_rect.top - this.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = _rect.left - 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                this.pos_top  = (_rect.top + _rect.height / 2 - this.height / 2);
                this.pos_left = (_rect.left - this.width);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                this.pos_top  = (_rect.top + _rect.height / 2 - this.height / 2);
                this.pos_left = (_rect.left + _width_rect);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                this.pos_top  = (_rect.bottom - SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = (_rect.left + _width_rect / 2 - this.width / 2);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                this.pos_top  = (_rect.bottom - SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = _rect.left - 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                this.pos_top  = _rect.top + _rect.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                this.pos_left = _rect.left + _width_rect / 2 - this.width;
                break;
            default:
                console.warn( "[shi-type]", this.placement, "NOT MANAGED" );
        }
    },
    isInScreen            : function () {
        var _to_return     = true;
        var _left_parent   = -10;
        var _right_parent  = window.innerWidth - 10;
        var _top_parent    = -10;
        var _bottom_parent = window.innerHeight - 10;
        
        
        
        if ( this.pos_left < _left_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (this.pos_left + this.width) > _right_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( this.pos_top < _top_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (this.pos_top + this.height) > _bottom_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        this.try++;
        if ( this.try > this.getMaxTry() ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            _to_return = true;
        }
        return _to_return;
    },
    
    parseFormToObject: function ( to_set ) {
        if ( to_set === "ON" ) {
            return true;
        }
        if ( to_set === "OFF" ) {
            return false;
        }
        return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
    },
    parseObjectToForm: function ( to_set ) {
        if ( to_set === true ) {
            return "ON";
        }
        if ( to_set === false ) {
            return "OFF";
        }
        return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
    },
    
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  ELLIPSIS   **************************************************//
    
    //********************************************  HTML   **************************************************//
    
    //********************************************  PHASE  *****************************************************//
    
    
    callbackForPhase: function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.show();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                break;
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown._interface, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown._interface, SHINKEN.OBJECT.PhaseInterface );

SHINKEN.OBJECT.Dropdown.CONST = {
    PLACEMENT        : {
        LEFT        : 'left',
        RIGHT       : 'right',
        TOP         : 'top',
        TOP_LEFT    : 'top-left',
        TOP_RIGHT   : 'top-right',
        BOTTOM      : 'bottom',
        BOTTOM_LEFT : 'bottom-left',
        BOTTOM_RIGHT: 'bottom-right'
    },
    STYLE            : {
        ARROW_SIZE: 5
    },
    MAX_TRY_IN_SCREEN: 10,
    
    HTML: '<table>' +
          '<tr>' +
          '<td></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-top-left"><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-left"></div></td>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-middle"></div></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-top-right"><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-right"></div></td>' +
          '<td></td>' +
          '</tr>' +
          '<tr>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-left" id="tooltip-arrow-left-middle"></div></td>' +
          '<td colspan="3"><div class="shi-tip-text"></div></td>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-right" id="tooltip-arrow-right-middle"></div></td>' +
          '</tr>' +
          '<tr>' +
          '<td></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-bottom-left"><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-left"></div></td>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-middle"></div></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-bottom-right"><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-right"></div></td>' +
          '<td></td>' +
          '</tr>' +
          '</table>'
};