//__lib__ lib_common
'use strict';

WINDOW.Element           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.Element';
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init          : function () {
        this.initCounters();
    },
    initDomElement: function () {
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName       : function () {
        return this.name;
    },
    getID         : function () {
        return this.id;
    },
    setHasRequired: function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setActive     : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    setDisabled     : function ( to_set ) {
        this.is_disabled = to_set;
        DOM.Service.addOrRemoveClasses(this.dom_element, this.is_disabled, "shinken-disabled");
    },
    hasProperties : function () {
        return false;
    },
    setContentDomElementTarget: function ( to_set ) {
        DOM.Service.addElementToAfterEmpty( to_set, this.dom_element_target );
    },
    hasProblems                     : function ( window_name ) {
        return !!(this.hasError() || this.hasWarning());
    },
    //********************************************  COUNTER MENU   **************************************************//
    updateCounter: function ( name, value ) {
        this.counters[ name ].update( "counter", value );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        return [];
    },
    //********************************************  OTHERS  *****************************************************//
    cancelUserModification: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );

WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.ElementWithProperties';
    
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementWithProperties.prototype = {
    hasProperties: function () {
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );