//__lib__ lib_common
'use strict';

WINDOW.ElementFromData           = function ( name, parent_name ) {
    this.__class_name__ = 'WINDOW.ElementFromData';
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.parent_name = parent_name;
    this.init();
};
WINDOW.ElementFromData.prototype = {
    init          : function () {
        this.initCounters();
        this.initId();
        this.initDomElements();
    },
    initId        : function () {
        this.id = "id-shinken-window-" + this.name + this.parent_name;
    },
    initController: function () {
    },
    getController     : function () {
        return "";
    },
    //********************************************  OTHER  *****************************************************//
    resizeDone        : function () {
        if ( this.getController() ){
            this.getController().resizeDone();
        }
    },
    //********************************************  HTML  *****************************************************//
    initDomElements      : function () {
    },
    initDomElement       : function ( _label ) {
        this.dom_element = DOM.Service.createElement( "td", {
            "class"          : "shinken-window-element",
            "id"             : this.id,
            "data-group-name": this.parent_name,
            "data-name"      : this.name
        } );
        DOM.Service.addElementTo( this.computeLabelContainer( _label ), this.dom_element );
    },
    initDomTarget        : function () {
        var _class = "shinken-tab-pane property-tab-pane shinken-prop-table shinken-parent-tab-id-parent";
        if ( !this.is_active ){
            _class += " shinken-hidden";
        }
        this.dom_element_target = DOM.Service.createElement( "div", {
            "class"    : _class,
            "id"       : this.id + "-target",
            "data-name": this.name
        } );
    },
    computeLabelContainer: function ( _label ) {
        return DOM.Service.createElement( "span", { "class": "shinken-window-element-label" }, '<span class="shinken-window-label">' + _label + '</span>' );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementFromData, WINDOW.Element );