#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.logs.logger_abstract import LoggerAbstract

if TYPE_CHECKING:
    from typing import Optional


class LoggerSession(LoggerAbstract):
    FORMATS = [
        (u'log_time', u'[ %(log_time)s ]'),
        (u'mode', u'[ %(mode)-5s ]'),
        (u'type_request', u'[ %(type_request)-6s ]'),
        (u'result_code', u'[ RESULT:--- ]'),
        (u'run_time', u'[ TIME:   0ms ]'),
        (u'user_info', u'[ USER:%(user_info)-9s ]'),
        (u'requester_ip', u'[ CALL_BY:%(requester_ip)-15s ]'),
        (u'requester_module', u'[ BY:%(requester_module)s ]'),
        (u'session_message', u'[ ALREADY AUTHENTICATED USERS, START A SESSION %(session_message)s]'),
        (u'error', u'[ ERROR:%(error)-9s ]'),
    ]
    
    
    def start_session(self, user_uuid, user_name, requester_ip, requester_module=None):
        # type: (unicode, unicode, unicode, Optional[unicode]) -> None
        if not self.log_enable or not self._logger:
            return
        log_data = self._build_common_log_data(
            user_uuid=user_uuid,
            user_name=user_name,
            result_code=0,
            requester_ip=requester_ip,
            requester_module=requester_module,
            session_message=u''
        )
        
        log_data.update({
            u'type_request': u'SESSION',
        })
        
        self._log(self._build_message(log_data, self.FORMATS))
