#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
import copy


class ToolsBoxArray(object):
    @staticmethod
    def add_if_not_inside(to_add, array):
        if to_add not in array:
            array.append(to_add)
    
    
    @staticmethod
    def concat_array_unique(array_1, array_2):
        _to_return = copy.deepcopy(array_1)
        for _current in array_2:
            if _current not in _to_return:
                _to_return.append(_current)
        return _to_return
    
    
    @staticmethod
    def is_in(value_to_find, array):
        if not array:
            return False
        return value_to_find in array
    
    
    @staticmethod
    def append_and_return_insert_index(array, element_to_append):
        array.append(element_to_append)
        return len(array) - 1