#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

import json
from multiprocessing.sharedctypes import Value
from shinken.log import logger


class ShinkenEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, property):
            return obj.fget()
        return json.JSONEncoder.default(self, obj)


def dumps(obj, **kw):
    if 'cls' in kw:
        raise RuntimeError('Please do not specify cls for this json.dump')
    return json.dumps(obj, cls=ShinkenEncoder, **kw)


def loads(obj, **kw):
    return json.loads(obj, **kw)
