#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013:
#    Gabes Jean, j.gabes@shinken-solutions.com
#
# This file is part of Shinken Enterprise, all rights reserved.


import socket
import urllib2
import ssl

HTTP_ERRORS = (urllib2.URLError, urllib2.HTTPError, socket.error, socket.timeout, ssl.SSLError)


def http_get(uri, timeout, strong_https=False, do_read=True):
    # NOTE: ssl.SSLContext is only availabe on last python 2.7 versions
    if hasattr(ssl, 'SSLContext'):
        ssl_context = ssl.SSLContext(ssl.PROTOCOL_TLSv1)
        ssl_context.check_hostname = False
        ssl_context.verify_mode = ssl.CERT_NONE
    else:
        ssl_context = None
    
    args = {}
    if ssl_context:
        args['context'] = ssl_context
    reply = urllib2.urlopen(uri, timeout=int(timeout), **args)
    # Maybe the caller just want the raw response
    if not do_read:
        return reply
    data = reply.read()
    return data
