#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.property import BoolProp

_bprop = BoolProp()


def read_bool_in_configuration(conf, key_name, default_value):
    return _bprop.pythonize(getattr(conf, key_name, default_value))


def read_int_in_configuration(conf, key_name, default_value):
    try:
        return int(getattr(conf, key_name, default_value))
    except ValueError:
        return default_value


def read_float_in_configuration(conf, key_name, default_value):
    try:
        return float(getattr(conf, key_name, default_value))
    except ValueError:
        return default_value


def read_string_in_configuration(conf, key_name, default_value):
    return getattr(conf, key_name, default_value)


def read_list_in_configuration(conf, key_name, default_value):
    raw_list = getattr(conf, key_name, default_value).split(',')
    return [i.strip() for i in raw_list]
