SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_LINE = (function ( self ) {
    //********************************************  GET DOM ELEMENT   **************************************************//
    self._getCfgContainer           = function ( property_name ) {
        var _line  = SHINKEN.TOOLS.TEST_AUTO_PROPERTY._getLine( property_name );
        var _state = _line.dataset.state;
        switch ( _state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return _line.querySelector( '.shinken-inherited-cfg-cell .shinken-editable-container' );
            default:
                return _line.querySelector( '.shinken-user-set-cfg-cell .shinken-editable-container' );
        }
    };
    self._getCfgLineContainer       = function ( property_name ) {
        var _line = SHINKEN.TOOLS.TEST_AUTO_PROPERTY._getLine( property_name );
        return _line.querySelector( '.shinken-cfg-line-cell .shinken-cfg-line-value' );
    };
    self._getLines                  = function ( property_name ) {
        var _dom_multi_line_property = SHINKEN.TOOLS.TEST_AUTO_PROPERTY._getLine( property_name );
        return _dom_multi_line_property.querySelectorAll( '.shinken-multi-line-object-container:not([data-is-first-line="1"])' );
    };
    self._getLineWithIndex          = function ( property_name, index ) {
        return self._getLines( property_name )[ index ];
    };
    self._getLineButton             = function ( property_name, button_name, index ) {
        var _dom_line = self._getLineWithIndex( property_name, index );
        return _dom_line.querySelector( '.shinken-action-multi-object .shinken-button[value="' + button_name + '"]' );
    };
    self._getOptionMultiline        = function ( property_name, selector_name, option_name, index ) {
        var _to_return = self._getLineSelector( property_name, selector_name, index );
        _to_return     = _to_return.querySelector( '.shinken-option[data-key-name="' + option_name + '"]' );
        return _to_return;
    };
    self._getLineSelector           = function ( property_name, selector_name, index ) {
        return self._getLineWithIndex( property_name, index ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
    };
    //********************************************  SETTER GETTER   **************************************************//
    self.setValue                   = function ( timeout, property_name, value ) {
        setTimeout( function () {
            var _parsed_value = self.parseValueForSetValue( property_name, value );
            SHINKEN.TOOLS.TEST_AUTO_PROPERTY.setValue( 0, property_name, _parsed_value );
        }, timeout );
        
        return 500;
    };
    self.getExpectedLabelBtn        = function ( property_name, value ) {
        var state_inheritance = SHINKEN.TOOLS.TEST_AUTO_PROPERTY._getLine( property_name ).dataset.stateInheritance;
        var _expected_label   = "";
        switch ( value ) {
            case PROPERTY.CONST.BUTTON_LABEL.NULL:
                _expected_label = SHINKEN.TOOLS.STRING.format( _( 'element.none' ) );
                break;
            case PROPERTY.CONST.BUTTON_LABEL.INHERITANCE:
                switch ( state_inheritance ) {
                    case 1:
                        _expected_label = SHINKEN.TOOLS.STRING.format( _( 'element.inherited_from_template' ) );
                        break;
                    default:
                        _expected_label = SHINKEN.TOOLS.STRING.format( _( 'element.default' ) );
                        break;
                }
                break;
            case PROPERTY.CONST.BUTTON_LABEL.DEFAULT:
                _expected_label = SHINKEN.TOOLS.STRING.format( _( 'element.forced_default' ) );
                break;
            case PROPERTY.CONST.BUTTON_LABEL.USER_SET:
                switch ( property_name ) {
                    case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                        _expected_label = SHINKEN.TOOLS.STRING.format( _( 'multi-line-object.notes_multi_url' ) );
                        break;
                    case PROPERTY.CONST.NAME.OUTPUT_RULES:
                        _expected_label = SHINKEN.TOOLS.STRING.format( _( 'multi-line-object.output_rules' ) );
                        break;
                    case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                        _expected_label = SHINKEN.TOOLS.STRING.format( _( 'multi-line-object.time_periods' ) );
                        break;
                }
                break;
        }
        return _expected_label;
    };
    self.parseValueForSetValue      = function ( property_name, value_to_parse ) {
        var _to_return = "";
        for ( var i = 0, _size_i = value_to_parse.length; i < _size_i; i++ ) {
            if ( _to_return ) {
                _to_return += MANAGER.__instance_property_distributor.getElement( property_name ).separator_line_html;
            }
            switch ( property_name ) {
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    _to_return += value_to_parse[ i ][ 0 ];
                    if ( value_to_parse[ i ][ 1 ] ) {
                        _to_return += "/" + value_to_parse[ i ][ 1 ] + "/";
                    }
                    _to_return += MANAGER.__instance_property_distributor.getElement( property_name ).separator_key_value_html + value_to_parse[ i ][ 2 ];
                    break;
                default:
                    _to_return += SHINKEN.TOOLS.ARRAY.join( value_to_parse[ i ], MANAGER.__instance_property_distributor.getElement( property_name ).separator_key_value_html );
                    break;
            }
        }
        return _to_return;
    };
    self.parseValueForSetCFGValue   = function ( property_name, value_to_parse, add_property_name ) {
        var _to_return = "";
        for ( var i = 0, _size_i = value_to_parse.length; i < _size_i; i++ ) {
            if ( _to_return ) {
                _to_return += MANAGER.__instance_property_distributor.getElement( property_name ).separator_line_html;
            }
            switch ( property_name ) {
                case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    if ( value_to_parse[ i ][ 0 ] && value_to_parse[ i ][ 1 ] ) {
                        _to_return += SHINKEN.TOOLS.ARRAY.join( value_to_parse[ i ], MANAGER.__instance_property_distributor.getElement( property_name ).separator_key_value_html );
                    }
                    break;
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    _to_return += value_to_parse[ i ][ 0 ];
                    if ( value_to_parse[ i ][ 1 ] ) {
                        _to_return += "/" + value_to_parse[ i ][ 1 ] + "/";
                    }
                    _to_return += MANAGER.__instance_property_distributor.getElement( property_name ).separator_key_value_saved + value_to_parse[ i ][ 2 ];
                    break;
            }
        }
        if ( !add_property_name ) {
            switch ( property_name ) {
                case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                    break;
                default:
                    _to_return = property_name + _to_return;
                    break;
            }
        }
        return _to_return;
    };
    self.parseValueForTestLineValue = function ( property_name, value_to_parse ) {
        var _to_return = SHINKEN.TOOLS.ARRAY.clone( value_to_parse );
        for ( var i = 0, _size_i = _to_return.length; i < _size_i; i++ ) {
            switch ( property_name ) {
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    _to_return[ i ][ 2 ] = "shinken-icons-url-" + _to_return[ i ][ 2 ];
                    _to_return[ i ][ 3 ] = SHINKEN.TOOLS.STRING.format( _( 'multi-line-object.url_' + _to_return[ i ][ 3 ] ) );
                    break;
                case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    break;
            }
        }
        return _to_return;
    };
    self.setLineValue               = function ( timeout, property_name, to_set, index ) {
        setTimeout( function () {
            switch ( property_name ) {
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self._getLineWithIndex( property_name, index ).querySelector( '.shinken-name-urlmulti .shinken-input' ), to_set[ 0 ] );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self._getLineWithIndex( property_name, index ).querySelector( '.shinken-url-urlmulti .shinken-input' ), to_set[ 1 ] );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getOptionMultiline( property_name, COMPONENT.UrlLine.CONST.SELECTORS.ICON, to_set[ 2 ], index ) );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getOptionMultiline( property_name, COMPONENT.UrlLine.CONST.SELECTORS.POPUPPING, to_set[ 3 ], index ) );
                    break;
            }
        }, timeout );
        return 3 * DOM.CONST.WAITING_TIME_BEFORE_EXEC.INPUT;
    };
    self.selectOptionInLine         = function ( timeout, property_name, selector_name, option_name, index ) {
        setTimeout( function () {
            if ( !index ) {
                index = 0;
            }
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getOptionMultiline( property_name, selector_name, option_name, index ) );
        }, timeout );
        return 3 * DOM.CONST.WAITING_TIME_BEFORE_EXEC.INPUT;
    };
    self.setCfgValue                = function ( timeout, property_name, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self._getCfgContainer( property_name ).querySelector( '.shinken-text-to-copy .shinken-editable-value' ), to_set );
        }, timeout );
        return 4 * DOM.CONST.WAITING_TIME_BEFORE_EXEC.INPUT;
    };
    //********************************************  EVENT   **************************************************//
    self.clickOnCfgButton           = function ( timeout, property_name, button_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getCfgContainer( property_name ).querySelector( '.shinken-button[value="' + button_name + '"]' ), true );
        }, timeout );
        return 500;
    };
    self.clickOnLineButton          = function ( timeout, property_name, button_name, index ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getLineButton( property_name, button_name, index ), true );
        }, timeout );
        return button_name === PROPERTY.CONST.BUTTON_LABEL.REMOVE ? 1000 : 100;
    };
    //********************************************  TEST   **************************************************//
    self.validRadioList             = function ( timeout, property_name, state ) {
        setTimeout( function () {
            var _prop      = MANAGER.__instance_property_distributor.getElement( property_name );
            var _container = SHINKEN.TOOLS.TEST_AUTO_PROPERTY._getRadioBtnContainer( property_name );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _container );
            var _dom_buttons     = _container.querySelectorAll( '.shinken-btn-cell .shinken-button' );
            var _nb_btn_expected = _prop.is_not_heritable ? 2 : 4;
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _dom_buttons, _nb_btn_expected );
            for ( var i = 0; i < _nb_btn_expected; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_PROPERTY.validRadioButton( _dom_buttons[ i ], state, self.getExpectedLabelBtn( property_name, _dom_buttons[ i ].getAttribute( "value" ) ) );
            }
        }, timeout );
        return 100;
    };
    self.validLineNumber            = function ( timeout, property_name, array_values_to_test ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self._getLines( property_name ), array_values_to_test.length, "line object of " + property_name );
        }, timeout );
        return 100;
    };
    self.testLineNumber             = function ( timeout, property_name, number_expected, indexes_empty_lines ) {
        setTimeout( function () {
            var _dom_lines = self._getLines( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _dom_lines, number_expected );
            if ( indexes_empty_lines ) {
                for ( var i = 0, _size_i = indexes_empty_lines.length; i < _size_i; i++ ) {
                    self.isLineEmpty( property_name, _dom_lines[ indexes_empty_lines[ i ] ] );
                }
            }
        }, timeout );
        return 100;
    };
    self.isLineEmpty                = function ( property_name, _dom_line ) {
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_line.querySelector( ".shinken-name-urlmulti .shinken-input" ), '' );
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_line.querySelector( ".shinken-url-urlmulti .shinken-input" ), '' );
                break;
        }
    };
    self.validLineButtons           = function ( timeout, property_name, index ) {
        var _to_return = 0;
        _to_return += self.validLineButtonStatus( timeout + _to_return, property_name, PROPERTY.CONST.BUTTON_LABEL.DRAG_AND_DROP, index, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN );
        _to_return += self.validLineButtonStatus( timeout + _to_return, property_name, PROPERTY.CONST.BUTTON_LABEL.ADD, index, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN );
        _to_return += self.validLineButtonStatus( timeout + _to_return, property_name, PROPERTY.CONST.BUTTON_LABEL.REMOVE, index, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN );
        _to_return += self.validLineButtonStatus( timeout + _to_return, property_name, PROPERTY.CONST.BUTTON_LABEL.COPY_TO_CLIPBOARD, index, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN );
        return _to_return;
    };
    self.validLineButtonStatus      = function ( timeout, property_name, button_name, index, status ) {
        setTimeout( function () {
            var _dom_line_button = self._getLineButton( property_name, button_name, index );
            switch ( status ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom_line_button );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.validLineStatus            = function ( timeout, property_name ) {
        setTimeout( function () {
            var _to_return    = 0;
            var _switch_value = __shinken_test_type + "-" + __phase;
            var _dom_line     = self._getLines( property_name );
            switch ( _switch_value ) {
                case "00088-1":
                    self.testLineStatus( timeout + _to_return, _dom_line[ 0 ], SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.VISIBLE );
                    break;
                case "00088-2":
                case "00088-6":
                    self.testLineStatus( timeout + _to_return, _dom_line[ 0 ], SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.USER_SET );
                    break;
                case "00088-3":
                    self.testLineStatus( timeout + _to_return, _dom_line[ 0 ], SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.ERROR );
                    break;
                case "00088-4":
                    self.testLineStatus( timeout + _to_return, _dom_line[ 0 ], SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.WARNING );
                    break;
                default:
                    console.warn( "GSOU", "[validLineStatus ]", "[NOT IMPLEMENTED]" );
            }
        }, timeout );
        return 100;
    };
    self.testLineContent            = function ( timeout, property_name, to_test, index ) {
        setTimeout( function () {
            var _dom_line = self._getLineWithIndex( property_name, index );
            switch ( property_name ) {
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_line.querySelector( ".shinken-name-urlmulti .shinken-input" ), to_test[ 0 ] );
                    SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_line.querySelector( ".shinken-url-urlmulti .shinken-input" ), to_test[ 1 ] );
                    SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector .shinken-selector-label" ), to_test[ 3 ] );
                    break;
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    self.validOutPutRulesSelector( _dom_line.querySelector( ".shinken-status-match-cell-select .shinken-select-selector" ), to_test[ 0 ] );
                    SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( _dom_line.querySelector( ".shinken-regex-match-cell .shinken-input-container .shinken-input" ).value, to_test[ 1 ] );
                    self.validOutPutRulesSelector( _dom_line.querySelector( ".shinken-status-final-cell .shinken-select-selector" ), to_test[ 2 ] );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.validOutPutRulesSelector   = function ( dom_element, value ) {
        switch ( value ) {
            case "":
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element.querySelector( ".shinken-selector-status-icon" ), _( "common.ANY" ) );
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element.querySelector( ".shinken-selector-status-label" ), _( "status.ANY_STATUS" ) );
                break;
            default:
                SHINKEN.TOOLS.TEST_AUTO.__containsText( dom_element.querySelector( ".shinken-selector-status-icon img" ).getAttribute( "src" ), value );
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element.querySelector( ".shinken-selector-status-label" ), _( "status." + value ) );
                break;
        }
    };
    self.validCfgContent            = function ( timeout, property_name, inner_text ) {
        setTimeout( function () {
            var _prop = MANAGER.__instance_property_distributor.getElement( property_name );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self._getCfgContainer( property_name ), inner_text, property_name );
            switch ( _prop.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self._getCfgContainer( property_name ), "border", "1px dashed rgba(128, 0, 128, 0.65)" );
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE:
                case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self._getCfgContainer( property_name ), "border", "1px dashed rgba(0, 0, 0, 0.65)" );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.validTimePeriodDayCfgLine  = function ( timeout, property_name, inner_text ) {
        setTimeout( function () {
            var _prop = MANAGER.__instance_property_distributor.getElement( property_name );
            switch ( _prop.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self._getCfgLineContainer( property_name ) );
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                    SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self._getCfgLineContainer( property_name ), inner_text, property_name );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self._getCfgLineContainer( property_name ), "border", "1px dashed rgba(0, 0, 0, 0.65)" );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.testLineStatus             = function ( timeout, line, status ) {
        switch ( status ) {
            case SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.ERROR:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "border-color", "rgb(236, 87, 87)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "border-color", "rgb(236, 87, 87)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                break;
            case SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.WARNING:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "border-color", "rgba(0, 0, 0, 0)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "border-color", "rgb(255, 165, 0)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                break;
            case SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.USER_SET:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "border-color", "rgba(0, 0, 0, 0)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "border-color", "rgba(0, 0, 0, 0)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                break;
            case SHINKEN.TOOLS.TEST_AUTO.CONST.MULTI_LINE_OBJECT.LINE_STATUS.VISIBLE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "color", "rgb(0, 0, 0)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-name-urlmulti .shinken-input" ), "border-color", "rgba(0, 0, 0, 0)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "color", "rgb(0, 0, 0)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-url-urlmulti .shinken-input" ), "border-color", "rgba(0, 0, 0, 0)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "color", "rgb(175, 175, 175)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-icon-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "color", "rgb(175, 175, 175)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( line.querySelector( ".shinken-popup-urlmulti-cell .shinken-select-selector" ), "border-color", "rgb(204, 204, 204)" );
                break;
        }
    };
    self.validLineObject            = function ( timeout, property_name, to_test ) {
        var _to_return = 0;
        _to_return += self.validLineNumber( timeout + _to_return, property_name, to_test );
        _to_return += self.validLineStatus( timeout + _to_return, property_name );
        for ( var i = 0, _size_i = to_test.length; i < _size_i; i++ ) {
            _to_return += self.testLineContent( timeout + _to_return, property_name, to_test[ i ], i );
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_LINE || {} );