'use strict';
SHINKEN_LIST.MassAction           = function ( dom_element ) {
    this.name = SHINKEN_LIST.CONST.MASS_ACTION.NAME;
    this.init( dom_element );
};
SHINKEN_LIST.MassAction.prototype = {
    init: function ( dom_element ) {
        this.dom_element = dom_element;
        
        var _dom_button              = this.dom_element.querySelector( '#btn-action-launch' );
        var _dom_button_with_comment = this.dom_element.querySelector( '#btn-action-launch-add-comment' );
        
        this.component_select                     = new COMPONENT.Select( this.dom_element.querySelector( '#id-shinken-select-mass-action' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this );
        this.component_button_launch              = new COMPONENT.Button( _dom_button );
        this.component_button_launch_with_comment = new COMPONENT.Button( _dom_button_with_comment );
    },
    
    clickOnSelector              : function () {
        this.component_select.clickOnSelector();
    },
    clickOnItemSelector          : function ( event, parent_name, dom_element ) {
        var _key_name = dom_element.dataset.keyName;
        this.component_select.clickOnItemSelector( parent_name, _key_name );
        var _current_counter = MANAGER.__instance_counter_distributor.findCounter( dom_element.dataset.state + '-' + _key_name );
        this.computeTitleSelect( _current_counter );
        this._enabledButtonAction( _key_name );
    },
    computeTitleSelect           : function ( _current_counter ) {
        if ( _current_counter && _current_counter.counter_final ) {
            this.component_select.computeTitle( false, ' <span class="shinken-counter-label shinken-between-bracket">' + _current_counter.counter_final + '</span>' );
        }
        else {
            this.component_select.clickOnItemSelector( "", "ALL" );
            this.component_select.computeTitle();
            this._disabledButtonAction();
        }
    },
    getSelectedAction            : function () {
        return this.component_select.getSelectedAction();
    },
    resetMassAction              : function () {
        this._disabledButtonAction();
        //this.component_select.resetSelection();
        close_comment_to_launch_select_action( true );
    },
    //********************************************  EVENT LISTENER   **************************************************//
    hidePopup                    : function () {
        this.component_select.hidePopup();
    },
    _enabledButtonAction         : function ( key_name ) {
        this.component_button_launch.setState( COMPONENT.CONST.BTN_STATE.OFF );
        var _state = COMPONENT.CONST.BTN_STATE.DISABLED;
        switch ( key_name ) {
            case ACTIONS.SUBMIT:
            case ACTIONS.REJECT:
                _state = COMPONENT.CONST.BTN_STATE.OFF;
                break;
        }
        this.component_button_launch_with_comment.setState( _state );
    },
    _disabledButtonAction        : function () {
        this.component_button_launch.setState( COMPONENT.CONST.BTN_STATE.DISABLED );
        this.component_button_launch_with_comment.setState( COMPONENT.CONST.BTN_STATE.DISABLED );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getParentName                : function () {
        return this.name;
    },
    //********************************************  COUNTERS   **************************************************//
    reinitCounter: function ( name ) {
        var _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.WORK_AREA_NAME + '-' + name );
        if ( _current_counter ){
            _current_counter.reset();
        }
        _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.NAME + '-' + name );
        if ( _current_counter ){
            _current_counter.reset();
        }
    },
    updateMassActonCountSelect: function ( data ) {
        var _list_action = Object.keys( data );
        var _size_action = _list_action.length;
        var _current_action_name;
        var _current_counter;
        var _current_actions;
        var _size;
        
        for ( var i = 0; i < _size_action; i++ ) {
            _current_action_name = _list_action[ i ];
            _current_actions     = data[ _current_action_name ];
            _size                = _current_actions.length;
            this.reinitCounter(_current_action_name);
            for ( var j = 0; j < _size; j++ ) {
                if ( _current_actions[ j ][ 0 ].dataset.itemType === OBJECT.CONST.ELEMENT.TYPE.HOSTS ) {
                    _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.WORK_AREA_NAME + '-' + _current_action_name );
                }
                else {
                    _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.NAME + '-' + _current_action_name );
                }
                if ( _current_counter ) {
                    _current_counter.toggle_parent_activity = true;
                    _current_counter.update( _current_actions[ j ][ 0 ].id, 1 );
                }
            }
            if ( _current_action_name === this.component_select.last_selected_key_name ) {
                this.computeTitleSelect( _current_counter );
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.MassAction, SHINKEN.OBJECT.CounterInterface );