'use strict';

OBJECT.ElementCheckbox           = function ( dom_element ) {
    this.init( dom_element );
};
OBJECT.ElementCheckbox.prototype = {
    init      : function ( dom_element ) {
        this.dom_element    = dom_element;
        this.is_checked     = dom_element.classList.contains( 'shinken-checked' );
    },
    setChecked: function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        this.is_checked = !!to_set;
        this.updateView();
    },
    isChecked : function () {
        return this.is_checked;
    },
    getValue  : function () {
        return this.is_checked ? '1' : '0';
    },
    updateView: function () {
        if ( this.is_checked ) {
            this.dom_element.classList.add( 'shinken-checked' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-checked' );
        }
    }
};