'use strict';

OBJECT.Template           = function ( data ) {
    // name
    // properties
    // datas
    // status
    // status_tooltip
    // checks
    // size_dfe_check
    this.init( data );
};
OBJECT.Template.prototype = {
    init                     : function ( data ) {
        this.properties                                  = {};
        this.datas                                       = {};
        this.checks                                      = [];
        this.size_dfe_check                              = 0;
        this[ OBJECT.CONST.TEMPLATE.FIELD.USE ]          = [];
        this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ]      = true;
        this[ OBJECT.CONST.TEMPLATE.FIELD.IS_NEW ]       = false;
        this[ OBJECT.CONST.TEMPLATE.FIELD.UNCONFIGURED ] = false;
        this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.USEFUL );
        this.updateData( data );
    },
    updateData               : function ( data ) {
        var _currentKey;
        this[ OBJECT.CONST.TEMPLATE.FIELD._ID ]  = data[ OBJECT.CONST.TEMPLATE.FIELD._ID ];
        this[ OBJECT.CONST.TEMPLATE.FIELD.UUID ] = data[ OBJECT.CONST.TEMPLATE.FIELD._ID ];
        var _keys                                = Object.keys( data );
        var _sizeData                            = _keys.length;
        this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ] = data[ OBJECT.CONST.TEMPLATE.FIELD.NAME ];
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                  : function ( key, value ) {
        switch ( key ) {
            case OBJECT.CONST.TEMPLATE.FIELD.NAME:
            case OBJECT.CONST.TEMPLATE.FIELD.IS_TEMPLATE:
            case OBJECT.CONST.TEMPLATE.FIELD.ITEM_TYPE:
            case OBJECT.CONST.TEMPLATE.FIELD.LAST_MODIFICATION:
            case OBJECT.CONST.TEMPLATE.FIELD.REGISTER:
            case OBJECT.CONST.TEMPLATE.FIELD.SOURCES:
                this[ key ] = value;
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.ENABLED:
                this.setEnabled( value );
                
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.UNCONFIGURED:
                this[ key ] = value;
                if ( value ) {
                    this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN );
                }
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.IS_NEW:
                this[ key ] = value;
                if ( value ) {
                    this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.NEW );
                }
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.LOOP:
                this[ key ] = value;
                this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.BADLOOP );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.USE:
                this.setUse( value );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.WORK_AREA_INFO:
            case OBJECT.CONST.TEMPLATE.FIELD.METADATA:
            case OBJECT.CONST.TEMPLATE.FIELD._SYNC_KEYS:
            case OBJECT.CONST.TEMPLATE.FIELD.IS_TOP_LEVEL:
                break;
            case OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES:
                this.override = new OBJECT.ServiceOverrides( value );
                break;
            default:
                if ( SHINKEN.TOOLS.STRING.startsWith( key, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                    var _data = new PROPERTY.Data( key, value );
                    if ( _data.is_valid ) {
                        this.datas[ key ] = new OBJECT.TemplateProperty( key, this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ], _data, this[ OBJECT.CONST.TEMPLATE.FIELD._ID ] );
                    }
                }
                else {  // Properties
                    this.properties[ key ] = new OBJECT.TemplateProperty( key, this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ], value, this[ OBJECT.CONST.TEMPLATE.FIELD._ID ] );
                }
        }
        
    },
    isEnabled                : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ];
    },
    setEnabled               : function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        to_set                                      = !!to_set;
        this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ] = to_set;
        if ( !to_set ) {
            this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.DISABLED );
        }
    },
    getName                  : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ];
    },
    getUuid                 : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.UUID ];
    },
    setUse                  : function ( to_set ) {
        this[ OBJECT.CONST.TEMPLATE.FIELD.USE ] = to_set.split( ',' );
    },
    isUsing                 : function ( template_name ) {
        return SHINKEN.TOOLS.ARRAY.contains( this[ OBJECT.CONST.TEMPLATE.FIELD.USE ], template_name );
    },
    isNew                   : function () {
        return !!this.is_new;
    },
    getType                 : function () {
        return this.item_type;
    },
    addCheck                : function ( to_add ) {
        this.checks.push( to_add );
        if ( to_add.is_dfe ) {
            this.size_dfe_check++;
        }
    },
    getValidCheck           : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.checks.length; i < _size_i; i++ ) {
            if ( !this.checks[ i ].is_obsolete ) {
                _to_return.push( this.checks[ i ] );
            }
        }
        return _to_return;
    },
    hasOverrideModulation   : function ( check_in_page_host, property_name ) {
        if ( !this.override ) {
            return false;
        }
        for ( var i = 0; i < this.override.size; i++ ) {
            if ( !this.override.overrides[ i ].is( check_in_page_host ) ) {
                continue;
            }
            if ( this.override.overrides[ i ].property !== property_name ) {
                continue;
            }
            switch ( this.override.overrides[ i ].value ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
                default:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
            }
            break;
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
    },
    getOverrideValue         : function ( prop_name, check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return null;
        }
        return this.override.getOverrideValue( prop_name, check_in_page_host );
    },
    setStatus                : function ( to_set, parent_template ) {
        this.status = to_set;
        switch ( this.status ) {
            case  OBJECT.CONST.TEMPLATE.STATUS.USEFUL:
                this.status_tooltip = "";
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
                this.status_tooltip = _( 'element.tooltip_undefined' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.DISABLED:
                this.status_tooltip = _( 'element.tooltip_disabled' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.NEW:
                this.status_tooltip = _( 'element.tooltip_new' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.BADLOOP:
                if ( this[ OBJECT.CONST.TEMPLATE.FIELD.LOOP ] ) {
                    this.status_tooltip = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_loop' ), this[ OBJECT.CONST.TEMPLATE.FIELD.LOOP ].join( '  >>>  ' ) );
                }
                if ( !this.enabled ) {
                    this.status_tooltip += "<br>" + _( 'element.tooltip_disabled' );
                }
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.USELESS:
                this.status_tooltip = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_already_included' ), '<i><b>' + parent_template + '</b></i>' );
                break;
        }
    },
    isStatus                 : function ( to_test ) {
        return this.status === to_test;
    },
    completeTemplateWithUse  : function ( template_use ) {
        this.completePropertiesWithUse( template_use );
        this.completeDatasWithUse( template_use );
        this.completeOverrideWithUse( template_use );
    },
    completeDatasWithUse     : function ( template_use ) {
        var _current_key;
        var _current_data;
        
        var _datas = template_use.datas;
        var _keys  = Object.keys( _datas );
        var _size  = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key  = _keys[ i ];
            _current_data = _datas[ _current_key ];
            
            if ( this.datas[ _current_key ] ) {
                continue;
            }
            else {
                this.datas[ _current_key ] = _current_data;
            }
        }
        
        
    },
    completePropertiesWithUse: function ( template_use ) {
        var _current_key;
        var _current_property;
        
        var _properties = template_use.properties;
        var _keys       = Object.keys( _properties );
        var _size       = _keys.length;
        
        
        for ( var i = 0; i < _size; i++ ) {
            _current_key      = _keys[ i ];
            _current_property = _properties[ _current_key ];
            
            if ( !this.properties[ _current_key ] ) {
                this.properties[ _current_key ] = _current_property;
                this.properties[ _current_key ].setTemplateName( this.name, this._id );
                this.properties[ _current_key ].is_heritage_stopped = false;
            }
            else {
                this.properties[ _current_key ].updateValueWithUse( _current_property );
            }
        }
    },
    completeOverrideWithUse : function ( template_use ) {
        var _add;
        var _current_override;
        if ( !template_use.override ) {
            return;
        }
        if ( !this.override ) {
            this.override = template_use.override;
            return;
        }
        for ( var i = 0, _size_i = template_use.override.overrides.length; i < _size_i; i++ ) {
            _add              = true;
            _current_override = template_use.override.overrides[ i ];
            for ( var j = 0, _size_j = this.override.overrides.length; j < _size_j; j++ ) {
                if ( this.override.overrides[ j ].isOnSame( _current_override ) ) {
                    _add = false;
                }
            }
            if ( _add ) {
                this.override.overrides.push( _current_override );
                this.override.size = this.override.overrides.length;
            }
        }
    },
    getLink                 : function () {
        var _class = MANAGER.__instance_element_distributor.current_user.is_admin ? "shinken-link shinken-space" : "shinken-space";
        return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( this.item_type, this.uuid, this.getName(), _class ).outerHTML;
    },
    getProperty             : function ( key ) {
        return this.properties[ key ];
    }
};