'use strict';

PROPERTY.CheckboxSample           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_checkbox
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // custom_selected
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.CheckboxSample.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_checkbox        = new COMPONENT.Checkbox( dom_element.querySelector( ".shinken-cell-checkbox-container" ) );
        this.component_btn_default     = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.initSpecific();
    },
    initSpecific              : function ( dom_element ) {
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE:
                this.getCounterWarning().setTooltip( _( 'element.warning_show_history_range_and_hide_history' ), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                break;
            case PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE:
                this.getCounterWarning().setTooltip( _( 'element.warning_show_sla_range_and_hide_sla' ), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                break;
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    computeErrorsSpecifics    : function () {
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE:
                var _value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ).getFlatValue();
                if ( _value === PROPERTY.CONST.ACL_TYPE.SLA ) {
                    if ( this.isFlatValueOn() ) {
                        this.counter_temp_warning = 1;
                        break;
                    }
                }
                break;
            case PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE:
                var _value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ).getFlatValue();
                if ( _value === PROPERTY.CONST.ACL_TYPE.HISTORY ) {
                    if ( this.isFlatValueOn() ) {
                        this.counter_temp_warning = 1;
                        break;
                    }
                }
                break;
        }
    },
    askComputeAfterChange     : function () {
        this.setStateInheritance( false );
        this.component_checkbox.setCheckedUser();
        this._computeState();
    },
    ___clickOnRadioBtn        : function () {
        if ( this.component_btn_default.isOn() ) {
            return;
        }
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.ON );  //UTILE ??
        this._computeState();
    },
    ___clickOnCheckboxInput   : function () {
        var _value = !this.component_checkbox.isCheckedUser();
        if ( !this.is_mass_change ) {
            switch ( this.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    _value = !this.component_checkbox.isCheckedDefault();
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    _value = this.component_btn_inheritance.isSet() ? !this.component_checkbox.isCheckedInheritance() : !this.component_checkbox.isCheckedDefault();
                    break;
            }
        }
        this.component_checkbox.setCheckedUser( _value );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAtMaximum      : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, true );
        }
        if ( property.isFlatValueOn() ) {
            return;
        }
        switch ( property.getName() ) {
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                var _value = property.getFlatValue();
                switch ( _value ) {
                    case PROPERTY.CONST.ACL_TYPE.HISTORY:
                        if ( this.name === PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE && this.isFlatValueOn() ) {
                            this.setValueFromUser( '0' );
                        }
                        break;
                    case PROPERTY.CONST.ACL_TYPE.SLA:
                        if ( this.name === PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE && this.isFlatValueOn() ) {
                            this.setValueFromUser( '0' );
                        }
                        break;
                }
                break;
            default:
                switch ( property.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.NONE:
                        if ( property.default_value === '1' ) {
                            return;
                        }
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        if ( property.inherited_value === '1' ) {
                            return;
                        }
                        break;
                    default:
                        if ( property.type === PROPERTY.CONST.TYPES.CHECKBOX_SINGLE && property.component_checkbox.isCheckedUser() ) {
                            return;
                        }
                }
                this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_checkbox.setCheckedUser( false );
                this._computeState();
                break;
        }
        this.checkErrorWarning();
    },
    synchronizeAtMinimum      : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, false );
        }
        if ( this.isFlatValueOn() ) {
            return;
        }
        switch ( property.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.NONE:
                if ( property.default_value === '0' ) {
                    return;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( property.inherited_value === '0' ) {
                    return;
                }
                break;
            default:
                if ( !property.component_checkbox.isCheckedUser() && !property.component_checkbox.isCheckedDefault() ) {
                    return;
                }
        }
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_checkbox.setCheckedUser( true );
        this._computeState();
        this.checkErrorWarning();
    },
    synchronizeAtMassChange   : function ( property, is_max ) {
        var _action_property = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _action_this     = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            if ( this.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ){
                if ( _action_property !== _action_this ) {
                    this.clickOnItemSelector( _action_property, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                }
            }
            return;
        }
        var _to_set = false;
        if ( is_max ) {
            if ( !property.component_checkbox.isCheckedUser() ) {
                _to_set = "0";
            }
        }
        else {
            if ( property.component_checkbox.isCheckedUser() ) {
                _to_set = "1";
            }
        }
        if ( _action_property !== _action_this ) {
            this.clickOnItemSelector( _action_property, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
        }
        if ( _to_set ) {
            this.setValueFromUser( _to_set );
        }
    },
    //********************************************  GET / SET ***********************************************//
    ___unset                  : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser          : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( null, PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            case "0":
            case "1":
                this.component_checkbox.setCheckedUser( value );
                this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
                
                break;
        }
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                this.component_checkbox.setCheckedInheritance( this.inherited_value );
            }
            else {
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        this.setStateInheritance( this.state_inheritance );
        if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_btn_default.isOn() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                    break;
                default:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
            }
        }
        else if ( this.component_btn_default.isOn() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return;
        if ( inherited_value === '1' ) {
            _to_return = _( "element.true" );
        }
        else {
            _to_return = _( "element.false" );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
        this._computeInheritedLabel();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    //********************************************  SAVE     *********************************************************//
    isFlatValueOn             : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return this.component_checkbox.isCheckedDefault();
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( this.component_btn_inheritance.isSet() ) {
                    return this.component_checkbox.isCheckedInheritance();
                }
                return this.component_checkbox.isCheckedDefault();
        }
        return this.component_checkbox.isCheckedUser();
    },
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : '';
        }
        var _to_return = this.component_checkbox.isCheckedUser() ? '1' : '0';
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.CheckboxSample, PROPERTY.Interface );