/**
 * Created by j.lipere on 13/06/2016.
 */

/**
 * Definition of base constructor for all classes, which will execute the final class prototype's initialize method if exists
 * @constructor
 */
var Class = function () {
    this.initialize && this.initialize.apply ( this, arguments );
};
/**
 * Definition of a static method 'extend', allow heritage
 * @param childPrototype
 * @return {child}
 */
Class.extend = function ( childPrototype ) {
    var self = this;
    
    // The child constructor is a call to its parent's
    var child = function () {
        return self.apply ( this, arguments );
    };
    
    // Adding the extend method to the child class
    child.extend = self.extend;
    
    // Inception mode: chaining prototypes, "trick" to allow heritage
    var surrogate       = function ( init ) {
    };
    surrogate.prototype = self.prototype;
    child.prototype     = new surrogate;
    for ( var key in childPrototype ) {
        child.prototype[ key ] = childPrototype[ key ];
    }
    return child;
};