$( window ).ready( function () {
    function init () {
        // Tab source old run
        initLastRun();
    }
    
    // Tab source list
    var sourceTable = new TableEvents( {
        idContainer     : "#tab-pane-detail-last-run-target",
        attrFieldsFilter: "data-filter-tag-js",
        options         : {
            debug: true
        }
    } );
    
    var discoveryRulesTable = new TableEvents( {
        idContainer: ".table-shinken-js",
        options    : {
            debug: true
        }
    } );
    
    sourceTable.showItem = function ( obj ) {
        TableEvents.prototype.showItem.call( this ); // Super
        getSourceElement( obj );
    };
    
    sourceTable.deleteItem = function ( obj ) {
        TableEvents.prototype.deleteItem.call( this ); // Super
        console.log( 'TableEvents::deleteItem' );
        deleteSourceElement( obj );
    };
    
    
    
    
    
    // Javascript to enable link to tab
    var url = document.location.toString();
    if ( url.match( '#' ) ) {
        $( '.nav-tabs a[href="#' + url.split( '#' )[ 1 ] + '"]' ).tab( 'show' );
    } //add a suffix
    
    // Change hash for page-reload
    $( '.nav-tabs a' ).on( 'shown.bs.tab', function ( e ) {
        window.location.hash = e.target.hash;
    } );
    init();
} );

/**************************************************************************
 *                             TABLE EVENTS BASE
 **************************************************************************/
/**
 * Constructor TableEvents
 * @param {object} init - Declare table's selectors
 * @constructor
 */
var TableEvents = function ( init ) {
    'use strict';
    var self = this;
    
    this.init = {
        // Selector Container table
        idContainer     : init.idContainer || "#tab-pane-detail-last-run-target",
        // Selector Layout table
        idHead          : init.idHead || ".table-head-js",
        idFilter        : init.idFilter || ".table-filter-js",
        idBody          : init.idBody || ".table-body-js",
        idFoot          : init.idFoot || ".table-foot-js",
        // Selectors Actions rows selector
        classShowItem   : init.classShowItem || ".show-item-js",
        classEditItem   : init.classEditItem || ".edit-item-js",
        classDeleteItem : init.classDeleteItem || ".delete-item-js",
        // Selector fields filter
        attrFieldsFilter: init.attrFieldsFilter || "data-filter-js",
        // Some override - watch constructor for more options
        options         : init.options || {}
    };
    
    // Layout
    this.container = init.options.container || $( this.init.idContainer );
    this.head      = init.options.head || this.container.find( this.init.idHead );
    this.filter    = init.options.filter || this.container.find( this.init.idFilter );
    this.body      = init.options.body || this.container.find( this.init.idBody );
    this.foot      = init.options.foot || this.container.find( this.init.idFoot );
    
    // Head Children
    
    // Filter Children
    this.checkboxAll = init.options.checkboxAll || this.filter.find( "input:checkbox" );
    
    // Body Children
    this.row         = init.options.row || this.body.find( "tr:not(.collapse)" );
    this.checkboxRow = init.options.checkboxRow || this.row.find( "input" );
    
    this.showItem   = init.options.showItem || this.row.find( this.init.classShowItem );
    this.editItem   = init.options.editItem || this.row.find( this.init.classEditItem );
    this.deleteItem = init.options.deleteItem || this.row.find( this.init.classDeleteItem );
    
    // Foot Children
    
    this.animate = init.options.animate || false;
    // Verbose levels
    // Can be 0| False
    // Or     1| v    public (True)
    // Or     2| vv   private
    // Or     3| vvv  data
    this.debug = init.options.debug || false;
    
    this.initialize();
};
/**
 * Initialize TableEvents
 * All events is called here.
 * @return this
 */
TableEvents.prototype.initialize = function () {
    var self = this;
    
    // Events Filter
    // Events scroll
    this.body.scroll( function () {
        var $scrollHead = self.filter;
        if ( $scrollHead.length === 0 ) {
            $scrollHead = self.head;
        }
        if ( $( this ).scrollTop() > 1 ) {
            $scrollHead.addClass( "scrolled" );
        }
        else {
            $scrollHead.removeClass( "scrolled" );
        }
    } );
    
    // Events col-check
    this.checkboxAll.on( 'change', function () {
        $( this ).is( ":checked" ) ? self.selectAllRow() : self.deselectAllRow();
    } );
    
    // Events row
    if ( !this.checkboxAll.length == 0 ) {
        this.row.on( 'click', function ( e ) {
            if ( !$( e.target ).is( 'a, i' ) ) {
                self.selectRow( this );
            }
        } );
    }
    this.row.addClass( 'table-hover' );
    
    this.showItem.on( 'click', function () {
        self.showItem( this );
    } );
    this.editItem.on( 'click', function () {
        self.editItem( this );
    } );
    this.deleteItem.on( 'click', function () {
        self.deleteItem( this );
    } );
    
    // Events Filter
    this.filter.find( "select[" + this.init.attrFieldsFilter + "]" ).on( 'change', function () {
        self.toggleClassFilter( this );
        self.search();
    } );
    this.filter.find( "input[" + this.init.attrFieldsFilter + "]" ).on( 'keyup', function ( e ) {
        self.toggleClassFilter( this );
        if ( e.keyCode == 13 ) {
            self.search();
        }
    } );
};

/**
 * [ROW] - Allows to select all the row.
 * @return this
 */
TableEvents.prototype.selectAllRow = function () {
    this.checkboxAll.attr( 'checked', true );
    this.checkboxRow.prop( 'checked', true );
    this.row.addClass( 'selected' );
};
/**
 * [ROW] -Allows to deselect all the row.
 * @return this
 */
TableEvents.prototype.deselectAllRow = function () {
    this.checkboxAll.attr( 'checked', false );
    this.checkboxRow.prop( 'checked', false );
    this.row.removeClass( 'selected' );
};
/**
 * [ROW] - Allows to select one row.
 * @param obj
 * @return this
 */
TableEvents.prototype.selectRow = function ( obj ) {
    if ( this.debug ) {
        console.log( 'TableEvents::selectRow' );
    }
    var $row      = $( obj ),
        $checkbox = $row.find( ".col-check input" );
    
    if ( $row.hasClass( 'selected' ) ) {
        $row.removeClass( 'selected' );
        $checkbox.prop( 'checked', false );
    }
    else {
        $row.addClass( 'selected' );
        $checkbox.prop( 'checked', true );
    }
};
TableEvents.prototype.dragAndDrop = function ( obj ) {
    if ( this.debug ) {
        console.log( 'TableEvents::dragAndDrop' );
    }
};

/**
 * [Filter] - Allows to add color to a filter if used.
 * @param obj
 * @return this
 */
TableEvents.prototype.toggleClassFilter = function ( obj ) {
    if ( this.debug ) {
        console.log( 'TableEvents::toggleClassFilter' );
    }
    var $target = $( obj );
    if ( obj.tagName == "INPUT" ) {
        if ( obj.type == "text" || obj.type == "search" ) {
            $target.val() ? $target.addClass( 'filled' ) : $target.removeClass( 'filled' );
        }
    }
    if ( obj.tagName == "SELECT" ) {
        $target.find( 'option:selected' ).text() ? $target.addClass( 'filled' ) : $target.removeClass( 'filled' );
    }
};
/**
 * [Filter] - Allows to reload current page with filter param.
 * @return this
 */
TableEvents.prototype.search = function () {
    var _filter_params = this._getFilter();
    var _url_params    = SHINKEN.HIGHWAY.getParams();
    var _url           = '';
    if ( this.debug ) {
        console.log( 'TableEvents::search' );
    }
    if ( location.pathname === "/analyzers/server-analyzer" ) {
        _url = "/sources/server-analyzer"; //BGL for SEF-2967
    }
    else {
        _url = location.pathname;
    }
    
    if ( _filter_params ) {
        _url_params[ 'filter' ] = _filter_params;
    }
    else {
        delete _url_params[ 'filter' ];
    }
    
    _url = _url + SHINKEN.HIGHWAY.buildParamsToUrl( _url_params );
    location.assign( _url );
};
/**
 * [Filter] - Allows to reload current page no filter.
 * @return this
 */
TableEvents.prototype.cleanFilter = function () {
    if ( this.debug ) {
        console.log( 'TableEvents::cleanFilter' );
    }
    location.assign( location.pathname );
};
/**
 * [Filter] - Allows to reload current page with one filter in less.
 * @param obj
 * @return this
 */
TableEvents.prototype.cleanOneFilter = function ( obj ) {
    if ( this.debug ) {
        console.log( 'TableEvents::cleanFilter' );
    }
    location.assign( location.pathname );
};
/**
 * [Filter] - Allows to get all param filtered.
 * (All select, input with "data-filter-js" attribut by default.)
 * @private
 * @return {string}
 */
TableEvents.prototype._getFilter = function () {
    var self          = this,
        $targets      = self.filter.find( "[" + self.init.attrFieldsFilter + "]" ),
        _isFirstParam = true,
        queryString   = '';
    
    $targets.each( function ( i, el ) {
        var value      = '',
            filterName = $( el ).attr( self.init.attrFieldsFilter );
        
        if ( el.tagName == "INPUT" ) {
            if ( el.type == "text" || el.type == "search" ) {
                value = $( el ).val();
            }
        }
        if ( el.tagName == "SELECT" ) {
            var $select = $( el ).find( 'option:selected' ),
                _key    = $select.val();
            value       = (_key != 0) ? _key : '';
        }
        
        if ( value && !_isFirstParam ) {
            queryString = queryString + '~';
        }
        if ( value ) {
            queryString   = queryString + filterName + ':' + value;
            _isFirstParam = false;
        }
    } );
    return queryString;
};

/**
 * [Actions abstract] - Allows to show detail of one row.
 * @param obj
 * @return this
 */
TableEvents.prototype.showItem = function ( obj ) {

};
/**
 * [Actions abstract] - Allows to edit one row.
 * @param obj
 * @return this
 */
TableEvents.prototype.editItem = function ( obj ) {
    if ( this.debug ) {
        console.log( 'TableEvents::editItem' );
    }
};
/**
 * [Actions abstract] - Allows to delete one row.
 * @param obj
 * @return this
 */
TableEvents.prototype.deleteItem = function ( obj ) {
    if ( this.debug ) {
        console.log( 'TableEvents::deleteItem' );
    }
};

// Deprecated and not used but working.
/**
 * [Filter Deprecated] - Allows to init search fields.
 * @param obj
 * @return this
 */
TableEvents.prototype.initFieldsFilter = function ( obj ) {
    var self     = obj,
        params   = self._getParams(),
        $targets = self.filter.find( "[" + self.init.attrFieldsFilter + "]" );
    
    for ( var key in params ) {
        var value = params[ key ];
        $targets.each( function ( i, el ) {
            var filterName = $( el ).attr( self.init.attrFieldsFilter );
            
            if ( filterName == key ) {
                if ( el.tagName == "INPUT" ) {
                    if ( el.type == "text" || el.type == "search" ) {
                        $( el ).val( value );
                        self.toggleClassFilter( el );
                    }
                }
                if ( el.tagName == "SELECT" ) {
                    $( el ).find( 'option:selected' ).text( value );
                    self.toggleClassFilter( el );
                }
            }
        } );
    }
};
/**
 * [Filter Deprecated] - Allows to get all params parse.
 * @private
 * @return {{}}
 */
TableEvents.prototype._getParams = function () {
    var queryObject = {},
        query       = /[^=]*$/.exec( window.location.href )[ 0 ], // Get Filter in url
        vars        = query.split( "~" );
    
    for ( var i = 0; i < vars.length; i++ ) {
        var pair  = vars[ i ].split( ":" ),
            key   = pair[ 0 ],
            value = pair[ 1 ];
        
        // If first entry with this name
        if ( typeof queryObject[ key ] === "undefined" ) {
            queryObject[ key ] = decodeURIComponent( value );
            // If second entry with this name
        }
        else if ( typeof queryObject[ key ] === "string" ) {
            var arr            = [ queryObject[ key ], decodeURIComponent( value ) ];
            queryObject[ key ] = arr;
            // If third or later entry with this name
        }
        else {
            queryObject[ key ].push( decodeURIComponent( value ) );
        }
    }
    return queryObject;
};

/**************************************************************************
 *                             TAB SOURCE LIST
 **************************************************************************/
function getSourceElement ( obj ) {
    console.log( 'TableEvents::getSourceElement' );
    var id_class        = obj.dataset.idClass; // object id used as html id
    var id              = obj.dataset.id;
    var source_name     = obj.dataset.name;
    var element_name    = obj.dataset.type;
    var last_run_number = obj.dataset.lastRunNumber;
    var hash            = obj.dataset.hash;
    
    var target = document.getElementById( 'elt-' + element_name + '-' + id_class );
    if ( !target.classList.contains( "shinken-collapsed" ) ) {
        target.classList.toggle( "shinken-collapsed" );
        return;
    }
    
    $.ajax( {
        url    : '/sources/' + source_name + '/' + last_run_number + '/elements/' + element_name + '/id/' + id + '/hash/' + hash,
        type   : 'GET',
        success: function ( data ) {
            target.innerHTML = data;
            target.classList.toggle( "shinken-collapsed" );
        },
        error  : function ( data ) {
            var msg          = _( 'source.sorry_error' );
            target.innerHTML = msg + data.status + " " + data.statusText;
            target.classList.toggle( "shinken-collapsed" );
        }
    } );
}



function deleteSourceElement ( obj ) {
    var id           = $( obj ).data( 'id' );
    var source_name  = $( obj ).data( 'name' );
    var element_name = $( obj ).data( 'type' );
    
    var delete_url = '/sources/' + source_name + '/elements/' + element_name + '/id/' + id + '/delete';
    SHINKEN.TOOLS.LOADER.show( _( 'source.action_delete' ), true );
    $.get( delete_url, function ( data ) {
        window.location.reload();
    } );
}

function deleteSourceElementConfirm ( source_name ) {
    var _list = document.querySelectorAll( '.delete-item-js' );
    var _size = _list.length;
    if ( !_size ) {
        //return;
    }
    if ( confirm( _( 'source.sure_to_remove_list_element' ) ) ) {
        deleteSourceElements( source_name, _list );
    }
}

function deleteSourceElements ( source_name, list ) {
    var delete_url = '/sources/' + source_name + '/elements/delete';
    SHINKEN.TOOLS.LOADER.show( _( 'source.action_delete' ), true );
    
    var items = [];
    
    var _list = list || document.querySelectorAll( '.delete-item-js' );
    var _current;
    for ( var i = 0, _size = _list.length; i < _size; i++ ) {
        _current        = _list[ i ];
        items[ i ]      = [];
        items[ i ][ 0 ] = _current.dataset.id;
        items[ i ][ 1 ] = _current.dataset.type;
    }
    
    $.ajax( {
        url    : delete_url,
        type   : 'DELETE',
        data   : { 'items': JSON.stringify( items ) },
        success: function ( response ) {
            window.location.reload();
        },
        error  : function ( response ) {
            window.location.reload();
        }
    } );
}

/**************************************************************************
 *                           TAB SOURCE OLD RUN
 **************************************************************************/
function initLastRun () {
    var last_run_to_display = document.querySelector( ".item-run-js.active .shinken-item-run" );
    if ( !last_run_to_display ) {
        return;
    }
    getResultLastRun( last_run_to_display );
}

function getOldRun ( dom_element ) {
    // First we clean from a previous run
    get_spinner( 'run-results' );
    
    // Clean all style active from #run_times sons
    var last_run_displayed = document.querySelector( ".item-run-js.active" );
    if ( last_run_displayed ) {
        last_run_displayed.classList.remove( 'active' );
    }
    
    // Add it only to the good one
    var source_time        = DOM.Service.getValueDataSet( dom_element, "time" );
    var next_run_displayed = document.querySelector( '#run-' + source_time );
    next_run_displayed.classList.add( "active" );
    getResultLastRun( dom_element );
}

function getResultLastRun ( dom_element ) {
    var source_name   = DOM.Service.getValueDataSet( dom_element, "name" );
    var source_time   = DOM.Service.getValueDataSet( dom_element, "time" );
    var is_latest_run = DOM.Service.getValueDataSet( dom_element, "isLastestRun" );
    var source_type   = DOM.Service.getValueDataSet( dom_element, "type" );
    
    var _target = document.querySelector( "#run-results" );
    var _params = SHINKEN.HIGHWAY.buildParamsToUrl( { 'is-latest-run': is_latest_run } );
    $.get( '/sources/' + source_type + '/' + source_name + '/times/' + source_time + _params, function ( response, status, xhr ) {
        _target.innerHTML = response;
        if ( status === "error" ) {
            var msg           = _( 'source.sorry_error' );
            _target.innerHTML = msg + xhr.status + " " + xhr.statusText;
        }
    } );
}

/**************************************************************************
 *                           TAB SOURCE TEMPLATE MAPPING
 **************************************************************************/
function submit_form_source_mapping ( elem ) {
    elem.classList.add( "shinken-content-disabled" );
    elem.parentNode.classList.add( "shinken-pending" );
    setTimeout( function () {
        document.getElementById( 'shinken-form-template-mapping' ).submit();
    }, 500 );
}
