#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.Messages import Messages
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.shinken_object import ShinkenObject


class Counter(ShinkenObject):
    def __init__(self, class_to_add, number="", label="", extra_attribute=""):
        # type: (str, str, str)-> None
        super(Counter, self).__init__()
        self.class_to_add = class_to_add
        self.number = number
        self.label = ''
        self.extra_attribute = extra_attribute
        self.set_label(label)
    
    
    def add_tooltip_messages(self, to_set, message_type="", placement=""):
        # type: (Messages, str, str)-> NoReturn
        self.extra_attribute = '''%s %s''' % (self.extra_attribute, self.get_html_tooltip(to_set.build_message(), message_type=message_type, placement=placement))
    
    
    def set_label(self, to_set):
        # type: (str)-> NoReturn
        self.label = ""
        if to_set:
            self.label = '''<span class="shinken-counter-extra-label">%s</span>''' % to_set
    
    
    def get_html(self):
        # type: ()-> str
        return '''<span class="shinken-counter %s" data-number="%s" %s><span class="shinken-counter-label">%s%s</span></span>''' \
               % (self.class_to_add, self.number, self.extra_attribute, self.number, self.label)
