var __dom_element_body;
document.addEventListener( "DOMContentLoaded", function ( e ) {
    doActionWhenDomReady();
} );

function action_when_resizing () {
    var shinkenContentErrorElement  = document.getElementById( 'id-shinken-content-error' );
    var shinkenContentHeaderElement = document.getElementById( 'id-shinken-content-header' );
    var shinkenContentElement       = document.getElementById( 'id-shinken-content' );
    
    shinkenContentElement.style.height = "calc(100% - " + (shinkenContentErrorElement.offsetHeight + shinkenContentHeaderElement.offsetHeight) + "px)";
}

var doActionWhenDomReady = function ( e ) {
    __dom_element_body = document.querySelector( 'body' );
    $( window ).resize( action_when_resizing );
    action_when_resizing();
    document.addEventListener( "click", function () {
        window.parent.document.querySelector( "body" ).click();
    } );
    setTimeout( function () {
        __dom_element_body.classList.remove( "shinken-import-in-progress" );
    }, 250 );
    DISCOVERY_CONTROLLER.updateWarningsAndErrors();
};

DISCOVERY_CONTROLLER = {
    clickOnForceReloadRules: function ( sname ) {
        parent.window.MANAGER.__instance_source_distributor.findSource(sname).askUpdateBeforeAnyAction();
        __dom_element_body.classList.add( "shinken-import-in-progress" );
        $.ajax( {
            url    : "/sources/" + sname + "/rules/rules_list/reload_rules/",
            success: function ( data ) {
                rulesWarningsNumber = data[ 'warnings' ];
                rulesErrorsNumber   = data[ 'errors' ];
                setTimeout( function () {
                    DISCOVERY_CONTROLLER.reloadContent();
                }, 1000 );
            },
            error  : function ( data, txt ) {
                setTimeout( function () {
                    location.reload();
                }, 1000 );
                console.log( 'Got bad result for ' + data );
            }
        } );
    },
    reloadContent          : function ( sname ) {
        $.ajax( {
            url     : "/sources/discovery/rules/rules_list",
            dataType: "text",
            success : function ( data ) {
                var _dom                     = document.createElement( "div" );
                _dom.innerHTML               = data;
                _dom                         = _dom.querySelector( '.shinken-ajax-container' );
                __dom_element_body.innerHTML = _dom.outerHTML;
                __dom_element_body.classList.remove( "shinken-import-in-progress" );
                action_when_resizing();
                DISCOVERY_CONTROLLER.updateWarningsAndErrors();
            },
            error   : function ( rc, state, error ) {
                console.error( 'getCheckOverrideData data', 'Got bad result ' + rc.status );
            }
        } );
    },
    updateWarningsAndErrors: function () {
        if ( typeof window.parent.MANAGER.__instance_counter_distributor === "undefined" ) {
            return;
        }
        
        window.parent.MANAGER.__instance_counter_distributor.findCounter( 'rules-warnings' ).update( 'rules-list', rulesWarningsNumber );
        window.parent.MANAGER.__instance_counter_distributor.findCounter( 'rules-errors' ).update( 'rules-list', rulesErrorsNumber );
    }
};