var __apply_parse_data          = 1;
var __previous_apply_parse_data = 1;
var __label_precision;
var __val_fix_min_scale         = null;
var __val_fix_max_scale         = null;
var show_trending               = false;
var fireEventTimeout;
var _timeout_compute_navigator;
var _dom_element_container;
var _is_init                    = true;
var list_metric_warning         = {};
var list_metric_critical        = {};

function push_series_to_highstock ( series, compute ) {
    var serie;
    var uuid_metric;
    var aera_colors;
    var _splited_metric_name;
    for ( var i = 0; i < series.length; i++ ) {
        serie       = series[ i ];
        uuid_metric = getUuidMetric( serie );
        aera_colors = "";
        
        if ( serie.warn ) {
            _splited_metric_name = serie.metric.split( '_warn' )[ 0 ];
            aera_colors          = get_color( serie.hname + serie.sdesc + _splited_metric_name );
            serie.color          = aera_colors[ 'start' ][ 1 ];
            
            serie.dashStyle = 'longdash';
            // Put a white blur around the warn/crit so we can show them even if they are "over" the serie
            serie.shadow    = { 'color': 'white', 'offsetX': 0, 'offsetY': 0, 'opacity': 0.5, 'width': 3 };
            serie.lineWidth = 0.6;
        }
        if ( serie.crit ) {
            _splited_metric_name = serie.metric.split( '_crit' )[ 0 ];
            aera_colors          = get_color( serie.hname + serie.sdesc + _splited_metric_name );
            serie.color          = aera_colors[ 'start' ][ 1 ];
            serie.dashStyle      = 'dash';
            serie.shadow         = { 'color': 'white', 'offsetX': 0, 'offsetY': 0, 'opacity': 0.5, 'width': 3 };
            serie.lineWidth      = 1.5;
        }
        
        if ( serie.trending ) {
            aera_colors     = get_trending_color( serie.sdesc + serie.metric ); //get a color but always the same for the same metric name
            serie.dashStyle = 'dash';
            serie.lineWidth = 1;
            serie.marker    = { enabled: false };
            serie.color     = aera_colors[ 'start' ][ 1 ];
            serie.lineColor = aera_colors[ 'start' ][ 1 ];
            serie.fillColor = {
                linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                stops         : [ aera_colors[ 'start' ], aera_colors[ 'end' ] ]
            };
        }
        if ( serie.real_metric ) {
            aera_colors = get_color( serie.hname + serie.sdesc + serie.metric ); //get a color but always the same for the same metric name
            serie.color     = aera_colors[ 'start' ][ 1 ];
            serie.lineWidth = 1.5;
            serie.lineColor = aera_colors[ 'start' ][ 1 ];
            serie.fillColor = {
                linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                stops         : [ aera_colors[ 'start' ], aera_colors[ 'end' ] ]
            };
        }
        
        // serie.getExtremesFromAll = true;
        serie.threshold     = 0;
        serie.softThreshold = false;
        __instanceCharts.addSeries( serie, false );
    }
    if ( compute ) {
        compute_navigator();
    }
}

function add_metric ( uuid, asked_metric ) {
    var jqxhr = $.getJSON( '/api/graphs/data/' + uuid + '?metric=' + asked_metric + '&from=' + timerange + '&trending=' + show_trending, function ( data ) {
        var _series = create_series_from_data( data );
        push_series_to_highstock( _series, true );
    } );
    // Catch non working server and show it
    jqxhr.fail( function ( obj ) {
        getJsonFailled( obj );
    } );
}

function remove_check ( hname, sdesc, asked_metric ) {
    var series_to_remove = get_serie_from_check( hname, sdesc, asked_metric );
    for ( var i = 0; i < series_to_remove.length; i++ ) {
        series_to_remove[ i ].remove( false );
    }
    compute_navigator();
}

function get_serie_from_check ( hname, sdesc ) {
    var series_found = [];
    if ( !__instanceCharts ) {
        return series_found;
    }
    for ( var i = 0; i < __instanceCharts.series.length; i++ ) {
        var serie = __instanceCharts.series[ i ];
        if ( (serie.options.hname === hname) && (serie.options.sdesc === sdesc) ) {
            series_found.push( serie );
        }
    }
    
    return series_found;
}

function remove_metric ( hname, sdesc, asked_metric, compute ) {
    var series_to_remove = get_serie_from_metric( hname, sdesc, asked_metric );
    for ( var i = 0; i < series_to_remove.length; i++ ) {
        series_to_remove[ i ].remove( false );
    }
    if ( compute ) {
        compute_navigator();
    }
}

function get_serie_from_metric ( hname, sdesc, metric ) {
    var series_found = [];
    var serie;
    for ( var i = 0; i < __instanceCharts.series.length; i++ ) {
        serie = __instanceCharts.series[ i ];
        if ( (serie.options.hname === hname) && (serie.options.sdesc === sdesc) && (serie.options.metric === metric) ) {
            series_found.push( serie );
        }
    }
    
    return series_found;
}

function create_series_from_data ( data ) {
    var series = [];
    for ( var i = 0; i < data.length; i++ ) {
        var e                     = data[ i ];
        var serie                 = {};
        var warn                  = endsWith( e.name, '_warn' );
        var crit                  = endsWith( e.name, '_crit' );
        var trending              = e.trending;
        var real_metric           = !(warn || crit || trending);
        serie.name_server         = e.name;
        serie.name                = name_serie_formatter( e.host_name, e.check_name, e.metric_name, real_metric, warn, crit, trending );
        serie.display_name        = e.metric_name + " (" + e.check_name + ")";
        serie.data_server         = clone_object( e.values );
        serie.data                = parseDataForGraph( e.values, e.interval );
        // serie.data         = serie.data_server ;
        serie.uuid                = e.uuid;
        serie.hname               = e.host_name;
        serie.host_name           = e.host_name;
        serie.sdesc               = e.check_name;
        serie.service_description = e.check_name;
        serie.metric              = e.metric_name;
        serie.real_metric         = real_metric;
        serie.warn                = warn;
        serie.crit                = crit;
        serie.trending            = trending;
        serie.has_value           = e.has_value;
        
        
        if ( real_metric ) {
            
            series.push( serie );
            
            if ( serie.has_value ) {
                $( '#container' ).highcharts().setTitle( { text: "" }, {}, false );
            }
            else {
                $( '#container' ).highcharts().setTitle( { text: _( 'graphics.no_data' ) + e.check_name + "/" + e.metric_name }, {}, false );
            }
        }
    }
    return series;
}

function getUuidMetric ( metric ) {
    return metric.uuid + "-" + metric.metric;
}

function getExtremeScale ( serie ) {
    var metric;
    var _size_metrics;
    
    _size_metrics = serie.data.length;
    
    __has_series = _size_metrics ? true : false;
    
    for ( var j = 0; j < _size_metrics; j++ ) {
        metric = serie.data[ j ].y;
        
        if ( !metric ) {
            continue;
        }
        
        if ( metric > __max_scale ) {
            __max_scale = metric;
        }
        else if ( metric < __min_scale ) {
            __min_scale = metric;
        }
    }
    
    if ( __val_fix_max_scale ) {
        __max_scale = __val_fix_max_scale;
    }
    if ( __val_fix_min_scale !== null ) {
        __min_scale = __val_fix_min_scale;
    }
}

function compute_navigator () {
    if ( !__instanceCharts ) {
        return;
    }
    var navigator_to_add         = [];
    var generic_navigator_option = {
        xAxis              : 1,
        yAxis              : 1,
        enableMouseTracking: false,
        isInternal         : true,
        navigator          : true
    };
    
    var old_zoom        = { 'min': __instanceCharts.xAxis[ 0 ].min, 'max': __instanceCharts.xAxis[ 0 ].max };
    var old_zoom_at_max = __instanceCharts.xAxis[ 0 ].dataMax == __instanceCharts.xAxis[ 0 ].max;
    
    __min_scale  = 0;
    __max_scale  = 0;
    __has_series = false;
    
    //initial draw for set the first 'Navigator'
    __instanceCharts.zoom();
    var type_areaspline = is_last_series();
    
    for ( var i = __instanceCharts.series.length - 1; i >= 0; i-- ) {
        var serie = __instanceCharts.series[ i ];
        if ( serie.name === 'Navigator' ) {
            serie.hide();
        }
        else if ( serie.options.navigator ) {
            serie.remove( false );
        }
        else if ( serie.options.real_metric ) {
            getExtremeScale( serie );
            var data = [];
            for ( var j = 0; j < serie.xData.length; j++ ) {
                data.push( [ serie.xData[ j ], serie.yData[ j ] ] );
            }
            
            if ( type_areaspline ) {
                serie.options.type = 'areaspline';
                serie.options.data = data;
            }
            else {
                serie.options.type = 'spline';
                serie.options.data = data;
            }
            serie.update( serie.options, false );
            
            var navigator_option          = jQuery.extend( true, {}, generic_navigator_option );
            navigator_option.name         = 'Navigator_' + serie.name;
            navigator_option.lineColor    = serie.options.lineColor;
            navigator_option.fillColor    = serie.options.fillColor;
            navigator_option.type         = serie.options.type;
            navigator_option.dataGrouping = serie.options.dataGrouping;
            navigator_option.threshold    = 0;
            navigator_option.data         = data;
            
            navigator_to_add.push( navigator_option );
        }
        else if ( serie.options.warn || serie.options.crit ) {
            getExtremeScale( serie );
        }
    }
    
    for ( var i = navigator_to_add.length - 1; i >= 0; i-- ) {
        var navigator = navigator_to_add[ i ];
        __instanceCharts.addSeries( navigator, false );
    }
    __instanceCharts.xAxis[ 1 ].update( { tickInterval: __instanceCharts.xAxis[ 0 ].tickInterval }, false );
    __instanceCharts.xAxis[ 0 ].update( { minRange: xAxis_min_range }, false );
    if ( !(__instanceCharts.xAxis[ 0 ].dataMin < old_zoom.min && old_zoom.min < __instanceCharts.xAxis[ 0 ].dataMax) ) {
        old_zoom.min = __instanceCharts.xAxis[ 0 ].dataMin;
    }
    if ( old_zoom_at_max || !(__instanceCharts.xAxis[ 0 ].dataMin < old_zoom.max && old_zoom.max < __instanceCharts.xAxis[ 0 ].dataMax) ) {
        old_zoom.max = __instanceCharts.xAxis[ 0 ].dataMax;
    }
    if ( !__resetExtremes && !_is_init ) {
        __instanceCharts.xAxis[ 0 ].setExtremes( old_zoom.min, old_zoom.max );
        setResetExtremes( true );
    }
    else {
        _is_init = false;
        if ( __instanceCharts.series.length ) {
            var _size = __instanceCharts.series[ 0 ].xData.length;
            var _min  = __instanceCharts.series[ 0 ].xData[ _size - 450 ];
            var _max  = __instanceCharts.series[ 0 ].xData[ _size - 1 ];
            __instanceCharts.xAxis[ 0 ].setExtremes( _min, _max );
        }
    }
    if ( __has_series ) {
        __instanceCharts.yAxis[ 0 ].setExtremes( __min_scale, __max_scale );
    }
    
}

function askForRebuildData ( min, max, redraw, event ) {
    if ( !redraw ) {
        return;
    }
    if ( !event ) {
        return;
    }
    
    var _diff = max - min;
    
    switch ( timerange ) {
        case "-1d":
        case "-1y":
            return;
        case "-1month":
            if ( _diff <= 691200000 ) {
                __apply_parse_data = 0;
            }
            else {
                __apply_parse_data = 1;
            }
            break;
        case "-1w":
            if ( _diff <= 90000000 ) {
                __apply_parse_data = 0;
            }
            else {
                __apply_parse_data = 1;
            }
            break;
    }
    
    
    if ( __apply_parse_data !== __previous_apply_parse_data ) {
        __previous_apply_parse_data = __apply_parse_data;
        rebuildData();
    }
}

function rebuildData () {
    console.warn( "[rebuildData]" );
    
    __loading_dom.classList.add( 'active' );
    var _chart = __instanceCharts;
    var _size  = _chart.series.length;
    var _current_serie;
    for ( var i = 0; i < _size; i++ ) {
        _current_serie = _chart.series[ i ];
        if ( typeof _current_serie.options.metric === 'undefined' || !_current_serie.options.real_metric || _current_serie.name === 'Navigator' ) {
            continue;
        }
        var _data_server = _current_serie.options.data_server;
        var _new_data    = parseDataForGraph( clone_object( _data_server ), _current_serie.options.interval );
        _current_serie.setData( _new_data, false );
    }
    __instanceCharts.redraw();
    
    setTimeout( function () {
        __loading_dom.classList.remove( 'active' );
    }, 1000 );
    
}

function set_show_trending ( new_trending ) {
    show_trending = new_trending;
}

function set_timerange ( new_timerange ) {
    timerange                   = new_timerange;
    __apply_parse_data          = 1;
    __previous_apply_parse_data = 1;
}

function set_xAxis_min_range ( new_xAxis_min_range ) {
    xAxis_min_range = new_xAxis_min_range;
}

//
// function hash_code ( s ) {
//     return s.split( "" ).reduce( function ( a, b ) {
//         a = ((a << 5) - a) + b.charCodeAt( 0 );
//         return a & a
//     }, 0 );
// }
//
function compute_key ( hname, sdesc ) {
    var key = hname + '--' + sdesc;
    // Protect for HTML ids
    key     = key.replace( /[ .:\[\]\/]/g, '_' );
    return key;
}

Highcharts.Axis.prototype.setExtremes = function ( newMin, newMax, redraw, animation, eventArguments ) {
    var axis  = this,
        chart = axis.chart;
    askForRebuildData( newMin, newMax, redraw, eventArguments );
    
    redraw = Highcharts.pick( redraw, true ); // defaults to true
    
    Array.prototype.forEach.call( axis.series, function ( serie ) {
        delete serie.kdTree;
    } );
    
    // Extend the arguments with min and max
    eventArguments = Highcharts.extend( eventArguments, {
        min: newMin,
        max: newMax
    } );
    
    // Fire the event
    Highcharts.fireEvent( axis, 'setExtremes', eventArguments, function () { // the default event handler
        axis.userMin   = newMin;
        axis.userMax   = newMax;
        axis.eventArgs = eventArguments;
        
        if ( redraw ) {
            if ( fireEventTimeout ) {
                clearTimeout( fireEventTimeout );
            }
            
            fireEventTimeout = setTimeout( function () {
                chart.redraw( animation );
            }, 300 );
        }
    } );
};

function getJsonFailled ( obj, uuid, asked_metric ) {
    var html_unauthorized = '<div class="unauthorized">';
    switch ( obj.status ) {
        case 403:
            html_unauthorized += '<div>' + _( "unauthorized.403_text" ) + '</div>';
            html_unauthorized += '<i class="shinkon-lock"></i>';
            break;
        case 401:
            html_unauthorized += '<div>' + _( "unauthorized.401_text" ) + '</div>';
            html_unauthorized += '<i class="shinkon-lock"></i>';
            break;
        case 404:
            html_unauthorized += '<div>' + _( "unauthorized.404_text" ) + '</div>';
            html_unauthorized += '<i class="shinkon-lock"></i>';
            break;
        case 500:
            html_unauthorized += '<div>' + _( "unauthorized.500_text" ) + '</div>';
            html_unauthorized += '<i class="shinkon-lock"></i>';
            break;
        case 512:
            html_unauthorized += '<div>' + _( "unauthorized.512_text" ) + '</div>';
            html_unauthorized += '<i class="shinkon-lock"></i>';
            break;
        case 513:
            html_unauthorized += '<div>' + _( "unauthorized.513_text" ) + '</div>';
            html_unauthorized += '<i class="shinkon-lock"></i>';
            break;
        default:
            html_unauthorized += '<div>' + obj + '</div>';
            html_unauthorized += '<i class="shinkon-warning"></i>';
            break;
    }
    html_unauthorized += '</div>';
    $( "#error-div" ).html( html_unauthorized );
    $( ".check_list" ).addClass( "disabled_div" );
    
    if ( !DETAIL_GRAPHS_CALL ) {
        var _metric = __instance_list_metric.getMetricByUUID( uuid, asked_metric );
        if ( _metric ) {
            _metric.setDisabledSeries( false, obj.status );
        }
        
        var _nb_series = __instanceCharts.series.length;
        
        for ( var j = 0; j < _nb_series; j++ ) {
            var _current_serie = __instanceCharts.series[ j ];
            if ( _current_serie.options.uuid === uuid && _current_serie.options.metric === asked_metric ) {
                console.log( "window.location.reload" );
                window.location.reload();
            }
        }
        
    }
}

function askComputeNavigator () {
    if ( _timeout_compute_navigator ) {
        clearTimeout( _timeout_compute_navigator );
    }
    _timeout_compute_navigator = setTimeout( function () {
        _timeout_compute_navigator = null;
        compute_navigator();
        __instanceCharts.redraw();
        stop_refreshing();
    }, 1000 );
    
}

function findSeriesWithData ( data, metric_name ) {
    
    var _uuid        = data.uuid;
    var _name_metric = metric_name;
    
    var warn = false;
    var crit = false;
    if ( endsWith( data.mname, '_warn' ) ) {
        warn = true;
    }
    else if ( endsWith( data.mname, '_crit' ) ) {
        crit = true;
    }
    
    var _nb_series = __instanceCharts.series.length;
    var _current;
    for ( var i = 0; i < _nb_series; i++ ) {
        _current = __instanceCharts.series[ i ];
        
        if ( !_current.options ) {
            continue;
        }
        if ( _current.options.uuid !== _uuid ) {
            continue;
        }
        if ( _current.options.metric !== _name_metric ) {
            continue;
        }
        if ( !_current.options.warn && warn ) {
            continue;
        }
        if ( !_current.options.crit && crit ) {
            continue;
        }
        return _current;
    }
    return null;
}

function updateSerie ( serie ) {
    setResetExtremes( false );
    var uuid;
    var asked_metric;
    var updateDone = false;
    if ( !DETAIL_GRAPHS_CALL ) {
        uuid         = serie.getUUID();
        asked_metric = serie.getMetric();
        asked_metric = asked_metric.name;
    }
    else {
        uuid         = serie.options.uuid;
        asked_metric = serie.options.metric;
    }
    console.log( '/api/graphs/data/' + uuid + '?metric=' + asked_metric + '&from=' + timerange + '&trending=' + show_trending );
    var jqxhr = $.getJSON( '/api/graphs/data/' + uuid + '?metric=' + asked_metric + '&from=' + timerange + '&trending=' + show_trending, function ( data ) {
        var _size_data = data.length;
        var _current_serie;
        if ( !DETAIL_GRAPHS_CALL ) {
            serie.refreshSeries( data );
        }
        
        
        for ( var i = 0; i < _size_data; i++ ) {
            _current_serie = findSeriesWithData( data[ i ], data[ i ].metric_name );
            
            if ( _current_serie === null ) {
                // var _series = create_series_from_data( data );
                // push_series_to_highstock( _series, true );
                // continue;
            }
            else {
                if ( update_serie( _current_serie, data[ i ] ) ) {
                    updateDone = true;
                }
            }
        }
        
        // var updateDone = update_serie( serie, data, uuid, hname, sdesc, asked_metric );
        if ( updateDone ) {
            askComputeNavigator();
        }
    } );
    // Catch non working server and show it
    jqxhr.fail( function ( obj ) {
        getJsonFailled( obj, uuid, asked_metric );
    } );
    
}


function start_refreshing () {
    if ( !_dom_element_container ) {
        _dom_element_container = document.getElementById( "cv_graphics_cont" );
    }
    if ( _dom_element_container ) {
        _dom_element_container.classList.add( "refreshing" );
    }
    setTimeout( stop_refreshing, 2000 );
}

function stop_refreshing () {
    if ( !_dom_element_container ) {
        _dom_element_container = document.getElementById( "cv_graphics_cont" );
    }
    if ( _dom_element_container ) {
        _dom_element_container.classList.remove( "refreshing" );
    }
}

function refresh () {
    var _nb_series;
    if ( !__instanceCharts ) {
        return;
    }
    start_refreshing();
    _first_date_parse_data = undefined;
    if ( !DETAIL_GRAPHS_CALL ) {
        _nb_series = __instance_list_metric.size;
        for ( var i = 0; i < _nb_series; i++ ) {
            updateSerie( __instance_list_metric.getMetric( i ) );
        }
    }
    else {
        var _current_serie;
        _nb_series = __instanceCharts.series.length;
        for ( var j = 0; j < _nb_series; j++ ) {
            _current_serie = __instanceCharts.series[ j ];
            if ( _current_serie.options.metric ) { // avoid empty series
                updateSerie( __instanceCharts.series[ j ] );
            }
        }
    }
    
}

function update_serie ( serie, data ) {
    var _old_serie_data_length = serie.data.length;
    if ( !_old_serie_data_length ) {
        return;
    }
    
    serie.options.data_server = data.values;
    var _new_data             = parseDataForGraph( clone_object( data.values ), data.interval );
    serie.setData( _new_data, false );
    
    return true;
}

function re_init () { //old method refresh
    var chart       = loadAllDomElement();
    var old_metrics = [];
    for ( var i = chart.series.length - 1; i >= 0; i-- ) {
        var serie = chart.series[ i ];
        var name  = serie.name;
        if ( typeof serie.options.metric !== 'undefined' && serie.options.real_metric && serie.name !== 'Navigator' ) {
            var metric_info = {
                "uuid"  : serie.options.uuid,
                "hname" : serie.options.hname,
                "sdesc" : serie.options.sdesc,
                "metric": serie.options.metric
            };
            old_metrics.push( metric_info );
        }
        serie.remove( false );
    }
    
    var callback                  = function () {
        callback.nb_metrics_update++;
        if ( callback.nb_metrics_update >= callback.nb_metrics_to_update ) {
            compute_navigator();
        }
    };
    callback.nb_metrics_to_update = old_metrics.length;
    callback.nb_metrics_update    = 0;
    
    for ( var i = 0; i < old_metrics.length; i++ ) {
        var metric_info = old_metrics[ i ];
        add_metric( metric_info.uuid, metric_info.metric, callback );
    }
}