%helper = app.helper
%datamgr = app.datamgr

%# Look for actions if we must show them or not
%global_disabled = ''

%if not helper.can_action(user):
%global_disabled = 'disabled-link'
%end

<script>
    var http_start_time = {{app.http_start_time}};
</script>

%include mainmenu globals()

<div class='span12' style='margin-top:70px; margin-left:0px;'>
    %for imp_id in impacts:
    %impact = impacts[imp_id]

    <div class="shinken-impact well span3" id="{{imp_id}}" onclick="toggleBox('{{imp_id}}')">
        <div class="span12">
            <!--<div class="show-problem" id="show-problem-{{imp_id}}"> </div>-->

            %for i in range(0, impact.business_impact + 1):
            <div class="criticity-icon-{{i}}">
                <img src="/static/{{app.http_start_time}}/images/dollar.png">
            </div>
            %end

            <div class="impact-icon"><img style="width: 64px;height: 64px;" src="{{helper.get_icon_state(helper.get_small_icon_state(impact))}}"></div>
            <div class="impact-rows">
                <div class="impact-row">
                    <span class="impact-name">{{impact.get_name()}}</span>
                    <span>{{app._('dep_tree.is')}}</span>
                    <span class="impact-state-text">{{impact.state}}</span>
                </div>
                <div class="impact-row">
                    <span class="impact-duration">{{app._('dep_tree.since')}} {{helper.print_duration(impact.last_state_change, just_duration=True, x_elts=2)}}</span>
                </div>
            </div>
        </div>
    </div>
    %end

</div>


<script type="text/javascript">
    var impact_to_expand = -1;
</script>


%if len(impacts) == 0:
<div class="no-elements">{{app._('business_apps.no_elements')}}</div>
%end

%# "#######    Now we will output righ panel with all root problems"
<div class="problems-panels span11">
    %# Init
    %pb_id = 0
    %l_pb_id = 0

    %for imp_id in impacts:
    %impact = impacts[imp_id]

    <div class="shinken-problem-panel problems-panel well" id="problems-{{imp_id}}" style="box-shadow: 0 5px 15px rgba(0,0,0,.25);">
        <div class="panel-header row-fluid">
            <div class="span11">
                %for i in range(0, impact.business_impact + 1):
                <div class="criticity-inpb-icon-{{i}}">
                    <img src="/static/{{app.http_start_time}}/images/dollar.png">
                </div>
                %end
                <h2 class="state_{{impact.state.lower()}}">
                    <img style="width: 64px; height:64px" src="{{helper.get_icon_state(helper.get_small_icon_state(impact))}}"/>
                    {{impact.state}}: {{impact.get_full_name()}}
                </h2>
            </div>
            <button class="btn pull-right" type="button" onclick="toggleBox('{{imp_id}}')"><i class="icon-remove"></i></button>
        </div>

        <div style="float:right;">
            <a href="{{!helper.get_link_dest(impact)}}" class='btn'><i class="icon-search"></i> Details</a>
        </div>


        %##### OK, we print root problem NON ack first

        <br style="clear: both" class='hide'>
        <div class='span12'>
            <div class='span5 shinken-history-state-impact-container'>
                %source_problems = [app.helper.get_elt_from_uuid(problem_uuid) for problem_uuid in impact.source_problems]
                %unack_pbs = [pb for pb in source_problems if not pb.problem_has_been_acknowledged]
                %ack_pbs = [pb for pb in source_problems if pb.problem_has_been_acknowledged]

                %nb_unack_pbs = len(unack_pbs)
                %nb_ack_pbs = len(ack_pbs)

                %guessed = []
                %if impact.state_id != 0 and len(unack_pbs+ack_pbs) == 0:
                %guessed = datamgr.guess_root_problems(impact)
                %end

                %if nb_unack_pbs > 0:
                <h4>Root problems unacknowledged:</h4>
                %end

                %for pb in unack_pbs+ack_pbs+guessed:
                    % pb_id += 1
                    % l_pb_id += 1

                    %if nb_ack_pbs != 0 and l_pb_id == nb_unack_pbs + 1:
                    <h4>Acknowledged problems:</h4>
                    %end

                    %if len(guessed) != 0 and l_pb_id == nb_unack_pbs + nb_ack_pbs + 1:
                    <h4>Pure guessed root problems:</h4>
                    %end

                    <div class="" id="{{pb_id}}">
                        <div class="">
                            <img style="width: 32px;height: 32px;" src="{{helper.get_icon_state(helper.get_small_icon_state(pb))}}">
                            {{!helper.get_link(pb)}}
                            <span>{{app._('dep_tree.is')}}</span>
                            <span class="alert-small alert-{{pb.state.lower()}}">{{pb.state}}</span>
                            <span>{{app._('dep_tree.since')}}</span>
                            {{helper.print_duration(pb.last_state_change, just_duration=True, x_elts=2)}}
                        </div>
                        <div class="problem-actions opacity_hover">
                            %disabled_s = ''
                            %if not pb.event_handler:
                            %disabled_s = 'disabled-link'
                            %end
                        </div>
                    </div>

                    %# end for pb in impact.source_problems:
                %end

                %if len(impact.parent_dependencies) > 0:
                %hid = helper.get_html_id(impact)
                <a id="togglelink-{{impact.get_dbg_name()}}" href="javascript:toggleBusinessElt('{{hid}}', '{{impact.get_dbg_name()}}')">
                    {{!helper.get_button(app._('dep_tree.hide_dep_tree'),img='/static/'+str(app.http_start_time)+'/images/reduce.png')}}
                </a>
                <div class="clear"></div>
                {{!helper.print_business_rules(app, datamgr.get_business_parents(impact), source_problems=impact.source_problems, prefix=hid)}}
                %end
            </div>

            <div class='span7 nomargin'>
                %uuid = impact.uuid
                %if impact.__class__.my_type == 'service':
                %uuid="%s-%s"%(impact.host.uuid,uuid)
                %end
                <div id="inner_depgraph-{{imp_id}}" data-elt-id='{{uuid}}'>
                    <!--<span class="alert alert-error"> Cannot load dependency graph.</span>-->
                </div>
            </div>

            <div class='span12'></div>
        </div>
    </div>
    %# end for imp_id in impacts:
    %end
</div>


%rebase layout globals(), js=['impacts/js/impacts.js'], title='All critical impacts for your business', css=['impacts/css/impacts.css'], refresh=True, menu_part = '/impacts', user=user
