var newDetailGraphWidth = function ( new_width ) {
    EXTERNAL_COMMUNICATION.setNewWidthDetail( new_width );
};

EXTERNAL_COMMUNICATION = (function ( self ) {
    "use strict";

    self.NEW_DETAIL_WIDTH = 0;
    self.uncollapsed_id   = {};
    self.displayed_id     = {};

    self.setNewWidthDetail          = function ( new_width ) {
        self.NEW_DETAIL_WIDTH = new_width;
        self.saveUser();
    };
    self.saveUser                   = function () {
        var elem                = angular.element( document.querySelector( '[ng-controller]' ) );
        var injector            = elem.injector();
        var _root_scope_service = injector.get( 'RootScopeService' );
        _root_scope_service.saveUser();
    };
    self.toggleCollapse             = function ( event, _id ) {
        var _target = event.target;
        var _parent = self.findParentElementWithClass( _target, 'shinken-collapsed-parent', 15 );
        if ( _parent ) {
            if ( _parent.classList.contains( 'shinken-collapsed' ) ) {
                _parent.classList.remove( 'shinken-collapsed' );
                self.uncollapsed_id[ _id ] = true;
            }
            else {
                _parent.classList.add( 'shinken-collapsed' );
                self.uncollapsed_id[ _id ] = false;
            }

        }
    };
    self.toggleDisplay              = function ( event, _id ) {
        var _target = event.target;
        var _parent = self.findParentElementWithClass( _target, 'shinken-is-displayed-parent', 15 );
        if ( _parent ) {
            if ( _parent.classList.contains( 'shinken-is-displayed' ) ) {
                _parent.classList.remove( 'shinken-is-displayed' );
                self.displayed_id[ _id ] = false;
            }
            else {
                _parent.classList.add( 'shinken-is-displayed' );
                self.displayed_id[ _id ] = true;
            }

        }
    };
    self.checkCollapseNeeded        = function ( is_init ) {
        var _list = document.querySelectorAll( is_init ? '.shinken-collapsed-parent' : '.shinken-is-today .shinken-collapsed-parent' );
        var _current;
        for ( var i = 0, _size_i = _list.length; i < _size_i; i++ ) {
            _current = _list[ i ].querySelector( '.shinken-output-text' );
            if ( _current.scrollHeight > 52 ){
                _list[ i ].classList.add( 'shinken-collapse-available' );
            }
            else {
                _list[ i ].classList.remove( 'shinken-collapse-available' );
            }
            if ( _current.scrollHeight <= _current.offsetHeight ) {
                _list[ i ].classList.remove( 'shinken-collapsed' );
            }
            else {
                _list[ i ].classList.add( 'shinken-collapsed' );
            }
        }
    };
    self.setCollapseAll             = function ( is_collapse ) {
        var _list = document.querySelectorAll( '.shinken-collapsed-parent' );
        var _current;
        for ( var i = 0, _size_i = _list.length; i < _size_i; i++ ) {
            _current = _list[ i ];
            if ( is_collapse ) {
                _current.classList.add( 'shinken-collapsed' );
            }
            else {
                _current.classList.remove( 'shinken-collapsed' );
            }
        }

        var _list_long_output = document.querySelectorAll( '.shinken-is-displayed-parent' );
        for ( var j = 0, _size_long_output = _list_long_output.length; j < _size_long_output; j++ ) {
            _current = _list_long_output[ j ];
            if ( is_collapse ) {
                _current.classList.remove( 'shinken-is-displayed' );
            }
            else {
                _current.classList.add( 'shinken-is-displayed' );
            }
        }

        var _keys = Object.keys( self.uncollapsed_id );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            self.uncollapsed_id[ _keys[ i ] ] = !is_collapse;
        }
        var _keys = Object.keys( self.displayed_id );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            self.displayed_id[ _keys[ i ] ] = !is_collapse;
        }
    };
    self.findParentElementWithClass = function ( element, class_to_find, deepLimit ) {
        if ( !element ) {
            return null;
        }
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.classList.contains( class_to_find ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_to_find, deepLimit );
    };

    return self;

})( {} );