SHINKEN_TOOLTIP = (function ( self ) {
    "use strict";

    self.PLACEMENT                = {};
    self.PLACEMENT.LEFT           = 'left';
    self.PLACEMENT.RIGHT          = 'right';
    self.PLACEMENT.TOP            = 'top';
    self.PLACEMENT.TOP_LEFT       = 'top-left';
    self.PLACEMENT.TOP_RIGHT      = 'top-right';
    self.PLACEMENT.BOTTOM         = 'bottom';
    self.PLACEMENT.BOTTOM_LEFT    = 'bottom-left';
    self.PLACEMENT.BOTTOM_RIGHT   = 'bottom-right';
    self.TYPE                     = {};
    self.TYPE.ERROR               = 'shinken-error';
    self.TYPE.ERROR_BORDER        = 'shinken-error-border';
    self.TYPE.WARNING             = 'shinken-warning';
    self.TYPE.WARNING_BORDER      = 'shinken-warning-border';
    self.TYPE.BEWARE_BORDER       = 'shinken-beware-border';
    self.TYPE.NORMAL_DISCREET     = 'shinken-normal-discreet';
    self.CONDITION                = {};
    self.CONDITION.SHIFT          = 'shinken-shift';
    self.CONDITION.CTRL_SHIFT     = 'shinken-ctrl-shift';
    self.CONDITION.ELLIPSIS       = 'shinken-ellipsis';
    self.TYPE_TO_CHECK            = {};
    self.TYPE_TO_CHECK.CLASS      = 'class';
    self.STYLE                    = {};
    self.STYLE.PADDING_HORIZONTAL = 8;
    self.STYLE.PADDING_VERTICAL   = 4;
    self.STYLE.MIN_WIDTH_TEXT     = 60;
    self.STYLE.HEIGHT_TEXT_LINE   = 20;
    self.STYLE.ARROW_SIZE         = 5;
    self.DEFAULT                  = {};
    self.DEFAULT.TIMER_POP        = 100;
    self.MAX_TRY_IN_SCREEN        = 10;

    var __container;
    var __text_container;
    var __type;
    var __condition;
    var __arrow;
    var __placement;
    var __placement_origin;
    var __try;
    var __innerText;
    var __innerHtml;
    var __width;
    var __height;
    var __timer_pop;
    var __classes_added;
    var __timeout_pop;
    var __interval_pop_out;
    var __interval_auto_scroll;
    var __timeout_auto_scroll;
    var __pos_top;
    var __pos_left;

    //public
    self.showTooltipIf = function ( element, type_to_check, value, check_if_not ) {
        if ( !value || !type_to_check ) {
            return;
        }
        switch ( type_to_check ) {
            case self.TYPE_TO_CHECK.CLASS:
                var _has_class = element.classList.contains( value );
                if ( check_if_not ) {
                    _has_class = !_has_class;
                }
                if ( _has_class ) {
                    self.showTooltip( element );
                }
                break;
            default:
                console.log( "Type not manage" );
                break;
        }
    };
    self.showTooltip   = function ( element ) {
        if ( !element ) {
            return;
        }
        if ( !__container ) {
            initDomElement();
        }
        if ( !__container ) {
            return;
        }

        __try = 0;
        clean();
        setTimerPop( element );
        setText( element );
        setHTML( element );
        setType( element );
        setCondition( element );
        if ( __innerText || __innerHtml ) {
            setClass( element );
            getSize();
            setPlacement( element );
            setPosition( element );
            setArrow();
            launchIntervalPopOut( element );
            launchIntervalAutoScroll( element );
        }
    };
    self.hideTooltip   = function () {
        if ( __container ) {
            setActive( false );
            clean();
        }
    };

    //private

    function setPlacement ( element ) {
        cleanArrow();
        __placement        = element.getAttribute( 'shi-tip-placement' ) || self.PLACEMENT.TOP;
        __placement_origin = __placement;
    }

    function setActive ( _bool ) {
        if ( _bool ) {
            __container.classList.add( 'shinken-tooltip-active' );
        }
        else {
            __container.classList.remove( 'shinken-tooltip-active' );
        }
    }

    function setArrow () {
        __container.classList.add( __placement );
    }

    function cleanIntervalPopOut () {
        if ( __interval_pop_out ) {
            clearInterval( __interval_pop_out );
            __interval_pop_out = null;
        }
    }

    function cleanIntervalAutoScroll () {
        __text_container.scrollTop = -400;
        if ( __timeout_auto_scroll ) {
            clearTimeout( __timeout_auto_scroll );
            __timeout_auto_scroll = null;
        }
        if ( __interval_auto_scroll ) {
            clearInterval( __interval_auto_scroll );
            __interval_auto_scroll = null;
        }
    }

    function launchIntervalPopOut ( element ) {
        cleanIntervalPopOut();
        var _data_timer                = new Date().getTime();
        var _selector                  = "[data-shinken-tooltip='" + _data_timer + "']";
        element.dataset.shinkenTooltip = _data_timer;
        __interval_pop_out             = setInterval( function () {
            var _elements = document.querySelector( _selector );
            if ( !_elements ) {
                setActive( false );
                cleanIntervalPopOut();
            }
        }, 1000 );
    }

    function launchIntervalAutoScroll ( element ) {
        cleanIntervalAutoScroll();
        if ( __text_container.clientHeight < __text_container.scrollHeight ) {
            __timeout_auto_scroll = setTimeout( function () {
                __interval_auto_scroll = setInterval( function () {
                    __text_container.scrollTop = __text_container.scrollTop + 1;
                    if ( __text_container.scrollTop >= __text_container.scrollHeight - __text_container.clientHeight ) {
                        __timeout_auto_scroll = setTimeout( function () {
                            launchIntervalAutoScroll();
                        }, 2000 )
                    }
                }, 100 );
            }, 2000 )

        }

    }

    function cleanArrow () {
        __container.classList.remove( __placement );
    }

    function cleanRectWidth ( _rect ) {
        var _to_return = Math.min( _rect.width, 600 );
        if ( __classes_added ) {
            if ( __classes_added.indexOf( '300' ) !== -1 ) { //BGL  A REFAIRE PROPRE
                _to_return = Math.min( _to_return, 300 );
            }
        }
        return _to_return;
    }

    function setPosition ( element_to_bind ) {
        clean();
        var _rect       = element_to_bind.getBoundingClientRect();
        var _width_rect = cleanRectWidth( _rect );
        if ( !_width_rect ) {
            return; //ELEMENT NOT DISPLAYED
        }
        switch ( __placement ) {
            case self.PLACEMENT.TOP:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.TOP_LEFT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect +  2 * self.STYLE.ARROW_SIZE ;
                break;
            case self.PLACEMENT.TOP_RIGHT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.LEFT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left - __width);
                break;
            case self.PLACEMENT.RIGHT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left + _width_rect);
                break;
            case self.PLACEMENT.BOTTOM:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.BOTTOM_LEFT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect +  2 * self.STYLE.ARROW_SIZE ;
                break;
            case self.PLACEMENT.BOTTOM_RIGHT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
        }

        if ( isInScreen() ) {
            __timeout_pop = setTimeout( function () {
                __container.style.top  = __pos_top + 'px';
                __container.style.left = __pos_left + 'px';
            }, __timer_pop );
        }
        else {
            setPosition( element_to_bind );
        }
    }

    function isInScreen () {
        var _to_return = true;

        if ( __pos_left < -10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (__pos_left + __width) > window.innerWidth - 10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                case self.PLACEMENT.RIGHT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( __pos_top < -10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (__pos_top + __height) > window.innerHeight - 10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        __try++;
        if ( __try > self.MAX_TRY_IN_SCREEN ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            __placement = __placement_origin;
            _to_return  = true;
        }
        return _to_return;


    }

    function initDomElement () {
        __container = document.getElementById( "shi-tip" );
        if ( __container ) {
            __text_container = __container.querySelector( ".shi-tip-text" );
            __arrow          = __container.querySelector( ".shi-tip-arrow" );
        }
    }

    function setText ( element ) {
        __innerText = element.getAttribute( 'shi-tip-text' );
        if ( __innerText ) {
            __text_container.innerHTML = __innerText;
        }
    }

    function setHTML ( element ) {
        __innerHtml = element.getAttribute( 'shi-tip-html' );
        if ( __innerHtml ) {
            __text_container.innerHTML = __innerHtml;
        }
    }

    function setType ( element ) {
        __type                   = element.getAttribute( 'shi-tip-type' ) || false;
        __container.dataset.type = __type;
    }

    function setCondition ( element ) {
        __condition = element.getAttribute( 'shi-tip-condition' ) || false;
        if ( __condition === SHINKEN_TOOLTIP.CONDITION.ELLIPSIS && element.offsetWidth < element.scrollWidth ) {
            __condition = '';
        }
        __container.dataset.condition = __condition;
    }

    function setTimerPop ( element ) {
        __timer_pop = element.getAttribute( 'shi-tip-timer-pop' ) || self.DEFAULT.TIMER_POP;
    }

    function setClass ( element ) {
        __classes_added = element.getAttribute( 'shi-tip-class' );
        if ( !__classes_added ) {
            __classes_added = '';
        }
        __container.className = __classes_added;
    }

    function getSize () {
        setActive( true );
        var _sizes = __container.getBoundingClientRect();
        __width    = _sizes.width;
        __height   = _sizes.height;
    }

    function clean () {
        __container.style.top  = '-5000px';
        __container.style.left = '-5000px';
        clearTimeout( __timeout_pop );
        cleanIntervalPopOut();
        cleanIntervalAutoScroll();
    }

    return self;

})( {} );