//__lib__ lib_external
'use strict';

SHINKEN_LIST.Set           = function ( dom_element, type ) {
    //lines
    //filters
    //headers
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Set.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initHeaders( this.dom_element.querySelectorAll( '.shinken-list-header' ) );
        this.filters               = new SHINKEN_LIST.Filters( dom_element, this.type );
        this.lines                 = new SHINKEN_LIST.Lines( dom_element, this.type );
        this.is_all_data_selected  = this.dom_element.classList.contains( "shinken-selected" ) ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        this.is_all_data_collapsed = false;
        this.updateHtml();
    },
    initHeaders          : function ( dom_elements ) {
        this.headers = [];
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.headers[ i ] = new SHINKEN_LIST.Header( this.type, dom_elements[ i ] );
        }
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        var _type = args['type'];
        switch ( _type ) {
            case 'shinken-list-filter':
                this.lines.applyFilter( this.filters.getActiveFilters() );
                this.setSelectAllStatus();
                break;
            case 'shinken-hide-all-element':
                this.lines.hideAllLines();
                break;
        }
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.mapping[ name ].toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.setIsCollapseAllData( false );
        this.lines.toggleCollapse( uuid );
    },
    clickOnSelector      : function ( event ) {
        var _filter = this.filters.clickOnSelector( event );
        this.hidePopup( _filter );
    },
    clickOnItemSelector  : function ( event ) {
        this.filters.clickOnItemSelector( event );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        this.doActionAfterChange( {'type' : _parent_dom_element.dataset.objectType} );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setIsCollapseAllData : function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData      : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus   : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
    },
    selectAllData        : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines     : function () {
        return this.lines.getSelected();
    },
    getNotSelectedLines  : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet   : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    addLine              : function ( dom_element ) {
        this.lines.add( dom_element );
        this.updateHtml();
    },
    removeLine           : function ( uuid ) {
        this.lines.remove( uuid );
        this.updateHtml();
    },
    getLineByUUID        : function ( uuid ) {
        return this.lines.getByUUID( uuid );
    },
    //********************************************  OTHERS  *****************************************************//
    hidePopup            : function ( _filter ) {
        this.filters.hidePopup( _filter );
    },
    //********************************************  OTHERS  *****************************************************//
    updateHtml           : function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave        : function ( type ) {
        return this.lines.getDataToSave( type );
    }
};