'use strict';

MANAGER.DragNDropSourceManager = {
    
    dragged_source: null,
    source_all    : MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL ),
    pause_timeout : null,
    
    dragStartSource: function( event, source_name ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        // Fix pour firefox
        event.dataTransfer.setData( 'text', 'anything' );
        // end Fix
        this.source_all.stopAutoRefresh();
        this.dragged_source = this.source_all.getSource( source_name );
        this.dragged_source.dragStartSource();
    },
    dragOverSource : function( event, source_name ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.preventDefault();
        
        if ( this.pause_timeout ) {
            return;
        }
        var _source_overred = this.source_all.getSource( source_name );
        if ( this.dragged_source.getOrder() === _source_overred.getOrder() ) {
            return;
        }
        this.source_all.changeSourcePosition( this.dragged_source, _source_overred );
        
        
        
        var self           = this;
        self.pause_timeout = setTimeout( function() {
            self.pause_timeout = null;
            //SI ON EST ENTRE DEUX ELEMENT DE LONGUEUR DIFFERENTE CELA EVITE UN SWITCH PERPETUEL
        }, 500 );
    },
    dropSource     : function( event ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.preventDefault();
        this.source_all.sendNewOrderToBackend();
    },
    dragEndSource  : function( event ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.preventDefault();
        this.dragged_source.resetDragging();
        this.dragged_source = null;
        MANAGER.__instance_source_distributor.reorderAllSourceDom();
        this.source_all.startAutoRefresh();
    }
};