//__lib__ lib_external
//priority 10
DOM.ScrollService = (function ( self ) {
    "use strict";
    
    self.getMiddleScrollPosition       = function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        return ((_bottom - _top) / 2) + _top;
    };
    self.getFirstVisibleDom            = function ( dom_element_container, css_selector_children, move_down ) {
        var _position = DOM.Service.getBoundingClientRect( dom_element_container, move_down ? DOM.CONST.STYLE.TOP : DOM.CONST.STYLE.BOTTOM );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _position, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFromMiddle = function ( dom_element_container, css_selector_children, move_down ) {
        var _middle_pos = DOM.ScrollService.getMiddleScrollPosition( dom_element_container );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _middle_pos, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFrom       = function ( list, position, move_down, dom_element_container ) {
        var _size  = list.length;
        var _index = move_down ? _size - 1 : 0;
        var _delta = move_down ? -1 : 1;
        
        var _closer_index     = _index;
        var _last_closer_diff = 9999;
        var _current;
        for ( ; _index < _size && _index >= 0; _index = _index + _delta ) {
            _current = list[ _index ];
            if ( !DOM.Service.isVisible( _current ) ) {
                continue;
            }
            if ( !DOM.Service.isFullyVisibleInParent( _current, dom_element_container ) ) {
                continue;
            }
            var _median = DOM.Service.getBoundingClientRect( _current, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
            if ( Math.abs( _median - position ) < _last_closer_diff ) {
                _last_closer_diff = Math.abs( _median - position );
                _closer_index     = _index;
                continue;
            }
            else {
                break;
            }
        }
        return list[ _closer_index ];
    };
    self.isVisible                     = function ( dom_element_container, dom_element_to_test, marge, action_type ) {
        if ( !dom_element_to_test ) {
            return false;
        }
        marge               = marge || 0;
        var _rect_to_test   = dom_element_to_test.getBoundingClientRect();
        var _rect_container = dom_element_container.getBoundingClientRect();
        
        if ( action_type ) {
            if ( _rect_to_test.bottom - _rect_container.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
            }
            if ( _rect_container.bottom - _rect_to_test.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_TOP;
            }
            return true;
        }
        else {
            return _rect_to_test.bottom - _rect_container.top >= marge && _rect_container.bottom - _rect_to_test.top >= marge;
        }
    };
    self.bindWith                      = function ( dom_element, dom_element_to_bind_with, previous_position_vertical, action_type ) {
        switch ( action_type ) {
            case DOM.CONST.ATTRIBUTE.SCROLL_TOP:
            case DOM.CONST.ATTRIBUTE.SCROLL_DOWN:
                if ( self.isVisible( dom_element, dom_element_to_bind_with, 3 * DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT ), action_type ) ) {
                    return;
                }
                else {
                    var _delta = DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT );
                    if ( previous_position_vertical ) {
                        _delta = previous_position_vertical - DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                    }
                    self.changeVerticaly( dom_element, _delta, action_type );
                }
                break;
        }
    };
    self.changeVerticaly               = function ( dom_element, delta, action_type ) {
        dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] = Math.ceil( dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] - delta );
    };
    
    return self;
})( DOM.ScrollService || {} );
