#!/bin/bash


# Exit as the first error command
set -e



cd /tmp

RETURN_FILE="/tmp/shinken-local-analyzer-payload.json"
EXCUTION_LOG=/tmp/shinken-local-analyzer-payload.log


rm -fr analyzer $RETURN_FILE $EXCUTION_LOG

echo "Executing the discovery of this host and get back data to the Shinken Enterprise daemons" | tee -a $EXCUTION_LOG
echo "Local server `hostname` :: Ips: `hostname -I`" | tee -a $EXCUTION_LOG

echo "---- 1/4 untaring" | tee -a $EXCUTION_LOG
tar xfz server-analyzer.tar.gz | tee -a $EXCUTION_LOG
cd analyzer

# Allow the shinken-enterprise module to run
# theses commands are fast (no network) so we do not expect them to timeout
echo "---- 2/4 configuring" | tee -a $EXCUTION_LOG
python -u bin/opsbro packs overload global.shinken-enterprise                                  2>&1 | tee -a $EXCUTION_LOG
python -u bin/opsbro packs parameters set local.shinken-enterprise.enabled True                2>&1 | tee -a $EXCUTION_LOG
python -u bin/opsbro packs parameters set local.shinken-enterprise.file_result "$RETURN_FILE"  2>&1 | tee -a $EXCUTION_LOG

# Be sure to disable websocket, we do not want it
python -u bin/opsbro packs overload global.websocket                                           2>&1 | tee -a $EXCUTION_LOG
python -u bin/opsbro packs parameters set local.websocket.enabled False                        2>&1 | tee -a $EXCUTION_LOG


echo "---- 3/4 executing" | tee -a $EXCUTION_LOG
# Launch the agent in a one-shot mode (not a daemon, only one loop)
# Timeout after 125s (120 from the ssh + 5s bonus so the timeout will be the ssh one)
# NOTE: --preserve-status => cannot be used because centos6 do not have it
# --signal=9 => when timeout, just kill it and all it's sons
timeout --signal=9 125s python -u bin/opsbro agent start --one-shot                            2>&1 | tee -a $EXCUTION_LOG


echo "---- 4/4 cleaning" | tee -a $EXCUTION_LOG

cd /tmp
rm -fr analyzer server-analyzer.tar.gz execute_analyzer_on_server.sh
