#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

import bson
import pymongo

from ec_module_broker import EventContainerBrokerModule
from ec_module_webui import EventContainerWebUIModule

properties = {
    'daemons' : ['broker', 'webui'],
    'type'    : 'event_container',
    'external': False,
}


# called by the plugin manager to get a module instance
def get_instance(configuration, module_on):
    if not pymongo.has_c():
        raise Exception('Your pymongo lib has not the C extension installed')
    if not bson.has_c():
        raise Exception('Your bson lib has not the C extension installed')
    
    if module_on == 'broker':
        return EventContainerBrokerModule(configuration)
    elif module_on == 'webui':
        return EventContainerWebUIModule(configuration)
