#!/usr/bin/python

# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.


import os

from shinken.basemodule import BaseModule
from shinken.log import logger

properties = {
    'daemons': ['webui'],
    'type': 'reporting_log',
    'external': False,
    }


# called by the plugin manager to get a broker
def get_instance(mod_conf):
    logger.info("[ReportingLog] Get ReportingLog module for plugin %s" % mod_conf.get_name())
    instance = Reporting_Log(mod_conf)
    return instance



class Reporting_Log(BaseModule):
    def __init__(self, mod_conf):
        BaseModule.__init__(self, mod_conf)
        self.server = mod_conf.server
        self.database = mod_conf.database


    # Called by Broker to say 'let's prepare yourself guy'
    def init(self):
        pass
        #HERE CONNECT TO MONGODB an assume indexs if need


    # Ok We got some plugins for WebUI, so give the info at WebUI :)
    def get_webui_plugins_path(self, webui):
        my_dir = os.path.os.path.dirname(__file__)
        plugins_dir = os.path.join(my_dir, 'plugins')
        return plugins_dir
