//******************************  START  main.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/traductions/main.js *
function __gup ( name, url ) {
    if ( !url ) {
        url = location.href;
    }
    name        = name.replace( /[\[]/, "\\\[" ).replace( /[\]]/, "\\\]" );
    var regexS  = "[\\?&]" + name + "=([^&#]*)";
    var regex   = new RegExp( regexS );
    var results = regex.exec( url );
    return results == null ? null : results[ 1 ];
}

function _find_lang_obj () {
    var lang = __gup( 'lang' );
    if ( lang == null ) {
        lang = global_lang;
    }
    if ( lang == 'en' ) {
        return lang_en;
    }
    if ( lang == 'fr' ) {
        return lang_fr;
    }
    return lang_en;
    
}

/* find the traduction of a call in the lang objects, if cannot find in the lang, fail back to the en one */
function _ ( s ) {
    var lang_obj = _find_lang_obj();
    var elts     = s.split( '.' );
    var p        = lang_obj;
    for ( var i = 0; i < elts.length; i++ ) {
        var key = elts[ i ];
        p       = p[ key ];
        if ( typeof p == 'undefined' ) {
            return 'TO_TRAD(' + s + ')';
        }
    }
    return p;
}

//******************************  END  main.js   **************************

//******************************  START  common.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/common.js *
var ITEM_TYPE = {
    ELEMENTS: 'elements',
    
    CLUSTERS   : 'clusters',
    CLUSTERTPLS: 'clustertpls',
    
    HOSTS     : 'hosts',
    HOSTTPLS  : 'hosttpls',
    HOSTGROUPS: 'hostgroups',
    
    SERVICESHOSTS      : 'serviceshosts',
    SERVICESHOSTTPLS   : 'serviceshosttpls',
    SERVICESCLUSTERS   : 'servicesclusters',
    SERVICESCLUSTERTPLS: 'servicesclustertpls',
    SERVICETPLS        : 'servicetpls',
    
    CONTACTS     : 'contacts',
    CONTACTTPLS  : 'contacttpls',
    CONTACTGROUPS: 'contactgroups',
    
    ESCALATIONS              : 'escalations',
    NOTIFICATIONWAYS         : 'notificationways',
    COMMANDS                 : 'commands',
    BUSINESSIMPACTMODULATIONS: 'businessimpactmodulations',
    MACROMODULATIONS         : 'macromodulations',
    RESULTMODULATIONS        : 'resultmodulations',
    TIMEPERIODS              : 'timeperiods',
    PACK                     : 'packs',
    PLUGIN                   : 'plugins',
    
    // These 2 object types are used to have a distinction between "my objects" and "all objects"
    WORKING_AREA   : 'working_area',
    MY_WORKING_AREA: 'my_working_area'
};
var AREAS     = {
    STAGING        : 'staging',
    WORKING_AREA   : 'working_area',
    MY_WORKING_AREA: 'my_working_area'
};
var CONTEXTS  = {
    success: "success",
    warning: "warning",
    error  : "error",
    beware : "beware",
    unknown: "unknown"
};
var MESSAGES  = {
    same: _( "element.tooltip_same" ),
    max : _( "element.tooltip_max" ),
    min : _( "element.tooltip_min" )
};
var REGEXS    = {
    MISSING_GLOBAL        : /__MISSING_GLOBAL__/g,
    MISSING_ARGN          : /__MISSING_ARGN__/g,
    UNKNOWN_DATA          : /__UNKNOWN_DATA__/g,
    MISSING_DFE           : /__MISSING_DFE__/g,
    PROTECTED_PASSWORD    : /__PROTECTED_PASSWORD__/g,
    DOUBLEDOLLAR          : /__DOUBLEDOLLAR__/g,
    // parse_dfe:       /\s*([^,]+?)\s*(?:\$\((.+?)\)\$)*(?:[,]|$)/g,
    parse_dfe             : /\s*([^,]+?)\s*(?:\$\((?:.+?)\)\$)*\s*(?:[,]|$)/g, // Allows to get the $key$ and is group of args.
    parse_dfe_args        : /\s*(?:\$\((.+?)\)\$)\s*/g, // Allows to match value in the group of args.
    parse_dfe_args_reverse: /\s*(?:\)\$(.+?)\$\()\s*/g, // Allows to match value out of the group of args, it mean the syntax  is not valid.
    parse_arguments       : /(\$.*?\$)/g
};

var App = {};

App.Scope = (function ( self ) {
    "use strict";
    
    // Verbose levels
    var _debug = 0,
        _v     = (_debug >= 1),
        _vv    = (_debug >= 2),
        _vvv   = (_debug >= 3);
    
    // Public
    /**
     * Generate something that it look like to a uid.
     * @returns {string}
     */
    self.generateUuid = function () {
        function s4 () {
            return Math.floor( (1 + Math.random()) * 0x10000 )
                       .toString( 16 )
                       .substring( 1 );
        }
        
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    };
    /**
     * Translate tool, allows to add variable easily in text.
     * @returns {*}
     */
    self.format = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.isInteger = function ( x ) {
        return (typeof x === 'number') && (x % 1 === 0);
    };
    /**
     * Allows to adjust the size of the $bottom contained in $container, relative to the $top.
     * @param $top
     * @param $bottom
     * @param $container
     * @param forceTop
     */
    self.adjustHeight = function ( $top, $bottom, $container, forceTop ) {
        forceTop         = (forceTop === false || forceTop) ? forceTop : true;
        var topHeight    = ($top.height() == 0) ? 0 : $top.outerHeight( true );    // Give the height with the margin and padding if the element is not display: none.
        var bottomHeight = ($bottom.height() == 0) ? 0 : $bottom.outerHeight( true ); // Give the height with the margin and padding if the element is not display: none.
        
        var containerHeight       = $container.height(); // Give the size with the padding.
        var height_already_adjust = (bottomHeight + topHeight) !== containerHeight;
        
        if ( height_already_adjust ) {
            if ( forceTop ) {
                $bottom.css( 'top', topHeight );
            }
            // We get the margin apply to the container.
            var marginTop    = $bottom.css( 'margin-top' );
            var marginBottom = $bottom.css( 'margin-bottom' );
            marginTop        = (marginTop) ? marginTop.replace( 'px', '' ) : 0;
            marginBottom     = (marginBottom) ? marginBottom.replace( 'px', '' ) : 0;
            
            var margin = parseInt( marginTop ) + parseInt( marginBottom );
            $bottom.css( 'height', (containerHeight - topHeight) - margin );
        }
    };
    self.resetAdjustHeight = function ( $target ) {
        $target.css( 'height', '' );
        $target.removeAttr( 'style' );
    };
    // TODO: Temp
    self.adjustHeightMulti = function ( $top, $bottom, $container, forceTop ) {
        for ( var i = 0, l = $top.length; i > l; i++ ) {
            var _$top           = $top[ i ],
                _$bottom        = $bottom[ i ],
                _$container     = $container[ i ];
            forceTop            = (forceTop === false || forceTop) ? forceTop : true;
            var topHeight       = _$top.outerHeight( true ),    // Give the height with the margin.
                bottomHeight    = _$bottom.outerHeight( true ); // Give the height with the margin.
            var containerHeight = _$container.height(), // Give the size with the padding.
                calcul          = (bottomHeight + topHeight);
            // console.log( 'app new', containerHeight, '-', topHeight, '=', containerHeight - topHeight );
            if ( calcul !== containerHeight ) {
                if ( forceTop ) {
                    _$bottom.css( 'top', topHeight );
                }
                // We get the margin apply to the container.
                var margin       = 0,
                    marginTop    = _$bottom.css( 'margin-top' ),
                    marginBottom = _$bottom.css( 'margin-bottom' );
                marginTop        = (marginTop) ? marginTop.replace( 'px', '' ) : 0;
                marginBottom     = (marginBottom) ? marginBottom.replace( 'px', '' ) : 0;
                margin           = parseInt( marginTop ) + parseInt( marginBottom );
                _$bottom.css( 'height', (containerHeight - topHeight) - margin );
            }
        }
    };
    
    /**
     * Sort JavaScript Object
     * order = 'asc' or 'desc'
     */
    self.sortObj = function ( obj, order ) {
        var keys    = Object.keys( obj ),
            tempObj = {};
        keys.sort(
            function ( a, b ) {
                return a.toLowerCase().localeCompare( b.toLowerCase() );
            }
        );
        if ( order === 'desc' ) {
            for ( var i = keys.length - 1; i >= 0; i-- ) {
                tempObj[ keys[ i ] ] = obj[ keys[ i ] ];
            }
        }
        else {
            for ( var i = 0, l = keys.length; i < l; i++ ) {
                tempObj[ keys[ i ] ] = obj[ keys[ i ] ];
            }
        }
        return tempObj;
    };
    // TODO todo logger system
    self.debug = function ( text ) {
        if ( level < 1 ) {
            console.log( text );
        }
    };
    self.info  = function ( text ) {
        if ( level < 2 ) {
            console.log( text );
        }
    };
    self.error = function ( text ) {
        if ( level < 3 ) {
            console.log( text );
        }
    };
    
    
    return self;
})( App.Scope || {} );
/**
 *
 * @deprecated V02.06
 */
App.Scope.Tags = (function ( self, Tooltip ) {
    "use strict";
    
    var config = {
        defaults: {
            id     : '',
            class  : '',
            clear  : false,
            context: 'error',
            message: '',
            html   : true,
            auto   : true,
            show   : 'mouseenter',
            hide   : 'mouseleave'
        }
    };
    
    // Public
    self.create  = function ( label, options ) {
        return this.set( $( '<span/>' ), label, options );
    };
    self.set     = function ( $tag, label, options ) {
        options = options || {};
        options = $.extend( {}, config.defaults, options );
        
        (options.html) ? $tag.html( label ) : $tag.text( label );
        
        if ( options.id ) {
            $tag.attr( 'id', options.id );
        }
        
        $tag.removeClass( 'tag-success tag-info tag-warning tag-error tag-beware' );
        $tag.addClass( (!options.clear) ? 'tag tag-' + options.context + ' tag-btn-js '.concat( options.class ) : options.class );
        
        if ( options.message ) {
            $tag.on( options.show, function () {
                Tooltip.reset();
                Tooltip.create( $( this ), options.message, { context: options.context } );
            } );
            if ( options.auto === true ) {
                $tag.on( options.hide, function () {
                    Tooltip.destroy( $( this ) );
                } );
            }
        }
        return $tag;
    };
    self.destroy = function ( element ) {
        element.remove();
    };
    
    return self;
})( App.Scope.Tags || {}, App.Scope.Tooltips || {} );
/**
 * Scope MANAGER helpers.
 */
App.StorageManager = (function ( self ) {
    "use strict";
    
    var config = {
        defaults: {
            isPersistent: false,
            prefix      : 'shinken_'
        }
    };
    
    // Private
    var _list  = [ localStorage, sessionStorage ],
        _param = function ( options ) {
            options = options || {};
            return $.extend( {}, config.defaults, options );
        };
    
    // Public
    self.setItem          = function ( id, value, options ) {
        options     = _param( options );
        var storage = (options.isPersistent) ? localStorage : sessionStorage;
        try {
            storage.setItem( options.prefix.concat( id ), JSON.stringify( value ) );
        }
        catch ( e ) {
            storage.clear();
        }
        
        return value;
    };
    self.getItem          = function ( id, options ) {
        options = _param( options );
        
        var result = null;
        for ( var i = 0, l = _list.length; i < l; i++ ) {
            var storage = _list[ i ];
            result      = JSON.parse( storage.getItem( options.prefix.concat( id ) ) );
            if ( result ) {
                break;
            }
        }
        return result;
    };
    self.removeItem       = function ( id, options ) {
        options     = _param( options );
        var storage = (options.isPersistent) ? localStorage : sessionStorage;
        storage.getItem( options.prefix.concat( id ) );
    };
    self.clear            = function () {
        sessionStorage.clear();
        localStorage.clear();
    };
    self.getSizeOfStorage = function () {
        var _lsTotal = 0,
            total,
            _xLen,
            _x;
        for ( var i = 0, l = _list.length; i < l; i++ ) {
            var storage = _list[ i ];
            for ( _x in storage ) {
                _xLen = ((storage[ _x ].length + _x.length) * 2);
                _lsTotal += _xLen;
                // console.log( (_xLen / 1024).toFixed( 2 ) + " KB = " + ((i == 1) ? 'localStorage: ' : 'sessionStorage: ') + _x.substr( 0, 50 ) );
            }
        }
        total = (_lsTotal / 1024).toFixed( 2 );
        // console.log( "Total = " + total + " KB" );
        return total;
    };
    
    return self;
})( App.StorageManager || {} );
App.HistoryManager = (function ( self, Scope, Storage ) {
    "use strict";
    
    var config = {
        defaults: {
            url   : '/',                // Default page if no previous page.
            prefix: 'shinken_history_', // The cookie or storage prefix.
            limit : '50'                // The number of pages that can be traced.
        }
    };
    
    // Private
    var _uid      = null,
        _handlers = null;
    
    // Verbose levels
    var _debug = 0,
        _v     = (_debug >= 1), // public
        _vv    = (_debug >= 2), // private
        _vvv   = (_debug >= 3); // other
    
    var _getRootUrl        = function () {
        var _urlName  = window.location.pathname,
            _urlParam = window.location.search;
        return (_urlParam) ? _urlName.concat( _urlParam ) : _urlName;
    };
    var _getHistoryStorage = function ( id, valueDefault, options ) {
        var data = Storage.getItem( id, options );
        if ( !data ) {
            Storage.setItem( id, data = valueDefault || '', options );
        }
        return data;
    };
    var _getHandlers       = function ( attr ) {
        if ( _handlers && (_uid in _handlers) && (attr in _handlers[ _uid ]) ) {
            return _handlers[ _uid ][ attr ];
        }
        else {
            console.error( Scope.format( 'History, the {0} asked does not exist', attr ) );
        }
    };
    var _setTime           = function () {
        var now                     = new Date().getTime();
        _handlers[ _uid ][ 'time' ] = now;
        return now;
    };
    var _getDate           = function ( date ) {
        var date    = new Date( date ),
            hours   = date.getHours(),
            minutes = "0" + date.getMinutes(),
            seconds = "0" + date.getSeconds();
        // Will display time in 10:30:23 format.
        return hours + ':' + minutes.substr( -2 ) + ':' + seconds.substr( -2 );
    };
    
    // Get history of last tab to put it in the new one.
    var _initListenerActiveTab  = function () {
        // Set the name of the hidden property and the change event for visibility
        var hidden,
            visibilityChange;
        if ( typeof document.hidden !== "undefined" ) { // Opera 12.10 and Firefox 18 and later support
            hidden           = "hidden";
            visibilityChange = "visibilitychange";
        }
        else if ( typeof document.msHidden !== "undefined" ) {
            hidden           = "msHidden";
            visibilityChange = "msvisibilitychange";
        }
        else if ( typeof document.webkitHidden !== "undefined" ) {
            hidden           = "webkitHidden";
            visibilityChange = "webkitvisibilitychange";
        }
        
        var handleVisibilityChange = function () {
            if ( !document[ hidden ] ) {
                // Tab is active
                // Save
                self.setHandlers();
            }
        };
        
        // Warn if the browser doesn't support addEventListener or the Page Visibility API
        if ( typeof document.addEventListener === "undefined" || typeof document[ hidden ] === "undefined" ) {
            console.error( "This browser doesn't support the Page Visibility API" );
        }
        else {
            // Handle page visibility change
            document.addEventListener( visibilityChange, handleVisibilityChange, false );
        }
    };
    var _getLastActiveTab       = function () {
        var tabs = Object.keys( _handlers ),
            time = new Date( '1980-01-01' ).getTime();
        
        // uid of the last used tab.
        var resultUid = _uid; //.slice(0, -1) ; // Clone for be sure.
        for ( var i = 0, l = tabs.length; i < l; i++ ) {
            var uid = tabs[ i ];
            if ( _uid === uid ) { // it's me.
                continue;
            }
            if ( time < _handlers[ uid ][ 'time' ] ) {
                time      = _handlers[ uid ][ 'time' ];
                resultUid = uid; //.slice(0, -1); // Clone for be sure.
                // console.info( 'lastActive =', resultUid,' - ', time, _getDate(time));
            }
        }
        return resultUid;
    };
    var _cloneActiveTabToNewOne = function () {
        var uid = _getLastActiveTab();
        if ( _uid !== uid ) {
            _handlers[ _uid ][ 'histories' ] = _handlers[ uid ][ 'histories' ];
        }
    };
    
    // Public
    self.uid         = function () {
        return _uid = "shinken-history";
    };
    self.setUid      = function () {
        if ( _v ) {
            console.log( 'App.HistoryManager::setUid' );
        }
        return Storage.setItem( 'uid', _uid, { prefix: config.defaults.prefix } );
    };
    self.handlers    = function () {
        _handlers = (_handlers) ? _handlers : _getHistoryStorage( 'handlers', {}, { prefix: config.defaults.prefix, isPersistent: true } );
        if ( !_handlers[ _uid ] ) {
            _handlers[ _uid ] = {
                histories: [],
                page     : 0, //-1, // => config.defaults.url;
                time     : (new Date().getTime())
            };
            // Check if other tab and clone it.
            _cloneActiveTabToNewOne();
            this.setHandlers();
        }
        return _handlers;
    };
    self.setHandlers = function () {
        if ( _v ) {
            console.log( 'App.HistoryManager::setHandlers' );
            console.info( 'App.HistoryManager::setHandlers', _handlers[ _uid ], ' at', _getDate( _handlers[ _uid ][ 'time' ] ), true );
        }
        return Storage.setItem( 'handlers', _handlers, { prefix: config.defaults.prefix, isPersistent: true } );
    };
    
    // Getter of handlers object.
    self.histories = function () {
        return _getHandlers( 'histories' );
    };
    self.page      = function () {
        return _getHandlers( 'page' );
    };
    self.time      = function () {
        return _getHandlers( 'time' );
    };
    
    /***************************
     * INITIALIZATION
     ***************************/
    self.init = function () {
        if ( typeof localStorage === 'undefined' ) {
            console.error( "This browser doesn't support the localStorage" );
        }
        if ( typeof sessionStorage === 'undefined' ) {
            console.error( "This browser doesn't support the sessionStorage" );
        }
        if ( App.StorageManager.getSizeOfStorage() >= 1000 ) { // If size >= 1 Mo
            Storage.clear();
            console.info( 'App.HistoryManager::init - The storage has been cleaned' );
        }
        this.uid();
        this.handlers();
        
        if ( _v ) {
            console.info( 'App.HistoryManager::init ', _handlers[ _uid ], ' at', _getDate( _handlers[ _uid ][ 'time' ] ) );
            if ( _vvv ) {
                console.log( 'App.HistoryManager::init - uid      ( sessionsStorage ) ', _uid );
                console.log( 'App.HistoryManager::init - handlers ( localStorage )    ', _handlers );
                console.log( 'App.HistoryManager::init - handlers.uid.history', _handlers[ _uid ][ 'histories' ] );
                console.log( 'App.HistoryManager::init - handlers.uid.page', _handlers[ _uid ][ 'page' ] );
            }
            window.ShinkenHistory = App.HistoryManager;
        }
        
        this.save();
        _initListenerActiveTab();
    };
    
    self.save     = function () {
        // Same page or what!
        if ( this.current() !== _getRootUrl() ) {
            var histories = this.histories();
            // Allows to put a limit to the history.
            if ( histories.length > config.defaults.limit - 1 ) {
                histories.shift();
            }
            histories.push( _getRootUrl() );
            // set time
            _setTime();
            // _setPage(0);
            // Save
            this.setHandlers(); // Save
            if ( _v ) {
                console.info( 'App.HistoryManager::save', true );
            }
        }
        else {
            if ( _v ) {
                console.info( 'App.HistoryManager::save', false );
            }
        }
    };
    self.getUrl   = function ( indice ) {
        if ( _v ) {
            console.log( 'App.HistoryManager::get - indice', indice );
        }
        
        if ( (indice) ? true : (indice === 0) ) {
            if ( indice !== parseInt( indice, 10 ) ) {
                return config.defaults.url;
            }
            
            var histories = this.histories(),
                l         = histories.length,
                index     = 0; // this.page() + indice;
            
            if ( indice <= 0 ) {
                index = l + indice - 1;
            }
            
            if ( histories.hasOwnProperty( index ) ) { // In the array
                return histories[ index ];
            }
            else { // Out the array.
                return config.defaults.url;
            }
        }
        else {
            console.error( 'History::get, Missing arg indice.' );
        }
    };
    self.setUrl   = function ( indice, url ) {
        var histories = this.histories(),
            l         = histories.length,
            index     = 0;
        
        if ( indice <= 0 ) {
            index = l + indice - 1;
        }
        
        if ( histories.hasOwnProperty( index ) ) { // In the array
            _handlers[ _uid ][ 'histories' ][ index ] = url;
            this.setHandlers(); // Save
        }
        else { // Out the array.
            console.error( 'History::set, Previous url is missing, can\'t be update.' );
        }
    };
    self.rollback = function () {
        if ( _v ) {
            console.log( 'App.HistoryManager::rollback' );
        }
        this.histories().pop();
        this.setHandlers();
    };
    
    /**
     * TODO
     **/
    // // Action save or delete in histories array.
    // self.save     = function() {
    //     var histories = this.histories(),
    //         page      = this.page();
    //
    //     // Same page or what!
    //     if ( this.current() !== _getRootUrl() ) {
    //         // Allows to put a limit to the history.
    //         console.log('save', histories, ' - ', histories.length, ' > ', config.defaults.limit - 1 )
    //         if ( histories.length > config.defaults.limit - 1 ) {
    //             histories.shift();
    //         }
    //         // Allows to remove all urls after the current page.
    //         if ( histories.length && page !== histories.length - 1 ) { // No the last index.
    //             histories.length = page + 1;
    //         }
    //
    //         // Set
    //         histories.push( _getRootUrl() );
    //         _setPage( +1 );
    //         _setTime();
    //         this.setHandlers(); // Save
    //
    //         if ( _v ) {
    //             console.info( 'App.HistoryManager::save', true );
    //         }
    //     } else {
    //         if ( _v ) {
    //             console.info( 'App.HistoryManager::save', false );
    //         }
    //     }
    // };
    // self.rollback = function() {
    //     if ( _v ) {
    //         console.log( 'App.HistoryManager::rollback' );
    //     }
    //     // Set
    //     this.histories().pop();
    //     _setPage( -1 );
    //     _setTime();
    //     this.setHandlers(); // Save
    // };
    //
    // // Allows to retrieve or change a specific url.
    // self.getUrl = function( indice ) {
    //     var index     = _getPage( indice ),
    //         histories = this.histories();
    //     if ( histories.hasOwnProperty( index ) ) { // In the array
    //         return histories[ index ];
    //     } else { // Out the array.
    //         return config.defaults.url;
    //     }
    // };
    // self.setUrl = function( indice, url ) {
    //     var index     = _getPage( indice ),
    //         histories = this.histories();
    //     if ( histories.hasOwnProperty( index ) ) { // In the array
    //         _handlers[ _uid ][ 'histories' ][ index ] = url;
    //         this.setHandlers(); // Save
    //     } else { // Out the array.
    //         console.error( 'History::set, Previous url is missing, can\'t be update.' );
    //     }
    // };
    
    // Getter Urls
    self.previous = function () {
        return this.getUrl( -1 );
    };
    self.current = function () {
        return this.getUrl( 0 );
    };
    self.next    = function () {
        return this.getUrl( +1 );
    };
    
    // Redirection - Go to Url
    self.back    = function () {
        location.assign( this.previous() );
    };
    self.forward = function () {
        location.assign( this.next() );
    };
    
    /**
     * TODO
     **/
    // self.back    = function() {
    //     _setPage( -1 );
    //     _setTime();
    //     this.setHandlers(); // Save
    //     location.assign( this.previous() );
    // };
    // self.forward = function() {
    //     var histories = this.histories().length,
    //         page      = this.page();
    //     console.log('page', page+1, 'loo', histories.length);
    //     if ( histories.length && page+1 > histories.length ) { // No the last index.
    //         var url = this.next();
    //         _setPage( +1 );
    //         _setTime();
    //         this.setHandlers(); // Save
    //         location.assign( url );
    //     } else {
    //         location.assign( config.defaults.url );
    //     }
    // };
    
    return self;
})( App.HistoryManager || {}, App.Scope || {}, App.StorageManager || {} );

// Call directly - Closure
(function () {
    "use strict";
    App.HistoryManager.init();
})();

// Call went the DOM is loaded.
$( document ).ready( function () {
    var _initEvents = function () {
        $( 'body' ).on( 'click', function ( e ) {
            // Did not click a element with tooltip, so we hide all.
            if ( typeof $( e.target ).data( 'original-title' ) === 'undefined' ) {
                $( ".tooltip-custom" ).hide();
            }
            SHINKEN_TOOLTIP.hideTooltip();
        } );
    };
    _initEvents();
    
    /**
     * History - exceptionSetBackUrl - After created a new elements,
     * we changes every time the back url to "my_working_area"
     */
    (function () {
        var isNewElement  = false,
            isWorkingArea = false;
        
        if ( typeof (is_new_object) !== "undefined" ) {
            isNewElement = is_new_object;
        }
        if ( typeof (working_area) !== "undefined" ) {
            isWorkingArea = working_area;
        }
        var $form = $( document.forms[ 'form-element' ] ),
            type  = $form.data( 'type' );
        if ( isWorkingArea && !isNewElement ) {
            type    = (type) ? type : 'hosts'; // TODO: Temp
            var url = '/elements/my_working_area/'.concat( type );
            // Set the back url.
            App.HistoryManager.setUrl( -1, url );
        }
    })();
} );


//******************************  END  common.js   **************************

//******************************  START  shinken-tooltip.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken-tooltip.js *
SHINKEN_TOOLTIP = (function ( self ) {
    "use strict";
    
    self.PLACEMENT                = {};
    self.PLACEMENT.LEFT           = 'left';
    self.PLACEMENT.RIGHT          = 'right';
    self.PLACEMENT.TOP            = 'top';
    self.PLACEMENT.TOP_LEFT       = 'top-left';
    self.PLACEMENT.TOP_RIGHT      = 'top-right';
    self.PLACEMENT.BOTTOM         = 'bottom';
    self.PLACEMENT.BOTTOM_LEFT    = 'bottom-left';
    self.PLACEMENT.BOTTOM_RIGHT   = 'bottom-right';
    self.TYPE                     = {};
    self.TYPE.ERROR               = 'shinken-error';
    self.TYPE.ERROR_BORDER        = 'shinken-error-border';
    self.TYPE.WARNING             = 'shinken-warning';
    self.TYPE.WARNING_BORDER      = 'shinken-warning-border';
    self.TYPE.BEWARE_BORDER       = 'shinken-beware-border';
    self.TYPE.NORMAL_DISCREET     = 'shinken-normal-discreet';
    self.CONDITION                = {};
    self.CONDITION.SHIFT          = 'shinken-shift';
    self.CONDITION.CTRL_SHIFT     = 'shinken-ctrl-shift';
    self.CONDITION.ELLIPSIS       = 'shinken-ellipsis';
    self.TYPE_TO_CHECK            = {};
    self.TYPE_TO_CHECK.CLASS      = 'class';
    self.STYLE                    = {};
    self.STYLE.PADDING_HORIZONTAL = 8;
    self.STYLE.PADDING_VERTICAL   = 4;
    self.STYLE.MIN_WIDTH_TEXT     = 60;
    self.STYLE.HEIGHT_TEXT_LINE   = 20;
    self.STYLE.ARROW_SIZE         = 5;
    self.DEFAULT                  = {};
    self.DEFAULT.TIMER_POP        = 100;
    self.MAX_TRY_IN_SCREEN        = 10;
    
    var __container;
    var __text_container;
    var __type;
    var __condition;
    var __arrow;
    var __placement;
    var __placement_origin;
    var __try;
    var __innerText;
    var __innerHtml;
    var __width;
    var __height;
    var __timer_pop;
    var __classes_added;
    var __timeout_pop;
    var __interval_pop_out;
    var __pos_top;
    var __pos_left;
    
    //public
    self.showTooltipIf = function ( element, type_to_check, value, check_if_not ) {
        if ( !value || !type_to_check ) {
            return;
        }
        switch ( type_to_check ) {
            case self.TYPE_TO_CHECK.CLASS:
                var _has_class = element.classList.contains( value );
                if ( check_if_not ) {
                    _has_class = !_has_class;
                }
                if ( _has_class ) {
                    self.showTooltip( element );
                }
                break;
            default:
                console.log( "Type not manage" );
                break;
        }
    };
    self.showTooltip   = function ( element ) {
        if ( !element ) {
            return;
        }
        if ( !__container ) {
            initDomElement();
        }
        if ( !__container ) {
            return;
        }
        
        __try = 0;
        clean();
        setTimerPop( element );
        setText( element );
        setHTML( element );
        setType( element );
        setCondition( element );
        if ( __innerText || __innerHtml ) {
            setClass( element );
            getSize();
            setPlacement( element );
            setPosition( element );
            setArrow();
            launchIntervalPopOut( element );
        }
    };
    self.hideTooltip   = function () {
        if ( __container ) {
            setActive( false );
            cleanIntervalPopOut();
        }
    };
    
    //private
    
    function setPlacement ( element ) {
        cleanArrow();
        __placement        = element.getAttribute( 'shi-tip-placement' ) || self.PLACEMENT.TOP;
        __placement_origin = __placement;
    };
    
    function setActive ( _bool ) {
        if ( _bool ) {
            __container.classList.add( 'shinken-tooltip-active' );
        }
        else {
            __container.classList.remove( 'shinken-tooltip-active' );
        }
    };
    
    function setArrow () {
        __container.classList.add( __placement );
    };
    
    function cleanIntervalPopOut () {
        if ( __interval_pop_out ) {
            clearInterval( __interval_pop_out );
            __interval_pop_out = null;
        }
    };
    
    function launchIntervalPopOut ( element ) {
        cleanIntervalPopOut();
        var _data_timer                = new Date().getTime();
        var _selector                  = "[data-shinken-tooltip='" + _data_timer + "']";
        element.dataset.shinkenTooltip = _data_timer;
        __interval_pop_out             = setInterval( function () {
            var _elements = document.querySelector( _selector );
            if ( !_elements ) {
                setActive( false );
                cleanIntervalPopOut();
            }
        }, 1000 );
    };
    
    function cleanArrow () {
        __container.classList.remove( __placement );
    };
    
    function cleanRectWidth ( _rect ) {
        var _to_return = Math.min( _rect.width, 600 );
        if ( __classes_added ) {
            if ( __classes_added.indexOf( '300' ) !== -1 ) { //BGL  A REFAIRE PROPRE
                _to_return = Math.min( _to_return, 300 );
            }
        }
        return _to_return;
    }
    
    function setPosition ( element_to_bind ) {
        clean();
        var _rect       = element_to_bind.getBoundingClientRect();
        var _width_rect = cleanRectWidth( _rect );
        if ( !_width_rect ) {
            return; //ELEMENT NOT DISPLAYED
        }
        
        switch ( __placement ) {
            case self.PLACEMENT.TOP:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.TOP_LEFT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left - (__width / 2) * 5 / 3 + _width_rect / 2 + self.STYLE.ARROW_SIZE);
                break;
            case self.PLACEMENT.TOP_RIGHT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - (__width / 6) - self.STYLE.ARROW_SIZE);
                break;
            case self.PLACEMENT.LEFT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left - __width);
                break;
            case self.PLACEMENT.RIGHT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left + _width_rect);
                break;
            case self.PLACEMENT.BOTTOM:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.BOTTOM_LEFT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left - (__width / 2) * 5 / 3 + _width_rect / 2 + self.STYLE.ARROW_SIZE);
                break;
            case self.PLACEMENT.BOTTOM_RIGHT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - (__width / 6) - self.STYLE.ARROW_SIZE);
                break;
        }
        
        if ( isInScreen() ) {
            __timeout_pop = setTimeout( function () {
                __container.style.top  = __pos_top + 'px';
                __container.style.left = __pos_left + 'px';
            }, __timer_pop );
        }
        else {
            setPosition( element_to_bind );
        }
    };
    
    function isInScreen () {
        var _to_return = true;
        
        if ( __pos_left < -10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (__pos_left + __width) > window.innerWidth - 10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                case self.PLACEMENT.RIGHT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( __pos_top < -10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (__pos_top + __height) > window.innerHeight - 10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        __try++;
        if ( __try > self.MAX_TRY_IN_SCREEN ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            __placement = __placement_origin;
            _to_return  = true;
        }
        return _to_return;
        
        
    };
    
    function initDomElement () {
        __container = document.getElementById( "shi-tip" );
        if ( __container ) {
            __text_container = __container.querySelector( ".shi-tip-text" );
            __arrow          = __container.querySelector( ".shi-tip-arrow" );
        }
    };
    
    function setText ( element ) {
        __innerText = element.getAttribute( 'shi-tip-text' );
        if ( __innerText ) {
            __text_container.innerHTML = __innerText;
        }
    };
    
    function setHTML ( element ) {
        __innerHtml = element.getAttribute( 'shi-tip-html' );
        if ( __innerHtml ) {
            __text_container.innerHTML = __innerHtml;
        }
    };
    
    function setType ( element ) {
        __type                   = element.getAttribute( 'shi-tip-type' ) || false;
        __container.dataset.type = __type;
    };
    
    function setCondition ( element ) {
        __condition = element.getAttribute( 'shi-tip-condition' ) || false;
        if ( __condition === SHINKEN_TOOLTIP.CONDITION.ELLIPSIS && element.offsetWidth < element.scrollWidth ) {
            __condition = '';
        }
        __container.dataset.condition = __condition;
    };
    
    function setTimerPop ( element ) {
        __timer_pop = element.getAttribute( 'shi-tip-timer-pop' ) || self.DEFAULT.TIMER_POP;
    };
    
    function setClass ( element ) {
        __classes_added = element.getAttribute( 'shi-tip-class' );
        if ( !__classes_added ) {
            __classes_added = '';
        }
        __container.className = __classes_added;
    };
    
    function getSize () {
        setActive( true );
        var _sizes = __container.getBoundingClientRect();
        __width    = _sizes.width;
        __height   = _sizes.height;
    };
    
    function clean () {
        __container.style.top  = '-500px';
        __container.style.left = '-500px';
        clearTimeout( __timeout_pop );
    };
    
    return self;
    
})( {} );
//******************************  END  shinken-tooltip.js   **************************

//******************************  START  __constante.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/__constante.js *
var SHINKEN = {};

SHINKEN.DOM = {};

SHINKEN.MODAL     = {};
SHINKEN.NAVIGATOR = {};
SHINKEN.PAGE      = {};

SHINKEN.TOOLS            = {};
SHINKEN.TOOLS.ARRAY      = {};
SHINKEN.TOOLS.ENCRYPTION = {};
SHINKEN.OBJECT           = {};

var DOM   = {};
DOM.CONST = {};


SHINKEN.CONST = {
    KEY_CODE : {
        ENTER: 13,
        SPACE: 32,
        LEFT : 37,
        UP   : 38,
        RIGHT: 39,
        DOWN : 40
    },
    CLASS_CSS: {
        PULSATE: 'shinken-pulsate'
    }
};


SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
var LIST                                       = {};
LIST.CONST                                     = {
    MASS_ACTION: {
        ID: 'massaction'
    }
};
//******************************  END  __constante.js   **************************

//******************************  START  __constante.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/__constante.js *
'use strict';

var OBJECT = {};

OBJECT.CONST = {
    TEMPLATE       : {
        FIELD : {
            UUID             : 'uuid',
            _ID              : '_id',
            _SYNC_KEYS       : '_SYNC_KEYS',
            NAME             : 'name',
            IS_TEMPLATE      : 'is_template',
            IS_TOP_LEVEL     : 'is_top_level',
            ITEM_TYPE        : 'item_type',
            LAST_MODIFICATION: 'last_modification',
            REGISTER         : 'register',
            SOURCES          : 'sources',
            USE              : 'use',
            ENABLED          : 'enabled',
            UNCONFIGURED     : 'unconfigured',
            STATUS           : 'template-status',
            IS_NEW           : 'is_new',
            LOOP             : 'loop',
            WORK_AREA_INFO   : 'work_area_info',
            METADATA         : '@metadata'
        },
        STATUS: {
            USEFUL  : 'useful-template',
            USELESS : 'useless-template',
            BADLOOP : 'badloop-template',
            NEW     : 'new-template',
            UNKNOWN : 'unknown-template',
            DISABLED: 'disabled-template'
        }
    },
    ELEMENT_LIST   : {
        TYPE: {
            USER       : 'user',
            INHERITANCE: 'inheritance',
            SEARCHING  : 'searching'
        }
    },
    MACRO          : {
        TYPE: {
            HOST_LOCAL        : '_HOST',
            SERVICE_LOCAL     : '_SERVICE',
            HOST_PROPERTY     : 'macros_host_properties',
            SERVICE_PROPERTY  : 'macros_service_properties',
            GLOBAL            : 'macros_global',
            GLOBAL_INTERPRETED: 'macros_global_interpreted',
            UNKNOWN           : 'unknown',
            VALUE_DFE         : 'VALUE_DFE',
            DFE_KEY           : '$KEY$'
        }
    },
    CHECK_IN_HOST  : {
        STATUS: {
            NONE                         : "",
            DFE_STRUCTURE                : 'dfe-structure',
            ALREADY_EXISTING_NAME        : "already_existing_name",
            ALREADY_EXISTING_NAME_IN_SAME: "already_existing_name_in_same_host"
        }
    },
    ELEMENT        : {
        PHASE           : {
            INIT         : 0,
            VIEWING      : 1,
            EDITING      : 2,
            ON_SAVING    : 3,
            SAVING_FAILED: 4,
            RELOADING    : 5
        },
        FIELD           : {
            ID                    : '_id',
            SOURCES               : 'sources',
            IMPORT_DATE           : 'import_date',
            SERVICE_OVERRIDES     : 'service_overrides',
            SERVICE_EXCLUDES_BY_ID: 'service_excludes_by_id',
            WORK_AREA_INFO        : 'work_area_info',
            SYNC_KEYS             : '_SYNC_KEYS ',
            LAST_MODIFICATION     : 'last_modification',
            ENABLED               : 'enabled',
            STATUS                : 'status'
        },
        MODULATION      : {
            TYPE: {
                NONE_FORCED: -1,
                NONE       : 0,
                EXISTING   : 1,
                ERROR      : 2
            }
        },
        TYPE            : {
            CLUSTERS                  : 'clusters',
            CLUSTER_TPLS              : 'clustertpls',
            DISCOVERY                 : 'discovery',
            HOSTS                     : 'hosts',
            HOST_GROUPS               : 'hostgroups',
            HOST_TPLS                 : 'hosttpls',
            CHECK_ON_HOST             : 'serviceshosts',
            CHECK_ON_TPL_HOST         : 'serviceshosttpls',
            CHECK_ON_CLUSTER          : 'servicesclusters',
            CHECK_ON_TPL_CLUSTER      : 'servicesclustertpls',
            CHECK_TPLS                : 'servicetpls',
            COMMANDS                  : 'commands',
            CONTACT_GROUPS            : 'contactgroups',
            CONTACT_TPLS              : 'contacttpls',
            CONTACTS                  : 'contacts',
            ESCALATIONS               : 'escalations',
            MODULATION_BUSINESS_IMPACT: 'businessimpactmodulations',
            MODULATION_DATA           : 'macromodulations',
            MODULATION_RESULT         : 'resultmodulations',
            NOTIFICATION_WAYS         : 'notificationways',
            TIME_PERIODS              : 'timeperiods',
            SYNCHRONIZER_LINKER       : 'sync'
        },
        WORK_AREA_STATUS: {
            PROPOSED : 'PROPOSED',
            WORKING  : 'WORKING',
            REJECTED : 'REJECTED',
            VALIDATED: 'VALIDATED'
            
        },
        STATUS          : {
            NEW: 'new'
        }
    },
    OVERRIDE_STATUS: {
        OFF: "0",
        ON : "1"
    },
    EXCLUDE_STATUS : {
        OFF    : "0",
        BY_ID  : "1",
        BY_NAME: "2"
    }
};
//******************************  END  __constante.js   **************************

//******************************  START  __constante.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/__constante.js *
'use strict';

var MANAGER = {};

MANAGER.CONST = {
    STATE       : {
        WORK_FLOW: {
            STAGING     : 'save-direct-in-staging',
            WORKING_AREA: 'save-in-working-area'
        }
    },
    DRAG_N_DROP : {
        CLASS: {
            HOVER    : 'hover',
            DRAGGABLE: 'draggable',
            DRAGGING : 'dragging-on',
            DISCREET : 'discreet'
        }
    },
    HELP        : {
        STATUS: {
            INACTIVE: 1,
            ACTIVE  : 2,
            FORCED  : 3
        }
    },
    AFTER_ACTION: {
        CLICK_ON_SERVICE_OVERRIDE    : 0,
        CLICK_ON_WINDOW_DATA_OVERRIDE: 1
    }
};

//******************************  END  __constante.js   **************************

//******************************  START  __constante.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/window/__constante.js *
'use strict';

var WINDOW = {};

WINDOW.CONST = {
    ELEMENT: {
        GENERIC: 'generic',
        DATAS  : 'datas',
        CHECKS : 'checks'
    },
    CLASS  : {
        WINDOW_GROUP: 'shinken-window-group',
        WINDOW_TAB  : 'shinken-window-element'
    },
    ID     : {
        WINDOW_TAB: 'id-shinken-window-'
    }
};

//******************************  END  __constante.js   **************************

//******************************  START  __constante.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/__constante.js *
'use strict';

var COMPONENT = {};

COMPONENT.CONST = {
    BTN_STATE               : {
        DISABLED: -1,
        OFF     : 0,
        ON      : 1,
        DISCREET: 2,
        INIT    : 3
    },
    BTN_NAME                : {
        SAVE: 'save'
    },
    SELECT                  : {
        SELECTOR                  : 'shinken-select-selector',
        SELECTOR_TEXT             : 'shinken-selector-label',
        SELECTOR_LIST             : 'shinken-list-select',
        SELECTOR_LIST_SEARCH_INPUT: 'shinken-input-search',
        SELECTOR_LIST_GROUP       : 'shinken-optgroup',
        SELECTOR_LIST_OPTION      : 'shinken-option',
        OPTION_ACTIVE_STAGING     : 'shinken-active-option-staging',
        OPTION_ACTIVE_WORKING_AREA: 'shinken-active-option-working-area',
        DATA_STATE_SELECTOR       : 'stateSelector',
        LINK_ICON_CONTAINER       : 'shinken-link-icon-container',
        LINK_ICON_BUTTON          : 'shinken-link-icon-button',
        TIMER_DELAY_BUILD_HTML    : 100
    },
    BTN_INHERITANCE         : {
        TIMER_DELAY_BUILD_HTML: 100
    },
    INHERITANCE_ARBORESCENCE: {},
    TAG                     : {
        STATE: {
            WORKING         : 'working_area',
            NEW             : 'new',
            STAGGING        : 'stagging',
            DISABLED        : 'disabled',
            UNKNOWN         : 'unknown',
            HIDDEN          : 'hidden',
            INHERITED       : 'inherited',
            FORCE_TO_NULL   : 'force-to-null',
            OVERRIDE_NEW    : 'override-new',
            OVERRIDE_UNKNOWN: 'override-unknown'
        }
    },
    TYPES                   : {
        SINGLE_SELECT: 'singleselect'
    },
    MASS_ACTION_GROUP       : {
        'HOST_WORKING_AREA'       : 'actions-host-working-area',
        'HOST_STAGING'            : 'actions-host-staging',
        'HOST_BYPASS_WORKING_AREA': 'actions-bypass-working-area',
        'STAGING'                 : 'actions-staging'
    },
    LIST_SELECT             : {
        CLASS: {
            NO_RESULT   : 'shinken-no-result',
            FILTERING_ON: 'shinken-filtering-on'
        }
    },
    LIST_SELECT_ELEMENT     : {
        CLASS: {
            HIDDEN: 'shinken-hidden'
        }
    },
    BTN_RADIO               : {
        CLASS: {
            SHINKEN_BUTTON_ACTIVE  : 'shinken-active',
            SHINKEN_BUTTON_DISABLED: 'shinken-disabled'
        }
    },
    STATUS                  : {
        NONE   : 'shinken-no-status',
        ERROR  : 'shinken-error-status',
        WARNING: 'shinken-warning-status',
        BEWARE : 'shinken-beware-status'
    },
    TAG_INFORMATION         : {
        STATUS: {
            NONE                 : 'none',
            ALL_DISABLED         : 'all-disabled',
            ALL_DISABLED_OVERRIDE: 'all-disabled-override',
            NOT_VALID_FOR_ARBITER: 'not-arbiter-valid',
            USER_GROUP_COHERENCY : 'user-group-coherency',
            IN_SHELL             : 'in_shell',
            CHECK_DUPLICATE      : 'check_duplicate'
        }
    }
};
//******************************  END  __constante.js   **************************

//******************************  START  __constante.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/__constante.js *
'use strict';

var PROPERTY = {};

PROPERTY.CONST = {
    NAME                  : {
        ACL_MAKE_DOWNTIME              : 'acl_make_downtime',
        ACL_MAKE_ACKNOWLEDGE           : 'acl_make_acknowledge',
        ACL_FORCE_RESULT_CHECK         : 'acl_force_result_check',
        ACL_FORCE_RETRY_CHECK          : 'acl_force_retry_check',
        ACL_IN_TAB_HISTORY             : 'acl_in_tab_history',
        ACL_SHOW_HISTORY_RANGE         : 'acl_show_history_range',
        ACL_SHOW_SLA_RANGE             : 'acl_show_sla_range',
        ACL_TRY_CHECK_ON_SYNCHRONIZER  : 'acl_try_check_on_synchronizer',
        ACL_TRY_CHECK_ON_POLLER        : 'acl_try_check_on_poller',
        ADDRESS                        : 'address',
        ADVANCED_TIME_PERIODS          : 'advanced_time_periods',
        BUSINESS_IMPACT                : 'business_impact',
        BUSINESS_IMPACT_MODULATIONS    : 'business_impact_modulations',
        BUSINESS_IMPACT_MODULATION_NAME: 'business_impact_modulation_name',
        CAN_SUBMIT_COMMANDS            : 'can_submit_commands',
        CHECK_COMMAND                  : 'check_command',
        CHECK_COMMAND_ARGS             : 'check_command_args',
        CHECK_INTERVAL                 : 'check_interval',
        CHECK_PERIOD                   : 'check_period',
        CHECK_RUNNING_TIMEOUT          : 'check_running_timeout',
        COMMAND_NAME                   : 'command_name',
        CONTACTS                       : 'contacts',
        CONTACT_NAME                   : 'contact_name',
        CONTACT_GROUPS                 : 'contact_groups',
        CONTACTGROUP_NAME              : 'contactgroup_name',
        CONTACTGROUPS                  : 'contactgroups',
        DEFAULT_VALUE                  : 'default_value',
        DEFINITION_ORDER               : 'definition_order',
        DISPLAY_NAME                   : 'display_name',
        DUPLICATE_FOREACH_NAME         : 'duplicate_foreach',
        ENABLED                        : 'enabled',
        ESCALATIONS                    : 'escalations',
        ESCALATION_NAME                : 'escalation_name',
        ESCALATION_OPTIONS             : 'escalation_options',
        EDITION_CONTACTS               : 'edition_contacts',
        EDITION_CONTACT_GROUPS         : 'edition_contact_groups',
        EVENT_HANDLER                  : 'event_handler',
        FIRST_NOTIFICATION_DELAY       : 'first_notification_delay',
        FLAP_DETECTION_OPTIONS         : 'flap_detection_options',
        FRESHNESS_THRESHOLD            : 'freshness_threshold',
        HOST_NAME                      : 'host_name',
        HOST_NOTIFICATION_OPTIONS      : 'host_notification_options',
        HOST_NOTIFICATION_PERIOD       : 'host_notification_period',
        HOSTGROUPS                     : 'hostgroups',
        HOSTGROUP_NAME                 : 'hostgroup_name',
        IP_RANGE                       : 'iprange',
        IS_CLUSTER                     : 'is_cluster',
        LOW_FLAP_THRESHOLD             : 'low_flap_threshold',
        HIGH_FLAP_THRESHOLD            : 'high_flap_threshold',
        MACRO_MODULATIONS              : 'macromodulations',
        MACROMODULATION_NAME           : 'macromodulation_name',
        MAINTENANCE_PERIOD             : 'maintenance_period',
        MAX_CHECK_ATTEMPTS             : 'max_check_attempts',
        NAME                           : 'name',
        NOTE_URL                       : 'notes_url',
        NOTE_MULTI_URL                 : 'notes_multi_url',
        NOTIFICATIONS_ENABLED          : 'notifications_enabled',
        NOTIFICATION_PERIOD            : 'notification_period',
        NOTIFICATIONWAY_NAME           : 'notificationway_name',
        NOTIFICATIONWAYS               : 'notificationways',
        PACK                           : 'pack',
        PERIOD_ADVANCED_NAME           : 'period_advanced_type',
        PERIOD_DAY_NAME                : 'period_day_type',
        POLLER_TAG                     : 'poller_tag',
        PREFIX                         : 'prefix',
        REACTIONNER_TAG                : 'reactionner_tag',
        RESULTMODULATION_NAME          : 'resultmodulation_name',
        RETRY_INTERVAL                 : 'retry_interval',
        NOTIFICATION_OPTIONS           : 'notification_options',
        NOTIFICATION_CONTACTS          : 'notification_contacts',
        NOTIFICATION_CONTACT_GROUPS    : 'notification_contact_groups',
        NOTIFICATION_INTERVAL          : 'notification_interval',
        OUTPUT_RULES                   : 'output_rules',
        PARENTS                        : 'parents',
        PORT_RANGE                     : 'port_range',
        RESULT_MODULATIONS             : 'resultmodulations',
        SERVICE_NOTIFICATION_OPTIONS   : 'service_notification_options',
        SERVICE_DESCRIPTION            : 'service_description',
        SERVICE_EXCLUDES               : 'service_excludes',
        SHELL_EXECUTION                : 'shell_execution',
        SYNC_NAME                      : 'sync_name',
        TIMEPERIOD_NAME                : 'timeperiod_name',
        TIMEPERIODS                    : 'timeperiods',
        TIMEOUT                        : 'timeout',
        USE                            : 'use',
        VIEW_CONTACTS                  : 'view_contacts',
        VIEW_CONTACT_GROUPS            : 'view_contact_groups',
        WARNING_THRESHOLD_CPU_USAGE    : 'warning_threshold_cpu_usage',
        TIMEPERIOD_DAYS                : {
            MONDAY   : "monday",
            TUESDAY  : "tuesday",
            WEDNESDAY: "wednesday",
            THURSDAY : "thursday",
            FRIDAY   : "friday",
            SATURDAY : "saturday",
            SUNDAY   : "sunday"
        }
    },
    TYPES                 : {
        BOOLEAN                 : 'boolean',
        DATA                    : 'data',
        MULTI_SELECT            : 'select-multi',
        RANGE                   : 'range',
        RANGE_BUSINESS_IMPACT   : 'range_business_impact',
        SINGLE_SELECT           : 'select-single',
        SINGLE_SELECT_WITH_INPUT: 'select-single-with-input',
        STRING_INPUT            : 'input_string',
        CHECKBOX_SINGLE         : 'checkbox-single',
        CHECKBOX_MULTI          : 'checkbox-multi',
        MULTI_LINE_OBJECT       : 'multi-line-object'
    },
    CLASS                 : {
        SKINKEN_LINE: 'shinken-element-property-line'
    },
    DEFAULT_BUTTON_LABEL  : 'default_button',
    STATE_PROPERTY        : {
        INHERITANCE_AND_USER   : 'inheritance-and-user',
        INHERITANCE            : 'inheritance-only',
        USER_SET               : 'user-set',
        USER_SET_NONE          : 'user-set-none',
        USER_FORCED_DEFAULT    : 'user-default-forced',
        OVERRIDE               : 'override-only',
        OVERRIDE_AND_PLUS      : 'override-and-plus',
        OVERRIDE_FORCED_DEFAULT: 'override-default-forced'
    },
    STATE_PROBLEM_PROPERTY: {
        NONE       : 'none',
        HAS_ERROR  : 'has_error',
        HAS_WARNING: 'has_warning'
    },
    STATE_VALUE_PLUS      : {
        ON : '+',
        OFF: ''
    },
    STATE_IS_NULL_VALUE   : {
        TRUE : '1',
        FALSE: '0'
    },
    ACTIVE                : {
        TRUE : '1',
        FALSE: '0'
    },
    MAX_SELECTABLE_ITEMS  : {
        RESULT_MODULATIONS: '4'
    },
    CUSTOM_SELECT         : {
        PLUS_AND_INHERITANCE  : '__PLUS_AND_INHERITANCE__',
        PLUS_AND_OVERRIDE     : '__PLUS_AND_OVERRIDE__',
        NONE                  : 'null',
        INHERITANCE           : '__INHERITANCE__',
        DEFAULT               : '__DEFAULT_NO_TEMPLATE__',
        DEFAULT_FORCED        : '__DEFAULT_NO_TEMPLATE_FORCED__',
        DEFAULT_OR_INHERITANCE: '__DEFAULT_OR_INHERITANCE__',
        NO_OVERRIDE           : '__NO_OVERRIDE__'
    },
    DRAG_N_DROP           : {
        TYPE: {
            SELECTED_ITEM: 'selected-item'
        }
    },
    BOOLEAN               : {
        STATE_INHERITANCE: {
            INHERITANCE: true,
            DEFAULT    : false
        }
    },
    DATA                  : {
        IDENTIFIER_DATA_LOCAL: "_",
        PROTECTED_PLACEHOLDER: '********',
        GROUP                : {
            LOCALE   : "local",
            INHERITED: "templates",
            DFE      : "foreach-dfe"
        },
        STATUS               : {
            NONE  : "",
            NEW   : "shinken-data-status-new",
            HIDDEN: "shinken-data-hidden"
        }
    },
    TIMEPERIOD            : {
        SEPARATOR   : {
            RANGES  : ",",
            HOURS   : "-",
            HOUR_MIN: ":"
        },
        FORMAT_LABEL: {
            FULL : 'full',
            RANGE: 'range',
            HOUR : 'hour'
        },
        NO_MONTH    : "None"
    },
    ACL_MULTI             : {
        NAME: {
            READ    : 'read',
            CREATE  : 'create',
            ORGANIZE: 'organize',
            MODIFY  : 'modify',
            DELETE  : 'delete',
            ALL     : 'all'
        }
    },
    ACL_TYPE              : {
        HISTORY_SLA: 'history_sla',
        HISTORY    : 'history',
        SLA        : 'sla'
    },
    OVERRIDE              : {
        SEPERATOR: {
            AFTER_NAME: ',',
            AFTER_PROP: ' ',
            BETWEEN   : '-=#=-'
        }
    },
    NOTES_URL             : {
        SEPERATOR: {
            ENTRY    : '~#~',
            KEY_VALUE: '~='
        }
    },
    CHECK_COMMAND         : {
        SEPERATOR: '!'
    },
    PROTECTED_STATUS      : {
        NONE              : 0,
        PROTECTED         : 1,
        PROTECTED_MODIFIED: 2
    }
};

PROPERTY.getTypeByName = function ( property_name, shinken_element_type ) {
    switch ( property_name ) {
        case PROPERTY.CONST.NAME.CHECK_INTERVAL:
        case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
        case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
        case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
        case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
        case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
        case PROPERTY.CONST.NAME.NOTE_URL:
        case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
        case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
        case PROPERTY.CONST.NAME.RETRY_INTERVAL:
            return PROPERTY.CONST.TYPES.STRING_INPUT;
        case PROPERTY.CONST.NAME.CHECK_PERIOD:
        case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
        case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
            return PROPERTY.CONST.TYPES.SINGLE_SELECT;
        case PROPERTY.CONST.NAME.USE:
        case PROPERTY.CONST.NAME.VIEW_CONTACTS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
        case PROPERTY.CONST.NAME.EDITION_CONTACTS:
        case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
        case PROPERTY.CONST.NAME.CONTACTS:
        case PROPERTY.CONST.NAME.CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.ESCALATIONS:
        case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
        case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
        case PROPERTY.CONST.NAME.PARENTS:
        case PROPERTY.CONST.NAME.NOTIFICATIONWAYS:
        case PROPERTY.CONST.NAME.CONTACTGROUPS:
        case PROPERTY.CONST.NAME.HOSTGROUPS:
            return PROPERTY.CONST.TYPES.MULTI_SELECT;
        case PROPERTY.CONST.NAME.HOST_NAME:
            switch ( shinken_element_type ) {
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    return PROPERTY.CONST.TYPES.MULTI_SELECT;
                default:
                    return PROPERTY.CONST.TYPES.STRING_INPUT;
            }
        case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
        case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE;
        case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
            return PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT;
        default:
            if ( SHINKEN.TOOLS.STRING.startsWith( property_name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                return PROPERTY.CONST.TYPES.DATA;
            }
            return '';
        
    }
    
};
//******************************  END  __constante.js   **************************

//******************************  START  array-service.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/array-service.js *
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.split                    = function ( array_1, separator ) {
        var toReturn = array_1.split( separator );
        return toReturn;
    };
    self.concat                   = function ( array_1, array_2 ) {
        var toReturn = array_1.concat( array_2 );
        return toReturn;
    };
    self.concatUnique             = function ( array_1, array_2, key_for_unique ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.sortArray                = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayMultiple        = function ( array, comparator_values ) {
        if ( !array ) {
            return array;
        }
        if ( !comparator_values ) {
            return array;
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return fix_array.concat( to_sort );
    };
    self.getMapValues             = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator              = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith               = function ( array, key, value ) {
        if ( !array || !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var toReturn = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply         = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _to_return = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply          = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        var _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        var _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith     = function ( array, key, value ) {
        if ( !array || !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.getLengthWith            = function ( array, key, value ) {
        var _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey               = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent        = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        var _extract1 = self.extractKey( array1, key );
        var _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        var _size1 = _extract1.length;
        var _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( var i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo         = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement               = function ( array, key, value_to_find ) {
        var _size = self.getLength( array );
        var _current_element;
        for ( var i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone        = function ( array ) {
        var toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initIntegerArray         = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.indexOf                  = function ( array, key, value ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.search                   = function ( array, key, value ) {
        var index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                     = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                    = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                     = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        var b            = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                 = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.addElement               = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement            = function ( array, toRemove ) {
        var index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        array.splice( index, 1 );
        return true;
    };
    self.parseToArray             = function ( obj ) {
        if ( !obj ) {
            return null;
        }
        
        var _keys      = Object.keys( obj );
        var _size      = _keys.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.containsElementWith      = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        var _size = array.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEquals                = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );

//******************************  END  array-service.js   **************************

//******************************  START  counter.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/counter.js *
'use strict';

SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    //type
    //nb
    //elements_mapping
    //dom_element
    //counter_final
    this.is_string        = false;
    this.is_label_before  = false;
    this.label            = "";
    this.show_if_null     = !!show_if_null;
    this.elements_mapping = {};
    this.counter_final    = 0;
    this.counter_parent   = null;
    this.uuid             = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html     = null;
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_discreet = !this.dom_element;
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this.counter_parent = MANAGER.__instance_counter_distributor.findCounter( _name_parent );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label           = _label.outerHTML;
                this.is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this.is_string = true;
            }
        }
    },
    has           : function ( name ) {
        return !!this.elements_mapping[ name ];
    },
    reset         : function () {
        this.elements_mapping = {};
        this.counter_final    = 0;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    update        : function ( name, nb_counter, tooltip, retry_update_html ) {
        if ( !nb_counter ) {
            delete this.elements_mapping[ name ];
        }
        else {
            if ( this.elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this.elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltip( tooltip );
        }
        this.counter_final = this.is_string ? "" : 0;
        var _keys          = Object.keys( this.elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counter_final = this.counter_final + this.elements_mapping[ _keys[ i ] ];
        }
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        return this._askUpdateHTML( retry_update_html );
    },
    setParent     : function ( to_set ) {
        this.counter_parent = to_set;
    },
    setLabel      : function ( to_set, is_before ) {
        this.label           = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this.is_label_before = !!is_before;
    },
    isString      : function ( to_set ) {
        this.is_string = to_set;
    },
    _askUpdateHTML: function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            this.timeout_html = null;
        }, 50 );
    },
    _updateHTML   : function ( retry_update_html ) {
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        if ( this.counter_final ) {
            this.dom_element_label.innerHTML = this.label ? this.is_label_before ? this.label + " " + this.counter_final : this.counter_final + " " + this.label : this.counter_final;
            DOM.Service.setDataSet( this.dom_element, 'number', this.counter_final );
        }
        else if ( this.show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        return true;
    },
    setTooltip    : function ( label, type ) {
        if ( !label ) {
            return;
        }
        this.dom_element.setAttribute( 'onmouseenter', 'SHINKEN_TOOLTIP.showTooltip(this)' );
        this.dom_element.setAttribute( 'onmouseleave', 'SHINKEN_TOOLTIP.hideTooltip()' );
        this.dom_element.setAttribute( 'shi-tip-html', label );
        this.dom_element.setAttribute( 'shi-tip-type', type );
    }
};
//******************************  END  counter.js   **************************

//******************************  START  date-time.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/date-time.js *
var DATE_TIME    = {};
var __traduction;
//DATE_TIME.FORMAT_TIME                 = {};
DATE_TIME.FORMAT = {
    TIME           : {
        DEFAULT: "HH:MM:SS",
        HH_MM  : "HH:MM"
    },
    DATE           : {
        DEFAULT   : "DD-MM-YYYY",
        WITH_SLASH: "DD/MM/YYYY"
    },
    TIME_PERIOD    : {
        YEAR   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30 * 355,
            KEY      : 'year',
            SHORT_KEY: 'short_year'
        },
        MONTH  : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30,
            KEY      : 'month',
            SHORT_KEY: 'short_month'
        },
        WEEK   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 7,
            KEY      : 'week',
            SHORT_KEY: 'short_week'
        },
        DAY    : {
            NB_MS    : 1000 * 60 * 60 * 24,
            KEY      : 'day',
            SHORT_KEY: 'short_day'
        },
        HOUR   : {
            NB_MS    : 1000 * 60 * 60,
            KEY      : 'hour',
            SHORT_KEY: 'short_hour'
        },
        MINUTE : {
            NB_MS    : 1000 * 60,
            KEY      : 'minute',
            SHORT_KEY: 'short_minute'
        },
        SECONDE: {
            NB_MS    : 1000,
            KEY      : 'second',
            SHORT_KEY: 'short_second'
        }
    },
    NOW            : 'now',
    TYPE_VALIDATION: {
        HOUR: "hour",
        MIN : "min"
    }
};

DATE_TIME.now             = function () {
    return new Date();
};
DATE_TIME.getTimestampNow = function () {
    return Date.now();
};

DATE_TIME.FORMAT.getTime = function ( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.TIME.DEFAULT;
    }
    format = format.toUpperCase();
    switch ( format ) {
        case DATE_TIME.FORMAT.TIME.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
        case DATE_TIME.FORMAT.TIME.HH_MM:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 );
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
    }
    
};

DATE_TIME.FORMAT.get_date = function ( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.DATE.DEFAULT;
    }
    
    switch ( format ) {
        case DATE_TIME.FORMAT.DATE.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDay(), 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth(), 2 ) + '-' + date.getFullYear();
        case DATE_TIME.FORMAT.DATE.WITH_SLASH:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDay(), 2 ) + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth(), 2 ) + '/' + date.getFullYear();
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDay(), 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth(), 2 ) + '-' + date.getFullYear();
    }
    
};

DATE_TIME.initTraduction = function () {
    __traduction = [];
    var keys     = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _short_label;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key                         = keys[ i ];
        _label                       = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        _short_label                 = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        __traduction[ _label ]       = [ _( 'timeperiods.' + _label ), _( 'timeperiods.' + _label + 's' ) ];
        __traduction[ _short_label ] = [ _( 'timeperiods.' + _short_label ), _( 'timeperiods.' + _short_label + 's' ) ];
    }
    __traduction[ DATE_TIME.NOW ] = [ _( 'timeperiods.now' ), '' ];
};

DATE_TIME.getTraduction = function ( key, is_plural ) {
    if ( !__traduction ) {
        this.initTraduction();
    }
    return __traduction[ key ][ is_plural ? 1 : 0 ];
};

DATE_TIME.durationToString = function ( timestamp, is_short_name, limit ) {
    if ( !timestamp ) {
        return DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    
    var in_the_past = false;
    if ( timestamp < 0 ) {
        in_the_past = true;
        timestamp   = -timestamp;
    }
    
    if ( !limit ) {
        limit = 9999;
    }
    var toReturn = '';
    var _nb;
    var keys     = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _nb_sec;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        if ( is_short_name ) {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        }
        else {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        }
        
        _nb_sec = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'NB_MS' ];
        
        if ( timestamp >= _nb_sec ) {
            _nb = parseInt( timestamp / _nb_sec );
            if ( toReturn ) {
                toReturn += " ";
            }
            toReturn += _nb + " " + DATE_TIME.getTraduction( _label, _nb > 1 );
            timestamp = timestamp - _nb * _nb_sec;
            limit--;
        }
        if ( limit <= 0 ) {
            break;
        }
    }
    if ( in_the_past ) {
        toReturn = _( 'timeperiods.agoMoment' ) + ' ' + toReturn;
    }
    else {
        toReturn = _( 'timeperiods.inMoment' ) + ' ' + toReturn;
    }
    return toReturn;
};

DATE_TIME.relativeTime = function ( elapsed ) {
    if ( elapsed < 0 ) {
        return relativeTime( -elapsed ) + ' ago';
    }
    var msPerSecond = DATE_TIME.FORMAT.TIME_PERIOD[ 'SECONDE' ][ 'NB_MS' ];
    var msPerMinute = DATE_TIME.FORMAT.TIME_PERIOD[ 'MINUTE' ][ 'NB_MS' ];
    var msPerHour   = DATE_TIME.FORMAT.TIME_PERIOD[ 'HOUR' ][ 'NB_MS' ];
    var msPerDay    = DATE_TIME.FORMAT.TIME_PERIOD[ 'DAY' ][ 'NB_MS' ];
    var msPerMonth  = DATE_TIME.FORMAT.TIME_PERIOD[ 'MONTH' ][ 'NB_MS' ];
    var msPerYear   = DATE_TIME.FORMAT.TIME_PERIOD[ 'YEAR' ][ 'NB_MS' ];
    
    if ( elapsed < msPerMinute ) {
        return Math.round( elapsed / msPerSecond );
    }
    else if ( elapsed < msPerHour ) {
        return Math.round( elapsed / msPerMinute );
    }
    else if ( elapsed < msPerDay ) {
        return Math.round( elapsed / msPerHour );
    }
    else if ( elapsed < msPerMonth ) {
        return Math.round( elapsed / msPerDay );
    }
    else if ( elapsed < msPerYear ) {
        return Math.round( elapsed / msPerMonth );
    }
    else {
        return Math.round( elapsed / msPerYear );
    }
};

DATE_TIME.isValid                = function ( type, string_value ) {
    if ( isNaN( string_value ) ) {
        return false;
    }
    var _value_splitted = string_value.split( '' );
    var _size           = _value_splitted.length;
    var value;
    switch ( type ) {
        case DATE_TIME.FORMAT.TYPE_VALIDATION.HOUR:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 23 ) {
                return false;
            }
            break;
        case DATE_TIME.FORMAT.TYPE_VALIDATION.MIN:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 59 ) {
                return false;
            }
            break;
        default:
            console.warn( "DATE_TIME.isValid : unknown format =>", type );
    }
    return true;
};
DATE_TIME.isValidRangeTimeperiod = function ( time1, time2 ) {
    return (DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time1 ) <= DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time2 ));
};

DATE_TIME.splitTimeperiodDay    = function ( value ) {
    var _to_return         = [];
    var _timeperiod_ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES );
    for ( var i = 0, _size = _timeperiod_ranges.length; i < _size; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodRanges( _timeperiod_ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodRanges = function ( value ) {
    var ranges       = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS );
    var _size_ranges = ranges.length;
    var _to_return   = [];
    for ( var i = 0; i < _size_ranges; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodTime( ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodTime   = function ( value ) {
    var _to_return     = {};
    var _time_splitted = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN );
    if ( _time_splitted.length !== 2 ) {
        _to_return.invalid = true;
        return _to_return;
    }
    _to_return.hour = _time_splitted[ 0 ].trim();
    _to_return.min  = _time_splitted[ 1 ].trim();
    
    return _to_return;
};
DATE_TIME.getTimeperiodLabel    = function ( type, value ) {
    switch ( type ) {
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR:
            return value.hour + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN + value.min;
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE:
            return DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 0 ] ) + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS + DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 1 ] );
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.FULL:
            var _current_range;
            var _to_return = "";
            var _size      = value.length;
            for ( var i = 0; i < _size; i++ ) {
                _current_range = value[ i ];
                _to_return += DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE, value[ i ] );
                if ( (value + 1) !== _size ) {
                    _to_return += PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES;
                }
            }
            return _to_return;
    }
};


//******************************  END  date-time.js   **************************

//******************************  START  dom.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/dom/dom.js *
SHINKEN.DOM = (function ( self ) {
    "use strict";
    
    self.hide    = function ( dom_element ) {
        if ( dom_element ) {
            dom_element.style.display = 'none';
        }
    };
    self.hideAll = function ( dom_elements ) {
        if ( !dom_elements ) {
            return;
        }
        var _size = dom_elements.length;
        for ( var i = 0 ; i < _size; i++ )
            self.hide( dom_elements[ i ] );
    };
    self.show    = function ( dom_element, display_type ) {
        if ( dom_element ) {
            dom_element.style.display = display_type || 'block';
        }
    };
    self.showAll = function ( dom_elements ) {
        if ( !dom_elements ) {
            return;
        }
        var _size = dom_elements.length;
        for ( var i = 0 ; i < _size; i++ )
            self.show( dom_elements[ i ] );
    };
    
    self.remove_class_for = function ( selector, class_to_remove ) {
        var _elements = document.querySelectorAll( selector );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].classList.remove( class_to_remove );
        }
    };
    self.add_class_for    = function ( selector, class_to_add ) {
        var _elements = document.querySelectorAll( selector );
        
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].classList.add( class_to_add );
        }
    };
    
    self.set_inner_HTML_for = function ( selector, html ) {
        var _elements = document.querySelectorAll( selector );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].innerHTML = html;
        }
    };
    self.getDataInteger     = function ( element, name ) {
        var _to_return = element.dataset[ name ];
        return parseInt( _to_return );
    };
    
    
    
    return self;
})( SHINKEN.DOM || {} );


//******************************  END  dom.js   **************************

//******************************  START  dom-body-service.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/dom/dom-body-service.js *
DOM.BodyService = (function ( self ) {
    "use strict";
    
    var __body_element;
    var __list_to_remove = {};
    var __time_out_add;
    
    self.load            = function () {
        if ( !__body_element ) {
            __body_element = document.querySelector( 'body' );
        }
    };
    self.hasChildWithID  = function ( id ) {
        var _child = self.getDomElement().querySelector( "#" + id );
        return _child;
    };
    self.askAddClass     = function ( to_add, time_out ) {
        self.getDomElement().classList.add( to_add );
        if ( time_out ) {
            __list_to_remove[ to_add ] = true;
            clearTimeout( __time_out_add );
            __time_out_add = setTimeout( function () {
                var _keys = Object.keys( __list_to_remove );
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    self.getDomElement().classList.remove( _keys[ i ] );
                }
                __list_to_remove = {};
            }, time_out );
        }
    };
    self.removeClass     = function ( to_remove ) {
        self.getDomElement().classList.remove( to_remove );
        __list_to_remove[ to_remove ] = false;
    };
    self.addChild        = function ( dom_element ) {
        DOM.Service.addElementTo( dom_element, self.getDomElement() );
    };
    self.getDomElement   = function () {
        if ( !__body_element ) {
            self.load();
        }
        return __body_element;
    };
    self.cleanDomElement = function () {
        __body_element = null;
    };
    return self;
})( DOM.BodyService || {} );
//******************************  END  dom-body-service.js   **************************

//******************************  START  dom-service.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/dom/dom-service.js *
DOM.Service = (function ( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.findParentElementWithDataSet    = function ( element, key, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.dataset[ key ] ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass      = function ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.createElement                   = function ( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.cloneElement                    = function ( dom_element_to_clone, attributes ) {
        var _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                      = function ( element, attributes ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        var _keys = Object.keys( attributes );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.bindElementOnScroll             = function ( elementScrolled, elementToBind, name_property, callback ) {
        elementScrolled.addEventListener( DOM_CONSTANT.SCROLL.EVENT, function () {
            var scrollPos         = elementScrolled.getData( name_property );
            var _do_callback      = scrollPos !== __previous_scrollLeft;
            __previous_scrollLeft = scrollPos;
            elementToBind.setData( name_property, scrollPos );
            if ( _do_callback && callback ) {
                callback();
            }
        } );
    };
    self.removeElement                   = function ( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        
        try {
            var _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.setDataSet                      = function ( element, attr, value ) {
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.askAddClass                     = function ( element, to_add, time_out ) {
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.removeElementIfHasClass         = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementTo                    = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.switchElement                   = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.insertElementBefore             = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var _parent = element_1.parentNode;
        _parent.insertBefore( element_1, element_2 );
    };
    self.getValueDataSet                 = function ( dom_element, key ) {
        return dom_element.dataset[ key ];
    };
    self.addToClassList                  = function ( dom_element, className ) {
        return dom_element.classList.add( className );
    };
    self.removeToClassList               = function ( dom_element, className ) {
        return dom_element.classList.remove( className );
    };
    self.getBoundingClientRect           = function ( dom_element, key ) {
        if ( !key ) {
            return dom_element.getBoundingClientRect();
        }
        return dom_element.getBoundingClientRect()[ key ];
    };
    self.hasScrollHeight                 = function ( dom_element ) {
        var _height = self.getBoundingClientRect( dom_element, 'height' );
        return _height < dom_element.scrollHeight;
    };
    self.setHtmlOrHide                   = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( 'shinken-hidden' );
        }
        else {
            dom_element.classList.add( 'shinken-hidden' );
        }
    };
    self.replaceChild                    = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                           = function ( dom_element ) {
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.removeAttribute                 = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    self.isVisible                       = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        if ( !(elem instanceof Element) ) {
            throw Error( 'DomUtil: elem is not an element.' );
        }
        var style = getComputedStyle( elem );
        if ( style.display === 'none' ) {
            return false;
        }
        if ( style.visibility !== 'visible' ) {
            return false;
        }
        if ( style.opacity < 0.1 ) {
            return false;
        }
        
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, deepness-- );
        }
        return true;
    };
    
    return self;
})( DOM.Service || {} );
//******************************  END  dom-service.js   **************************

//******************************  START  encryption.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/encryption.js *
SHINKEN.TOOLS.ENCRYPTION = (function ( self ) {
    "use strict";
    self.default_label;
    self.getDefaultSpanLabel           = function () {
        var _to_return = DOM.Service.createElement( "span", { class: 'shinken-encrypted-label shinken-between-parathensis' }, self.getDefaultLabel() );
        return _to_return.outerHTML;
    };
    self.getDefaultLabel               = function () {
        if ( !self.default_label ) {
            self.default_label = _( 'element.password_protected' );
        }
        return self.default_label;
    };
    self.getLabelHidden                = function () {
        return '**************';
    };
    self.getProtectedKeys              = function () {
        return protect_fields__substrings_matching_fields;
    };
    self.isDatabaseEncryptionActivated = function () {
        return protect_fields__activate_interface_encryption;
    };
    self.isProtectedField              = function ( field_label ) {
        if ( !self.isDatabaseEncryptionActivated() && MANAGER.__instance_element_distributor.current_user.is_admin ) {
            return false;
        }
        if ( !field_label ) {
            return false;
        }
        var _protected_fields = self.getProtectedKeys();
        var _size             = _protected_fields.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _protected_fields[ i ];
            if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( field_label, _current ) ) {
                return true;
            }
        }
        return false;
    };
    return self;
})( SHINKEN.TOOLS.ENCRYPTION || {} );

//******************************  END  encryption.js   **************************

//******************************  START  highway_manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/highway_manager.js *
SHINKEN.HIGHWAY = (function ( self ) {
    "use strict";
    self.goToParentUrl        = function () {
        var _floors        = location.pathname.split( '/' );
        var _new_path_name = "";
        var _size          = _floors.length;
        for ( var i = 1; i < _size - 1; i++ ) {
            _new_path_name += "/";
            _new_path_name += _floors[ i ];
        }
        switch ( _new_path_name ) {
            case "":
            case "/elements/my_working_area":
            case "/elements/working_area":
            case "/elements":
            case "/sources":
            case "/tagger":
            case "/elements/add":
                _new_path_name = "/main";
                break;
            case "/elements/add/working_area":
                _new_path_name = "/elements/working_area/hosts";
                break;
            case "/sources/server-analyzer/discovery":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
            case "/sources/server-analyzer/discovery/add":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery/add":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
        }
        switch ( location.pathname ) {
            case "/elements/add/cluster":
            case "/elements/add/clustertpl":
            case "/elements/add/hosttpl":
            case "/elements/add/hostgroup":
            case "/elements/add/serviceshost":
            case "/elements/add/serviceshosttpl":
            case "/elements/add/servicescluster":
            case "/elements/add/servicesclustertpl":
            case "/elements/add/servicetpl":
            case "/elements/add/contact":
            case "/elements/add/contacttpl":
            case "/elements/add/contactgroup":
            case "/elements/add/escalation":
            case "/elements/add/notificationway":
            case "/elements/add/command":
            case "/elements/add/businessimpactmodulation":
            case "/elements/add/macromodulation":
            case "/elements/add/resultmodulation":
            case "/elements/add/timeperiod":
                _new_path_name = "/elements/" + _floors[ _size - 1 ] + 's';
                break;
        }
        window.location = location.origin + _new_path_name;
    };
    self.goToElementTab       = function ( tab_name ) {
        var _path     = self.getPath();
        var _params   = self.getParams();
        var _old_name = _params[ 'tab' ];
        if ( _old_name === tab_name ) {
            return;
        }
        _params[ 'tab' ]       = tab_name;
        var _new_params_string = self.buildParamsToUrl( _params );
        self.changeUrl( _path + _new_params_string );
        if ( MANAGER.__instance_element_distributor && MANAGER.__instance_element_distributor.current_element ) {
            DOM.Service.setDataSet( MANAGER.__instance_element_distributor.current_element.dom_form, 'tabSelected', tab_name );
        }
    };
    self.changeUrl            = function ( new_url ) {
        window.history.pushState( "object or string", "Title", new_url );
    };
    self.getPath              = function () {
        return location.origin + location.pathname;
    };
    self.getPathWithoutOrigin = function () {
        return location.pathname + self.buildParamsToUrl( self.getParams() );
    };
    self.buildParamsToUrl     = function ( params ) {
        var _keys = Object.keys( params );
        var _size = _keys.length;
        if ( !_size ) {
            return '';
        }
        var _to_return = COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                _to_return += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            }
            _to_return += _keys[ i ] + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + params[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.getParams            = function ( param ) {
        var vars = {};
        window.location.href.replace( location.hash, '' ).replace(
            /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
            function ( m, key, value ) { // callback
                vars[ key ] = value !== undefined ? value : '';
            }
        );
        
        if ( param ) {
            return vars[ param ] ? vars[ param ] : null;
        }
        return vars;
    };
    self.isListAllElement     = function ( param ) { //PATCH BUG 4022 TO REMOVE
        if ( location.pathname === "/elements/elements" ) {
            return true;
        }
        else {
            return false;
        }
    };
    self.goTo                 = function ( url, event ) {
        event.stopPropagation();
        event.preventDefault();
        if ( event && event.ctrlKey ) {
            window.open( url, '_blank' );
        }
        else {
            window.location = url;
        }
    };
    self.refreshCurrentPage   = function () {
        location.reload();
        
    };
    return self;
})( SHINKEN.HIGHWAY || {} );

//******************************  END  highway_manager.js   **************************

//******************************  START  key-service.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/key-service.js *
SHINKEN.TOOLS.KEY = (function ( self ) {
    "use strict";
    
    self.simulateKey = function ( key_code ) {
        //console.log("GREG", "simulateKey[]", key_code );
    };
    return self;
})( SHINKEN.TOOLS.KEY || {} );

//******************************  END  key-service.js   **************************

//******************************  START  string-service.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/tools/string-service.js *
SHINKEN.TOOLS.STRING = (function ( self ) {
    "use strict";
    self.CONST = {
        REGEX                 : {
            HTML_TAG        : /<(?:.|\n)*?>/gm,
            ESCAPE_CHARACTER: /\x1b/g
        },
        WHITE_SPACE           : ' ',
        NON_BREAK_SPACE       : '\u00a0',
        COMMA                 : ',',
        CHAR_CODE_BACK_TO_LINE: 10
    };
    
    self.capitalize                 = function ( str ) {
        if ( !str ) {
            return "";
        }
        return str.charAt( 0 ).toUpperCase() + str.substring( 1 ).toLowerCase();
    };
    self.toUpperCase                = function ( str ) {
        return str.toUpperCase();
    };
    self.isUpperCase                = function ( str ) {
        if ( !str ) {
            return false;
        }
        return str === self.toUpperCase( str );
    };
    self.extractBetween             = function ( string, start_tag, end_tag ) {
        if ( !string ) {
            return string;
        }
        var _start = string.indexOf( start_tag );
        if ( _start === -1 ) {
            return string;
        }
        _start   = _start + start_tag.length;
        var _end = string.indexOf( end_tag, _start );
        if ( _end === -1 ) {
            return string;
        }
        return string.substring( _start, _end );
    };
    self.replaceAll                 = function ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    };
    self.replaceWithRegex           = function ( text_to_change, regex, change_with ) {
        return text_to_change.replace( regex, change_with );
    };
    self.extractStringIfBeginningBy = function ( str, search ) {
        var _to_return = false;
        if ( str.startsWith( search ) ) {
            _to_return = str.substr( search.length, str.length );
        }
        return _to_return;
    };
    self.contains                   = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.indexOf( to_find ) !== -1;
    };
    self.containsCharCode           = function ( string, char_code ) {
        if ( !string ) {
            return false;
        }
        var _codes = this.getCharCodes( string );
        return SHINKEN.TOOLS.ARRAY.contains( _codes, char_code );
    };
    self.containsIgnoreCase         = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        
        var _string_to_lower_case  = string.toLowerCase();
        var _to_find_to_lower_case = to_find.toLowerCase();
        return self.contains( _string_to_lower_case, _to_find_to_lower_case );
    };
    self.removeXss                  = function ( string ) {
        string = string || "";
        string = string.replace( /&/g, "" );
        string = string.replace( /</g, "" );
        string = string.replace( />/g, "" );
        string = string.replace( /"/g, "" );
        string = string.replace( /'/g, "" );
        string = string.replace( /\//g, "" );
        return string;
    };
    self.cleanXss                   = function ( string ) {
        string = string || "";
        string = string.replace( /&/g, "&amp;" );
        string = string.replace( /</g, "&lt;" );
        string = string.replace( />/g, "&gt;" );
        string = string.replace( /"/g, "&quot;" );
        string = string.replace( /'/g, "&#x27;" );
        string = string.replace( /\//g, "&#x2F;" );
        return string;
    };
    self.unescape_xss               = function ( string ) {
        string = string || "";
        string = string.replace( /&amp;/g, '&' );
        string = string.replace( /&lt;/g, '<' );
        string = string.replace( /&gt;/g, '>' );
        string = string.replace( /&quot;/g, '"' );
        string = string.replace( /&#x27;/g, "'" );
        string = string.replace( /&#x2F;/g, "/" );
        return string;
    };
    self.getRandomInt               = function ( max ) {
        return Math.floor( Math.random() * Math.floor( max ) );
    };
    self.trim                       = function ( string ) {
        return string.trim();
    };
    self.trimExtented               = function ( string ) {
        var _to_return = string.trim();
        if ( _to_return === string ) {
            return string;
        }
        return self.trimExtented( _to_return );
    };
    self.format                     = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.getNumberOccurence         = function ( string, to_find ) {
        if ( to_find.length <= 0 ) {
            return (string.length + 1);
        }
        
        var n    = 0;
        var pos  = 0;
        var step = to_find.length;
        
        while ( true ) {
            pos = string.indexOf( to_find, pos );
            if ( pos >= 0 ) {
                ++n;
                pos += step;
            }
            else {
                break;
            }
        }
        return n;
    };
    self.startsWith                 = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.substr( 0, to_find.length ) === to_find;
    };
    self.endsWith                   = function ( string, to_find ) {
        var _start_index = string.length - to_find.length;
        return string.substr( _start_index ) === to_find;
    };
    self.buildS4                    = function () {
        return Math.floor( (1 + Math.random()) * 0x10000 )
                   .toString( 16 )
                   .substring( 1 );
    };
    self.buildUUID                  = function () {
        return self.buildS4() + self.buildS4() + '-' + self.buildS4() + '-' + self.buildS4() + '-' +
               self.buildS4() + '-' + self.buildS4() + self.buildS4() + self.buildS4();
    };
    self.getCharCodes               = function ( string ) {
        var _size      = string.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = string.charCodeAt( i );
        }
        return _to_return;
    };
    self.b64Encode                  = function ( str ) {
        return btoa( encodeURIComponent( str ).replace( /%([0-9A-F]{2})/g, function ( match, p1 ) {
            return String.fromCharCode( parseInt( p1, 16 ) );
        } ) );
    };
    self.b64Decode                  = function ( str ) {
        return decodeURIComponent( Array.prototype.map.call( atob( str ), function ( c ) {
            return '%' + ('00' + c.charCodeAt( 0 ).toString( 16 )).slice( -2 );
        } ).join( '' ) );
    };
    self.isEmpty                    = function ( string ) {
        if ( !string ) {
            return true;
        }
        var s = string.replace( /\s/g, '' );
        return s.length === 0;
    };
    self.indexesOf                  = function ( string, to_find ) {
        var _to_return = [];
        
        var _length         = string.length;
        var _length_to_find = to_find.length;
        
        var _current;
        for ( var i = 0; i <= _length - _length_to_find; i++ ) {
            _current = string.substring( i, i + _length_to_find );
            if ( _current === to_find ) {
                _to_return.push( i );
            }
        }
        return _to_return;
    };
    self.isInteger                  = function ( string ) {
        var pattern = /^\d+$/;
        return pattern.test( string );
    };
    self.splitWithIndexes           = function ( string, indexes, size_split_label ) {
        var _to_return = [];
        if ( !size_split_label ) {
            size_split_label = 1;
        }
        var _size_index = indexes.length;
        if ( !_size_index ) {
            _to_return[ 0 ] = string;
            return _to_return;
        }
        
        for ( var i = 0; i <= _size_index; i++ ) {
            if ( i === 0 ) {
                _to_return[ i ] = string.substring( 0, indexes[ i ] );
            }
            else if ( i === _size_index ) {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label );
            }
            else {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label, indexes[ i ] );
            }
        }
        
        return _to_return;
        
    };
    self.prefix_by_zero             = function ( str, max ) {
        str = str.toString();
        return str.length < max ? self.prefix_by_zero( "0" + str, max ) : str;
    };
    self.getSubStringUntil          = function ( string, start, end ) {
        var _size = string.length;
        return string.substr( start, _size - end );
    };
    self.getAllIndexOf = function ( string, to_find, to_return, start_index ) {
        if ( !to_return ) {
            to_return   = [];
            start_index = 0;
        }
        var _index = string.substr( start_index ).indexOf( to_find );
        if ( _index !== -1 ) {
            to_return.push( _index + start_index );
            return self.getAllIndexOf( string, to_find, to_return, _index + to_find.length + start_index );
        }
        return to_return;
    },
        self.escapeRegExp = function ( string ) {
            return string.replace( /[.*+?^${}()|[\]\\]/g, '\\$&' );
        },
        self.isMatchingStarRegex = function ( to_test, regex_star ) {
            var _contains_star = self.getAllIndexOf( regex_star, "*" );
            if ( !_contains_star.length ) {
                return to_test === regex_star;
            }
            var _replaced = SHINKEN.TOOLS.STRING.replaceAll( regex_star, "**", "*" );
            if ( regex_star !== _replaced ) {
                return self.isMatchingStarRegex( to_test, _replaced );
            }
            regex_star         = self.escapeRegExp( regex_star );
            var _current       = new RegExp( SHINKEN.TOOLS.STRING.replaceAll( SHINKEN.TOOLS.STRING.trim( regex_star ), "\\*", ".*" ) );
            var _current_match = to_test.match( _current );
            if ( _current_match && _current_match[ 0 ] === to_test ) {
                return true;
            }
            return false;
        };
    return self;
})( SHINKEN.TOOLS.STRING || {} );

SHINKEN.TOOLS.MD5 = (function ( self ) {
    "use strict";
    self.MD5 = function ( d ) {
        var result = M( V( Y( X( d ), 8 * d.length ) ) );
        return result.toLowerCase();
    };
    
    function M ( d ) {
        for ( var _, m = "0123456789ABCDEF", f = "", r = 0; r < d.length; r++ ) {
            _ = d.charCodeAt( r ), f += m.charAt( _ >>> 4 & 15 ) + m.charAt( 15 & _ );
        }
        return f;
    }
    
    function X ( d ) {
        for ( var _ = Array( d.length >> 2 ), m = 0; m < _.length; m++ ) {
            _[ m ] = 0;
        }
        for ( m = 0; m < 8 * d.length; m += 8 ) {
            _[ m >> 5 ] |= (255 & d.charCodeAt( m / 8 )) << m % 32;
        }
        return _;
    }
    
    function V ( d ) {
        for ( var _ = "", m = 0; m < 32 * d.length; m += 8 ) {
            _ += String.fromCharCode( d[ m >> 5 ] >>> m % 32 & 255 );
        }
        return _;
    }
    
    function Y ( d, _ ) {
        d[ _ >> 5 ] |= 128 << _ % 32, d[ 14 + (_ + 64 >>> 9 << 4) ] = _;
        for ( var m = 1732584193, f = -271733879, r = -1732584194, i = 271733878, n = 0; n < d.length; n += 16 ) {
            var h = m,
                t = f,
                g = r,
                e = i;
            f = md5_ii( f = md5_ii( f = md5_ii( f = md5_ii( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_ff( f = md5_ff( f = md5_ff( f = md5_ff( f, r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 0 ], 7, -680876936 ), f, r, d[ n + 1 ], 12, -389564586 ), m, f, d[ n + 2 ], 17, 606105819 ), i, m, d[ n + 3 ], 22, -1044525330 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 4 ], 7, -176418897 ), f, r, d[ n + 5 ], 12, 1200080426 ), m, f, d[ n + 6 ], 17, -1473231341 ), i, m, d[ n + 7 ], 22, -45705983 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 8 ], 7, 1770035416 ), f, r, d[ n + 9 ], 12, -1958414417 ), m, f, d[ n + 10 ], 17, -42063 ), i, m, d[ n + 11 ], 22, -1990404162 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 12 ], 7, 1804603682 ), f, r, d[ n + 13 ], 12, -40341101 ), m, f, d[ n + 14 ], 17, -1502002290 ), i, m, d[ n + 15 ], 22, 1236535329 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 1 ], 5, -165796510 ), f, r, d[ n + 6 ], 9, -1069501632 ), m, f, d[ n + 11 ], 14, 643717713 ), i, m, d[ n + 0 ], 20, -373897302 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 5 ], 5, -701558691 ), f, r, d[ n + 10 ], 9, 38016083 ), m, f, d[ n + 15 ], 14, -660478335 ), i, m, d[ n + 4 ], 20, -405537848 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 9 ], 5, 568446438 ), f, r, d[ n + 14 ], 9, -1019803690 ), m, f, d[ n + 3 ], 14, -187363961 ), i, m, d[ n + 8 ], 20, 1163531501 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 13 ], 5, -1444681467 ), f, r, d[ n + 2 ], 9, -51403784 ), m, f, d[ n + 7 ], 14, 1735328473 ), i, m, d[ n + 12 ], 20, -1926607734 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 5 ], 4, -378558 ), f, r, d[ n + 8 ], 11, -2022574463 ), m, f, d[ n + 11 ], 16, 1839030562 ), i, m, d[ n + 14 ], 23, -35309556 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 1 ], 4, -1530992060 ), f, r, d[ n + 4 ], 11, 1272893353 ), m, f, d[ n + 7 ], 16, -155497632 ), i, m, d[ n + 10 ], 23, -1094730640 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 13 ], 4, 681279174 ), f, r, d[ n + 0 ], 11, -358537222 ), m, f, d[ n + 3 ], 16, -722521979 ), i, m, d[ n + 6 ], 23, 76029189 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 9 ], 4, -640364487 ), f, r, d[ n + 12 ], 11, -421815835 ), m, f, d[ n + 15 ], 16, 530742520 ), i, m, d[ n + 2 ], 23, -995338651 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 0 ], 6, -198630844 ), f, r, d[ n + 7 ], 10, 1126891415 ), m, f, d[ n + 14 ], 15, -1416354905 ), i, m, d[ n + 5 ], 21, -57434055 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 12 ], 6, 1700485571 ), f, r, d[ n + 3 ], 10, -1894986606 ), m, f, d[ n + 10 ], 15, -1051523 ), i, m, d[ n + 1 ], 21, -2054922799 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 8 ], 6, 1873313359 ), f, r, d[ n + 15 ], 10, -30611744 ), m, f, d[ n + 6 ], 15, -1560198380 ), i, m, d[ n + 13 ], 21, 1309151649 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 4 ], 6, -145523070 ), f, r, d[ n + 11 ], 10, -1120210379 ), m, f, d[ n + 2 ], 15, 718787259 ), i, m, d[ n + 9 ], 21, -343485551 ), m = safe_add( m, h ), f = safe_add( f, t ), r = safe_add( r, g ), i = safe_add( i, e );
        }
        return Array( m, f, r, i );
    }
    
    function md5_cmn ( d, _, m, f, r, i ) {
        return safe_add( bit_rol( safe_add( safe_add( _, d ), safe_add( f, i ) ), r ), m );
    }
    
    function md5_ff ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & m | ~_ & f, d, _, r, i, n );
    }
    
    function md5_gg ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & f | m & ~f, d, _, r, i, n );
    }
    
    function md5_hh ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ ^ m ^ f, d, _, r, i, n );
    }
    
    function md5_ii ( d, _, m, f, r, i, n ) {
        return md5_cmn( m ^ (_ | ~f), d, _, r, i, n );
    }
    
    function safe_add ( d, _ ) {
        var m = (65535 & d) + (65535 & _);
        return (d >> 16) + (_ >> 16) + (m >> 16) << 16 | 65535 & m;
    }
    
    function bit_rol ( d, _ ) {
        return d << _ | d >>> 32 - _;
    }
    
    return self;
})( SHINKEN.TOOLS.MD5 || {} );

String.prototype.startsWith = String.prototype.startsWith || function ( pattern ) {
    return this.indexOf( pattern ) === 0;
};
String.prototype.endsWith   = String.prototype.endsWith || function ( pattern ) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf( pattern ) === d;
};

//******************************  END  string-service.js   **************************

//******************************  START  element-checkbox.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/element-checkbox.js *
'use strict';

OBJECT.ElementCheckbox           = function ( dom_element ) {
    this.init( dom_element );
};
OBJECT.ElementCheckbox.prototype = {
    init      : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_checked  = dom_element.classList.contains( 'shinken-checked' );
    },
    setChecked: function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        this.is_checked = !!to_set;
        this.updateView();
    },
    isChecked : function () {
        return this.is_checked;
    },
    getValue  : function () {
        return this.is_checked ? '1' : '0';
    },
    updateView: function () {
        if ( this.is_checked ) {
            this.dom_element.classList.add( 'shinken-checked' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-checked' );
        }
    }
};
//******************************  END  element-checkbox.js   **************************

//******************************  START  element-list.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/element-list.js *
'use strict';

OBJECT.ElementList           = function () {
    // name
    // label
    // state
    // is_disabled
    // type
    // item_type
    // counter_stagging
    // counter_working_area
    // uuid
    // shinken_element
    this.init();
};
OBJECT.ElementList.prototype = {
    init                 : function () {
        this.is_disabled = false;
        this.initCounter();
    },
    getName              : function () {
        return this.name;
    },
    getState             : function () {
        return this.state;
    },
    getType              : function () {
        return this.type;
    },
    getItemType          : function () {
        return this.item_type ? this.item_type : '';
    },
    getLabel             : function () {
        return this.label;
    },
    setName              : function ( to_set, dom_element ) {
        this.name = to_set;
        this.setLabel( to_set, dom_element );
    },
    setLabel             : function ( to_set ) {
        this.label = to_set;
    },
    setState             : function ( to_set ) {
        this.state = to_set;
    },
    setIsDisabled        : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_disabled = !!to_set;
    },
    setIsForceToNull     : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_force_to_null = !!to_set;
    },
    setIsHiddenForAdminSi: function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_hidden_for_admin_si = !!to_set;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        this.findShinkenElement();
    },
    findShinkenElement   : function () {
        if ( this.uuid && this.item_type ) {
            var _shinken_element = MANAGER.__instance_element_distributor.getElementListElementByUuid( this.item_type, this.uuid );
            if ( _shinken_element ) {
                this.setShinkenElement( _shinken_element );
            }
        }
    },
    setShinkenElement    : function ( to_set ) {
        this.shinken_element = to_set;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setItemType          : function ( to_set ) {
        this.item_type = to_set;
        this.findShinkenElement();
    },
    clone                : function () {
        var _to_return = new OBJECT.ElementList();
        var _keys      = Object.keys( this );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key               = _keys[ i ];
            _to_return[ _current_key ] = this[ _current_key ];
        }
        return _to_return;
    },
    getClass             : function () {
        var _to_return = "";
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _to_return += " shinken-element-new";
        }
        else if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            _to_return += " shinken-element-unknown";
        }
        else if ( this.is_disabled ) {
            _to_return += " shinken-element-disabled";
        }
        return _to_return;
    },
    getError             : function () {
        if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            return 1;
        }
        if ( this.is_disabled ) {
            return 1;
        }
        return 0;
    },
    getTooltip           : function () {
        var _to_return = "";
        switch ( this.state ) {
            case COMPONENT.CONST.TAG.STATE.NEW :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                _to_return = _( 'element.tooltip_new' );
                break;
            case COMPONENT.CONST.TAG.STATE.WORKING :
                _to_return = _( 'element.tooltip_working' );
                break;
            case COMPONENT.CONST.TAG.STATE.UNKNOWN :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN :
                _to_return = _( 'element.tooltip_undefined' );
                break;
        }
        if ( this.is_disabled ) {
            _to_return = _( 'element.tooltip_disabled' );
        }
        if ( this.is_force_to_null ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += SHINKEN.TOOLS.STRING.format( _( 'element.double_link_long_warning' ), this.getLabel() );
        }
        return _to_return;
    },
    getValueFinal        : function () {
        var _to_return = {};
        switch ( this.getState() ) {
            case OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
            case OBJECT.CONST.TEMPLATE.STATUS.NEW:
            case COMPONENT.CONST.TAG.STATE.UNKNOWN:
            case COMPONENT.CONST.TAG.STATE.NEW:
                _to_return.name   = this.name;
                _to_return.exists = false;
                break;
            default:
                _to_return.name      = this.name;
                _to_return.item_type = this.getItemType();
                _to_return._id       = this.uuid;
                _to_return.exists    = true;
                break;
        }
        return _to_return;
    },
    //***********************************************   COUNTER (MASS ACTION)**************************************************//
    initCounter          : function () {
        this.counter_working_area = 0;
        this.counter_stagging     = 0;
    },
    getCounter           : function ( type ) {
        switch ( type ) {
            case MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA:
                return this.counter_working_area;
            case MANAGER.CONST.STATE.WORK_FLOW.STAGING:
                return this.counter_stagging;
            
        }
    },
    addCounter           : function ( type ) {
        switch ( type ) {
            case MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA:
                this.counter_working_area++;
                break;
            case MANAGER.CONST.STATE.WORK_FLOW.STAGING:
                this.counter_stagging++;
                break;
        }
    }
};
//******************************  END  element-list.js   **************************

//******************************  START  list-template.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/list-template.js *
'use strict';

OBJECT.ListTemplate           = function ( data ) {
    // list_template
    // list_template_mapping
    // list_template_computed
    // size
    // size_computed
    this.init( data );
};
OBJECT.ListTemplate.prototype = {
    init               : function ( data ) {
        this.list_template         = [];
        this.list_template_mapping = {};
        this.list_use_by_name      = {};
        if ( !data ) {
            this.size = 0;
            return;
        }
        this.initData( data );
        this.computeListUseFinal();
        this.buildTemplateStatus();
        this.buildComputedList();
    },
    initData           : function ( data ) {
        this.size = data.length;
        var object;
        for ( var i = 0; i < this.size; i++ ) {
            object                                         = new OBJECT.Template( data[ i ] );
            this.list_template[ i ]                        = object;
            this.list_template_mapping[ object.getUuid() ] = i;
        }
    },
    computeListUseFinal: function () {
        var _current;
        for ( var i = this.size - 1; i >= 0; i-- ) {
            _current = this.list_template[ i ];
            this._computeUse( _current );
        }
    },
    buildTemplateStatus: function () {
        var _current;
        var _current_tested;
        
        for ( var i = 1; i < this.size; i++ ) {
            _current = this.list_template[ i ];
            for ( var j = 0; j < i; j++ ) {
                _current_tested = this.list_template[ j ];
                
                if ( this.list_use_by_name[ _current_tested.getName() ][ _current.getName() ] ) {
                    _current.setStatus( OBJECT.CONST.TEMPLATE.STATUS.USELESS, _current_tested.getName() );
                    break;
                }
            }
        }
    },
    buildComputedList  : function () {
        this.list_template_computed = [];
        var _current;
        for ( var i = 0; i < this.size; i++ ) {
            _current = this.list_template[ i ];
            if ( _current.isStatus( OBJECT.CONST.TEMPLATE.STATUS.USEFUL ) ) {
                this.list_template_computed.push( _current );
            }
        }
        this.size_computed = this.list_template_computed.length;
    },
    getTemplateByTag   : function ( tag ) {
        var _to_return;
        _to_return = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( tag.element.uuid );
        
        if ( !_to_return ) {
            _to_return = MANAGER.__instance_element_distributor.list_templates.getTemplateByName( tag.element.name );
        }
        return _to_return;
    },
    getTemplateByUuid  : function ( uuid ) {
        var _index = this.list_template_mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getTemplateByIndex( _index );
    },
    getTemplateByName  : function ( name ) {
        if ( !name ) {
            return null;
        }
        return SHINKEN.TOOLS.ARRAY.findFirstElementWith( this.list_template, OBJECT.CONST.TEMPLATE.FIELD.NAME, name );
    },
    getTemplateByIndex : function ( index ) {
        return this.list_template[ index ];
    },
    isEmpty            : function () {
        return !this.size;
    },
    _computeUse        : function ( template ) {
        var _level_template_already_used;
        var _current_name_template_use;
        var _keys_already_used;
        var _size_already_used;
        var _current_template;
        
        var _name = template.getName();
        if ( !this.list_use_by_name[ _name ] ) {
            this.list_use_by_name[ _name ] = {};
        }
        if ( !template.isEnabled() ) {
            return;
        }
        var _current_use      = template[ OBJECT.CONST.TEMPLATE.FIELD.USE ];
        var _size_current_use = _current_use.length;
        
        for ( var i = 0; i < _size_current_use; i++ ) {
            _current_name_template_use = _current_use[ i ];
            if ( this.list_use_by_name[ _name ][ _current_name_template_use ] ) {
                this.list_use_by_name[ _name ][ _current_name_template_use ] = 1;
                continue;
            }
            this.list_use_by_name[ _name ][ _current_name_template_use ] = 1;
            
            if ( !this.list_use_by_name[ _current_name_template_use ] ) {
                continue;
            }
            
            _keys_already_used = Object.keys( this.list_use_by_name[ _current_name_template_use ] );
            _size_already_used = _keys_already_used.length;
            
            for ( var j = 0; j < _size_already_used; j++ ) {
                _level_template_already_used = this.list_use_by_name[ _current_name_template_use ][ _keys_already_used[ j ] ];
                if ( this.list_use_by_name[ _name ][ _keys_already_used[ j ] ] ) {
                    continue;
                }
                this.list_use_by_name[ _name ][ _keys_already_used[ j ] ] = _level_template_already_used + 1;
            }
            _current_template = this.getTemplateByName( _current_name_template_use );
            template.completeTemplateWithUse( _current_template );
        }
    },
    getIndexForCompute : function ( template ) {
        for ( var i = 0; i < this.size_computed; i++ ) {
            if ( template.uuid === this.list_template_computed[ i ].uuid ) {
                return i;
            }
        }
        return -1;
    },
    getProperties      : function ( name ) {
        var _to_return    = [];
        var _stop_compute = false;
        var _current;
        var _current_property;
        
        for ( var i = 0; i < this.size_computed; i++ ) {
            _current = this.list_template_computed[ i ];
            
            _current_property = _current.properties[ name ];
            
            if ( !_current_property ) {
                continue;
            }
            
            if ( !_current_property.isEmpty() ) {
                _to_return.push( _current_property );
            }
            
            if ( _stop_compute ) {
                _current_property.setIsStopped( true );
                continue;
            }
            if ( !_current_property.hasPlus() ) {
                _stop_compute = true;
            }
        }
        
        
        var _size = _to_return.length;
        if ( _size ) {
            _to_return[ _size - 1 ].setIsLast( true );
        }
        else {
            _to_return = null;
        }
        return _to_return;
    },
    finalyzeView       : function () {
        var _current;
        var _current_state;
        var _current_template;
        var _use = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        if ( !_use ) {
            return;
        }
        for ( var i = 0; i < _use.component_select.list_element_selected.size_tags; i++ ) {
            _current          = _use.component_select.list_element_selected.getTagByIndex( i );
            _current_state    = _current.getState();
            _current_template = this.getTemplateByTag( _current );
            if ( _current_state === COMPONENT.CONST.TAG.STATE.HIDDEN ) {
                continue;
            }
            if ( _current_state === COMPONENT.CONST.TAG.STATE.NEW && _current_template.status === OBJECT.CONST.TEMPLATE.STATUS.USEFUL ) {
                _current.setState( OBJECT.CONST.TEMPLATE.STATUS.NEW );
            }
            else {
                if ( !_current.element.item_type ) {
                    _current.element.setItemType( _current_template.item_type );
                }
                _current.setState( _current_template.status );
                _current.setTooltip( _current_template.status_tooltip );
            }
        }
        _use.checkErrorWarning();
    }
};
//******************************  END  list-template.js   **************************

//******************************  START  macro.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/macro.js *
'use strict';

OBJECT.Macro           = function ( name, value, type ) {
    name                   = name.toUpperCase();
    this.name              = name;
    this.key               = name.substr( 1, name.length - 2 );
    this.property          = null;
    this.value             = value;
    this.final_value       = value;
    this.type              = type;
    this.macro_used        = {};
    this.is_loop           = false;
    this.is_protected      = false;
    this.is_unknown        = false;
    this.is_herited        = false;
    this.is_double_dollar  = !this.key;
    this.is_force_to_empty = false;
};
OBJECT.Macro.prototype = {
    init                 : function ( forced ) {
        if ( this.value && !forced ) {
            return;
        }
        if ( forced ) {
            if ( !this.is_loop ) {
                var _keys = Object.keys( this.macro_used );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    _current_key = _keys[ i ];
                    this.macro_used[ _current_key ].init( forced );
                }
            }
            this.macro_used = {};
            this.is_loop    = false;
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( this.key, OBJECT.CONST.MACRO.TYPE.HOST_LOCAL ) ) {
            this.type       = OBJECT.CONST.MACRO.TYPE.HOST_LOCAL;
            var _key        = "_" + this.key.substr( OBJECT.CONST.MACRO.TYPE.HOST_LOCAL.length );
            var _local_data = MANAGER.__instance_property_distributor.getDataWithName( _key );
            if ( !_local_data ) {
                this.setUnknown( true );
                return;
            }
            this.setUnknown( false );
            if ( _local_data.isProtected() ) {
                this.is_protected = true;
                return;
            }
            var _value = '';
            switch ( _local_data.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                    _value = _local_data.getValue();
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    this.is_herited = true;
                    _value          = _local_data.getValueInherited();
                    break;
            }
            this.setValue( _value );
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( this.key, OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL ) ) {
            this.type = OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL;
            return;
        }
        else if ( this.key === 'VALUE' ) {
            this.type      = OBJECT.CONST.MACRO.TYPE.VALUE_DFE;
            this.index_dfe = 0;
            return;
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( this.key, 'VALUE' ) ) {
            var _index = parseInt( this.key.replace( 'VALUE', '' ) );
            if ( isNaN( _index ) ) {
                this.type = this.getTypeMacrosNotLocal( this.key );
            }
            else {
                this.type      = OBJECT.CONST.MACRO.TYPE.VALUE_DFE;
                this.index_dfe = _index - 1;
            }
            return;
        }
        else if ( this.name === OBJECT.CONST.MACRO.TYPE.DFE_KEY ) {
            this.type = OBJECT.CONST.MACRO.TYPE.DFE_KEY;
            return;
        }
        else {
            this.type = this.getTypeMacrosNotLocal( this.key );
            return;
        }
    },
    setUnknown           : function ( to_set ) {
        this.is_unknown = to_set;
    },
    setValue             : function ( to_set, property ) {
        this.setUnknown( !to_set );
        if ( property ) {
            this.is_herited = property.state_inheritance;
        }
        switch ( this.type ) {
            case OBJECT.CONST.MACRO.TYPE.VALUE_DFE:
            case OBJECT.CONST.MACRO.TYPE.HOST_LOCAL:
                this.final_value = "";
                this.value       = to_set;
                if ( to_set === undefined ) {
                    return;
                }
                var _splitted = MANAGER.__instance_macro_distributor.splitCommand( to_set );
                var _current;
                
                for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
                    _current = _splitted[ i ];
                    if ( typeof _current === 'string' ) {
                        this.final_value += SHINKEN.TOOLS.STRING.cleanXss( _current );
                    }
                    else {
                        this.macro_used[ _current.name ] = _current;
                        if ( _current.macro_used[ this.name ] ) {
                            this.macro_used[ _current.name ] = _current;
                            this.is_loop                     = true;
                            _current.is_loop                 = true;
                            return;
                        }
                        else {
                            for ( var macro in _current.macro_used ) {
                                this.macro_used[ macro ] = _current.macro_used[ macro ];
                            }
                        }
                        this.final_value += _current.getValue();
                    }
                }
                break;
            case OBJECT.CONST.MACRO.TYPE.HOST_PROPERTY:
                this.value       = to_set;
                this.final_value = to_set;
                break;
            default:
                this.value = to_set;
        }
    },
    getValue             : function () {
        var _to_return = this.final_value;
        if ( this.is_force_to_empty ) {
            return "";
        }
        if ( this.is_double_dollar ) {
            return "$";
        }
        if ( this.is_unknown || this.type === OBJECT.CONST.MACRO.TYPE.UNKNOWN || (this.type === OBJECT.CONST.MACRO.TYPE.VALUE_DFE && !this.final_value) ) {
            _to_return = DOM.Service.createElement( "span",
                {
                    class         : "shinken-macro-warning value",
                    onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                    'shi-tip-html': SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_found' ), this.name ),
                    onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()"
                }, this.name );
            return _to_return.outerHTML;
        }
        switch ( this.type ) {
            case OBJECT.CONST.MACRO.TYPE.DFE_KEY:
                return OBJECT.CONST.MACRO.TYPE.DFE_KEY;
            case OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL:
            case OBJECT.CONST.MACRO.TYPE.HOST_PROPERTY:
            case OBJECT.CONST.MACRO.TYPE.GLOBAL:
            case OBJECT.CONST.MACRO.TYPE.GLOBAL_INTERPRETED:
            case OBJECT.CONST.MACRO.TYPE.SERVICE_PROPERTY:
                _to_return = DOM.Service.createElement( "span",
                    {
                        class         : "shinken-macro-warning value",
                        onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                        'shi-tip-html': SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_evaluated' ), this.name ),
                        onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()"
                    }, this.name );
                return _to_return.outerHTML;
        }
        if ( this.is_loop || this.is_protected ) {
            _to_return = DOM.Service.createElement( "span",
                {
                    class       : "shinken-macro-error value",
                    onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                    onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
                }, this.name );
            if ( this.is_loop ) {
                _to_return.setAttribute( "shi-tip-html", SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_infinity_loop' ), this.name ) );
            }
            else if ( this.is_protected ) {
                _to_return.setAttribute( "shi-tip-html", _( 'element.password_protected' ) );
                _to_return.classList.add( "shinken-macro-protected" );
            }
            return _to_return.outerHTML;
        }
        if ( this.is_herited ) {
            _to_return = "<span class='shinken-macro-inherited'>" + _to_return + "</span>";
        }
        return _to_return;
    },
    getTypeMacrosNotLocal: function ( key ) {
        var _list_names_properties;
        var _current_type_name;
        var _key_types_macros = Object.keys( OBJECT.CONST.MACRO.TYPE );
        for ( var i = 0, _size_types = _key_types_macros.length; i < _size_types; i++ ) {
            _current_type_name     = OBJECT.CONST.MACRO.TYPE[ _key_types_macros[ i ] ];
            _list_names_properties = all_macros_name_not_resolved[ _current_type_name ];
            if ( !_list_names_properties ) {
                continue;
            }
            
            for ( var j = 0, _size_macro_name = _list_names_properties.length; j < _size_macro_name; j++ ) {
                if ( key === _list_names_properties[ j ] ) {
                    return _current_type_name;
                }
                
            }
        }
        return OBJECT.CONST.MACRO.TYPE.UNKNOWN;
    }
};

//******************************  END  macro.js   **************************

//******************************  START  messages.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/messages.js *
'use strict';

OBJECT.Messages = function ( footer ) {
    this.messages_error   = [];
    this.messages_warning = [];
    this.messages_beware  = [];
    this.messages_info    = [];
    this.is_dfe           = false;
    this.footer           = footer;
};

OBJECT.MESSAGE            = {
    ICON       : {
        ERROR  : '<span class="shinken-icon-error shinkon-warning"></span>',
        WARNING: '<span class="shinken-icon-warning shinkon-warning"></span>',
        BEWARE : '<span class="shinken-icon-warning shinkon-warning-light"></span>'
    },
    MAX_ERROR  : 5,
    MAX_WARNING: 5
};
OBJECT.Messages.prototype = {
    addMessage  : function ( type_message, text ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.Message( type_message, text ) );
                break;
            default:
                this.messages_info.push( new OBJECT.Message( type_message, text ) );
                break;
        }
    },
    addMessages : function ( messages ) {
        if ( !messages ) {
            return;
        }
        var _size = messages.length;
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            this.addMessage( _current_message._type, _current_message._text );
        }
    },
    hasMessage  : function () {
        return this.hasError() || this.hasWarning() || this.hasBeware() || this.hasInfo();
    },
    hasError    : function () {
        return this.messages_error.length > 0;
    },
    hasWarning  : function () {
        return this.messages_warning.length > 0;
    },
    hasBeware   : function () {
        return this.messages_beware.length > 0;
    },
    hasInfo     : function () {
        return this.messages_info.length > 0;
    },
    getStatus   : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasBeware() ) {
            return COMPONENT.CONST.STATUS.BEWARE;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage: function ( is_default, template_name ) {
        
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return          = '<div class="shinken-tooltip-message text-left">';
        var _show_extra_message = false;
        if ( this.hasError() ) {
            _show_extra_message = true;
            _to_return += '<span class="text-underline">' + _( 'element.tooltip_message_invalid_syntax' ) + '</span><br>';
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'element.tooltip_message_tag_error' ) + '<br><ol>';
            var _size           = Math.min( this.messages_error.length, OBJECT.MESSAGE.MAX_ERROR );
            for ( var i = 0; i < _size; i++ ) {
                _to_return += this.messages_error[ i ].buildHtml();
            }
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _show_extra_message = true;
            _to_return += OBJECT.MESSAGE.ICON.WARNING + _( 'element.tooltip_message_tag_warning' ) + '<br><ol>';
            var _size           = Math.min( this.messages_warning.length, OBJECT.MESSAGE.MAX_WARNING );
            for ( var i = 0; i < _size; i++ ) {
                _to_return += this.messages_warning[ i ].buildHtml();
            }
            _to_return += '</ol>';
        }
        if ( _show_extra_message && this.is_dfe ) {
            var _format_to_follow        = is_default ? _( 'element.tooltip_dfe_common_default_value' ) : _( 'element.tooltip_dfe_common' );
            var _note_to_update_template = template_name ? '<div class=\'container-legend \'>' + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_common_go_tpl' ), template_name ) + '</div>' : "";
            _to_return                   = _to_return +
                                           '<div class=\'container-legend\'>' + _format_to_follow + '</div>' +
                                           _note_to_update_template;
            
        }
        if ( this.hasBeware() && this.is_dfe ) {
            if ( _show_extra_message ) {
                _to_return += '<hr>';
            }
            _to_return += '<ol>' + OBJECT.MESSAGE.ICON.BEWARE + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_deleted_part_1' ), this.property_name );
            var _size = this.messages_beware.length;
            for ( var i = 0; i < _size; i++ ) {
                _to_return += this.messages_beware[ i ].buildHtml();
            }
            _to_return += '</ol>';
        }
        else if ( this.hasBeware() ) {
            _to_return += OBJECT.MESSAGE.ICON.BEWARE + _( 'element.tooltip_message_tag_warning' ) + '<br>';
            var _size = this.messages_beware.length;
            for ( var i = 0; i < _size; i++ ) {
                _to_return += this.messages_beware[ i ].buildHtml();
            }
        }
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    }
};

OBJECT.Message = function ( type, text ) {
    this._type = type;
    this._text = text;
};

OBJECT.Message.prototype = {
    buildHtml: function () {
        return '<li class=\'' + this._type + '\'>' + this._text + '</li>';
    }
};
//******************************  END  messages.js   **************************

//******************************  START  phase.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/phase.js *
'use strict';

OBJECT.CONST.PHASE = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7
};

OBJECT.Phase           = function () {
    this.previous_phase = null;
    this.current_phase  = OBJECT.CONST.PHASE.INIT;
};
OBJECT.Phase.prototype = {
    setPhase           : function ( to_set ) {
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        setTimeout( function () {
            self.previous_phase = this.current_phase;
            self.current_phase  = to_set;
        }, timeout );
    },
    isPhase            : function ( to_test ) {
        return this.current_phase === to_test;
    }
};

//******************************  END  phase.js   **************************

//******************************  START  shinken-element.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/shinken-element.js *
'use strict';

OBJECT.ShinkenElement           = function () {
    //key_name
    this.name_element = '';
    this.type         = '';
    this.is_enabled   = true;
    this.phase        = OBJECT.CONST.ELEMENT.PHASE.INIT;
};
OBJECT.ShinkenElement.prototype = {
    FIELD                         : OBJECT.CONST.ELEMENT.FIELD,
    init                          : function () {
    },
    updateData                    : function ( datas ) {
        if ( !datas ) {
            return;
        }
        var _keys     = Object.keys( datas );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, datas[ _currentKey ] );
        }
        this.computeName();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setPhase                      : function ( to_set ) {
        var self = this;
        switch ( to_set ) {
            case OBJECT.CONST.ELEMENT.PHASE.EDITING:
                if ( this.phase === OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED ) {
                    return;
                }
                break;
        }
        this.phase = to_set;
        switch ( this.phase ) {
            case OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED:
                var _all_properties = MANAGER.__instance_property_distributor.getAllElements();
                for ( var i = 0, _size = _all_properties.length; i < _size; i++ ) {
                    _all_properties[ i ].checkErrorWarning();
                }
                break;
        }
    },
    setType                       : function ( to_set ) {
        this.type = to_set;
    },
    getType                       : function () {
        return this.type;
    },
    getHelpType                   : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.HOSTS;
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.CLUSTERS;
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return "services";
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.CONTACTS;
        }
        return this.type;
    },
    getSEUUIDType                 : function () {
        var _to_return = SHINKEN.TOOLS.STRING.getSubStringUntil( this.getHelpType(), 0, 1 );
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                _to_return = 'host';
                break;
        }
        return _to_return;
    },
    isType                        : function ( types ) {
        if ( typeof types === 'string' ) {
            types = [ types ];
        }
        for ( var i = 0, _size_i = types.length; i < _size_i; i++ ) {
            if ( this.type === types[ i ] ) {
                return true;
            }
        }
        return false;
    },
    isNew                         : function () {
        return this.is_new;
    },
    isCheck                       : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return true;
        }
        return false;
    },
    isCluster                     : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                return true;
        }
        return false;
    },
    isTemplate                    : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
                return true;
        }
        return false;
    },
    canHaveData                   : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
                return true;
        }
        return false;
    },
    canHaveCheck                  : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return true;
        }
        return false;
    },
    canHaveTemplate               : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return true;
        }
        return false;
    },
    setData                       : function ( key, value ) {
        switch ( key ) {
            case this.FIELD.ID:
                this.setUUID( value );
                break;
            case this.FIELD.SERVICE_OVERRIDES:
                this.setOverride( value );
                break;
            case this.FIELD.SERVICE_EXCLUDES_BY_ID:
                this.setExclude( value );
                break;
            case this.FIELD.ENABLED:
                this.setEnabled( value );
                break;
            case this.FIELD.SOURCES:
            case this.FIELD.IMPORT_DATE:
            case this.FIELD.USE:
                this[ key ] = value;
                break;
            case this.FIELD.SYNC_KEYS:
            case this.FIELD.LAST_MODIFICATION:
            case '_SE_UUID':
            case '_SE_UUID_HASH':
                break;
            case '@metadata':
                this.setMetadata( value );
                break;
            case 'duplicate_foreach':
                this[ key ] = value;
                this.is_dfe = true;
                break;
            case this.FIELD.WORK_AREA_INFO:
                this.setWorkAreaData( value );
                break;
            default:
                this[ key ] = value;
            
        }
    },
    setMetadata                   : function ( to_set ) {
        if ( this.is_used_in_check_inheritance && !to_set.is_used_in_check_inheritance ) {
            return;
        }
        this.setType( to_set.type );
        this.host_uuid = to_set.host_uuid;
        if ( !this.host_uuid && MANAGER.__instance_element_distributor && MANAGER.__instance_element_distributor.current_element ) {
            //BIDOUILE CAR IL N Y A PAS LES HOST_UUID POUR LES ELEMENTS NEW
            switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                    if ( this.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST ) {
                        this.host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
                    }
                    break;
                case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                    if ( this.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST ) {
                        this.host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
                    }
                    break;
            }
        }
        this.host_type   = to_set.host_type;
        this.is_new      = to_set.new;
        this.is_creation = to_set.in_creation || false;
        this.has_data    = to_set.has_data;
        this.setStatus( to_set.state );
        this.is_used_in_check_inheritance = to_set.is_used_in_check_inheritance;
    },
    setUUID                       : function ( to_set ) {
        this.uuid = to_set;
    },
    setEnabled                    : function ( to_set ) {
        if ( to_set === '1' ) {
            this.is_enabled = true;
        }
        else if ( to_set === '0' ) {
            this.is_enabled = false;
        }
    },
    setStatus                     : function ( to_set ) {
        this[ OBJECT.CONST.ELEMENT.FIELD.STATUS ] = to_set;
        if ( to_set === OBJECT.CONST.ELEMENT.STATUS.NEW ) {
            this.is_new = true;
        }
    },
    cleanChecks                   : function () {
        if ( !this.canHaveCheck() ) {
            return;
        }
        this.checks         = [];
        this.size_dfe_check = 0;
    },
    addCheck                      : function ( to_add ) {
        this.checks.push( to_add );
        if ( to_add.is_dfe ) {
            this.size_dfe_check++;
        }
    },
    isEnabled                     : function () {
        return this.is_enabled;
    },
    setWorkAreaData               : function ( data ) {
        this.work_area_status = data[ 'status' ];
    },
    getName                       : function () {
        return this.name_element;
    },
    getUUID                       : function () {
        return this.uuid;
    },
    getSEUUID                     : function () {
        return "core-" + this.getSEUUIDType() + "-" + this.uuid;
    },
    getAllData                    : function () {
        var _to_return = {};
        var keys       = Object.keys( this );
        var _current;
        for ( var i = 0, _size = keys.length; i < _size; i++ ) {
            _current = keys[ i ];
            if ( SHINKEN.TOOLS.STRING.startsWith( _current, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                _to_return[ _current ] = this[ _current ];
            }
        }
        delete _to_return[ "_SYNC_KEYS" ];
        return _to_return;
    },
    computeKeyName                : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                this.key_name = 'host_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.HOST_GROUPS:
                this.key_name = 'hostgroup_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                this.key_name = 'service_description';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.COMMANDS:
                this.key_name = 'command_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_GROUPS:
                this.key_name = 'contactgroup_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                this.key_name = 'name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
                this.key_name = 'contact_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.ESCALATIONS:
                this.key_name = 'escalation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_BUSINESS_IMPACT:
                this.key_name = 'business_impact_modulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
                this.key_name = 'macromodulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_RESULT:
                this.key_name = 'resultmodulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.NOTIFICATION_WAYS:
                this.key_name = 'notificationway_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.TIME_PERIODS:
                this.key_name = 'timeperiod_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.DISCOVERY:
                this.key_name = 'discovery_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.SYNCHRONIZER_LINKER:
                this.key_name = PROPERTY.CONST.NAME.SYNC_NAME;
                break;
            default:
                console.error( "[type not managed] ==>", this.type );
        }
    },
    computeName                   : function () {
        this.computeKeyName();
        this.name_element = this[ this.key_name ];
    },
    getValuesSplitted             : function ( property_name ) {
        var _to_return = [];
        if ( !this[ property_name ] ) {
            return _to_return;
        }
        var _modulation_list;
        var _modulation_name;
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                _modulation_name = PROPERTY.CONST.NAME.RESULTMODULATION_NAME;
                break;
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                _modulation_name = PROPERTY.CONST.NAME.MACROMODULATION_NAME;
                break;
            default:
                _to_return = SHINKEN.TOOLS.STRING.startsWith( this[ property_name ], PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ? this[ property_name ].substr( 1 ) : this[ property_name ];
                _to_return = _to_return.split( ',' );
                break;
        }
        if ( _modulation_name ) {
            _modulation_list = this[ property_name ];
            _to_return       = [];
            if ( typeof _modulation_list !== 'string' ) {
                for ( var i = 0, _size_i = _modulation_list.length; i < _size_i; i++ ) {
                    _to_return.push( _modulation_list[ i ][ _modulation_name ] );
                }
            }
            else {
                _to_return = _modulation_list.split( ',' );
            }
        }
        
        return _to_return;
    },
    getValidCheck                 : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.checks.length; i < _size_i; i++ ) {
            if ( !this.checks[ i ].is_obsolete ) {
                _to_return.push( this.checks[ i ] );
            }
        }
        return _to_return;
    },
    //********************************************  MODULATION   **************************************************//
    getTypeModulation             : function ( modulation_name ) {
        if ( !this[ modulation_name ] ) {
            return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
        }
        if ( this[ modulation_name ] === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
        }
        if ( this[ modulation_name ] === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
            return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
        }
        var _current;
        for ( var i = 0, _size = this[ modulation_name ].length; i < _size; i++ ) {
            _current = this[ modulation_name ][ i ];
            if ( _current.missing || _current.invalid ) {
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR;
            }
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
    },
    //********************************************  EXCLUDE   **************************************************//
    setExclude                    : function ( to_set ) {
        this.exclude = new OBJECT.ServiceExcludes( to_set );
    },
    changeExcludeStatus           : function ( check_in_page_host ) {
        if ( !this.exclude ) {
            this.exclude = new OBJECT.ServiceExcludes();
        }
        return this.exclude.changeExcludeStatus( check_in_page_host );
    },
    getExcludeStatus              : function ( check_in_page_host ) {
        if ( !this.exclude ) {
            return OBJECT.CONST.EXCLUDE_STATUS.OFF;
        }
        return this.exclude.getExcludeStatus( check_in_page_host );
    },
    //********************************************  OVERRIDE   **************************************************//
    setOverride                   : function ( to_set ) {
        this.override = new OBJECT.ServiceOverrides( to_set );
    },
    addOverrideByProperty         : function ( property, check_in_page_host, host_in_page_host ) {
        if ( !this.override ) {
            this.override = new OBJECT.ServiceOverrides();
        }
        this.override.addOverrideByProperty( property, check_in_page_host, host_in_page_host );
    },
    hasOverride                   : function ( check_in_page_host ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.hasOverride( check_in_page_host );
    },
    setCheckInPageHostOnOverride  : function ( check_in_page_host ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.setCheckInPageHostOnOverride( check_in_page_host );
    },
    getOverrideValue              : function ( prop_name, check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return null;
        }
        return this.override.getOverrideValue( prop_name, check_in_page_host );
    },
    getOverrideErrorWarningCounter: function ( check_in_page_host ) {
        if ( !this.override ) {
            return [ 0, 0 ];
        }
        return this.override.getErrorWarningCounter( check_in_page_host );
    },
    hasOverrideModulation         : function ( check_host, property_name ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.hasOverrideModulation( check_host, property_name );
    },
    cleanOverrideFor              : function ( _check_in_host ) {
        if ( !this.override ) {
            return;
        }
        var _nb_override = this.override.cleanOverrideFor( _check_in_host );
        if ( !_nb_override ) {
            delete this.override;
        }
        return _nb_override;
    },
    validateOverride              : function () {
        if ( !this.override ) {
            return;
        }
        this.override.validate();
    },
    unSetOverrideCheckInPageHost  : function ( check_in_page_host ) {
        if ( !this.override ) {
            return;
        }
        this.override.unSetOverrideCheckInPageHost( check_in_page_host );
    }
};

//******************************  END  shinken-element.js   **************************

//******************************  START  template.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/template.js *
'use strict';

OBJECT.Template           = function ( data ) {
    // name
    // properties
    // datas
    // status
    // status_tooltip
    // checks
    // size_dfe_check
    this.init( data );
};
OBJECT.Template.prototype = {
    init                     : function ( data ) {
        this.properties                                  = {};
        this.datas                                       = {};
        this.checks                                      = [];
        this.size_dfe_check                              = 0;
        this[ OBJECT.CONST.TEMPLATE.FIELD.USE ]          = [];
        this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ]      = true;
        this[ OBJECT.CONST.TEMPLATE.FIELD.IS_NEW ]       = false;
        this[ OBJECT.CONST.TEMPLATE.FIELD.UNCONFIGURED ] = false;
        this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.USEFUL );
        this.updateData( data );
    },
    updateData               : function ( data ) {
        var _currentKey;
        this[ OBJECT.CONST.TEMPLATE.FIELD._ID ]  = data[ OBJECT.CONST.TEMPLATE.FIELD._ID ];
        this[ OBJECT.CONST.TEMPLATE.FIELD.UUID ] = data[ OBJECT.CONST.TEMPLATE.FIELD._ID ];
        var _keys                                = Object.keys( data );
        var _sizeData                            = _keys.length;
        this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ] = data[ OBJECT.CONST.TEMPLATE.FIELD.NAME ];
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                  : function ( key, value ) {
        switch ( key ) {
            case OBJECT.CONST.TEMPLATE.FIELD.NAME:
            case OBJECT.CONST.TEMPLATE.FIELD.IS_TEMPLATE:
            case OBJECT.CONST.TEMPLATE.FIELD.ITEM_TYPE:
            case OBJECT.CONST.TEMPLATE.FIELD.LAST_MODIFICATION:
            case OBJECT.CONST.TEMPLATE.FIELD.REGISTER:
            case OBJECT.CONST.TEMPLATE.FIELD.SOURCES:
                this[ key ] = value;
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.ENABLED:
                this.setEnabled( value );
                
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.UNCONFIGURED:
                this[ key ] = value;
                if ( value ) {
                    this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN );
                }
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.IS_NEW:
                this[ key ] = value;
                if ( value ) {
                    this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.NEW );
                }
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.LOOP:
                this[ key ] = value;
                this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.BADLOOP );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.USE:
                this.setUse( value );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.WORK_AREA_INFO:
            case OBJECT.CONST.TEMPLATE.FIELD.METADATA:
            case OBJECT.CONST.TEMPLATE.FIELD._SYNC_KEYS:
            case OBJECT.CONST.TEMPLATE.FIELD.IS_TOP_LEVEL:
                break;
            case OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES:
                this.override = new OBJECT.ServiceOverrides( value );
                break;
            default:
                if ( SHINKEN.TOOLS.STRING.startsWith( key, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                    var _data = new PROPERTY.Data( key, value );
                    if ( _data.is_valid ) {
                        this.datas[ key ] = new OBJECT.TemplateProperty( key, this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ], _data, this[ OBJECT.CONST.TEMPLATE.FIELD._ID ] );
                    }
                }
                else {  // Properties
                    this.properties[ key ] = new OBJECT.TemplateProperty( key, this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ], value, this[ OBJECT.CONST.TEMPLATE.FIELD._ID ] );
                }
        }
        
    },
    isEnabled                : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ];
    },
    setEnabled               : function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        to_set                                      = !!to_set;
        this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ] = to_set;
        if ( !to_set ) {
            this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.DISABLED );
        }
    },
    getName                  : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ];
    },
    getUuid                  : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.UUID ];
    },
    setUse                   : function ( to_set ) {
        this[ OBJECT.CONST.TEMPLATE.FIELD.USE ] = to_set.split( ',' );
    },
    isUsing                  : function ( template_name ) {
        return SHINKEN.TOOLS.ARRAY.contains( this[ OBJECT.CONST.TEMPLATE.FIELD.USE ], template_name );
    },
    isNew                    : function () {
        return !!this.is_new;
    },
    getType                  : function () {
        return this.item_type;
    },
    isCheckExcludeByTemplate : function ( to_test ) {
        var _excludes = this.getProperty( OBJECT.CONST.ELEMENT.FIELD.SERVICE_EXCLUDES_BY_ID );
        if ( !_excludes ) {
            return false;
        }
        for ( var i = 0, _size_i = _excludes.value.links.length; i < _size_i; i++ ) {
            if ( to_test.uuid === _excludes.value.links[ i ]._id ) {
                return true;
            }
        }
        return false;
    },
    addCheck                 : function ( to_add ) {
        if ( this.isCheckExcludeByTemplate( to_add ) ) {
            return;
        }
        this.checks.push( to_add );
        if ( to_add.is_dfe ) {
            this.size_dfe_check++;
        }
    },
    getValidCheck            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.checks.length; i < _size_i; i++ ) {
            if ( !this.checks[ i ].is_obsolete ) {
                _to_return.push( this.checks[ i ] );
            }
        }
        return _to_return;
    },
    hasOverrideModulation    : function ( check_in_page_host, property_name ) {
        if ( !this.override ) {
            return false;
        }
        for ( var i = 0; i < this.override.size; i++ ) {
            if ( !this.override.overrides[ i ].is( check_in_page_host ) ) {
                continue;
            }
            if ( this.override.overrides[ i ].property !== property_name ) {
                continue;
            }
            switch ( this.override.overrides[ i ].value ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
                default:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
            }
            break;
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
    },
    getOverrideValue         : function ( prop_name, check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return null;
        }
        return this.override.getOverrideValue( prop_name, check_in_page_host );
    },
    setStatus                : function ( to_set, parent_template ) {
        this.status = to_set;
        switch ( this.status ) {
            case  OBJECT.CONST.TEMPLATE.STATUS.USEFUL:
                this.status_tooltip = "";
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
                this.status_tooltip = _( 'element.tooltip_undefined' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.DISABLED:
                this.status_tooltip = _( 'element.tooltip_disabled' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.NEW:
                this.status_tooltip = _( 'element.tooltip_new' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.BADLOOP:
                if ( this[ OBJECT.CONST.TEMPLATE.FIELD.LOOP ] ) {
                    this.status_tooltip = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_loop' ), this[ OBJECT.CONST.TEMPLATE.FIELD.LOOP ].join( '  >>>  ' ) );
                }
                if ( !this.enabled ) {
                    this.status_tooltip += "<br>" + _( 'element.tooltip_disabled' );
                }
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.USELESS:
                this.status_tooltip = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_already_included' ), '<i><b>' + parent_template + '</b></i>' );
                break;
        }
    },
    isStatus                 : function ( to_test ) {
        return this.status === to_test;
    },
    completeTemplateWithUse  : function ( template_use ) {
        this.completePropertiesWithUse( template_use );
        this.completeDatasWithUse( template_use );
        this.completeOverrideWithUse( template_use );
    },
    completeDatasWithUse     : function ( template_use ) {
        var _current_key;
        var _current_data;
        
        var _datas = template_use.datas;
        var _keys  = Object.keys( _datas );
        var _size  = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key  = _keys[ i ];
            _current_data = _datas[ _current_key ];
            
            if ( this.datas[ _current_key ] ) {
                continue;
            }
            else {
                this.datas[ _current_key ] = _current_data;
            }
        }
        
        
    },
    completePropertiesWithUse: function ( template_use ) {
        var _current_key;
        var _current_property;
        
        var _properties = template_use.properties;
        var _keys       = Object.keys( _properties );
        var _size       = _keys.length;
        
        
        for ( var i = 0; i < _size; i++ ) {
            _current_key      = _keys[ i ];
            _current_property = _properties[ _current_key ];
            
            if ( !this.properties[ _current_key ] ) {
                this.properties[ _current_key ] = _current_property;
                this.properties[ _current_key ].setTemplateName( this.name, this._id );
                this.properties[ _current_key ].is_heritage_stopped = false;
            }
            else {
                this.properties[ _current_key ].updateValueWithUse( _current_property );
            }
        }
    },
    completeOverrideWithUse  : function ( template_use ) {
        var _add;
        var _current_override;
        if ( !template_use.override ) {
            return;
        }
        if ( !this.override ) {
            this.override = template_use.override;
            return;
        }
        for ( var i = 0, _size_i = template_use.override.overrides.length; i < _size_i; i++ ) {
            _add              = true;
            _current_override = template_use.override.overrides[ i ];
            for ( var j = 0, _size_j = this.override.overrides.length; j < _size_j; j++ ) {
                if ( this.override.overrides[ j ].isOnSame( _current_override ) ) {
                    _add = false;
                }
            }
            if ( _add ) {
                this.override.overrides.push( _current_override );
                this.override.size = this.override.overrides.length;
            }
        }
    },
    getLink                  : function () {
        var _class = MANAGER.__instance_element_distributor.current_user.is_admin ? "shinken-link shinken-space" : "shinken-space";
        return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( this.item_type, this.uuid, this.getName(), _class ).outerHTML;
    },
    getProperty              : function ( key ) {
        return this.properties[ key ];
    }
};
//******************************  END  template.js   **************************

//******************************  START  template-property.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/object/template-property.js *
'use strict';

OBJECT.TemplateProperty           = function ( name, template_name, value, _template_id ) {
    // name
    // value
    // label
    // data
    // value_inherited
    // flat_value
    // flat_value_inherited
    // state (has plus)
    // is_heritage_stopped
    // tags
    // size_tags
    // is_stopped
    // is_last
    this.name = name;
    this.setTemplateName( template_name, _template_id );
    this.init( value );
};
OBJECT.TemplateProperty.prototype = {
    init              : function ( value ) {
        this.state               = COMPONENT.CONST.BTN_STATE.OFF;
        this.is_stopped          = false;
        this.is_heritage_stopped = false;
        this.is_last             = false;
        this.setValue( value );
    },
    updateValueWithUse: function ( property ) {
        if ( !this.hasPlus() ) {
            return;
        }
        if ( property.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
             property.value === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
            this.is_heritage_stopped = true;
        }
        if ( this.is_heritage_stopped ) {
            return;
        }
        
        var _values = property.values;
        this.values = SHINKEN.TOOLS.ARRAY.concatUnique( this.values, _values );
        this._computeTags();
        if ( !property.hasPlus() ) {
            this.is_heritage_stopped = true;
        }
    },
    hasPlus           : function () {
        return (this.state === COMPONENT.CONST.BTN_STATE.ON);
    },
    getTags           : function () {
        return this.tags;
    },
    isEmpty           : function () {
        var _property = MANAGER.__instance_property_distributor.findElement( this.name );
        switch ( _property.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return !this.size_tags;
            default:
                return !this.value;
        }
        return true;
    },
    setValue          : function ( to_set ) {
        if ( to_set && to_set.type === PROPERTY.CONST.TYPES.DATA ) {
            this.setValueData( to_set );
            return;
        }
        this.value = to_set;
        
        to_set        = to_set + "";
        var _has_plus = SHINKEN.TOOLS.STRING.extractStringIfBeginningBy( to_set, PROPERTY.CONST.STATE_VALUE_PLUS.ON );
        if ( _has_plus !== false ) { //CAN BE EMPTY ("")
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
            to_set = _has_plus;
        }
        switch ( to_set ) {
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                break;
        }
        this.label  = this.value;
        this.values = to_set ? to_set.split( ',' ) : [];
        this._computeTags();
    },
    setValueData      : function ( to_set ) {
        this.data   = to_set;
        this.value  = to_set.value + "";
        this.label  = this.value;
        this.values = this.value ? this.value.split( ',' ) : [];
        this._computeTags();
    },
    setState          : function ( to_set ) {
        this.state = to_set;
    },
    setTags           : function ( to_set ) {
        this.tags = to_set;
    },
    setIsStopped      : function ( to_set ) {
        this.is_stopped = to_set;
    },
    setTemplateName   : function ( to_set, _template_id ) {
        this.template_name = to_set;
        if ( _template_id ) {
            this.template_id = _template_id;
        }
    },
    setIsLast         : function ( to_set ) {
        this.is_last = to_set;
    },
    _computeTags      : function () {
        var _property = MANAGER.__instance_property_distributor.findElement( this.name );
        if ( !_property ) {
            return;
        }
        if ( _property.type !== PROPERTY.CONST.TYPES.MULTI_SELECT ) {
            return;
        }
        this.size_tags = 0;
        var _size      = this.values.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = this._addTag( this.values[ i ], _property );
        }
        this.setTags( _to_return );
    },
    _createElementList: function ( name, state, type ) {
        var _element = new OBJECT.ElementList();
        _element.setName( name );
        _element.setState( state );
        _element.setType( type );
        return _element;
    },
    _addTag           : function ( key_name, _property ) {
        var _element = this._createElementList( key_name, 'inherited', OBJECT.CONST.ELEMENT_LIST.TYPE.INHERITANCE );
        var _tag     = new COMPONENT.Tag();
        _tag.setElement( _element );
        var _full_link = '';
        if ( _property && MANAGER.__instance_element_distributor.current_user.is_admin ) {
            var _element = _property.component_select.list_element.getElement( key_name );
            if ( _element ) {
                var _link_1 = _element.getItemType();
                var _link_2 = _element.uuid;
                if ( _element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
                    _link_2 = _link_2 + '?new=1';
                }
                _full_link = [ _link_1, _link_2 ];
            }
        }
        _tag.buildHTML( "", "", _full_link );
        this.size_tags++;
        return _tag;
    }
};
//******************************  END  template-property.js   **************************

//******************************  START  btn-inheritance.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/btn-inheritance.js *
'use strict';

COMPONENT.BtnInheritance           = function ( parent_name, dom_element_parent, type_property, is_order_kept ) {
    // parent_name
    // name_template
    // from_template
    // state
    // has_arborescence
    // list_arborescence
    // list_template_property
    // dom_element
    // dom_element_parent
    // dom_container
    // timer_ask_html
    this.init( parent_name, dom_element_parent, type_property );
};
COMPONENT.BtnInheritance.prototype = {
    init: function ( parent_name, dom_element_parent, type_property ) {
        this.parent_name         = parent_name;
        this.state               = COMPONENT.CONST.BTN_STATE.DISABLED;
        this.name_template       = null;
        this.from_template       = null;
        this.dom_element_parent  = dom_element_parent;
        this.dom_container       = null;
        this.dom_container_tbody = null;
        this.has_arborescence    = false;
        this.type_property       = type_property;
    },
    
    buildHTML            : function () {
        this.dom_container = this.dom_element_parent.querySelector( '.from-template' );
        if ( !this.dom_container ) {
            return;
        }
        this.dom_container.innerHTML = '';
        this.dom_element             = DOM.Service.createElement( 'div', {
            class  : 'switch-button-wrapper',
            onclick: 'MANAGER.EventManager.clickOnBtnInheritance("' + this.parent_name + '")'
        } );
        var _btn                     = DOM.Service.createElement( 'div', { class: 'switch-button' } );
        var _on_label                = DOM.Service.createElement( 'span', { class: 'switch-button-label on' }, _( 'element.inheritance_on' ) );
        var _off_label               = DOM.Service.createElement( 'span', { class: 'switch-button-label off' }, _( 'element.inheritance_off' ) );
        
        var _attr_table       = { class: 'table-inheritance' };
        var _attr_col_content = { class: 'col-content' };
        if ( this.has_arborescence ) {
            _attr_table       = { class: 'table-inheritance-with-arborescence' };
            _attr_col_content = { class: 'col-content', colspan: '2', rowspan: '2' };
        }
        
        var table = DOM.Service.createElement( 'table', _attr_table );
        var thead = DOM.Service.createElement( 'thead', {} );
        var tbody = DOM.Service.createElement( 'tbody', { class: 'switch-button-value' } );
        
        var _line_1      = DOM.Service.createElement( 'tr', {} );
        var _col_btn     = DOM.Service.createElement( 'td', { class: 'col-btn', colspan: '2' } );
        var _col_content = DOM.Service.createElement( 'td', _attr_col_content );
        
        DOM.Service.addElementTo( _col_btn, _line_1 );
        DOM.Service.addElementTo( _col_content, _line_1 );
        DOM.Service.addElementTo( _line_1, thead );
        
        if ( this.has_arborescence ) {
            var _line_2       = DOM.Service.createElement( 'tr', { class: 'switch-button-wrapper-line' } );
            var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' } );
            var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' } );
            DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
            DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
            DOM.Service.addElementTo( _line_2, thead );
        }
        
        DOM.Service.addElementTo( _btn, this.dom_element );
        DOM.Service.addElementTo( _on_label, _col_content );
        DOM.Service.addElementTo( _off_label, _col_content );
        DOM.Service.addElementTo( this.dom_element, _col_btn );
        
        DOM.Service.addElementTo( thead, table );
        DOM.Service.addElementTo( tbody, table );
        DOM.Service.addElementTo( table, this.dom_container );
        
        this.dom_container_tbody = tbody;
    },
    buildFromTemplateLine: function () {
        this.dom_container_tbody.innerHTML = '';
        
        var _line        = DOM.Service.createElement( 'tr' );
        var _col_content = DOM.Service.createElement( 'td', { class: 'col-content', colspan: '4' } );
        
        
        var _label_text;
        var _label;
        var _id_tpl   = this.list_template_property.template_id;
        var _name_tpl = this.list_template_property.template_name;
        
        switch ( this.type_property ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _tags = this.list_template_property[ 0 ].getTags();
                for ( var i = 0; i < this.list_template_property[ 0 ].size_tags; i++ ) {
                    DOM.Service.addElementTo( _tags[ i ].getDomElement(), _col_content );
                }
                var _clear = DOM.Service.createElement( 'div', { class: 'clear' } );
                DOM.Service.addElementTo( _clear, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                var _selected_prop = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                var _split         = this.list_template_property[ 0 ].value.split( "!" );
                var _selected      = _selected_prop.component_select.list_element.getElement( _split[ 0 ] );
                _label_text        = this.list_template_property[ 0 ].label;
                if ( _selected ) {
                    var _shinken_element = MANAGER.__instance_element_distributor.getElementListElementByName( _selected.item_type, _selected.name );
                    if ( _shinken_element ) {
                        _label_text = SHINKEN.TOOLS.buildLinkShinkenElement( _shinken_element ).outerHTML;
                        for ( var i = 1, _size_i = _split.length; i < _size_i; i++ ) {
                            _label_text += "!" + _split[ i ];
                        }
                    }
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                var _selected_prop = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                var _selected      = _selected_prop.component_select.list_element.getElement( this.list_template_property[ 0 ].value );
                _label_text        = _selected ? _selected.label : this.list_template_property[ 0 ].value;
                if ( _selected ) {
                    var _shinken_element = MANAGER.__instance_element_distributor.getElementListElementByName( _selected.item_type, _selected.name );
                    if ( _shinken_element ) {
                        _label_text = SHINKEN.TOOLS.buildLinkShinkenElement( _shinken_element ).outerHTML;
                    }
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.BOOLEAN:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                _label_text      = this.list_template_property[ 0 ].label;
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _label_text = this.list_template_property[ 0 ].value;
                if ( _label_text === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label_text = _( 'element.forced_default' );
                    var _prop   = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                    if ( _prop && _prop.default_value ) {
                        _label_text += " " + _prop.default_value;
                    }
                }
                _label           = DOM.Service.createElement( 'div', { class: "shinken-heritance-value" } );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.DATA:
                _label_text = this.list_template_property.label;
                if ( _label_text === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label_text = _( 'element.forced_default' );
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                break;
            
        }
        var _template_link = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( shinken_link_tpl, _id_tpl, _name_tpl ).outerHTML;
        var _info          = DOM.Service.createElement( 'span', { class: "shinken-inheritance-template-name" }, '&nbsp;<span class="shinken-between-bracket">' + _( 'source.tag' ) + '&nbsp;' + _template_link + '</span>' );
        DOM.Service.addElementTo( _info, _col_content );
        
        DOM.Service.addElementTo( _col_content, _line );
        DOM.Service.addElementTo( _line, this.dom_container_tbody );
    },
    askUpdateHTML        : function () {
        var self = this;
        if ( this.timer_ask_html ) {
            clearTimeout( this.timer_ask_html );
        }
        this.timer_ask_html = setTimeout( function () {
            self.timer_ask_html = null;
            
            self.updateHTML();
        }, COMPONENT.CONST.BTN_INHERITANCE.TIMER_DELAY_BUILD_HTML );
    },
    updateHTML           : function () {
        if ( !this.isSet() ) {
            if ( this.dom_container ) {
                this.dom_container.innerHTML = '';
                this.dom_container           = null;
            }
            return;
        }
        this.buildHTML();
        
        if ( this.has_arborescence ) {
            this.list_arborescence.buildFromTemplateArbo( this.list_template_property, this.dom_container_tbody );
        }
        else {
            this.buildFromTemplateLine();
        }
    },
    
    setHasArborescence: function ( _to_set ) {
        this.has_arborescence = _to_set;
        if ( _to_set ) {
            this.list_arborescence = new COMPONENT.InheritanceArborescence( this.parent_name, this.dom_element_parent );
        }
    },
    
    getDomElement: function () {
        return this.dom_element;
    },
    
    isSet        : function () {
        return this.state !== COMPONENT.CONST.BTN_STATE.DISABLED;
    },
    getTags      : function () {
        var _to_return = [];
        if ( this.has_arborescence ) {
            var _current;
            var _size = this.list_template_property.length;
            for ( var i = 0; i < _size; i++ ) {
                _current = this.list_template_property[ i ];
                if ( !_current.is_stopped ) {
                    _to_return = _to_return.concat( _current.getTags() );
                }
            }
        }
        else {
            var _template = this.list_template_property[ 0 ];
            _to_return    = _template.getTags();
        }
        return _to_return;
    },
    getState     : function () {
        return this.state;
    },
    setState     : function ( state ) {
        if ( !this.isSet() ) {
            return;
        }
        this.state = state;
        fire_element_is_modifie();
    },
    getValueFinal: function () {
        if ( !this.isSet() ) {
            return "";
        }
        if ( !this.list_template_property || !this.list_template_property[ 0 ] ) {
            return "";
        }
        return this.list_template_property[ 0 ].value;
    },
    
    toggleState: function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
        }
        return this.state;
    },
    
    setTemplateProperty: function ( to_set ) {
        this.list_template_property = to_set;
        
        if ( !this.list_template_property ) {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
            return false;
        }
        
        if ( !this.isSet() ) {
            this.state = COMPONENT.CONST.BTN_STATE.INIT;
        }
        return true;
    }
};
//******************************  END  btn-inheritance.js   **************************

//******************************  START  button.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/button.js *
'use strict';

COMPONENT.Button           = function ( dom_element, name ) {
    // dom_element
    // value
    // state
    // label
    // name
    this.state = COMPONENT.CONST.BTN_STATE.OFF;
    this.name  = name;
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init             : function ( dom_element ) {
        this.dom_element = dom_element;
        this.value       = this.dom_element.value;
        this._computeState();
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
        }
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    _computeState    : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerText = to_set;
    },
    appendToHtml     : function ( _dom_value_to_append ) {
        //TODO GREG A RENDRE OBSOLETE
        this.dom_element.appendChild( _dom_value_to_append );
    },
    //********************************************  COUNTERS   *********************************************************//
    initCounters     : function ( dom_element ) {
        this.errors   = new SHINKEN.OBJECT.Counter();
        this.warnings = new SHINKEN.OBJECT.Counter();
        this.override = new SHINKEN.OBJECT.Counter();
        this.errors.init( this.dom_element.querySelector( '.shinken-error-counter' ) );
        this.warnings.init( this.dom_element.querySelector( '.shinken-warning-counter' ) );
        this.override.init( this.dom_element.querySelector( '.shinken-override-counter' ) );
    },
    setError         : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning       : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setOverride      : function ( data_name, nb ) {
        if ( !this.override.update( data_name, nb ) ) {
            this.dom_element.dataset.overrideCounter = this.override.counter_final;
        }
    }
};
//******************************  END  button.js   **************************

//******************************  START  checkbox.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/checkbox.js *
'use strict';

COMPONENT.Checkbox           = function ( dom_element ) {
    // dom_element
    // is_checked
    // checkbox_user
    // checkbox_inherited
    this.init( dom_element );
};
COMPONENT.Checkbox.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element        = dom_element;
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ) );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ) );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ) );
    },
    setCheckedUser       : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
    },
    setCheckedInheritance: function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    isCheckedUser        : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault     : function () {
        return this.checkbox_default.isChecked();
    }
};
//******************************  END  checkbox.js   **************************

//******************************  START  checkbox.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/checkbox.js *
'use strict';

COMPONENT.Checkbox           = function ( dom_element ) {
    // dom_element
    // is_checked
    // checkbox_user
    // checkbox_inherited
    this.init( dom_element );
};
COMPONENT.Checkbox.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element        = dom_element;
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ) );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ) );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ) );
    },
    setCheckedUser       : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
    },
    setCheckedInheritance: function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    isCheckedUser        : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault     : function () {
        return this.checkbox_default.isChecked();
    }
};
//******************************  END  checkbox.js   **************************

//******************************  START  input.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/input.js *
'use strict';

COMPONENT.Input           = function ( dom_element, parent, extra_key_validation ) {
    // dom_element
    // current_value
    // original_value
    // placeholder
    // is_protected
    // is_resizable
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init                : function ( dom_element, parent, extra_key_validation ) {
        this._initErrorWarning( parent );
        this.dom_element             = dom_element;
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element.getAttribute( 'value' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element.placeholder;
        this.placeholder             = this.dom_element.placeholder;
        this.type                    = this.dom_element.getAttribute( 'type' );
        this.is_resizable            = this.dom_element.tagName === 'TEXTAREA';
        this.need_validation         = true;
        var _self                    = this;
        this.key_validation          = {
            "prop_name"     : parent.getParentName(),
            "component_name": extra_key_validation ? extra_key_validation : ''
        };
        setTimeout( function () {
            _self.validateValueInput();
        }, 50 );
    },
    _initErrorWarning   : function ( parent ) {
        this.error_counter   = new SHINKEN.OBJECT.Counter();
        this.warning_counter = new SHINKEN.OBJECT.Counter();
        this.error_counter.init();
        this.warning_counter.init();
        this.error_counter.setParent( parent.error_counter );
        this.warning_counter.setParent( parent.warning_counter );
    },
    //********************************************  SETTER GETTER   **************************************************//
    setValue            : function () {
        this.need_validation = true;
        if ( this.current_value && this.current_value === this.dom_element.value ) {
            this.need_validation = false;
            return;
        }
        this.current_value = this.dom_element.value;
        this.updateView( '', true );
    },
    setTooltip          : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip     : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    setStatus           : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setIsProtected      : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated()) ? "password" : this.type );
    },
    setPlaceholder      : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder             = to_set;
        this.dom_element.placeholder = this.placeholder;
    },
    getValue            : function () {
        return SHINKEN.TOOLS.STRING.trimExtented( this.current_value );
    },
    hasBeenChanged      : function () {
        return this.current_value !== this.original_value;
    },
    //********************************************  TOOLTIP  **************************************************//
    addShinkenTooltip   : function ( type, message ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( message ) {
                message += "<br>";
            }
            
            message += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        this.dom_element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
        
    },
    updateShinkenTooltip: function ( message ) {
        var _status  = message.getStatus();
        var _counter = [ 0, 0 ];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message.buildMessage() );
                
                break;
        }
        this.error_counter.update( this.uuid, _counter[ 0 ] );
        this.warning_counter.update( this.uuid, _counter[ 1 ] );
    },
    validateValueInput  : function () {
        if ( this.need_validation ) {
            var _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
            this.updateShinkenTooltip( _validator );
        }
    },
    
    //********************************************  UPDATE VIEW  **************************************************//
    updateView           : function ( is_inherited, update ) {
        //SEF-4379 Sous IE et chrome 56 le curseur se mettait à la fin après saisie, car n'aime pas dom_element.value = laValeur
        // Les textarea ne fonctionne pas avec un setAttribut
        // La mise à jour du champ par changement d'attribut ne doit se faire que lors d'une modification du champ
        if ( update && (SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) || !this.is_resizable) ) {
            this.dom_element.setAttribute( 'value', is_inherited ? '' : this.current_value );
        }
        else {
            this.dom_element.value = is_inherited ? '' : this.current_value;
        }
        if ( !this.dom_element.value ) {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        var self = this;
        setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element ) && DOM.Service.getBoundingClientRect( self.dom_element, 'height' ) < 150 ) {
                self.dom_element.style.height = Math.min( 150, self.dom_element.scrollHeight ) + 'px';
            }
        }, 100 );
        
    },
    askComputeAfterChange: function ( parent_prop ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.setValue();
            self.validateValueInput();
            parent_prop.computeValue();
            MANAGER.ListenerEventManager.afterActionProperty( parent_prop );
        }, 200 );
    }
};
//******************************  END  input.js   **************************

//******************************  START  input-range.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/input-range.js *
'use strict';

COMPONENT.InputRange           = function ( dom_element, property_name ) {
    // dom_input_range
    // component_label_input
    // value
    // value_from_user
    // min
    // max
    // unit
    // dom_label_value
    // type_range
    this.init( dom_element, property_name );
};
COMPONENT.InputRange.prototype = {
    init            : function ( dom_element, property_name ) {
        this.type_range            = dom_element.dataset.type;
        this.dom_input_range       = dom_element.querySelector( ".shinken-range-container input" );
        this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
        this.value                 = this.dom_input_range.value;
        this.value_from_user       = this.value;
        this.min                   = this.dom_input_range.getAttribute( 'min' );
        this.max                   = this.dom_input_range.getAttribute( 'max' );
        this.unit                  = dom_element.dataset.unit;
        
    },
    setValue        : function ( to_set ) {
        this.value                 = to_set;
        this.dom_input_range.value = to_set;
        this.updateLabel();
    },
    setValueFromUser: function ( to_set ) {
        if ( to_set === null || to_set === undefined ) {
            to_set = this.dom_input_range.value;
        }
        to_set               = to_set + '';
        this.value_from_user = to_set;
        this.setValue( to_set );
    },
    updateLabel     : function () {
        var _to_set;
        switch ( this.type_range ) {
            case PROPERTY.CONST.TYPES.RANGE:
                _to_set = this.value + this.unit;
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                _to_set = _( "element.business_impact_" + this.value );
                break;
        }
        this.component_label_input.updateLabel( _to_set );
    },
    getValue        : function () {
        return this.value;
    },
    getValueFromUser: function () {
        return this.value_from_user;
    }
};
//******************************  END  input-range.js   **************************

//******************************  START  label.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/label.js *
'use strict';

COMPONENT.Label           = function ( dom_element ) {
    // dom_element
    // label
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    },
    updateLabel: function ( to_set ) {
        this.label                 = to_set;
        this.dom_element.innerText = this.label;
    }
};
//******************************  END  label.js   **************************

//******************************  START  _interface-line-property.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/line-object/_interface-line-property.js *
'use strict';


COMPONENT.InterfaceLine = function () {
};

COMPONENT.InterfaceLine.prototype = {
    init                 : function ( parent, element ) {
        this.inputs    = {};
        this.selectors = {};
        this.uuid      = SHINKEN.TOOLS.STRING.buildUUID();
        DOM.Service.setDataSet( element, 'uuid', this.uuid );
        this.parent_name = parent.getParentName();
        this._initErrorWarning( parent );
        this.initSpecific();
        this.initDomElement( element );
        this.initSpecificEnd();
    },
    initDomElement       : function ( element ) {
        this.dom_element          = element;
        this.dom_element_cfg_file = element.querySelector( '.shinken-cfg-line-value' );
        
        var _keys = Object.keys( this.inputs );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.addInput( _current_key );
        }
        _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key                   = _keys[ i ];
            this.selectors[ _current_key ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + _current_key + '"]' ), this.selectors[ _current_key ] );
            this.selectors[ _current_key ].computeTitle();
        }
    },
    _initErrorWarning    : function ( parent ) {
        this.error_counter   = new SHINKEN.OBJECT.Counter();
        this.warning_counter = new SHINKEN.OBJECT.Counter();
        this.error_counter.init();
        this.warning_counter.init();
        this.error_counter.setParent( parent.error_counter );
        this.warning_counter.setParent( parent.warning_counter );
    },
    initSpecificEnd      : function ( parent ) {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector      : function ( _target ) {
        var _keys = Object.keys( this.selectors );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.selectors[ _keys[ i ] ];
            if ( _keys[ i ] === _target ) {
                _current.clickOnSelector();
            }
            else {
                _current.hidePopup();
            }
        }
    },
    clickOnItemSelector  : function ( key_name, _target ) {
        var _keys = Object.keys( this.selectors );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.selectors[ _keys[ i ] ];
            if ( _keys[ i ] === _target ) {
                _current.clickOnItemSelector( "", key_name );
                _current.computeTitle();
                return;
            }
        }
    },
    askComputeAfterChange: function ( dom_element, parent_prop_object ) {
        var _keys = Object.keys( this.inputs );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.inputs[ _keys[ i ] ];
            if ( _current.dom_element === dom_element ) {
                _current.askComputeAfterChange( parent_prop_object );
                return;
            }
        }
    },
    delete               : function () {
        this.error_counter.reset();
        this.warning_counter.reset();
        DOM.Service.removeElement( this.dom_element );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getParentName        : function () {
        return this.parent_name;
    },
    getValue             : function () {
    },
    getCfgValue          : function () {
    },
    setValueFromUser     : function ( value ) {
        console.warn( "GREG", "[note implemented for ]", this.constructor );
    },
    addInput             : function ( _current_key ) {
        this.inputs[ _current_key ] = new COMPONENT.Input( this.dom_element.querySelector( "." + _current_key + " .shinken-input" ), this );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    updateCfgDomElement  : function () {
        if ( !this.dom_element_cfg_file ) {
            return;
        }
        this.dom_element_cfg_file.innerHTML = this.getCfgValue().trim() || "&nbsp;";
    },
    hidePopup            : function () {
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.selectors[ _keys[ i ] ].hidePopup();
        }
    }
};


COMPONENT.getInterfaceLinePrototype = function ( object, name_constructor ) {
    var _current;
    var _keys = Object.keys( COMPONENT.InterfaceLine.prototype );
    for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
        _current = _keys[ i ];
        if ( !object.prototype[ _current ] ) {
            object.prototype[ _current ] = COMPONENT.InterfaceLine.prototype[ _current ];
        }
    }
    
    object.prototype.constructor = name_constructor;
};

//******************************  END  _interface-line-property.js   **************************

//******************************  START  output-rule.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/line-object/output-rule.js *
'use strict';

COMPONENT.OutputRule           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.OutputRule.prototype = {
    initSpecific: function ( dom_element ) {
        this.inputs[ 'shinken-input-container-cell' ] = 0;
        this.selectors[ 'shinken-matching' ]          = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'shinken-final' ]             = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue    : function () {
        var _to_return = this.selectors[ 'shinken-matching' ].getValue();
        if ( this.inputs[ 'shinken-input-container-cell' ].getValue() ) {
            _to_return += "/";
            _to_return += this.inputs[ 'shinken-input-container-cell' ].getValue();
            _to_return += "/";
        }
        _to_return += this.separator_key_value_saved + this.selectors[ 'shinken-final' ].getValue();
        return _to_return;
    },
    //********************************************  UPDATE VIEW  **************************************************//
    getCfgValue : function () {
        return this.getValue();
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.OutputRule, 'COMPONENT.OutputRule' );
//******************************  END  output-rule.js   **************************

//******************************  START  time_period_day_line.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/line-object/time_period_day_line.js *
'use strict';

COMPONENT.TimePeriodDayLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.TimePeriodDayLine.prototype = {
    initSpecific    : function () {
        this.inputs[ 'shinken-value-line' ] = 0;
        this.selectors[ 'week' ]            = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'month' ]           = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue        : function () {
        var _to_return = this.inputs[ 'shinken-value-line' ].getValue();
        if ( !_to_return ) {
            this.updateCfgDomElement();
            return _to_return;
        }
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'week' ].getValue();
        var _month = this.selectors[ 'month' ].getValue();
        if ( _month !== PROPERTY.CONST.TIMEPERIOD.NO_MONTH ) {
            _to_return += this.separator_key_value_saved;
            _to_return += _month;
        }
        this.updateCfgDomElement();
        return _to_return;
    },
    setValueFromUser: function ( value ) {
        var _elements                                         = value.split( this.separator_key_value_saved );
        var _size                                             = _elements.length;
        this.inputs[ 'shinken-value-line' ].dom_element.value = _elements[ 0 ];
        this.askComputeAfterChange( this.inputs[ 'shinken-value-line' ].dom_element );
        this.selectors[ 'week' ].clickOnItemSelector( "", _elements[ 1 ] );
        this.selectors[ 'week' ].computeTitle();
        if ( _size === 3 ) {
            this.selectors[ 'month' ].clickOnItemSelector( "", _elements[ 2 ] );
            this.selectors[ 'month' ].computeTitle();
        }
    },
    //********************************************  UPDATE VIEW  **************************************************//
    getCfgValue     : function () {
        var _to_return = this.parent_name + this.separator_key_value_html + this.selectors[ 'week' ].getValue();
        var _month     = this.selectors[ 'month' ].getValue();
        if ( _month !== PROPERTY.CONST.TIMEPERIOD.NO_MONTH ) {
            _to_return += this.separator_key_value_html + _month;
        }
        _to_return += this.separator_key_value_html + this.inputs[ 'shinken-value-line' ].getValue();
        return _to_return;
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.TimePeriodDayLine, 'COMPONENT.TimePeriodDayLine' );
//******************************  END  time_period_day_line.js   **************************

//******************************  START  url-line.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/line-object/url-line.js *
'use strict';

COMPONENT.UrlLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.UrlLine.prototype = {
    initSpecific: function ( dom_element ) {
        this.inputs[ 'shinken-name-urlmulti' ] = 0;
        this.inputs[ 'shinken-url-urlmulti' ]  = 1;
        this.selectors[ 'icon-url' ]           = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'popupping' ]          = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue    : function ( is_display_cfg ) {
        var _url = this.inputs[ 'shinken-url-urlmulti' ].getValue();
        if ( !is_display_cfg && !_url ) {
            return '';
        }
        var _to_return = '';
        _to_return += this.inputs[ 'shinken-name-urlmulti' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += _url;
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'icon-url' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'popupping' ].getValue();
        return _to_return;
    },
    addInput    : function ( _current_key ) {
        this.inputs[ _current_key ] = new COMPONENT.Input( this.dom_element.querySelector( "." + _current_key + " .shinken-input" ), this, _current_key );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    getCfgValue : function () {
        return this.getValue( true );
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.UrlLine, 'COMPONENT.UrlLine' );
//******************************  END  url-line.js   **************************

//******************************  START  key_value_line.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/line-object/key_value_line.js *
'use strict';

COMPONENT.KeyValueLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    // dom_element
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.KeyValueLine.prototype = {
    initSpecific    : function () {
        this.inputs[ 'shinken-key-line' ]   = 0;
        this.inputs[ 'shinken-value-line' ] = 1;
    },
    initSpecificEnd : function () {
        this.inputs[ 'shinken-key-line' ].key_validation += "KEY_" + this.inputs[ 'shinken-key-line' ].key_validation;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue        : function () {
        if ( !this.inputs[ 'shinken-value-line' ].getValue() ) {
            this.updateCfgDomElement();
            return "";
        }
        var _to_return = this.inputs[ 'shinken-key-line' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += this.inputs[ 'shinken-value-line' ].getValue();
        this.updateCfgDomElement();
        return _to_return;
    },
    setValueFromUser: function ( value ) {
        var _elements                                       = value.split( this.separator_key_value_saved );
        this.inputs[ 'shinken-key-line' ].dom_element.value = _elements[ 0 ];
        this.askComputeAfterChange( this.inputs[ 'shinken-key-line' ].dom_element );
        this.inputs[ 'shinken-value-line' ].dom_element.value = _elements[ 1 ];
        this.askComputeAfterChange( this.inputs[ 'shinken-value-line' ].dom_element );
    },
    getCfgValue     : function () {
        return this.inputs[ 'shinken-key-line' ].getValue() + this.separator_key_value_html + this.inputs[ 'shinken-value-line' ].getValue();
    }
};

COMPONENT.getInterfaceLinePrototype( COMPONENT.KeyValueLine, 'COMPONENT.KeyValueLine' );
//******************************  END  key_value_line.js   **************************

//******************************  START  list-select.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/list-select.js *
'use strict';

COMPONENT.ListSelect           = function ( dom_element ) {
    // dom_element
    // dom_element_input_research
    // dom_element_counter_research
    // dom_element_research
    // state
    // list
    // list_mapping
    // size_list
    // nbr_in_list_after_filter
    // counter_auto_select;
    // last_auto_select_element;
    // current_filter;
    this.init( dom_element );
};
COMPONENT.ListSelect.prototype = {
    init                     : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element_counter_research = dom_element.querySelector( '.shinken-counter-current' );
        this.dom_element_counter_total    = dom_element.querySelector( '.shinken-counter-total' );
        this.dom_element_input_research   = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_SEARCH_INPUT );
        this.state                        = COMPONENT.CONST.BTN_STATE.OFF;
        this.initListElement();
        this.resetAutoSelect();
    },
    initListElement          : function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.nbr_in_list_after_filter = 0;
        var _list_element             = this.dom_element.querySelectorAll( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION );
        this.size_list                = _list_element.length;
        for ( var i = 0; i < this.size_list; i++ ) {
            this.list[ i ]                                = new COMPONENT.ListSelectElement( _list_element[ i ] );
            this.list_mapping[ this.list[ i ].getName() ] = i;
        }
    },
    toggleStateSelectedInList: function ( key_name ) {
        var _index               = this.list_mapping[ key_name ];
        var _list_select_element = this.list[ _index ];
        _list_select_element.setSelected( !_list_select_element.is_selected );
        return _list_select_element.getElement();
    },
    unselectAllElement       : function () {
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            _current.setSelected( false );
        }
    },
    addNewElementUnknown     : function ( key_name, prop_name ) {
        var _to_add    = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-state"        : "unknown",
                "data-key-name"     : key_name,
                "data-key-label"    : key_name,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onclick             : "MANAGER.EventManager.clickOnItemSelector('" + prop_name + "', '" + key_name + "')"
            },
            "<span class='shinken-space'>" + key_name + " ( " + _( 'element.unknown' ) + " )" + "</span>"
        );
        var _to_return = new COMPONENT.ListSelectElement( _to_add );
        this.addNewElement( key_name, _to_return );
        return _to_return;
    },
    addNewElement            : function ( key_name, list_select_element ) {
        this.list[ this.size_list ]              = list_select_element;
        this.list_mapping[ key_name ]            = this.size_list;
        this.dom_element_counter_total.innerHTML = parseInt( this.dom_element_counter_total.innerHTML ) + 1;
        this.size_list++;
        this.dom_element.querySelector( '.list-select-content' ).appendChild( list_select_element.dom_element );
    },
    getElement               : function ( key_name ) {
        var _index = this.list_mapping[ key_name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.list[ _index ].getElement();
    },
    getListSelectElement     : function ( key_name ) {
        var _index = this.list_mapping[ key_name ];
        return this.list[ _index ];
    },
    getSelectedElements      : function () {
        var _to_return = [];
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                _to_return.push( _current_element );
            }
        }
        return _to_return;
    },
    getFirstSelectedElement  : function () {
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                return _current_element;
            }
        }
        return null;
    },
    setState                 : function ( state ) {
        this.state = state;
        this.resetAutoSelect();
        return this.state;
    },
    focusOnResearchInput     : function () {
        if ( this.dom_element_input_research ) {
            this.dom_element_input_research.focus();
        }
    },
    toggleState              : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    },
    //********************************************  FILTER   *********************************************************//
    doFilter                 : function ( filter ) {
        if ( this.current_filter && filter === this.current_filter ) {
            return;
        }
        this.current_filter           = filter;
        this.nbr_in_list_after_filter = 0;
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            if ( _current.doFilter( filter ) ) {
                this.nbr_in_list_after_filter++;
            }
        }
        if ( !filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        
        if ( this.nbr_in_list_after_filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        
        this.dom_element_counter_research.innerHTML = this.nbr_in_list_after_filter;
        this.resetAutoSelect();
    },
    cleanFilter              : function () {
        this.dom_element_input_research.value = "";
        this.doFilter( '' );
    },
    addNewElementList        : function ( value ) {
        var _to_add = new COMPONENT.ListSelectElement( _list_element[ i ] );
    },
    //********************************************  AUTO SELECT  *****************************************************//
    resetAutoSelect          : function () {
        this.counter_auto_select = -1;
        if ( this.last_auto_select_element ) {
            this.last_auto_select_element.dom_element.classList.remove( 'shinken-select-focused' );
            this.last_auto_select_element = null;
        }
    },
    validAutoSelect          : function () {
        if ( this.last_auto_select_element ) {
            this.last_auto_select_element.dom_element.click();
            this.resetAutoSelect();
        }
    },
    moveAutoSelectCursor     : function ( move_down ) {
        if ( this.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return;
        }
        if ( !this.size_list ) {
            return;
        }
        var _previous_counter = this.counter_auto_select;
        if ( move_down ) {
            this.counter_auto_select++;
        }
        else {
            this.counter_auto_select--;
        }
        var _current_count = -1;
        var _current;
        var _found_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current     = this.list[ i ];
            var _display = window.getComputedStyle( _current.dom_element ).display;
            if ( _display === 'none' ) {
                continue;
            }
            if ( _current.dom_element.classList.contains( 'selected' ) ) {
                continue;
            }
            _current_count++;
            if ( _current_count === this.counter_auto_select ) {
                _found_element = _current;
                break;
            }
        }
        if ( _found_element ) {
            if ( this.last_auto_select_element ) {
                this.last_auto_select_element.dom_element.classList.remove( 'shinken-select-focused' );
            }
            _found_element.dom_element.classList.add( 'shinken-select-focused' );
            _found_element.dom_element.scrollIntoView( { behaviour: 'auto' } );
            this.last_auto_select_element = _found_element;
        }
        else {
            this.counter_auto_select = _previous_counter;
        }
    }
};
//******************************  END  list-select.js   **************************

//******************************  START  list-select-element.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/list-select-element.js *
'use strict';

COMPONENT.ListSelectElement           = function ( dom_element ) {
    // dom_element
    // element
    // is_selected
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        if ( dom_element ) {
            this.dom_element = dom_element;
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            //TODO GREG A REGARDER Car l'appel est faire pour le multiselect alors qu'il ne semble pas nécessaire
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'selected' );
        }
    },
    initElement        : function () {
        this.element = new OBJECT.ElementList();
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
        if ( this.element.uuid ) {
            this.initShinkenElement();
        }
    },
    initShinkenElement : function () {
        var _shinken_element = new OBJECT.ShinkenElement();
        _shinken_element.setUUID( this.element.uuid );
        _shinken_element.setEnabled( this.element.is_disabled );
        _shinken_element.setType( this.element.item_type );
        _shinken_element.name_element = this.element.name;
        if ( this.element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _shinken_element.is_new = true;
        }
        if ( _shinken_element.isCheck() ) {
            MANAGER.__instance_element_distributor.addElement( _shinken_element );
        }
        else {
            if ( !MANAGER.__instance_element_distributor[ this.element.item_type ] ) {
                MANAGER.__instance_element_distributor[ this.element.item_type ] = [];
            }
            MANAGER.__instance_element_distributor[ this.element.item_type ].push( _shinken_element );
        }
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set ) {
        if ( _to_set ) {
            this.dom_element.classList.add( 'selected' );
        }
        else {
            this.dom_element.classList.remove( 'selected' );
        }
        this.is_selected = _to_set;
    },
    isOptionSelectable : function () {
        return !!this.getOptionCounter();
    },
    getOptionCounter   : function () {
        var _body_dom_element = DOM.BodyService.getDomElement();
        var _type             = _body_dom_element.dataset.stateWorkFlow;
        return this.element.getCounter( _type );
    },
    //***********************************************   COUNTER   ******************************************************//
    initAllCounter     : function () {
        this.element.initCounter();
        this.dom_element.querySelector( '.' + MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA ).innerHTML = '';
        this.dom_element.querySelector( '.' + MANAGER.CONST.STATE.WORK_FLOW.STAGING ).innerHTML      = '';
        this.dom_element.classList.remove( COMPONENT.CONST.SELECT.OPTION_ACTIVE_STAGING );
        this.dom_element.classList.remove( COMPONENT.CONST.SELECT.OPTION_ACTIVE_WORKING_AREA );
    },
    addCounter         : function ( type ) {
        this.element.addCounter( type );
        var _counter                                           = this.element.getCounter( type );
        this.dom_element.querySelector( '.' + type ).innerHTML = '[ ' + _counter + ' ]';
        switch ( type ) {
            case MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA:
                this.dom_element.classList.add( COMPONENT.CONST.SELECT.OPTION_ACTIVE_WORKING_AREA );
                break;
            case MANAGER.CONST.STATE.WORK_FLOW.STAGING:
                this.dom_element.classList.add( COMPONENT.CONST.SELECT.OPTION_ACTIVE_STAGING );
                break;
        }
        
    },
    //********************************************  FILTER   *********************************************************//
    doFilter           : function ( filter ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && this.element.is_hidden_for_admin_si ) {
            return false;
        }
        if ( !filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
            if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
                return false;
            }
            return true;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
            return true;
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
            return false;
        }
    },
    //********************************************  VIEW   *********************************************************//
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};

//******************************  END  list-select-element.js   **************************

//******************************  START  list-tag.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/list-tag.js *
'use strict';

COMPONENT.ListTag           = function ( dom_element, parent_name ) {
    // dom_element
    // tags
    // tags_mapping
    // size_tags
    // dragged_tag
    this.init( dom_element, parent_name );
    
};
COMPONENT.ListTag.prototype = {
    init                          : function ( dom_element, parent_name ) {
        this.dom_element = dom_element;
        this.initTags( parent_name );
    },
    initTags                      : function ( parent_name ) {
        this.tags         = [];
        this.tags_mapping = {};
        
        var _list_tags_element = this.dom_element.querySelectorAll( '.container-tag' );
        if ( !_list_tags_element ) {
            this.size_tags = 0;
            return;
        }
        
        this.size_tags = _list_tags_element.length;
        for ( var i = 0; i < this.size_tags; i++ ) {
            this.tags[ i ]                                = new COMPONENT.Tag( _list_tags_element[ i ], parent_name );
            this.tags_mapping[ this.tags[ i ].getName() ] = i;
        }
    },
    reset                         : function () {
        this.tags         = [];
        this.tags_mapping = {};
        this.size_tags    = 0;
    },
    addTag                        : function ( parent_name, element_list ) {
        fire_element_is_modifie();
        var _tag = new COMPONENT.Tag();
        _tag.setElement( element_list );
        var _dom_to_add = _tag.buildHTMLParent( parent_name, this.size_tags, element_list.getItemType() );
        _tag.setTooltip();
        this.tags[ this.size_tags ]         = _tag;
        this.tags_mapping[ _tag.getName() ] = this.size_tags;
        DOM.Service.addElementTo( _dom_to_add, this.dom_element );
        this._computeMapping();
    },
    deleteTag                     : function ( element_list ) {
        fire_element_is_modifie();
        var _name  = element_list.getName();
        var _tag   = this.getTagByName( _name );
        var _index = this.tags_mapping[ _name ];
        DOM.Service.removeParentIfHasClassOrElement( _tag.getDomElement(), 'droppable' );
        this.tags.splice( _index, 1 );
        this._computeMapping();
    },
    _computeMapping               : function () {
        this.size_tags    = this.tags.length;
        this.tags_mapping = {};
        for ( var i = 0; i < this.size_tags; i++ ) {
            this.tags_mapping[ this.tags[ i ].getName() ] = i;
            this.tags[ i ].setIndexParentDomElement( i );
        }
        if ( this.isEmpty() ) {
            this.dom_element.classList.add( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-hidden' );
        }
    },
    addTags                       : function ( tags ) {
        this.tags      = [];
        this.size_tags = tags.length;
        var _current;
        for ( var i = 0; i < this.size_tags; i++ ) {
            _current = tags[ i ].clone();
            var _add = true;
            for ( var j = 0, _size = this.tags.length; j < _size; j++ ) {
                if ( this.tags[ j ].getName() === _current.getName() ) {
                    _add = false;
                    break;
                }
            }
            if ( _add ) {
                this.tags.push( _current );
                this.dom_element.appendChild( _current.getDomElement() );
            }
        }
        this._computeMapping();
    },
    getTagByName                  : function ( key_name ) {
        var _index = this.tags_mapping[ key_name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getTagByIndex( _index );
    },
    getTagByIndex                 : function ( index ) {
        return this.tags[ index ];
    },
    isEmpty                       : function () {
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( !this.tags[ i ].isHidden() ) {
                return false;
            }
        }
        return true;
    },
    emptyList                     : function () {
        this.reset();
        this.dom_element.innerHTML = '';
    },
    getValue                      : function () {
        var _to_return = '';
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( i ) {
                _to_return += ',';
            }
            _to_return += this.getTagByIndex( i ).getName();
        }
        return _to_return;
    },
    getTags                       : function () {
        return this.tags;
    },
    hasTag                        : function ( key_name ) {
        return this.tags_mapping[ key_name ] !== undefined;
    },
    getSizeTags                   : function () {
        return this.size_tags;
    },
    hasUserTag                    : function () {
        for ( var i = 0; i < this.size_tags; i++ ) {
            switch ( this.tags[ i ].element.name ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    break;
                default:
                    return true;
            }
        }
        return false;
    },
    getMissingItemSelectorWith    : function ( property ) {
        var _to_return = [];
        var _selected  = Object.keys( property.component_select.list_element_selected.tags_mapping );
        var _size      = _selected.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _selected[ i ];
            if ( _current === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
                 _current === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ||
                 _current === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                continue;
            }
            if ( this.tags_mapping[ _current ] === undefined ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    getExtraItemSelectorWith      : function ( property ) {
        var _to_return             = [];
        var _property_tags_mapping = property.component_select.list_element_selected.tags_mapping;
        var _selected              = Object.keys( this.tags_mapping );
        var _size                  = _selected.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _selected[ i ];
            if ( _property_tags_mapping[ _current ] === undefined ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    dragStartShinken              : function ( key_name ) {
        this.dragged_tag = this.getTagByName( key_name );
        this.dragged_tag.setDragging( true );
        return this;
    },
    getDragged                    : function () {
        return this.dragged_tag;
    },
    //allowDrop: function( e ) {
    //    e.preventDefault();
    //},
    resetDragging                 : function () {
        if ( this.dragged_tag ) {
            this.dragged_tag.setDragging( false );
            this.dragged_tag = null;
        }
    },
    changeElementPosition         : function ( index_1, index_2 ) {
        if ( index_1 < index_2 ) {
            for ( var i = parseInt( index_1 ), _size = parseInt( index_2 ); i < _size; i++ ) {
                this.switchElement( i, i + 1 );
            }
        }
        else if ( index_1 > index_2 ) {
            for ( var i = parseInt( index_1 ) - 1, _size = parseInt( index_2 ); i >= _size; i-- ) {
                this.switchElement( i, i + 1 );
            }
        }
    },
    switchElement                 : function ( index_1, index_2 ) {
        var _element_1 = this.getTagByIndex( index_1 );
        var _element_2 = this.getTagByIndex( index_2 );
        if ( !_element_1 || !_element_2 ) {
            return;
        }
        DOM.Service.switchElement( _element_1.getDomElement(), _element_2.getDomElement() );
        SHINKEN.TOOLS.ARRAY.swap( this.tags, index_1, index_2 );
        this.tags_mapping[ _element_1.getName() ] = index_2;
        this.tags_mapping[ _element_2.getName() ] = index_1;
    },
    disabledTagsOutOfLimit        : function ( limit ) {
        var _stop = this.size_tags;
        if ( limit >= 0 ) {
            _stop = this.size_tags - limit;
            _stop = (_stop >= 0) ? _stop : this.size_tags;
        }
        var i;
        var _current;
        for ( i = 0; i < _stop; i++ ) {
            _current = this.getTagByIndex( i );
            _current.removeClass( 'disabled' );
            _current.setMessageTooltip( '' );
        }
        for ( i = this.size_tags - 1; i >= _stop; i-- ) {
            _current = this.getTagByIndex( i );
            _current.addClass( 'disabled' );
            _current.setMessageTooltip( _( 'property_multiselect.tooltip_limit_reached' ) );
        }
    },
    getErrors                     : function ( prop_name ) {
        var _to_return = 0;
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( this.getTagByIndex( i ).isError( prop_name ) ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    getWarnings                   : function ( prop_name ) {
        var _to_return = 0;
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( this.getTagByIndex( i ).isWarning( prop_name ) ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    isAllElementsSelectedDisabled : function () {
        var _size = this.tags.length;
        var _current_element;
        if ( !_size ) {
            return false;
        }
        for ( var i = 0; i < _size; i++ ) {
            _current_element = this.tags[ i ].element;
            if ( !_current_element.is_disabled &&
                 _current_element.state !== COMPONENT.CONST.TAG.STATE.NEW &&
                 _current_element.state !== COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
                return false;
            }
        }
        return true;
    },
    hasInvalidElementForProduction: function () {
        var _size = this.tags.length;
        var _current_element;
        if ( !_size ) {
            return false;
        }
        for ( var i = 0; i < _size; i++ ) {
            _current_element = this.tags[ i ].element;
            if ( _current_element.is_disabled ||
                 _current_element.state === COMPONENT.CONST.TAG.STATE.NEW ||
                 _current_element.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
                return true;
            }
        }
        return false;
    },
    //********************************************  GETTER  **************************************************//
    getListToString               : function ( prop_name ) {
        var _to_return = [];
        for ( var i = 0; i < this.size_tags; i++ ) {
            _to_return.push( this.tags[ i ].getName() );
        }
        return _to_return;
    }
};


//******************************  END  list-tag.js   **************************

//******************************  START  multi-select-comp.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/multi-select-comp.js *
'use strict';

COMPONENT.Select           = function ( dom_element, type, is_override, parent_name ) {
    // title
    // dom_element
    // dom_select
    // list_element
    // list_element_override
    // list_element_selected
    // last_selected_key_name
    // list_elements_inherited
    // maximum_selected
    this.type        = type;
    this.is_override = is_override;
    this.init( dom_element, parent_name );
};
COMPONENT.Select.prototype = {
    
    init                      : function ( dom_element, parent_name ) {
        this.dom_element             = dom_element;
        this.dom_select              = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        this.dom_link_icon_container = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.LINK_ICON_CONTAINER );
        this.dom_link_icon_button    = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.LINK_ICON_BUTTON );
        var _dom_list_select         = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST );
        this.list_element            = new COMPONENT.ListSelect( _dom_list_select );
        
        if ( this.type === PROPERTY.CONST.TYPES.MULTI_SELECT ) {
            var _dom_list_selected       = dom_element.querySelector( '.list-selected-in-select' );
            var _dom_list_inherited      = dom_element.querySelector( '.list-inherited' );
            var _dom_list_override       = dom_element.querySelector( '.shinken-list-override' );
            this.list_element_selected   = new COMPONENT.ListTag( _dom_list_selected, parent_name );
            this.list_elements_inherited = new COMPONENT.ListTag( _dom_list_inherited );
            this.list_element_override   = new COMPONENT.ListTag( _dom_list_override );
        }
    },
    updateWithTemplateSpecific: function ( tags ) {
        this.list_elements_inherited.addTags( tags );
    },
    hidePopup                 : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    
    clickOnSelector               : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
        this.list_element.focusOnResearchInput();
    },
    clickOnItemSelector           : function ( parent_name, key_name ) {
        this.last_selected_key_name = key_name;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _element = this.list_element.toggleStateSelectedInList( key_name );
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.getActiveListForUser().addTag( parent_name, _element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
        }
    },
    clickOnDeleteItemSelector     : function ( key_name ) {
        var _element = this.list_element.toggleStateSelectedInList( key_name );
        this.getActiveListForUser().deleteTag( _element );
    },
    dragStartShinken              : function ( type_element, key_name ) {
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getActiveListForUser().dragStartShinken( key_name );
        }
    },
    resetDragging                 : function () {
        this.list_element_selected.resetDragging();
    },
    setTitle                      : function ( _to_set ) {
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    isSet                         : function () {
        return !this.getActiveListForUser().isEmpty();
    },
    cleanAllTags                  : function () {
        this.getActiveListForUser().emptyList();
        this.cleanAllItemsSelected();
    },
    getActiveListForUser          : function () {
        if ( this.is_override ) {
            return this.list_element_override;
        }
        else {
            return this.list_element_selected;
        }
    },
    cleanAllItemsSelected         : function () {
        this.list_element.unselectAllElement();
    },
    getValue                      : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return this.getActiveListForUser().getValue();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                return this.getLastSelectedElementName();
        }
    },
    getValueToSave                : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return this.getTagsValueToSave();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                if ( this.last_selected_key_name ) {
                    return this.getLastSelectedElement().getElement().getValueFinal();
                }
                return;
        }
    },
    getTagsValueToSave            : function () {
        var _to_return = [];
        var _tags      = this.getActiveListForUser().getTags();
        for ( var i = 0, size = _tags.length; i < size; i++ ) {
            _to_return.push( _tags[ i ].getValueFinal() );
        }
        return _to_return;
    },
    computeTitle                  : function () {
        if ( this.last_selected_key_name === undefined ) {
            var _selected = this.list_element.getSelectedElements();
            if ( _selected[ 0 ] !== undefined ) {
                this.last_selected_key_name = _selected[ 0 ].element.name;
            }
        }
        this.setTitle( this.getLastSelectedElement().element.getLabel() );
    },
    getLastSelectedElement        : function () {
        return this.list_element.getListSelectElement( this.last_selected_key_name );
    },
    getLastSelectedElementName    : function () {
        return this.last_selected_key_name;
    },
    hasTag                        : function ( name ) {
        return !this.list_element_selected.hasTag( name ) || !this.list_elements_inherited.hasTag( name );
    },
    getMissingItemSelectorWith    : function ( property ) {
        return this.list_element_selected.getMissingItemSelectorWith( property );
    },
    getExtraItemSelectorWith      : function ( property ) {
        return this.list_element_selected.getExtraItemSelectorWith( property );
    },
    setMaximumSelected            : function ( to_set ) {
        this.maximum_selected = to_set;
    },
    getMaximumSelected            : function () {
        return this.maximum_selected;
    },
    isLimitReached                : function () {
        return (this.getActiveListForUser().getSizeTags() + this.list_elements_inherited.getSizeTags() - this.maximum_selected);
    },
    isLimitReachedForSelected     : function () {
        return (this.getActiveListForUser().getSizeTags() - this.maximum_selected);
    },
    addClassLimit                 : function () {
        this.dom_element.classList.add( 'behavior-limit' );
    },
    removeClassLimit              : function () {
        this.dom_element.classList.remove( 'behavior-limit' );
    },
    disabledTagsOutOfLimit        : function ( limit ) {
        this.list_elements_inherited.disabledTagsOutOfLimit( limit );
    },
    getErrors                     : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _to_return = this.list_element_selected.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                _to_return = this.list_element_selected.getErrors( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _to_return = this.list_elements_inherited.getErrors( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                _to_return = this.list_element_override.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                break;
        }
        return _to_return;
    },
    getWarnings                   : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _to_return = this.list_element_selected.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                _to_return = this.list_element_selected.getWarnings( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _to_return = this.list_elements_inherited.getWarnings( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                _to_return = this.list_element_override.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                break;
        }
        return _to_return;
    },
    //********************************************  FILTER   *********************************************************//
    doFilter                      : function ( filter ) {
        this.list_element.doFilter( filter );
    },
    cleanFilter                   : function () {
        this.list_element.cleanFilter();
    },
    validOrCreateTag              : function ( name_element, prop_name ) {
        var _existing = this.list_element.getListSelectElement( name_element );
        if ( _existing ) {
            return _existing;
        }
        return this.list_element.addNewElementUnknown( name_element, prop_name );
    },
    //********************************************  COMPUTE      *****************************************************//
    buildLinkOpenNewTab           : function ( link, id ) {
        var _span_link                         = "<span class=\"shinken-link-icon-button\"><span class=\"shinken-link-icon shinicon shinicon-open\"></span></span>";
        this.dom_link_icon_container.innerHTML = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, id, _span_link, "shinken-link" ).outerHTML;
    },
    //********************************************  ANIMATION    *****************************************************//
    pulsateTag                    : function ( name ) {
        var _existing = this.list_element_selected.getTagByName( name );
        if ( _existing ) {
            _existing.pulsateTag();
        }
    },
    //********************************************  AUTO SELECT  *****************************************************//
    moveAutoSelectCursor          : function ( move_down ) {
        this.list_element.moveAutoSelectCursor( move_down );
    },
    validAutoSelect               : function () {
        this.list_element.validAutoSelect();
    },
    isAllElementsSelectedDisabled : function () {
        return this.getActiveListForUser().isAllElementsSelectedDisabled();
    },
    hasInvalidElementForProduction: function () {
        return this.getActiveListForUser().hasInvalidElementForProduction();
    }
};
//******************************  END  multi-select-comp.js   **************************

//******************************  START  radio-list.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/radio-list.js *
'use strict';

COMPONENT.RadioList           = function ( dom_element ) {
    // list_radio_button
    // active_button
    // mapping_radio_button
    this.init( dom_element );
};
COMPONENT.RadioList.prototype = {
    init           : function ( dom_element ) {
        this.mapping_radio_button = {};
        this.initRadioList( dom_element );
    },
    initRadioList  : function ( dom_element ) {
        var _list_dom_radio_button = dom_element.querySelectorAll( '.shinken-radio-btn' );
        var _current_button;
        
        for ( var i = 0, size_list_button = _list_dom_radio_button.length; i < size_list_button; i++ ) {
            _current_button                                         = new COMPONENT.Button( _list_dom_radio_button[ i ] );
            this.mapping_radio_button[ _current_button.getValue() ] = _current_button;
            if ( _current_button.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current_button;
            }
        }
        
    },
    clickOnRadioBtn: function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getRadioButton( value );
        this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
    },
    getRadioButton : function ( value ) {
        return this.mapping_radio_button[ value ];
    },
    getValue       : function () {
        return this.active_button.getValue();
    },
    isDefaultOn    : function () {
        var _button = this.getRadioButton( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
        if ( _button ) {
            return _button.isOn();
        }
        return false;
    }
};
//******************************  END  radio-list.js   **************************

//******************************  START  select-comp.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/select-comp.js *
'use strict';

COMPONENT.SelectComp           = function ( dom_element ) {
    console.warn( "GREG", "[DEPRECATED]", "[]" );
    // title
    // selected_group_id
    // selected_key_name
    // dom_element
    // dom_element_title
    // element_selected
    // element_inherited
    // list_container
    this.init( dom_element );
};
COMPONENT.SelectComp.prototype = {
    
    init                : function ( dom_element ) {
        this.dom_element       = dom_element;
        this.dom_select        = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        this.dom_element_title = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.list_element      = new COMPONENT.ListSelect( dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST ) );
        
        this._initSelectedElement();
    },
    //***********************************************   INIT (private)   ******************************************************//
    _initSelectedElement: function () {
        this.selected_element = undefined;
        var _list_element     = this.getSelectedElement();
        if ( _list_element ) {
            this.selected_element = _list_element;
            this.list_element.toggleStateSelectedInList( this.selected_element.getName() );
        }
    },
    //***********************************************   GETTER SETTER   ******************************************************//
    setTitle            : function ( _text_to_set, is_default ) {
        this.dom_element_title.innerHTML = _text_to_set;
        (is_default) ? this.dom_element_title.classList.add( 'default' ) : this.dom_element_title.classList.remove( 'default' );
    },
    getValue            : function () {
        var _to_return = undefined;
        if ( this.selected_element ) {
            _to_return = this.selected_element.getName();
        }
        return _to_return;
    },
    getSelectedElement  : function () {
        return this.list_element.getSelectedElements()[ 0 ];
    },
    //***********************************************   TO SORT         ******************************************************//
    //updateWithTemplate  : function ( value ) {
    //    this.clickOnItemSelector( value );
    //},
    hidePopup           : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    
    clickOnSelector       : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
    },
    clickOnItemSelector   : function ( key_name ) {
        this.disableSelectedElement();
        this.list_element.toggleStateSelectedInList( key_name );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this.selected_element = this.getSelectedElement();
    },
    isSet                 : function () {
        return this.value !== undefined;
    },
    disableSelectedElement: function () {
        if ( this.selected_element ) {
            this.selected_element.setSelected( false );
        }
    },
    //********************************************  FILTER   *********************************************************//
    doFilter              : function ( filter ) {
        this.list_element.doFilter( filter );
    }
};
//******************************  END  select-comp.js   **************************

//******************************  START  tag.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/tag.js *
'use strict';

COMPONENT.Tag           = function ( dom_element, parent_name ) {
    // dom_element
    // element
    // is_dragging
    //animation_timer
    this.init( dom_element, parent_name );
};
COMPONENT.Tag.prototype = {
    init                    : function ( dom_element, parent_name ) {
        if ( dom_element ) {
            this.dom_element = dom_element;
            this.initElement( parent_name );
        }
    },
    initElement             : function ( parent_name ) {
        this.element = new OBJECT.ElementList();
        this.element.setName( this.dom_element.dataset.keyName );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setUUID( this.dom_element.dataset.uuid );
        if ( parent_name === PROPERTY.CONST.NAME.EDITION_CONTACTS && this.dom_element.classList.contains( 'shinken-tag-disabled' ) ) {
            this.text_tooltip = _( 'element.tooltip_edition_contact_not_expert' );
        }
        this.setTooltip();
    },
    setTooltip              : function ( text_tooltip ) {
        var _text = text_tooltip || this.element.getTooltip() || this.text_tooltip || '';
        this.dom_element.querySelector( 'tbody' ).setAttribute( "shi-tip-html", _text );
    },
    getDomElement           : function () {
        return this.dom_element;
    },
    isDefaultTag            : function () {
        return this.element.getName() === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
    },
    isNullTag               : function () {
        return this.element.getName() === PROPERTY.CONST.CUSTOM_SELECT.NONE;
    },
    getName                 : function () {
        return this.element.getName();
    },
    getLabel                : function () {
        return this.element.getLabel() || this.getName();
    },
    updateTagWithNoneTags   : function ( to_set ) {
        this.element.setLabel( to_set, this.dom_element );
        this.buildHTML();
    },
    setLabel                : function ( to_set ) {
        this.element.setLabel( to_set, this.dom_element.querySelector( '.title' ) );
        this.dom_element.querySelector( '.title' ).innerHTML = to_set;
    },
    getState                : function () {
        return this.element.getState();
    },
    setState                : function ( to_set ) {
        this.element.setState( to_set );
        DOM.Service.setDataSet( this.dom_element, 'state', to_set );
    },
    getType                 : function () {
        return this.element.getType();
    },
    setElement              : function ( to_set ) {
        this.element = to_set;
    },
    isDeletable             : function () {
        return (this.getType() !== 'inheritance');
    },
    isHidden                : function () {
        return this.element.getState() === COMPONENT.CONST.TAG.STATE.HIDDEN;
    },
    clone                   : function () {
        var _to_return         = new COMPONENT.Tag();
        _to_return.dom_element = this.dom_element.cloneNode( true );
        _to_return.element     = this.element.clone();
        return _to_return;
    },
    setIndexParentDomElement: function ( index ) {
        if ( !this.dom_element ) {
            return;
        }
        var _parent = DOM.Service.findParentElementWithClass( this.dom_element, 'droppable', 3 );
        if ( !_parent ) {
            return;
        }
        _parent.dataset.index = index;
    },
    
    pulsateTag : function () {
        this.dom_element.classList.add( SHINKEN.CONST.CLASS_CSS.PULSATE );
        if ( this.animation_timer ) {
            clearTimeout( this.animation_timer );
        }
        var self             = this;
        this.animation_timer = setTimeout( function () {
            self.dom_element.classList.remove( SHINKEN.CONST.CLASS_CSS.PULSATE );
        }, 1500 );
    },
    setDragging: function ( _to_set ) {
        this.is_dragging = _to_set;
        var self         = this;
        setTimeout( function () {
            if ( _to_set ) {
                self.dom_element.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DISCREET );
            }
            else {
                self.dom_element.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DISCREET );
            }
        }, 0 );
    },
    
    setMessageTooltip: function ( message ) {
        this.dom_element.querySelector( 'tbody' ).setAttribute( "shi-tip-html", message );
    },
    addClass         : function ( label ) {
        this.dom_element.classList.add( label );
    },
    removeClass      : function ( label ) {
        this.dom_element.classList.remove( label );
    },
    isError          : function ( prop_name ) {
        if ( prop_name === PROPERTY.CONST.NAME.USE ) {
            return this.element.getState() === OBJECT.CONST.TEMPLATE.STATUS.BADLOOP;
        }
        return this.element.getState() === COMPONENT.CONST.TAG.STATE.UNKNOWN;
    },
    isWarning        : function ( prop_name ) {
        if ( prop_name === PROPERTY.CONST.NAME.USE ) {
            return false;
        }
        var _to_return = this.element.is_disabled || this.element.is_force_to_null;
        if ( !_to_return ) {
            if ( this.element.shinken_element ) {
                _to_return = this.element.shinken_element.is_new;
            }
            else if ( this.element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
                _to_return = true;
            }
        }
        return _to_return;
    },
    buildHTMLParent  : function ( parent_name, index, link ) {
        var _to_return = DOM.Service.createElement( 'div', {
            class       : 'droppable',
            'data-index': index,
            ondrop      : 'MANAGER.DragNDropManager.dropShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", this)',
            ondragend   : 'MANAGER.DragNDropManager.dragEndShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '")',
            ondragover  : 'MANAGER.DragNDropManager.dragOverShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", this)'
        } );
        this.buildHTML( parent_name, link );
        DOM.Service.addElementTo( this.dom_element, _to_return );
        return _to_return;
    },
    buildHTML        : function ( parent_name, link, full_link ) {
        var dom_param = {
            class               : 'container-tag',
            'data-key-name'     : this.getName(),
            'data-state'        : this.getState(),
            'data-is-disabled'  : this.element.is_disabled,
            'data-force-to-null': this.element.is_force_to_null,
            'data-type'         : this.getType()
        };
        
        if ( parent_name && this.getType() === OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            dom_param[ 'class' ]       = 'container-tag ' + MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGABLE;
            dom_param[ 'draggable' ]   = true;
            dom_param[ 'ondragstart' ] = 'MANAGER.DragNDropManager.dragStartShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", "' + this.getName() + '")';
        }
        if ( parent_name === PROPERTY.CONST.NAME.EDITION_CONTACTS ) {
            if ( this.element.shinken_element && !this.element.shinken_element.is_admin && !this.element.shinken_element.is_expert ) {
                dom_param[ 'class' ] = dom_param[ 'class' ] + ' shinken-tag-disabled';
                this.text_tooltip    = _( 'element.tooltip_edition_contact_not_expert' );
            }
        }
        
        var _line        = DOM.Service.createElement( 'tr', { class: 'text-break-all-pre-line' } );
        var _col_content = DOM.Service.createElement( 'td', { class: 'content' } );
        var _col_cube    = DOM.Service.createElement( 'td', { class: 'shinken-tag-cube' } );
        var _title;
        if ( this.element.shinken_element ) {
            _title = SHINKEN.TOOLS.buildLinkShinkenElement( this.element.shinken_element );
        }
        else if ( this.getState() === COMPONENT.CONST.TAG.STATE.INHERITED && full_link ) {
            _title = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( full_link[ 0 ] || '', full_link[ 1 ] || '', this.getLabel() );
        }
        else {
            var _final_id = this.element.uuid;
            switch ( this.element.state ) {
                case COMPONENT.CONST.TAG.STATE.NEW :
                case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                    _final_id = this.element.uuid + '?new=1';
                    break;
            }
            _title = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, _final_id, this.getLabel() );
        }
        var _tbody = DOM.Service.createElement( 'tbody' ); // Tag
        _tbody.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        _tbody.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        _tbody.setAttribute( "shi-tip-html", '' );
        _tbody.setAttribute( "shi-tip-placement", "bottom" );
        
        this.dom_element = DOM.Service.createElement( 'table', dom_param ); // Tag
        
        
        DOM.Service.addElementTo( _title, _col_content );
        if ( this.isDeletable() ) {
            var _to_close = DOM.Service.createElement( 'span', {
                class  : 'shinken-close-icon',
                onclick: 'MANAGER.EventManager.clickOnDeleteItemSelector("' + parent_name + '","' + this.getName() + '")'
            }, 'x' );
            DOM.Service.addElementTo( _to_close, _col_content );
        }
        DOM.Service.addElementTo( _col_content, _line );
        DOM.Service.addElementTo( _col_cube, _line );
        DOM.Service.addElementTo( _line, _tbody );
        DOM.Service.addElementTo( _tbody, this.dom_element );
    },
    getValueFinal    : function () {
        return this.element.getValueFinal();
    }
};
//******************************  END  tag.js   **************************

//******************************  START  tag-information.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/component/tag-information.js *
'use strict';

COMPONENT.TagInformation           = function ( dom_element ) {
    //dom_element
    //params
    //dom_element_label
    this.params = [];
    if ( dom_element ) {
        this.status = dom_element.dataset.status;
        this.initDomElement( dom_element );
    }
    else {
        this.buildHtml();
        this.status = '';
    }
};
COMPONENT.TagInformation.prototype = {
    initDomElement: function ( dom_element ) {
        this.dom_element       = dom_element;
        this.dom_element_label = this.dom_element.querySelector( '.shinken-label-information' );
    },
    setStatus     : function ( to_set ) {
        if ( this.status === to_set ) {
            return;
        }
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
        var _tooltip      = "";
        var _tooltip_type = "";
        var _innerHTML    = "";
        switch ( this.status ) {
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED:
                _tooltip      = _( 'element.information_only_disable_tags_tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.WARNING_BORDER;
                _innerHTML    = _( 'element.information_only_disable_tags' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED_OVERRIDE:
                _tooltip      = _( 'element.information_only_disable_tags_override_tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.WARNING_BORDER;
                _innerHTML    = _( 'element.information_only_disable_tags' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER:
                _tooltip      = _( 'element.error-will-not-through-arbiter-tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.USER_GROUP_COHERENCY:
                _tooltip      = _( 'element.beware_user_groups_coherency' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.IN_SHELL:
                _tooltip      = _( 'element.tooltip_shell' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
                _innerHTML    = _( 'element.beware' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.CHECK_DUPLICATE:
                _tooltip      = SHINKEN.TOOLS.STRING.format( _( 'element.check_duplicate_on_the_same' ), this.params[ 0 ] );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            default:
                break;
        }
        this.dom_element.setAttribute( 'shi-tip-html', _tooltip );
        this.dom_element.setAttribute( 'shi-tip-type', _tooltip_type );
        this.dom_element_label.innerHTML = _innerHTML;
    },
    buildHtml     : function () {
        var _to_return = DOM.Service.createElement( 'span', { class: 'shinken-information-tag', onmouseenter: 'SHINKEN_TOOLTIP.showTooltip(this)', onmouseleave: 'SHINKEN_TOOLTIP.hideTooltip()' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: 'shinken-label-information' } ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: 'shinken-tag-mark' }, '?' ), _to_return );
        this.initDomElement( _to_return );
    },
    setParams     : function ( to_set ) {
        this.params = to_set;
    }
};

//******************************  END  tag-information.js   **************************

//******************************  START  distributor-button-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/distributor-button-manager.js *
'use strict';

MANAGER.DistributorButtonManager           = function () {
    this.buttons = {};
};
MANAGER.DistributorButtonManager.prototype = {
    createButton: function ( name ) {
        var _id          = 'id-shinken-btn-' + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new COMPONENT.Button( _dom_element, name );
        _to_return.initCounters();
        this.setButton( name, _to_return );
        return _to_return;
    },
    findButton  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getButton( name );
        if ( !_to_return ) {
            _to_return = this.createButton( name );
        }
        return _to_return;
    },
    setButton   : function ( name, button ) {
        this.buttons[ name ] = button;
    },
    getButton   : function ( name ) {
        return this.buttons[ name ];
    }
};
MANAGER.__instance_button_distributor      = new MANAGER.DistributorButtonManager();
//******************************  END  distributor-button-manager.js   **************************

//******************************  START  distributor-element-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/distributor-element-manager.js *
'use strict';

MANAGER.DistributorElementManager           = function () {
    this.current_element = null;
    this.current_user    = null;
    this.elements        = {};
    this.list_templates;
};
MANAGER.DistributorElementManager.prototype = {
    createElement                 : function ( datas ) {
        var _to_return = new OBJECT.ShinkenElement();
        _to_return.updateData( datas );
        this.addElement( _to_return );
        return _to_return;
    },
    findElement                   : function ( se_uuid, datas ) {
        if ( !se_uuid ) {
            return;
        }
        var _to_return = this.getElement( se_uuid );
        if ( !_to_return ) {
            _to_return = this.createElement( datas );
        }
        else {
            _to_return.updateData( datas );
        }
        return _to_return;
    },
    getElementListElementByName   : function ( list_name, name_element ) {
        if ( !this[ list_name ] ) {
            return null;
        }
        for ( var i = 0, _size_i = this[ list_name ].length; i < _size_i; i++ ) {
            if ( this[ list_name ][ i ].getName() === name_element ) {
                return this[ list_name ][ i ];
            }
        }
        return null;
    },
    getElementListElementByUuid   : function ( list_name, uuid_element ) {
        if ( !this[ list_name ] ) {
            return null;
        }
        for ( var i = 0, _size_i = this[ list_name ].length; i < _size_i; i++ ) {
            if ( this[ list_name ][ i ].getUUID() === uuid_element ) {
                return this[ list_name ][ i ];
            }
        }
        return null;
    },
    getElement                    : function ( se_uuid ) {
        return this.elements[ se_uuid ];
    },
    addElement                    : function ( element ) {
        this.elements[ element.getSEUUID() ] = element;
    },
    setCurrentElement             : function ( element ) {
        this.current_element = element;
        this.addElement( element );
        element.dom_form = document.getElementById( 'id-shinken-form-element' );
    },
    setCurrentUser                : function ( element ) {
        this.current_user = element;
        this.addElement( element );
    },
    getAllElements                : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
    },
    getAllElementsOfTypeCheck     : function () {
        var _to_return   = [];
        var all_elements = SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
        for ( var i = 0, _size_i = all_elements.length; i < _size_i; i++ ) {
            if ( all_elements[ i ].isCheck() ) {
                _to_return.push( all_elements[ i ] );
            }
        }
        return _to_return;
    },
    getCheckForCurrentElement     : function () {
        return this.getCheckForElement( this.current_element.uuid, true );
    },
    getCheckForElement            : function ( host_uuid, is_current ) {
        if ( is_current ) {
            return this.current_element.getValidCheck();
        }
        return this.list_templates.getTemplateByUuid( host_uuid ).getValidCheck();
    },
    getAllChecksDFE               : function () {
        var _to_return = [];
        var _keys      = Object.keys( this.elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.getElement( _keys[ i ] );
            if ( _current.is_obsolete || !_current.is_dfe ) {
                continue;
            }
            _to_return.push( _current );
        }
        return _to_return;
    },
    setAllChecksElementsToObsolete: function () {
        var _keys = Object.keys( this.elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.getElement( _keys[ i ] );
            if ( _current.isCheck() ) {
                _current.is_obsolete = true;
            }
        }
    },
    getElementValueOfLink         : function ( link ) {
        if ( typeof link === 'string' ) {
            return link;
        }
        var _to_return = "";
        var _current;
        for ( var i = 0, _size_i = link.links.length; i < _size_i; i++ ) {
            _current = this.getElementListElementByUuid( link.links[ i ].item_type, link.links[ i ]._id );
            if ( _to_return ) {
                _to_return += ",";
            }
            if ( _current ) {
                _to_return += _current.getName();
            }
            else {
                _to_return += link.links[ i ].name;
            }
        }
        return _to_return;
    }
};
MANAGER.__instance_element_distributor      = new MANAGER.DistributorElementManager();
//******************************  END  distributor-element-manager.js   **************************

//******************************  START  distributor-macro-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/distributor-macro-manager.js *
'use strict';

MANAGER.DistributorMacroManager           = function () {
    this.macros = {};
};
MANAGER.DistributorMacroManager.prototype = {
    construct                 : function ( string ) {
        if ( !this.isMacro( string ) ) {
            return string;
        }
        //var _macro_string = string.substr( 1, string.length - 2 );
        var _macro = this.findMacro( string );
        return _macro;
    },
    recomputeLabelForEachMacro: function () {
        var _keys = Object.keys( this.macros );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.macros[ _keys[ i ] ].init( true );
        }
    },
    isMacro                   : function ( string ) {
        if ( !SHINKEN.TOOLS.STRING.startsWith( string, '$' ) ) {
            return false;
        }
        if ( !SHINKEN.TOOLS.STRING.endsWith( string, '$' ) ) {
            return false;
        }
        return true;
    },
    findMacro                 : function ( name ) {
        var _to_return = this.getMacro( name );
        if ( !_to_return ) {
            _to_return          = new OBJECT.Macro( name );
            this.macros[ name ] = _to_return;
            _to_return.init();
        }
        return _to_return;
    },
    getMacro                  : function ( name ) {
        return this.macros[ name ];
    },
    findMacroByHostKey        : function ( name ) {
        var _name       = '$' + OBJECT.CONST.MACRO.TYPE.HOST_LOCAL + name.substr( 1 ) + '$';
        var _to_return  = this.findMacro( _name );
        _to_return.type = OBJECT.CONST.MACRO.TYPE.HOST_LOCAL; //TODO... A VOIR
        return _to_return;
    },
    changeMacro               : function ( property, value ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro = this.findMacroByHostKey( property.name );
            _macro.setValue( value, property );
            this.recomputeLabelForEachMacro();
        }
    },
    deleteMacroContent        : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro = this.findMacroByHostKey( name );
            _macro.setValue( '' );
            _macro.setU = OBJECT.CONST.MACRO.TYPE.UNKNOWN;
        }
    },
    renamedMacro              : function ( old_name, new_name, value ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro  = this.findMacroByHostKey( old_name );
            _macro.type = OBJECT.CONST.MACRO.TYPE.UNKNOWN;
            _macro      = this.findMacroByHostKey( new_name );
            _macro.setValue( value );
            this.recomputeLabelForEachMacro();
        }
    },
    splitCommand              : function ( colCommand ) {
        var _current;
        var _to_return = [];
        var _splitted  = colCommand.split( REGEXS.parse_arguments );
        var _size      = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.construct( _splitted[ i ] );
            if ( _current ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    hasMacro                  : function ( value ) {
        var _current;
        var _splitted = value.split( REGEXS.parse_arguments );
        var _size     = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.construct( _splitted[ i ] );
            if ( _current ) {
                if ( typeof _current !== 'string' ) {
                    return true;
                }
            }
        }
        return false;
    },
    buildLabel                : function ( _splitted_data, skip_container, key_dfe ) {
        var _to_return = "";
        var _current;
        for ( var i = 0, _size = _splitted_data.length; i < _size; i++ ) {
            _current = _splitted_data[ i ];
            if ( typeof _current === 'string' ) {
                if ( i ) {
                    _to_return += _current;
                }
                else {
                    var split_command    = _current.split( '!' );
                    var _current_command = MANAGER.__instance_element_distributor.getElementListElementByName( 'commands', split_command[ 0 ] );
                    if ( _current_command ) {
                        _to_return += SHINKEN.TOOLS.buildLinkShinkenElement( _current_command ).outerHTML;
                        for ( var j = 1, _size_j = split_command.length; j < _size_j; j++ ) {
                            _to_return += '!' + split_command[ j ];
                        }
                    }
                    else {
                        _to_return += _current;
                    }
                }
            }
            else {
                _to_return += _current.getValue();
            }
        }
        if ( !skip_container ) {
            var _class = "shinken-macro-container";
            _class += !_to_return ? ' shinken-hidden' : '';
            _to_return = "<div class='" + _class + "'>" + _to_return + "</div>";
        }
        if ( key_dfe ) {
            _to_return = SHINKEN.TOOLS.STRING.replaceAll( _to_return, OBJECT.CONST.MACRO.TYPE.DFE_KEY, key_dfe );
        }
        else {
            var _text       = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_found' ), '$KEY$' );
            var _to_replace = '<span class="shinken-macro-warning value" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"  onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="' + _text + '">$KEY$</span>';
            _to_return      = SHINKEN.TOOLS.STRING.replaceAll( _to_return, OBJECT.CONST.MACRO.TYPE.DFE_KEY, _to_replace );
        }
        return _to_return;
    }
};
MANAGER.__instance_macro_distributor      = new MANAGER.DistributorMacroManager();
//******************************  END  distributor-macro-manager.js   **************************

//******************************  START  distributor-property-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/distributor-property-manager.js *
'use strict';

MANAGER.DistributorPropertyManager           = function () {
    this.elements           = {};
    this.last_element_focus = null;
};
MANAGER.DistributorPropertyManager.prototype = {
    createElement                  : function ( name, selector, dom_element ) {
        var _to_return = null;
        
        switch ( name ) {
            case LIST.CONST.MASS_ACTION.ID:
                _to_return = new LIST.MassAction();
                if ( !_to_return.dom_element ) {
                    return null;
                }
                this.elements[ name ] = _to_return;
                return _to_return;
        }
        
        if ( !selector ) {
            switch ( name ) {
                default:
                    selector = '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE + '[data-name=' + name + ']';
            }
        }
        var _dom_element = dom_element;
        if ( !dom_element ) {
            try {
                var _dom_element = document.querySelector( selector );
            }
            catch ( e ) {
                console.log( 'Invalid name property' );
            }
        }
        
        if ( !_dom_element ) {
            return _to_return;
        }
        
        if ( !MANAGER.__instance_element_distributor.current_user ) {
            return _to_return;
        }
        
        var _type = _dom_element.dataset.type;
        switch ( _type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                _to_return = new PROPERTY.MultiSelect( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.BOOLEAN:
                _to_return = new PROPERTY.Boolean( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                _to_return = new PROPERTY.StringInput( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                _to_return = new PROPERTY.Range( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                _to_return = new PROPERTY.SingleSelect( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                _to_return = new PROPERTY.CheckboxSample( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _to_return = new PROPERTY.SingleSelectWithInput( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.DATA:
                _to_return = new PROPERTY.Data();
                _to_return.initWithDomElement( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                _to_return = new PROPERTY.CheckboxMulti( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _to_return = new PROPERTY.MultiLine( _dom_element );
                break;
            default:
                console.error( '[MANAGER.DistributorPropertyManager] This property type of [' + name + '] is not managed yet!', _type );
        }
        this.elements[ name ] = _to_return;
        return _to_return;
    },
    findElement                    : function ( name, focusing, selector, dom_element ) {
        if ( !name ) {
            return;
        }
        if ( name.startsWith( '@' ) ) { // Temp TODO test //sert a filtrer certain champs non visuel
            return;
        }
        var _to_return = this.getElement( name );
        if ( !_to_return ) {
            _to_return = this.createElement( name, selector, dom_element );
        }
        if ( focusing ) {
            this.setLastIntanceFocus( _to_return );
        }
        return _to_return;
    },
    getElement                     : function ( name ) {
        return this.elements[ name ];
    },
    setElement                     : function ( name, element ) {
        this.elements[ name ] = element;
    },
    getAllElements                 : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
    },
    getDataWithName                : function ( name_data ) {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        var _current;
        for ( var i = 0, _size = _to_return.length; i < _size; i++ ) {
            _current = _to_return[ i ];
            if ( _current.getName() === name_data ) {
                return _current;
            }
        }
        return null;
    },
    getAllDatasSorted              : function () {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        _to_return     = SHINKEN.TOOLS.ARRAY.sortArray( _to_return, "name" );
        return _to_return;
    },
    getAllOverrideProp             : function () {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "is_override", true );
        return _to_return;
    },
    getAllOverridePropByCheckId    : function ( uuid ) {
        var _to_return = this.getAllElements();
        var _to_return = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "override_check_uuid_final", uuid );
        return _to_return;
    },
    getAllDataOverridePropByCheckId: function ( uuid ) {
        var _to_return = this.getAllOverridePropByCheckId( uuid );
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        return _to_return;
    },
    getFirstOverridePropWithName   : function ( property_override_name ) { //FOR DOCUMENTATION
        var _to_return = this.getAllOverrideProp();
        for ( var i = 0, _size_i = _to_return.length; i < _size_i; i++ ) {
            if ( _to_return[ i ].override_prop_name === property_override_name ) {
                return _to_return[ i ];
            }
        }
        return null;
    },
    hasOverride                    : function ( check_in_page_host ) {
        var _overrides_prop = this.getAllOverrideProp();
        var _to_return      = false;
        var _current;
        for ( var i = 0, _size = _overrides_prop.length; i < _size; i++ ) {
            _current = _overrides_prop[ i ];
            if ( _current.override_check_uuid === check_in_page_host.uuid ) {
                if ( check_in_page_host.is_dfe ) {
                    if ( _current.override_check_name === check_in_page_host.name ) {
                        _to_return             = true;
                        _current.is_not_linked = false;
                    }
                    else {
                        continue;
                    }
                }
                else {
                    _to_return = true;
                }
            }
        }
        return _to_return;
    },
    deleteOverrideProp             : function ( check_in_page_host, host_in_page_host ) {
        var _datas = this.getAllElements();
        var _current_property;
        for ( var i = 0, _size_datas = _datas.length; i < _size_datas; i++ ) {
            _current_property = _datas[ i ];
            if ( _current_property.override_check_name === check_in_page_host.name ) {
                this.removeElement( _current_property.name, check_in_page_host, host_in_page_host );
            }
        }
    },
    removeElement                  : function ( name, check_in_page_host, host_in_page_host ) {
        var _to_remove = this.getElement( name );
        if ( _to_remove ) {
            if ( _to_remove.is_override && host_in_page_host && check_in_page_host ) {
                MANAGER.__instance_element_distributor.current_element.addOverrideByProperty( _to_remove, check_in_page_host, host_in_page_host );
            }
            delete this.elements[ name ];
        }
    },
    setLastIntanceFocus            : function ( _to_set ) {
        if ( this.last_element_focus && this.last_element_focus !== _to_set ) {
            this.hidePopups();
        }
        this.last_element_focus = _to_set;
    },
    getLastIntanceFocus            : function ( _to_set ) {
        return this.last_element_focus;
    },
    hidePopups                     : function () {
        if ( this.last_element_focus !== null ) {
            this.last_element_focus.hidePopup();
            this.last_element_focus = null;
        }
    },
    finalyzeModel                  : function () {
        var _object = this.getElement( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        if ( _object ) {
            _object.component_select.setMaximumSelected( PROPERTY.CONST.MAX_SELECTABLE_ITEMS.RESULT_MODULATIONS );
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
        if ( _object ) {
            _object.has_everybody_default = _object.default_value === 'everyone';
        }
    },
    finalyzeView                   : function () {
        MANAGER.__instance_element_distributor.list_templates.finalyzeView();
        
        var _object = this.getElement( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        if ( _object ) {
            _object.updateView();
        }
        
        var _object = this.getElement( PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS );
        if ( _object ) {
            MANAGER.ListenerEventManager.afterActionProperty( _object );
        }
        
        var _object = this.getElement( PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS );
        if ( _object ) {
            MANAGER.ListenerEventManager.afterActionProperty( _object );
        }
        
        var _object = this.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
        if ( _object ) {
            _object.updateView();
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.ENABLED );
        if ( _object ) {
            _object.updateView();
        }
    },
    unSetAllOverrideFor            : function ( check_in_page_host ) {
        var properties = this.getAllOverridePropByCheckId( check_in_page_host.getDomUUID() );
        var _size      = properties.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = properties[ i ];
            if ( _current.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                _current.unset();
            }
        }
    }
};
MANAGER.__instance_property_distributor      = new MANAGER.DistributorPropertyManager();
//******************************  END  distributor-property-manager.js   **************************

//******************************  START  drag-n-drop-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/drag-n-drop-manager.js *
'use strict';

MANAGER.DragNDropManager = {
    
    last_element_hovered: null,
    current_parent_name : null,
    type_drag_start     : null,
    list_element        : null,
    // pause_timeout       : null,
    
    dragStartShinken: function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        // Fix pour firefox
        e.dataTransfer.setData( 'text', 'anything' );
        // end Fix
        this.type_drag_start      = type;
        this.current_parent_name  = parent_name;
        this.list_element         = _object.dragStartShinken( type, key_name );
        this.last_element_hovered = this.list_element.getDragged().getDomElement().parentNode;
        this.last_index           = this.last_element_hovered.dataset.index;
        this.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width + 'px';
        }
    },
    dragOverShinken : function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( this.current_parent_name !== parent_name ) {
            return false;
        }
        if ( this.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === this.last_index ) {
            return false;
        }
        
        this.list_element.changeElementPosition( this.last_index, _current_index_hovered );
        this.last_index = _current_index_hovered;
        this.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        this.last_element_hovered = dom_element;
        this.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    },
    dragEndShinken  : function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( this.last_element_hovered ) {
            this.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        this.last_element_hovered = null;
        this.current_parent_name  = null;
        this.type_drag_start      = null;
        this.list_element         = null;
        this.pause_timeout        = null;
    },
    dropShinken     : function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    }
    
};
//******************************  END  drag-n-drop-manager.js   **************************

//******************************  START  distributor-window-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/distributor-window-manager.js *
'use strict';

MANAGER.DistributorWindowManager           = function () {
    this.windows        = {};
    this.parent_windows = {};
};
MANAGER.DistributorWindowManager.prototype = {
    createWindow                      : function ( name, is_menu ) {
        var _id          = WINDOW.CONST.ID.WINDOW_TAB + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new WINDOW.Element( name, _dom_element, is_menu );
        this.setWindow( name, _to_return );
        return _to_return;
    },
    createParentWindow                : function ( name ) {
        var _to_return = new WINDOW.ElementGroup( name );
        this.setParentWindow( name, _to_return );
        return _to_return;
    },
    findWindow                        : function ( name, is_menu ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getWindow( name );
        if ( !_to_return ) {
            _to_return = this.createWindow( name, is_menu );
        }
        return _to_return;
    },
    findParentWindow                  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getParentWindow( name );
        if ( !_to_return ) {
            _to_return = this.createParentWindow( name );
        }
        return _to_return;
    },
    setWindow                         : function ( name, window ) {
        this.windows[ name ] = window;
    },
    setParentWindow                   : function ( name, parent_window ) {
        this.parent_windows[ name ] = parent_window;
    },
    getWindow                         : function ( name ) {
        return this.windows[ name ];
    },
    clickOnFirstWindowInParentWithName: function ( name ) { //FOR DOCUMENTATION
        var _keys = Object.keys( this.parent_windows );
        this.parent_windows[ _keys[ 0 ] ].clickOnWindow( name );
    },
    getParentWindow                   : function ( name ) {
        return this.parent_windows[ name ];
    },
    reset                             : function () {
        this.windows        = {};
        this.parent_windows = {};
    }
};
MANAGER.__instance_window_distributor      = new MANAGER.DistributorWindowManager();
//******************************  END  distributor-window-manager.js   **************************

//******************************  START  event-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/event-manager.js *
'use strict';

MANAGER.EventManager = {
    last_element_hovered         : null,
    stop_propagation             : false,
    //********************************************  WINDOW MODAL      ******************************************//
    openIframeModal              : function ( url ) {
        MANAGER.__instance_window_modal_manager.setIframe( url );
    },
    closeModal                   : function () {
        MANAGER.__instance_window_modal_manager.close();
    },
    //********************************************  HEADER      ******************************************//
    logout                       : function () {
        window.location = '/logout';
        sessionStorage.removeItem( "user_id" );
    },
    //********************************************  GENERAL      ******************************************//
    onFocus                      : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onFocus();
    },
    onFocusOut                   : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name );
        _object.onFocusOut();
    },
    stopPropagation              : function () {
        this.stop_propagation = true;
        var self              = this;
        setTimeout( function () {
            self.stop_propagation = false;
        }, 50 );
    },
    clickOnRadioBtn              : function ( parent_name, value ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnRadioBtn( value );
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    //********************************************  PROPERTIES DATA  ******************************************//
    onChangeOnInputKey           : function ( event, dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeKeyAfterChange();
    },
    clickOnAddNewLocalMacro      : function () {
        return App.Elements.DataTab.addNewData();
    },
    clickOnDeletePropertyBtn     : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.delete();
    },
    clickDataCollapseButtonGlobal: function () {
        App.Elements.DataTab.toggleCollapseButtonGlobal();
    },
    clickDataCollapseButton      : function ( dom_element ) {
        App.Elements.DataTab.toggleCollapseButton( dom_element );
    },
    //********************************************  NAVIGATION      ******************************************//
    goToDataView                 : function ( data_name ) {
        MANAGER.EventManager.clickOnNavigation( WINDOW.CONST.ELEMENT.DATAS );
        var _prop = MANAGER.__instance_property_distributor.getDataWithName( data_name );
        if ( _prop.group_data ) {
            MANAGER.EventManager.clickOnDataNavigation( _prop.group_data.uuid );
        }
    },
    clickOnDataNavigation        : function ( group_uuid ) {
        App.Elements.DataTab.clickOnDataNavigation( group_uuid );
    },
    clickOnNavigation            : function ( tab_name ) {
        DOM.Service.setDataSet( MANAGER.__instance_element_distributor.current_element.dom_form, 'tabSelected', tab_name );
        SHINKEN.HIGHWAY.goToElementTab( tab_name );
    },
    clickOnWindowNavigation      : function ( event, dom_element, update_url ) {
        var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW.CONST.CLASS.WINDOW_TAB, 10 );
        if ( !_nav_tab ) {
            return;
        }
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( dom_element.dataset.name );
        _parent_window.clickOnWindow( _nav_tab.dataset.name );
        if ( update_url ) {
            SHINKEN.HIGHWAY.goToElementTab( _nav_tab.dataset.name );
        }
    },
    //********************************************  PROPERTIES CHECK  ******************************************//
    clickOnCheckboxInput         : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        var _name               = dom_element.dataset.name;
        _object.clickOnCheckboxInput( _name );
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    //********************************************  PROPERTIES STRING_INPUT  ******************************************//
    onChangeOnInput              : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeAfterChange( dom_element );
    },
    onResize                     : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onResize( dom_element );
    },
    //********************************************  PROPERTIES RANGE_INPUT  ******************************************//
    onMoveRangeCursor            : function ( parent_name, ask_after_action, event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onMoveRangeCursor( null, event );
        if ( ask_after_action ) {
            MANAGER.ListenerEventManager.afterActionProperty( _object );
        }
    },
    //********************************************  PROPERTIES MULTI-SELECT  *****************************************//
    clickOnBtnPlus               : function ( parent_name ) {
        this.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnPlus();
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    clickOnSelector              : function ( event, parent_name ) {
        event.stopPropagation();
        var _object        = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        var _scroll_parent = DOM.Service.findParentElementWithClass( _object.dom_element, _object.is_override ? 'shinken-check-override-table-container' : 'shinken-scroll-auto', 50 );
        if ( _scroll_parent ) {
            var _scroll_before = _scroll_parent.scrollHeight;
        }
        _object.clickOnSelector( event );
        if ( _scroll_parent ) {
            var _diff_scroll_height = _scroll_parent.scrollHeight - _scroll_before;
            if ( _diff_scroll_height > 0 ) {
                _scroll_parent.scrollTop = _scroll_parent.scrollTop + _diff_scroll_height;
            }
        }
    },
    clickOnAllItemsSelector      : function ( parent_name, limit ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAllItemsSelector( limit );
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    clickOnItemSelector          : function ( parent_name, key_name, element ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnItemSelector( key_name, element );
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    clickOnDeleteItemSelector    : function ( parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnDeleteItemSelector( key_name );
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    //********************************************  PROPERTIES SINGLE SELECT **********************************************//
    //********************************************  PROPERTIES GLOBAL   **********************************************//
    clickOnBtnInheritance        : function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnInheritance();
        MANAGER.ListenerEventManager.afterActionProperty( _object );
    },
    doChangeFilterSelect         : function ( event, parent_name, element ) {
        var key = event.which;
        switch ( key ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
            case SHINKEN.CONST.KEY_CODE.UP:
            case SHINKEN.CONST.KEY_CODE.ENTER:
                return;
        }
        var _filter = element.value;
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.doFilter( _filter );
    },
    muteEvent                    : function ( event ) {
        event.preventDefault();
        event.stopPropagation();
    },
    mutePropagation              : function ( event ) {
        event.stopPropagation();
    },
    
    //********************************************  SOURCES   ********************************************************//
    clickOnToggleViewSource        : function () {
        MANAGER.__instance_source_distributor.toggleViewSource();
        
    },
    clickOnActivatedSource         : function ( name ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.toogleEnable();
    },
    clickOnActivatedDiscoverySource: function ( source_name, discovery_id ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedDiscoverySource]", "[not admin]", "refused" );
            return;
        }
        var _source    = MANAGER.__instance_source_distributor.findSource( source_name );
        var _discovery = _source[ SOURCE.CONST.FIELD.IP_RANGES ].getRangeById( discovery_id );
        _discovery.toogleEnable();
    },
    clickOnForceSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnForceSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.askForceImport();
    },
    clickOnCleanSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnCleanSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.cleanImport();
    },
    clickOnOpenSource              : function ( name, state ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnOpenSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceDetail( state );
    },
    clickOnLastExecutionSource     : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnLastExecutionSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceLastExecution();
    },
    //********************************************  MONO-SELECT A TRIER  *********************************************//
    clickOnSelector_bis            : function ( e, parent_name ) {
        e.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnSelector();
    },
    clickOnItemSelector_bis        : function ( parent_name, group_id, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnItemSelector( group_id, key_name );
    },
    
    //********************************************  MASS ACTIONS  ****************************************************//
    updateMassActonCountSelect  : function ( data ) {
        var _object = MANAGER.__instance_property_distributor.findElement( LIST.CONST.MASS_ACTION.ID, false );
        _object.updateMassActonCountSelect( data );
    },
    //********************************************  WORKFLOW     *****************************************************//
    clickOnWorkflowTab          : function ( name ) {
        var dom_element = document.querySelector( "#shinken-workflow-container" );
        DOM.Service.setDataSet( dom_element, 'selected', name );
        dom_element.classList.toggle( 'PATCH_IE' );
    },
    clickOpenNewWindow          : function ( event, link, id ) {
        var _path = "/elements/";
        _path += link + '/';
        _path += id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    clickOnLinkForWorkingArea   : function ( event, id ) { //NE MARCHE QUE POUR LES HOSTS
        var _path = "/elements/working_area/hosts/" + id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    //********************************************  OTHERS     *****************************************************//
    keydown                     : function ( event ) {
        var _last_focus = MANAGER.__instance_property_distributor.getLastIntanceFocus();
        if ( !_last_focus ) {
            return;
        }
        switch ( _last_focus.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _last_focus.keydown( event );
                break;
        }
    },
    mouseEnter                  : function ( dom_element ) {
        var name    = dom_element.dataset.name;
        var _object = MANAGER.__instance_property_distributor.findElement( name );
        if ( _object ) {
            _object.mouseEnter();
        }
        else if ( dom_element.classList.contains( 'shinken-check-line' ) ) {
            //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
            MANAGER.HelpManager.setActive( 'help_title_try_checks' );
        }
    },
    mouseLeave                  : function ( dom_element ) {
        var name    = dom_element.dataset.name;
        var _object = MANAGER.__instance_property_distributor.findElement( name );
        if ( _object ) {
            _object.mouseLeave();
        }
        else if ( dom_element.classList.contains( 'shinken-check-line' ) ) {
            //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
            MANAGER.HelpManager.askSetInactive( 'help_title_try_checks' );
        }
    },
    onClick                     : function ( dom_element ) {
        if ( this.stop_propagation ) {
            return;
        }
        var name    = dom_element.dataset.name;
        var _object = MANAGER.__instance_property_distributor.findElement( name );
        if ( _object ) {
            _object.onClick();
        }
        else if ( dom_element.classList.contains( 'shinken-check-line' ) ) {
            //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
            var _help_button = dom_element.querySelector( '.tag-help' );
            if ( _help_button && _help_button.classList.contains( 'shinken-active' ) ) {
                return;
            }
            MANAGER.HelpManager.setForced( 'help_title_try_checks', _help_button );
        }
    },
    clickOnForcedHelpButton     : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 20 );
        var name                = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( name );
        _object.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButtonCheck: function ( event, dom_element ) {
        //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
        event.preventDefault();
        event.stopPropagation();
        MANAGER.HelpManager.setForced( 'help_title_try_checks', dom_element, true );
    },
    //********************************************  OVERRIDE     *****************************************************//
    clickOnModeTab              : function ( element, do_blink_animation ) {
        var _parents = DOM.Service.findParentElementWithClass( element, 'shinken-host-check-window-container', 20 );
        DOM.Service.setDataSet( _parents, 'tabSelected', element.dataset.value );
        if ( do_blink_animation ) {
            DOM.Service.askAddClass( element, 'shinken-pulsate', 2000 );
        }
        if ( element.dataset.value !== '1' ) {
            var _elements = document.querySelectorAll( '.shinken-tab-check-col-tags' );
            for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
                _elements[ i ].classList.remove( "shinken-active" );
            }
            var _elements_tr = document.querySelectorAll( '.shinken-tr-check-override' );
            for ( var i = 0, _size = _elements_tr.length; i < _size; i++ ) {
                _elements_tr[ i ].classList.add( "shinken-hidden" );
            }
        }
        MANAGER.__instance_navigator_size.tab_data_exclude();
    },
    clickOnSetOverride          : function ( dom_uuid ) {
        var _element = document.querySelector( '.shinken-host-check-window-container' );
        if ( _element.dataset.tabSelected !== '1' ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="1"]' ), true );
        }
        App.Elements.ChecksTab.getCheckOverrideData( dom_uuid );
        MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE );
    },
    clickOnSetExclude           : function ( dom_uuid, event, ignore_if_on_status_exclude ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _element = document.querySelector( '.shinken-host-check-window-container' );
        if ( _element.dataset.tabSelected !== '2' ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="2"]' ), true );
        }
        else if ( !ignore_if_on_status_exclude ) {
            var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( dom_uuid );
            _check_in_host.changeExcludeStatus();
        }
    },
    clickOnDeleteInvalidOverride: function ( type, name ) {
        MANAGER.__instance_override_unvalid.deleteOverride( type, name );
    },
    clickOnCleanCheckOverrides  : function ( event, check_uuid ) {
        event.stopPropagation();
        var _confirm = confirm( _( 'element.confirm_remove_override' ) );
        if ( _confirm ) {
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
            _check_in_page_host.cleanOverride();
        }
    },
    //********************************************  TRY CHECKS     *****************************************************//
    clickOnTryCheck             : function ( check_uuid, is_exec, is_on_poller ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.askTryCheck( is_exec, is_on_poller );
    },
    clickOnCleanTryCheck        : function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.hide_eval_check();
    },
    //********************************************  OUTPUT RULES     *****************************************************//
    clickOnMultiLineObjectAdd   : function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAddLine();
    },
    clickOnDeleteLine           : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.deleteLine( dom_element );
    },
    //********************************************  OUTPUT RULES     *****************************************************//
    clickOnHooksPopup           : function ( event, element ) {
        event.stopImmediatePropagation();
        var target    = element;
        var parent    = target.parentNode;
        var is_active = target.classList.contains( 'active' );
        if ( is_active ) {
            target.classList.remove( 'active' );
            parent.classList.remove( "shinken-force-display-block" );
        }
        else {
            target.classList.add( 'active' );
            parent.classList.add( "shinken-force-display-block" );
        }
    },
    
    clickOnForceImportInSource: function ( source_name ) {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + source_name
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    }
};
//******************************  END  event-manager.js   **************************

//******************************  START  help-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/help-manager.js *
'use strict';

MANAGER.HelpManager = {
    status                : MANAGER.CONST.HELP.STATUS.INACTIVE,
    active_name           : null,
    forced_name           : null,
    title                 : "",
    content               : "",
    mapping_label         : {},
    dom_element           : null,
    dom_element_title     : null,
    dom_element_content   : null,
    dom_element_import_key: null,
    dom_button_forced     : null,
    default_content       : _( 'element.help_hover' ),
    timer_set_inactive    : null,
    setStatus             : function ( to_set ) {
        this.status = to_set;
        this.initDomElement();
        this.buildHtml();
    },
    setActive             : function ( name, label, key_content, import_key ) {
        if ( this.timer_set_inactive ) {
            clearTimeout( this.timer_set_inactive );
        }
        if ( this.active_name === name ) {
            return;
        }
        this.active_name = name;
        this.createTextsIfMissing( name, label, key_content, import_key );
        this.setStatus( MANAGER.CONST.HELP.STATUS.ACTIVE );
        
        App.Scope.adjustHeight( $( '#shinken-help-title' ), $( '#shinken-help-content' ), $( '.info-box.help' ), false );
    },
    askSetInactive        : function ( name ) {
        if ( this.timer_set_inactive ) {
            clearTimeout( this.timer_set_inactive );
        }
        var _self               = this;
        this.timer_set_inactive = setTimeout( function () {
            _self.setInactive( name );
        }, 400 );
    },
    setInactive           : function ( name ) {
        if ( this.active_name !== name ) {
            return;
        }
        this.active_name = null;
        this.setStatus( this.forced_name ? MANAGER.CONST.HELP.STATUS.FORCED : MANAGER.CONST.HELP.STATUS.INACTIVE );
        this.timer_set_inactive = null;
        App.Scope.adjustHeight( $( '#shinken-help-title' ), $( '#shinken-help-content' ), $( '.info-box.help' ), false );
    },
    setForced             : function ( name, dom_element, forced ) {
        if ( this.forced_name === name && (name !== 'help_title_try_checks' || forced) ) {
            this.forced_name = false;
            this.dom_tag_help_button.classList.remove( 'shinken-active' );
        }
        else {
            if ( this.dom_tag_help_button ) {
                this.dom_tag_help_button.classList.remove( 'shinken-active' );
            }
            
            this.dom_tag_help_button = dom_element;
            this.forced_name         = name;
            if ( this.dom_tag_help_button ) {
                this.dom_tag_help_button.classList.add( 'shinken-active' );
            }
        }
        this.buildHtml();
    },
    setTitle              : function ( name_property, to_set ) {
        if ( !MANAGER.__instance_element_distributor.current_element ) {
            return;
        }
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = _( 'help-' + MANAGER.__instance_element_distributor.current_element.getHelpType() + '.' + name_property + "-title" );
        }
        this.mapping_label[ name_property ].title = to_set;
    },
    setContent            : function ( name_property, to_set ) {
        if ( !MANAGER.__instance_element_distributor.current_element ) {
            return;
        }
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = 'help-' + MANAGER.__instance_element_distributor.current_element.getHelpType() + '.' + name_property + "-content";
        }
        this.mapping_label[ name_property ].content = _( to_set );
        switch ( name_property ) {
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.MONDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.TUESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.WEDNESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.THURSDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.FRIDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SATURDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SUNDAY:
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                this.mapping_label[ name_property ].content += _( "help-timeperiods.day-specific-content" );
                break;
        }
    },
    setImportKey          : function ( name_property, to_set ) {
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = _( 'element.import_key' ) + ' : ' + name_property;
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( name_property );
        if ( _prop && _prop.hide_import_key ) {
            console.log( "GREG", "[name_property]", name_property, _prop.hide_import_key );
            to_set = "";
        }
        this.mapping_label[ name_property ].import_key = to_set;
    },
    clean                 : function () {
        DOM.Service.setHtmlOrHide( this.dom_element_title, '' );
        DOM.Service.setHtmlOrHide( this.dom_element_import_key, '' );
        DOM.Service.setHtmlOrHide( this.dom_element_content, '' );
    },
    buildHtml             : function () {
        var _texts = this.getTexts();
        DOM.Service.setHtmlOrHide( this.dom_element_title, _texts.title );
        DOM.Service.setHtmlOrHide( this.dom_element_import_key, _texts.import_key );
        DOM.Service.setHtmlOrHide( this.dom_element_content, _texts.content );
    },
    getHelpToDisplay      : function () {
        switch ( this.status ) {
            case MANAGER.CONST.HELP.STATUS.ACTIVE:
                return this.active_name;
            case MANAGER.CONST.HELP.STATUS.FORCED:
                return this.forced_name;
        }
        return false;
    },
    initDomElement        : function () {
        if ( this.dom_element ) {
            return;
        }
        this.dom_element            = document.getElementById( 'shinken-help-container' );
        this.dom_element_title      = this.dom_element.querySelector( '.shinken-help-name' );
        this.dom_element_content    = this.dom_element.querySelector( '.shinken-help-content-container' );
        this.dom_element_import_key = this.dom_element.querySelector( '.shinken-help-import-key' );
    },
    createTextsIfMissing  : function ( name_property, title, key_translate_content, import_key ) {
        if ( this.mapping_label[ name_property ] ) {
            return;
        }
        this.setTitle( name_property, title );
        this.setContent( name_property, key_translate_content );
        this.setImportKey( name_property, import_key );
    },
    getTexts              : function () {
        var _name_property = this.getHelpToDisplay();
        var _to_return;
        if ( _name_property ) {
            _to_return = this.mapping_label[ _name_property ];
        }
        else {
            _to_return            = {};
            _to_return.title      = '';
            _to_return.import_key = '';
            _to_return.content    = this.default_content;
            
        }
        return _to_return;
    }
    
};
//******************************  END  help-manager.js   **************************

//******************************  START  listener-event-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/listener-event-manager.js *

'use strict';

MANAGER.ListenerEventManager = {
    afterActionProperty           : function ( property ) {
        this.synchronizeAfterEvent( property );
        this.afterActionGlobal( property );
    },
    afterAction                   : function ( type, param1 ) {
        switch ( type ) {
            case MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE:
                var property = MANAGER.__instance_property_distributor.findElement( 'use' );
                this.setDisabledBecauseOverrideOpen( property );
                break;
            case MANAGER.CONST.AFTER_ACTION.CLICK_ON_WINDOW_DATA_OVERRIDE:
                var _props = MANAGER.__instance_property_distributor.getAllDataOverridePropByCheckId( param1 );
                for ( var i = 0, _size_ = _props.length; i < _size_; i++ ) {
                    _props[ i ].updateView();
                }
                break;
        }
    },
    setDisabledBecauseOverrideOpen: function ( property ) {
        property.setIsDisable( true );
        var _dom_element   = property.dom_element;
        var _property_data = _dom_element.getElementsByClassName( 'shinken-prop-cell-action-content' )[ 0 ];
        _property_data.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        _property_data.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        _property_data.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.use_cannot_be_modified' ) ) );
        
        var list_dom_element_with_tooltip = _property_data.querySelectorAll( "[shi-tip-html]" );
        var _current_dom_element;
        for ( var i = 0, _size = list_dom_element_with_tooltip.length; i < _size; i++ ) {
            _current_dom_element = list_dom_element_with_tooltip[ i ];
            DOM.Service.removeAttribute( _current_dom_element, "onmouseenter" );
            DOM.Service.removeAttribute( _current_dom_element, "onmouseleave" );
        }
        
    },
    synchronizeAfterEvent         : function ( property ) {
        var _object;
        var property_name = property.getName();
        if ( property.is_override ) {
            property_name = property.override_prop_name;
        }
        var _object_to_link = this.getObjectLink( property );
        var _switch_on      = true;
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                _switch_on = false;
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                var _size = _object_to_link.length;
                for ( var i = 0; i < _size; i++ ) {
                    _object = MANAGER.__instance_property_distributor.findElement( _object_to_link[ i ] );
                    _object.synchronize( property, _switch_on );
                }
                break;
            
        }
    },
    afterActionGlobal             : function ( property ) {
        var _object;
        var property_name = property.getName();
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.SERVICE_EXCLUDES:
                App.Elements.ChecksTab.updateExcludeStatus();
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                if ( property.has_everybody_default ) {
                    this.synchronizeAfterEvent( MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS ) );
                    this.synchronizeAfterEvent( MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ) );
                }
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                _object = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
                _object.updateView();
                break;
            case PROPERTY.CONST.NAME.USE:
                var _check_nb_label = property.dom_element.querySelectorAll( ".shinken-checks-tag-label" );
                for ( var i = 0, _size_i = _check_nb_label.length; i < _size_i; i++ ) {
                    DOM.Service.removeElement( _check_nb_label[ i ] );
                }
                updateALLTemplateAndCheckDatas();
                break;
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                if ( property.isSetOrIsSetHerited() ) {
                    var _list_tag = document.querySelectorAll( '.shinken-tag-modulation' );
                    for ( var i = 0, _size = _list_tag.length; i < _size; i++ ) {
                        _list_tag[ i ].classList.remove( 'shinken-hidden' );
                    }
                }
                break;
        }
        if ( property.is_override ) {
            var override_property_name = property.override_prop_name;
            switch ( override_property_name ) {
                case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                    var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( property.override_check_uuid_final );
                    var _id            = App.Elements.ChecksTab.buildIdTagModulation( _check_in_host );
                    var _tag_needed    = App.Elements.ChecksTab.isTagModulationNeeded( _check_in_host, property );
                    var _dom_element   = document.getElementById( _id );
                    if ( _tag_needed ) {
                        _dom_element.classList.remove( 'shinken-hidden' );
                    }
                    else {
                        _dom_element.classList.add( 'shinken-hidden' );
                    }
                    break;
                case PROPERTY.CONST.NAME.CONTACT_GROUPS:
                    var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( property.override_check_uuid_final );
                    _check_in_host.updateHtmlGroupAfterChange();
                    break;
            }
        }
        
        if ( property_name === MANAGER.__instance_element_distributor.current_element.key_name ) {
            document.getElementById( 'shinken-title-page-edition' ).innerText = property.getValue();
            if ( MANAGER.__instance_element_distributor.current_element.is_dfe ) {
                var _message = new OBJECT.Messages();
                _message.addMessage( COMPONENT.CONST.STATUS.BEWARE, _( 'element.tooltip_dfe_deleted_part_3' ) );
                _message.footer = _( 'element.tooltip_dfe_deleted_part_2' );
                _message.buildMessage();
                property.component_input.updateShinkenTooltip( _message );
            }
        }
    },
    
    getObjectLink: function ( property ) {
        var _to_return    = [];
        var property_name = property.getName();
        if ( property.is_override ) {
            property_name = property.override_prop_name;
        }
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.EDITION_CONTACTS;
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS;
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACTS;
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS;
                break;
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS;
                break;
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE;
                _to_return[ 2 ] = PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK;
                _to_return[ 3 ] = PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK;
                break;
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE;
                break;
        }
        if ( property.is_override ) {
            for ( var i = 0, _size_return = _to_return.length; i < _size_return; i++ ) {
                _to_return[ i ] = PROPERTY.BuildOverrideName( _to_return[ i ], property );
            }
        }
        return _to_return;
    }
    
};
//******************************  END  listener-event-manager.js   **************************

//******************************  START  loading-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/loading-manager.js *
'use strict';
var __shinken_debug_time_start = Date.now();
var __shinken_debug            = SHINKEN.HIGHWAY.getParams( 'shinken_debug' );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    test_user_change();
    if ( __shinken_debug ) {
        document.getElementById( 'id-shinken-debug-dom-ready' ).innerHTML = Date.now() - __shinken_debug_time_start;
    }
    if ( MANAGER.WindowModalManager ) {
        MANAGER.__instance_window_modal_manager = new MANAGER.WindowModalManager();
    }
    try {
        if ( typeof current_shinken_user !== 'undefined' ) {
            var _shinken_user = new OBJECT.ShinkenElement();
            _shinken_user.updateData( current_shinken_user );
            MANAGER.__instance_element_distributor.setCurrentUser( _shinken_user );
        }
        if ( document.getElementById( 'shinken-id-navigation-table' ) ) {
            setInterval( ask_menu_update, 30000 );
        }
        doActionWhenDomReady();
    }
    catch ( e ) {
        console.warn( "NO ACTION EXPECTED WHEN DOM READY", e );
    }
} );


MANAGER.LoadingManager           = function () {
    this.is_ready = false;
};
MANAGER.LoadingManager.prototype = {
    isReady        : function () {
        return this.is_ready;
    },
    setIsReady     : function ( to_set ) {
        this.is_ready = to_set;
        if ( __shinken_debug ) {
            document.getElementById( 'id-shinken-debug-js-ready' ).innerHTML = Date.now() - __shinken_debug_time_start;
        }
        if ( this.is_ready ) {
            if ( SHINKEN.HIGHWAY.getParams( 'shinken_doc' ) ) {
                doActionWhenReadyDocumentation();
            }
            if ( SHINKEN.HIGHWAY.getParams( 'shinken_test_auto' ) ) {
                doActionWhenReadyTestAuto();
            }
        }
    },
    setAjaxCallDone: function ( to_set ) {
        if ( __shinken_debug ) {
            document.getElementById( 'id-shinken-debug-ajax-done' ).innerHTML = Date.now() - __shinken_debug_time_start;
        }
    },
    showLoading    : function ( progress_state ) {
        var loading_text = document.getElementById( "loading_text" );
        if ( loading_text ) {
            loading_text.innerHTML = progress_state;
        }
        var container_loading_bar = document.getElementById( "container_loading_bar" );
        if ( container_loading_bar ) {
            container_loading_bar.classList.remove( "hide" );
        }
        var loading_page = document.getElementById( "loading_page" );
        if ( loading_page ) {
            loading_page.classList.remove( "hide" );
        }
    },
    removeLoading  : function () {
        var container_loading_bar = document.getElementById( "container_loading_bar" );
        if ( container_loading_bar ) {
            container_loading_bar.classList.add( "hide" );
        }
        var loading_page = document.getElementById( "loading_page" );
        if ( loading_page ) {
            loading_page.classList.add( "hide" );
        }
        var loading_text = document.getElementById( "loading_text" );
        if ( loading_text ) {
            loading_text.innerHTML = "";
        }
    }
};

MANAGER.__instance_loading = new MANAGER.LoadingManager();


//TO CLEAN
function test_user_change () {
    if ( !MANAGER.__instance_element_distributor.current_user ) {
        setTimeout( function () {
            test_user_change();
        }, 1000 );
        return;
    }
    var user_log_id_local = MANAGER.__instance_element_distributor.current_user.uuid || '';
    var user_stock        = sessionStorage.getItem( "user_id" );
    if ( user_log_id_local ) {
        if ( !user_stock ) {
            sessionStorage.setItem( "user_id", user_log_id_local );
        }
        else if ( user_log_id_local != user_stock ) {
            setTimeout( function () {
                alert( App.Scope.format( _( 'element.the_user_changed' ), MANAGER.__instance_element_distributor.current_user.contact_name ) );
            }, 1 );
            sessionStorage.setItem( "user_id", user_log_id_local );
        }
    }
}

//******************************  END  loading-manager.js   **************************

//******************************  START  navigator-size-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/navigator-size-manager.js *
'use strict';

document.addEventListener( "DOMContentLoaded", function ( e ) {
    MANAGER.__instance_navigator_size.run();
} );


MANAGER.NavigatorSizeManager           = function () {
    this._interval;
    this._check_top_shinken_content = true;
    this.init_done                  = false;
};
MANAGER.NavigatorSizeManager.prototype = {
    run                 : function () {
        setTimeout( function () {
            MANAGER.__instance_navigator_size.checkSizes();
        }, 100 );
        this._interval = setInterval( function () {
            MANAGER.__instance_navigator_size.checkSizes();
        }, 4000 );
    },
    initDomElements     : function () {
        this.dom_element_shinken_navigation_table = document.getElementById( 'shinken-id-navigation-table' );
        this.dom_element_shinken_menu_top_bar     = document.querySelector( '.shinken-menu-top-bar' );
        this.dom_element_shinken_content          = document.querySelector( '.shinken-content' );
        var _width_button_log                     = document.querySelector( '.shinken-quit-cell' ).getBoundingClientRect().width;
        var _width_logo_shinken                   = document.querySelector( '.shinken-logo-cell' ).getBoundingClientRect().width;
        var _width_back_button                    = document.querySelector( '.shinken-arrow-back-block-cell' ).getBoundingClientRect().width;
        this.width_nav_bar_used                   = _width_button_log + _width_back_button + _width_logo_shinken;
        this.init_done                            = true;
    },
    checkSizes          : function () {
        this._menu_elements();
        if ( this._check_top_shinken_content ) {
            this._top_shinken_content();
        }
    },
    tab_data_exclude    : function () {
        var _dom_element = document.querySelector( "#checks.shinken-host-check-window-container" );
        if ( _dom_element ) {
            if ( _dom_element.dataset.tabSelected === "2" ) {
                var _prop_exclude = document.getElementById( 'id-shinken-exclude-property-container' );
                if ( _prop_exclude ) {
                    var _height                                                                 = _prop_exclude.getBoundingClientRect().height;
                    _dom_element.querySelector( '.shinken-scroll-without-header' ).style.height = "calc(100% - " + _height + "px)";
                }
            }
            else {
                _dom_element.querySelector( '.shinken-scroll-without-header' ).style.height = "100%";
            }
        }
    },
    _menu_elements      : function () {
        if ( !this.dom_element_shinken_navigation_table ) {
            return;
        }
        var _rect = this.dom_element_shinken_navigation_table.getBoundingClientRect();
        
        if ( _rect.width + this.width_nav_bar_used > window.innerWidth ) {
            var _data_responsive = parseInt( this.dom_element_shinken_menu_top_bar.dataset.responsive );
            if ( _data_responsive < 4 ) {
                DOM.Service.setDataSet( this.dom_element_shinken_menu_top_bar, "responsive", _data_responsive + 1 );
                this._menu_elements();
            }
        }
    },
    _top_shinken_content: function () {
        this._check_top_shinken_content = false;
        if ( !this.dom_element_shinken_content || !this.dom_element_shinken_menu_top_bar ) {
            return;
        }
        var _height                                      = this.dom_element_shinken_menu_top_bar.getBoundingClientRect().height;
        this.dom_element_shinken_content.style.top       = _height + 'px';
        this.dom_element_shinken_content.style.height    = 'calc(100% - ' + _height + 'px)';
        this.dom_element_shinken_content.style.maxHeight = 'calc(100% - ' + _height + 'px)';
    },
    resizeDone          : function () {
        if ( !this.init_done ) {
            this.initDomElements();
        }
        if ( !this._interval ) {
            return;
        }
        this.dom_element_shinken_menu_top_bar.dataset.responsive = 0;
        this._check_top_shinken_content                          = true;
        this.checkSizes();
    }
};

MANAGER.__instance_navigator_size = new MANAGER.NavigatorSizeManager();


function action_when_resizing () {
    MANAGER.__instance_navigator_size.resizeDone();
    var _dom_area_header        = $( '.area-header' );
    var _dom_form               = $( '#id-shinken-form-element' );
    var _dom_right_column       = $( '#right-column' );
    var _dom_left_column        = $( '#left-column' );
    var _dom_element_list_panel = $( '.elements-list-panel' );
    
    /**********************
     * Resize LIST
     *********************/
    App.Scope.adjustHeight( $( '#top-list-container' ), _dom_element_list_panel, $( '.elements-panel' ), false );
    App.Scope.adjustHeight( $( '.header-background' ), $( '.body-background' ), _dom_element_list_panel );
    
    /*******************************
     * Resize Page Edition element
     *******************************/
    App.Scope.adjustHeight( _dom_area_header, $( '.form-element' ), _dom_right_column, false, true );
    App.Scope.adjustHeight( _dom_area_header, _dom_form, _dom_form.parent(), false, true );
    
    /**************************************
     * Page Edition element - Resize HELP
     **************************************/
    var _dom_info_area     = $( '.info-area' );
    var _dom_info_box_help = $( '.info-box.help' );
    var _dom_action_area   = $( '.action-area' );
    // ----- Level 1
    App.Scope.adjustHeight( _dom_action_area, _dom_info_area, _dom_left_column, false );
    // ----- Level 2
    App.Scope.adjustHeight( $( '#shinken-box-content-legend' ), _dom_info_box_help, _dom_info_area, false );
    // ----- Level 3
    App.Scope.adjustHeight( $( '#shinken-help-title' ), $( '#shinken-help-content' ), _dom_info_box_help, false );
    
    /*******************************
     * Resize Page Production
     *******************************/
    App.Scope.adjustHeight( $( '.main-header' ), $( '.main-content' ), $( '#main-right' ) );
    App.Scope.adjustHeight( _dom_action_area, $( '#left-panel-error' ), _dom_left_column );
    
    /*******************************
     * Resize Page Source and Tagger
     *******************************/
    App.Scope.adjustHeightMulti( $( '.table-head-js' ), $( '.table-body-js' ), $( '.table-shinken-js' ), false );
    
    /*******************************
     * Reposition Add Comment pop-up
     *******************************/
    var _element_add_comment_specific = document.getElementById( "comment-to-submit-for-staging" );
    if ( _element_add_comment_specific && _element_add_comment_specific.classList.contains( "active" ) ) {
        document.getElementById( "element-btn-submit-to-stagging-add-comment" ).click();
    }
    var _element_add_comment_list = document.getElementById( "comment-to-action-launch" );
    if ( _element_add_comment_list && _element_add_comment_list.classList.contains( "active" ) ) {
        var _element = document.querySelector( "#btn-action-launch-add-comment .label-button-mass-action" );
        if ( _element ) {
            _element.click();
        }
    }
}

$( window ).resize( action_when_resizing );

$( document ).ready( function () {
    $( window ).trigger( 'resize' );
} );


//******************************  END  navigator-size-manager.js   **************************

//******************************  START  work-flow-manager.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/manager/work-flow-manager.js *
'use strict';

MANAGER.WorkFlowManager = {
    dom_element_body: null,
    state           : null,
    setState        : function ( state ) {
        this.state = state;
        DOM.Service.setDataSet( this.getDomElement(), 'stateWorkFlow', state );
    },
    getState        : function () {
        if ( !this.state ) {
            this.state = this.getDomElement().dataset.stateWorkFlow;
        }
        return this.state;
    },
    clickOnTabArea  : function ( to_set ) {
        this.setState( to_set );
        var _object = MANAGER.__instance_property_distributor.findElement( LIST.CONST.MASS_ACTION.ID, false );
        if ( _object ) {
            _object.resetMassAction();
        }
        $( window ).trigger( 'resize' );
    },
    getDomElement   : function () {
        if ( !this.dom_element_body ) {
            this.dom_element_body = document.querySelector( 'body' );
        }
        return this.dom_element_body;
    }
};


//******************************  END  work-flow-manager.js   **************************

//******************************  START  _interface_property.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/_interface_property.js *
'use strict';


PROPERTY.Interface = function () {
};

PROPERTY.Interface.prototype = {
    initDomElement        : function ( element ) {
        this.dom_element      = element;
        this.name             = element.dataset.name;
        this.type             = element.dataset.type;
        this.default_value    = element.dataset.defaultValue;
        this.default_label    = element.dataset.defaultLabel;
        this.none_label       = element.dataset.noneLabel;
        this.item_type        = element.dataset.itemType;
        this.link_id          = element.dataset.linkId;
        this.unit             = element.dataset.unit;
        this.custom_selected  = element.dataset.customSelected;
        this.is_not_heritable = element.dataset.isPropNotHeritable;
        this.hide_import_key  = parseInt( element.dataset.hideImportKey );
        this.is_disabled      = element.classList.contains( 'shinken-disabled' );
        this.setOverride( element.dataset.override );
        this.computeTabId();
        this.setIsRequired( element.dataset.isRequired );
        this._initErrorWarning();
        this.tag_information = new COMPONENT.TagInformation( element.querySelector( ".shinken-prop-cell-label .shinken-information-tag" ) );
    },
    _initWithCustomSelect : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                        this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                switch ( this.last_list_element_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        if ( !this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( false );
                            this.state_inheritance = false;
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        if ( this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( true );
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
                        }
                        break;
                }
                
                if ( this.last_list_element_selected ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setLastItemSelected( this.component_btn_inheritance.isSet() ? PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
                        if ( this.is_override ) {
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                        this.setLastItemSelected( this.custom_selected );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
                        break;
                    
                    default:
                        var _last_element_selected = this.component_select.list_element.getFirstSelectedElement();
                        if ( !_last_element_selected ) {
                            return;
                        }
                        this.setLastItemSelected( _last_element_selected.element.name );
                        this.component_select.last_selected_key_name = this.last_list_element_selected;
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setStateInheritance( true );
                        break;
                }
                break;
        }
    },
    _initErrorWarning     : function () {
        this.error_counter   = new SHINKEN.OBJECT.Counter();
        this.warning_counter = new SHINKEN.OBJECT.Counter();
        this.error_counter.init( this.dom_element.querySelector( '.shinken-counter.shinken-error-counter' ) );
        this.warning_counter.init( this.dom_element.querySelector( '.shinken-counter.shinken-warning-counter' ) );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    checkErrorWarning     : function () {
        var _parent_window;
        var _window;
        this.computeErrors();
        this.setErrors();
        if ( this.is_override ) {
            _parent_window = MANAGER.__instance_window_distributor.findParentWindow( this.override_check_uuid_final );
            _window        = _parent_window.getElementByID( this.tab_parent_id );
            _window.setError( this.name, this.error_counter.counter_final, this );
            _window.setWarning( this.name, this.warning_counter.counter_final, this );
        }
        else if ( this.type !== PROPERTY.CONST.TYPES.DATA ) {
            _window = MANAGER.__instance_window_distributor.findWindow( this.tab_parent_id );
            _window.setError( this.name, this.error_counter.counter_final );
            _window.setWarning( this.name, this.warning_counter.counter_final );
        }
    },
    computeErrors         : function () {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
        this.computeErrorsSpecifics();
    },
    setErrors             : function () {
        this.setErrorsSpecific();
        var _key = this.uuid ? this.uuid : this.name;
        //this.error_counter.setLabel(this.state);
        //this.counter_temp_error = 1;
        this.error_counter.update( _key, this.counter_temp_error );
        this.warning_counter.update( _key, this.counter_temp_warning );
        this.error_counter.setTooltip( this.counter_error_tooltip, SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
        this.warning_counter.setTooltip( this.counter_warning_tooltip, SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
    },
    computeErrorsSpecifics: function () {
    },
    setErrorsSpecific     : function () {
    },
    clickOnBtnInheritance : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.DATA:
                this.component_input.updateView( this.state_inheritance );
                break;
        }
    },
    specificTreatment     : function () {
    },
    onFocus               : function () {
    },
    onFocusOut            : function () {
    },
    //********************************************  INHERITANCE     **************************************************//
    updateWithTemplate    : function ( templates, is_update ) {
        if ( is_update ) {
            this.cleanBeforeUpdate();
        }
        if ( this.is_not_heritable || !templates ) {
            this._initWithCustomSelect();
            this._computeState();
            this.updateView();
            return;
        }
        var _template_properties = templates.getProperties( this.name );
        
        this.updateAllTemplatesCustonmTags( _template_properties );
        var _has_template = this.component_btn_inheritance.setTemplateProperty( _template_properties );
        var _label;
        var _template;
        var _inherited_label;
        if ( _has_template ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.MULTI_SELECT:
                    _template            = _template_properties[ 0 ];
                    this.inherited_value = _template.value;
                    switch ( this.inherited_value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label  = this.component_select.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                            this.component_select.list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.BOOLEAN:
                    this.inherited_value            = _template_properties[ 0 ].value;
                    this.inherited_value            = this._computeInheritedLabel( this.inherited_value );
                    _template_properties[ 0 ].label = this.inherited_value;
                    this.component_radio_list.getRadioButton( PROPERTY.CONST.DEFAULT_BUTTON_LABEL ).setInheritedLabel( this.inherited_value );
                    break;
                
                case PROPERTY.CONST.TYPES.RANGE:
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    this.inherited_value = _template_properties[ 0 ].value;
                    switch ( this.inherited_value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            this.inherited_value = this.default_value;
                    }
                    _label = this._computeInheritedLabel( this.inherited_value );
                    this.component_btn_default.setInheritedLabel( _label );
                    _template_properties[ 0 ].label = _label;
                    break;
                case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                    this.inherited_value = _template_properties[ 0 ].value;
                    _label               = this._computeInheritedLabel( this.inherited_value );
                    this.component_btn_default.setInheritedLabel( _label );
                    _template_properties[ 0 ].label = _label;
                    this.component_checkbox.setCheckedInheritance( this.inherited_value );
                    break;
                case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                    this.inherited_value = _template_properties[ 0 ].value;
                    this.component_btn_default.setInheritedLabel( this.inherited_value );
                    _template_properties[ 0 ].label = this.inherited_value;
                    this.computeInheritanceCheckbox();
                    break;
                
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    _template            = _template_properties[ 0 ];
                    this.inherited_value = _template.value;
                    _template.label      = this._computeInheritedLabel( this.inherited_value );
                    switch ( _template.value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label = this.component_select.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            break;
                    }
                    if ( this.inherited_value ) {
                        _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                        this.component_select.list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                    _template               = _template_properties[ 0 ];
                    this.inherited_value    = _template.value;
                    var _elements_command   = this.inherited_value.split( '!' );
                    this.inherited_cmd_name = _elements_command[ 0 ];
                    this.inherited_cmd_args = _elements_command.splice( 1 ).join( '!' );
                    
                    _template.label = this._computeInheritedLabel( this.inherited_value );
                    switch ( _template.value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label = this.component_select.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            break;
                    }
                    if ( this.is_override ) {
                        _label = this.inherited_cmd_args + ' [ ' + _( 'element.in_template' ) + ' ' + _template.template_name + ' ]';
                        this.component_input.setPlaceholder( _label );
                    }
                    else if ( this.inherited_value ) {
                        _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                        this.component_select.list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                    _template = _template_properties[ 0 ];
                    if ( this.is_protected ) {
                        _label                          = PROPERTY.CONST.DATA.PROTECTED_PLACEHOLDER;
                        _template_properties[ 0 ].value = SHINKEN.TOOLS.ENCRYPTION.getDefaultLabel();
                    }
                    else {
                        if ( _template.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                            _label = _( 'element.forced_default' );
                            if ( this.default_value ) {
                                _label += " " + this.default_value;
                            }
                        }
                        else {
                            _label = _template.value;
                        }
                        _label += ' [' + _( 'element.in_template' ) + ' ' + _template.template_name + ']';
                    }
                    this.component_input.setPlaceholder( _label );
                    break;
                case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                    _template = _template_properties[ 0 ];
                    this._updateCfgInheritedLabel( _template.value );
                    break;
            }
        }
        this._computeBtnInheritance();
        this.component_btn_inheritance.askUpdateHTML();
        this._initWithCustomSelect();
        this.updateWithTemplateSpecific();
    },
    cleanBeforeUpdate     : function () {
    },
    
    updateWithTemplateSpecific   : function () {
    },
    updateAllTemplatesCustonmTags: function ( _template_properties ) {
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateInheritance          : function ( to_set ) {
        this.state_inheritance = to_set;
        this.component_btn_inheritance.setState( this.state_inheritance ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
        this.setStateInheritanceSpecific();
    },
    setStateInheritanceSpecific  : function () {
    },
    getName                      : function () {
        return this.name;
    },
    getParentName                : function () {
        return this.name;
    },
    getState                     : function () {
        return this.state;
    },
    setInheritanceStatus         : function ( to_set, message ) {
        DOM.Service.setDataSet( this.dom_element, 'inheritanceStatus', to_set );
        this.setInheritanceStatusTooltip( to_set, message );
    },
    setInheritanceStatusTooltip  : function ( status, to_set ) {
        var _element = this.dom_element.querySelector( '.shinken-status-tag[data-status="' + status + '"]' );
        if ( _element ) {
            _element.setAttribute( 'shi-tip-html', to_set );
        }
    },
    setOverride                  : function ( _to_set ) {
        this.is_override = !!_to_set;
        if ( !_to_set ) {
            return;
        }
        this.override_prop_name        = this.dom_element.dataset.overridePropName;
        this.override_check_uuid       = this.dom_element.dataset.overrideElementUuid;
        this.override_check_name       = this.dom_element.dataset.overrideElementName;
        this.override_dfe_name         = this.dom_element.dataset.overrideDfeName;
        var _parents                   = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-override-check-content', 20 );
        this.override_check_uuid_final = _parents.dataset.domUuid;
        
        var help_title   = this.override_prop_name;
        var prop_is_data = SHINKEN.TOOLS.STRING.startsWith( this.override_prop_name, '_' );
        if ( !prop_is_data ) {
            help_title = _( 'help-services.' + this.override_prop_name + "-title" );
        }
        MANAGER.HelpManager.setTitle( this.name, help_title + ' (override)' );
        if ( this.is_disabled ) {
            if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                MANAGER.HelpManager.setContent( this.name, 'help-services.check_command-content-override' );
            }
            else {
                MANAGER.HelpManager.setContent( this.name, 'element.help_lock_property' );
            }
        }
        else {
            if ( prop_is_data ) {
                MANAGER.HelpManager.setContent( this.name, 'element.help_text_data' );
            }
            else {
                
                MANAGER.HelpManager.setContent( this.name, 'help-services.' + this.override_prop_name + "-content" );
            }
        }
        var _import_key_html = DOM.Service.createElement( 'div', {}, _( 'element.import_key' ) + ' : service_overrides' );
        if ( !this.is_disabled ) {
            var _example_html_title = DOM.Service.createElement( 'div', { class: 'shinken-example' }, _( 'common.example' ) );
            var _example_html       = DOM.Service.createElement( 'div', { class: 'shinken-example' }, 'service_overrides <span class="shinken-data-user">' + _( 'common.check_name' ) + '</span>,' + this.override_prop_name + '&nbsp;<span class="shinken-data-user">' + _( 'common.override_value' ) + '</span>' );
            DOM.Service.addElementTo( _example_html_title, _import_key_html );
            DOM.Service.addElementTo( _example_html, _import_key_html );
        }
        MANAGER.HelpManager.setImportKey( this.name, _import_key_html.innerHTML );
    },
    setState                     : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
        DOM.Service.setDataSet( this.dom_element, 'stateInheritance', this.component_btn_inheritance.getState() );
        if ( this.has_plus ) {
            DOM.Service.setDataSet( this.dom_element, 'statePlus', this.state_plus );
        }
        this.updateOverrideCounter();
        fire_element_is_modifie();
    },
    setLastItemSelected          : function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    getValueInherited            : function () {
        console.warn( "getValueInherited", "[Not managed for type]", this.type );
    },
    getFlatValue                 : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.component_btn_inheritance.isSet() ? this.getValueInherited() : this.default_value;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return this.default_value;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                return this.getValue();
        }
    },
    getValue                     : function () {
        var _to_return = "";
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.DATA:
                _to_return = this.component_input.getValue();
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                _to_return = this.getDataToSaveFinal();
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                _to_return = this.component_select.getValue();
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                    _to_return = '';
                }
                else if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                    _to_return = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                        _to_return = PROPERTY.CONST.STATE_VALUE_PLUS.ON + _to_return;
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    case PROPERTY.CONST.STATE_PROPERTY.NO_OVERRIDE:
                        return '';
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                        return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    default:
                        return this.component_input_range.getValue();
                }
            case PROPERTY.CONST.TYPES.BOOLEAN:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    case PROPERTY.CONST.STATE_PROPERTY.NO_OVERRIDE:
                        return '';
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                        return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    default:
                        return this.component_radio_list.getValue();
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _to_return = this.component_select.getValue();
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                    return '';
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    return _to_return;
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ) {
                    return _to_return;
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                    return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                
                _to_return += '!' + this.component_input.getValue();
                
                break;
        }
        return _to_return;
    },
    setValue                     : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet                        : function () {
        var _to_return = this.getValue();
        return !!_to_return;
    },
    isStateOverride              : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return true;
        }
        return false;
    },
    setIsDisable                 : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    computeTabId                 : function () {
        var _tab_parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, this.is_override ? 'shinken-prop-table' : 'property-tab-pane', 10 );
        if ( _tab_parent_dom_element ) {
            this.tab_parent_id = _tab_parent_dom_element.id;
            if ( this.is_override ) {
                this.tab_parent_id = SHINKEN.TOOLS.STRING.replaceAll( this.tab_parent_id, '-target', '' );
            }
        }
    },
    setIsRequired                : function ( to_set ) {
        this.is_required = to_set;
        if ( this.is_required && this.tab_parent_id ) {
            var _window = MANAGER.__instance_window_distributor.findWindow( this.tab_parent_id );
            _window.setHasRequired( true );
        }
    },
    unset                        : function () {
    },
    setValueFromUser             : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    //********************************************  COMPUTE  *********************************************************//
    _computeBtnInheritance       : function () {
    
    },
    _computeState                : function () {
    
    },
    _computeValueForSynchronize  : function () {
        var _to_return;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                var _state_default = this.component_btn_default.getState();
                _to_return         = this.component_input_range.getValue();
                if ( _state_default ) {
                    _to_return = this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON ? this.inherited_value : this.component_btn_default.getValue();
                }
                break;
        }
        return _to_return;
    },
    _computeInheritedLabelHtml   : function ( template_name, inherited_value ) {
        return "<span class='shinken-space'>-- " + inherited_value + "   " + "<span class='shinken-between-bracket'>" + _( 'element.in_template' ) + " " + template_name + "</span> --</span>";
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                    : function () {
    },
    updateView                   : function () {
    },
    updateOverrideCounter        : function () {
        if ( !this.is_override ) {
            return;
        }
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( this.override_check_uuid_final );
        var _window        = _parent_window.getElementByID( this.tab_parent_id );
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE :
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT :
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER :
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS :
                _window.setOverride( this.name, 1, this.override_check_uuid_final );
                break;
            default:
                _window.setOverride( this.name, 0, this.override_check_uuid_final );
        }
        var _btn_set_override = document.getElementById( 'id-shinken-btn-' + this.override_check_uuid_final );
        var _check_line       = DOM.Service.findParentElementWithDataSet( _btn_set_override, 'overrideStatus', 10 );
        DOM.Service.setDataSet( _check_line, 'overrideStatus', _btn_set_override.dataset.overrideCounter === '0' ? OBJECT.CONST.OVERRIDE_STATUS.OFF : OBJECT.CONST.OVERRIDE_STATUS.ON );
    },
    remove                       : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        MANAGER.__instance_property_distributor.removeElement( this.name );
    },
    
    //********************************************  SAVE    **********************************************************//
    isFlatValueOn          : function () {
    },
    getDataToSave          : function () {
        if ( this.state_inheritance && !this.state_plus ) {
            return "";
        }
        return this.getDataToSaveFinal();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronize            : function ( property, switch_type ) {
        switch_type ? this.synchronizeAtMinimum( property ) : this.synchronizeAtMaximum( property );
        if ( this.name === PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ) {
            MANAGER.ListenerEventManager.afterActionGlobal( this );
        }
    },
    synchronizeAtMinimum   : function ( property ) {
    },
    synchronizeAtMaximum   : function ( property ) {
    },
    //********************************************  HELP    **********************************************************//
    mouseEnter             : function () {
        if ( this.is_override ) {
            var _title   = _( 'help-services.' + this.name_flat + "-title" );
            var _content = _( 'help-services.' + this.name_flat + "-content" );
            
            MANAGER.HelpManager.setActive( this.name, _title, _content );
        }
        else {
            MANAGER.HelpManager.setActive( this.name );
        }
    },
    mouseLeave             : function () {
        MANAGER.HelpManager.askSetInactive( this.name );
    },
    onClick                : function () {
        if ( !this.dom_element_help_btn ) {
            this.dom_element_help_btn = this.dom_element.querySelector( '.shinken-tag-help' );
        }
        if ( this.dom_element_help_btn.classList.contains( 'shinken-active' ) ) {
            return;
        }
        this.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButton: function () {
        if ( this.name.length === 1 && this.name.startsWith( '_' ) ) {
            return;
        }
        if ( !this.dom_element_help_btn ) {
            this.dom_element_help_btn = this.dom_element.querySelector( '.shinken-tag-help' );
        }
        MANAGER.HelpManager.setForced( this.name, this.dom_element_help_btn );
    }
};


PROPERTY.getInterfacePrototype = function ( object ) {
    var _current;
    var _keys = Object.keys( PROPERTY.Interface.prototype );
    for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
        _current = _keys[ i ];
        if ( !object.prototype[ _current ] ) {
            object.prototype[ _current ] = PROPERTY.Interface.prototype[ _current ];
        }
    }
    
};

PROPERTY.BuildOverrideName          = function ( property_name, property ) {
    return "override-" + property.override_check_uuid_final + '-' + property_name;
};
PROPERTY.BuildOverrideNameFromCheck = function ( property_name, check_host ) {
    if ( property_name === 'check_command_args' ) {
        property_name = PROPERTY.CONST.NAME.CHECK_COMMAND;
    }
    return "override-" + check_host.getDomUUID() + '-' + property_name;
};
//******************************  END  _interface_property.js   **************************

//******************************  START  boolean-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/boolean-prop.js *
'use strict';

PROPERTY.Boolean           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // default_label
    // type
    // component_radio_list
    // component_btn_inheritance
    // state
    // state_inheritance
    // tab_parent_id
    // error_counter
    // warning_counter
    this.init( dom_element );
};
PROPERTY.Boolean.prototype = {
    init                         : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.state                     = null;
        this.component_radio_list      = new COMPONENT.RadioList( dom_element );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.checkErrorWarning();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnRadioBtn              : function ( value ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_radio_list.clickOnRadioBtn( value );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
        this.updateView();
        fire_element_is_modifie();
    },
    updateAllTemplatesCustonmTags: function ( templates_properties ) {
        if ( !templates_properties ) {
            return;
        }
        var _size = templates_properties.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = templates_properties[ i ];
            if ( _current.value === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                _current.label = this.default_label;
            }
            else if ( _current.value === "0" ) {
                _current.label = _( 'element.false' );
            }
            else if ( _current.value === "1" ) {
                _current.label = _( 'element.true' );
            }
        }
        
    },
    //********************************************  GET / SET ***********************************************//
    unset                        : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser             : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnRadioBtn( value );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            default:
                this.clickOnRadioBtn( value );
                break;
        }
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance       : function () {
        var _value = this.component_radio_list.getValue();
        if ( _value === PROPERTY.CONST.DEFAULT_BUTTON_LABEL && this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this._computeState();
    },
    _computeState                : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var is_default_on      = this.component_radio_list.isDefaultOn();
        if ( this.is_override ) {
            if ( this.component_radio_list.getRadioButton( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ).isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( is_default_on ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else {
            if ( is_default_on && !this.component_btn_inheritance.isSet() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( is_default_on ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
            }
        }
        this.setState( _to_set );
    },
    _computeInheritedLabel       : function ( inherited_value ) {
        switch ( inherited_value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                inherited_value = this.default_value;
                break;
            case "1":
                inherited_value = _( 'element.true' );
                break;
            case "0":
                inherited_value = _( 'element.false' );
                break;
            
        }
        return inherited_value;
    },
    updateWithTemplateSpecific   : function () {
        this.updateView();
    },
    //********************************************  VIEW    **********************************************************//
    updateView                   : function () {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.SHELL_EXECUTION:
                var _status = this.component_radio_list.getValue() === '1' ? COMPONENT.CONST.TAG_INFORMATION.STATUS.IN_SHELL : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
                this.tag_information.setStatus( _status );
                break;
            case PROPERTY.CONST.NAME.ENABLED:
                var _is_disabled = this.component_radio_list.getValue() === '0';
                if ( _is_disabled ) {
                    DOM.BodyService.getDomElement().classList.add( "shinken-current-element-is-disabled" );
                }
                else {
                    DOM.BodyService.getDomElement().classList.remove( "shinken-current-element-is-disabled" );
                }
                break;
        }
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal           : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return '';
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        return this.getValue();
    }
};
PROPERTY.getInterfacePrototype( PROPERTY.Boolean );
//******************************  END  boolean-prop.js   **************************

//******************************  START  checkbox-multi-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/checkbox-multi-prop.js *
'use strict';

PROPERTY.CheckboxMulti           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_checkbox
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    this.init( dom_element );
};
PROPERTY.CheckboxMulti.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_checkbox_read     = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.READ + '"]' ) );
        this.component_checkbox_create   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.CREATE + '"]' ) );
        this.component_checkbox_organize = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE + '"]' ) );
        this.component_checkbox_modify   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.MODIFY + '"]' ) );
        this.component_checkbox_delete   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.DELETE + '"]' ) );
        this.component_checkbox_all      = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.ALL + '"]' ) );
        this.component_btn_default       = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        this.component_btn_inheritance   = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.checkErrorWarning();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    checkErrorWarning         : function () {
    },
    askComputeAfterChange     : function () {
        this.setStateInheritance( false );
        this.component_checkbox.setChecked();
        this._computeState();
    },
    clickOnRadioBtn           : function ( value ) {
        var _is_on = this.component_btn_default.isOn();
        if ( _is_on ) {
            return;
        }
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.ON );  //UTILE ??
        this._computeState();
    },
    clickOnCheckboxInput      : function ( name ) {
        var _current;
        switch ( name ) {
            case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                _current = this.component_checkbox_read;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
                _current = this.component_checkbox_create;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
                _current = this.component_checkbox_organize;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
                _current = this.component_checkbox_modify;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                _current = this.component_checkbox_delete;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                _current = this.component_checkbox_all;
                break;
            
        }
        var _value = !_current.isCheckedUser();
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _value = !_current.isCheckedDefault();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( !this.component_btn_inheritance.isSet() ) {
                    _value = !_current.isCheckedDefault();
                }
                else {
                    _value = !_current.isCheckedInheritance();
                }
                break;
        }
        _current.setCheckedUser( _value );
        this.synchronizeAfterClick( name, _current );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAfterClick     : function ( name, checkbox ) {
        switch ( name ) {
            case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                if ( !checkbox.isCheckedUser() ) {
                    this.component_checkbox_create.setCheckedUser( false );
                    this.component_checkbox_organize.setCheckedUser( false );
                    this.component_checkbox_modify.setCheckedUser( false );
                    this.component_checkbox_delete.setCheckedUser( false );
                    this.component_checkbox_all.setCheckedUser( false );
                }
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
            case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
            case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
            case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                if ( checkbox.isCheckedUser() ) {
                    this.component_checkbox_read.setCheckedUser( true );
                }
                else {
                    this.component_checkbox_all.setCheckedUser( false );
                }
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                var _value = checkbox.isCheckedUser();
                this.component_checkbox_read.setCheckedUser( _value );
                this.component_checkbox_create.setCheckedUser( _value );
                this.component_checkbox_organize.setCheckedUser( _value );
                this.component_checkbox_modify.setCheckedUser( _value );
                this.component_checkbox_delete.setCheckedUser( _value );
                break;
            
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_SET ) {
            return;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT ) {
            if ( this.component_btn_inheritance.isSet() ) {
                return;
            }
        }
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    computeInheritanceCheckbox: function () {
        var _splitted = this.inherited_value.split( ',' );
        for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
            switch ( _splitted[ i ] ) {
                case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                    this.component_checkbox_read.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
                    this.component_checkbox_create.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
                    this.component_checkbox_organize.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
                    this.component_checkbox_modify.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                    this.component_checkbox_delete.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                    this.component_checkbox_read.setCheckedInheritance( true );
                    this.component_checkbox_create.setCheckedInheritance( true );
                    this.component_checkbox_organize.setCheckedInheritance( true );
                    this.component_checkbox_modify.setCheckedInheritance( true );
                    this.component_checkbox_delete.setCheckedInheritance( true );
                    this.component_checkbox_all.setCheckedInheritance( true );
                    break;
            }
        }
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.component_btn_default.isOn() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return '';
        }
        var _to_return = '';
        _to_return += this.component_checkbox_delete.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_modify.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_organize.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_create.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_read.isCheckedUser() ? '1' : '0';
        return _to_return;
    }
};

PROPERTY.getInterfacePrototype( PROPERTY.CheckboxMulti );
//******************************  END  checkbox-multi-prop.js   **************************

//******************************  START  checkbox-sample-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/checkbox-sample-prop.js *
'use strict';

PROPERTY.CheckboxSample           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_checkbox
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // custom_selected
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.CheckboxSample.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_checkbox        = new COMPONENT.Checkbox( dom_element.querySelector( ".shinken-cell-checkbox-container" ) );
        this.component_btn_default     = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.initSpecific();
    },
    initSpecific              : function ( dom_element ) {
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE:
                this.warning_counter.setTooltip( _( 'element.warning_show_history_range_and_hide_history' ), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                break;
            case PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE:
                this.warning_counter.setTooltip( _( 'element.warning_show_sla_range_and_hide_sla' ), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                break;
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    computeErrorsSpecifics    : function () {
        this.counter_temp_warning = 0;
        this.counter_temp_error   = 0;
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE:
                var _value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ).getFlatValue();
                if ( _value === PROPERTY.CONST.ACL_TYPE.SLA ) {
                    if ( this.isFlatValueOn() ) {
                        this.counter_temp_warning = 1;
                        break;
                    }
                }
                break;
            case PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE:
                var _value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ).getFlatValue();
                if ( _value === PROPERTY.CONST.ACL_TYPE.HISTORY ) {
                    if ( this.isFlatValueOn() ) {
                        this.counter_temp_warning = 1;
                        break;
                    }
                }
                break;
        }
    },
    askComputeAfterChange     : function () {
        this.setStateInheritance( false );
        this.component_checkbox.setCheckedUser();
        this._computeState();
    },
    clickOnRadioBtn           : function () {
        var _is_on = this.component_btn_default.isOn();
        if ( _is_on ) {
            return;
        }
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.ON );  //UTILE ??
        this._computeState();
    },
    clickOnCheckboxInput      : function () {
        var _value = !this.component_checkbox.isCheckedUser();
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _value = !this.component_checkbox.isCheckedDefault();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _value = this.component_btn_inheritance.isSet() ? !this.component_checkbox.isCheckedInheritance() : !this.component_checkbox.isCheckedDefault();
                break;
        }
        this.component_checkbox.setCheckedUser( _value );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAtMaximum      : function ( property ) {
        if ( property.isFlatValueOn() ) {
            return;
        }
        switch ( property.getName() ) {
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                var _value = property.getFlatValue();
                switch ( _value ) {
                    case PROPERTY.CONST.ACL_TYPE.HISTORY:
                        if ( this.name === PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE && this.isFlatValueOn() ) {
                            this.setValueFromUser( '0' );
                        }
                        break;
                    case PROPERTY.CONST.ACL_TYPE.SLA:
                        if ( this.name === PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE && this.isFlatValueOn() ) {
                            this.setValueFromUser( '0' );
                        }
                        break;
                }
                break;
            default:
                switch ( property.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.NONE:
                        if ( property.default_value === '1' ) {
                            return;
                        }
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        if ( property.inherited_value === '1' ) {
                            return;
                        }
                        break;
                    default:
                        if ( property.type === PROPERTY.CONST.TYPES.CHECKBOX_SINGLE && property.component_checkbox.isCheckedUser() ) {
                            return;
                        }
                }
                this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_checkbox.setCheckedUser( false );
                this._computeState();
                break;
        }
        this.checkErrorWarning();
    },
    synchronizeAtMinimum      : function ( property ) {
        if ( this.isFlatValueOn() ) {
            return;
        }
        switch ( property.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.NONE:
                if ( property.default_value === '0' ) {
                    return;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( property.inherited_value === '0' ) {
                    return;
                }
                break;
            default:
                if ( !property.component_checkbox.isCheckedUser() && !property.component_checkbox.isCheckedDefault() ) {
                    return;
                }
        }
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_checkbox.setCheckedUser( true );
        this._computeState();
        this.checkErrorWarning();
    },
    //********************************************  GET / SET ***********************************************//
    unset                     : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser          : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            case "0":
            case "1":
                this.component_checkbox.setCheckedUser( value );
                this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this._computeState();
                break;
        }
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                this.component_checkbox.setCheckedInheritance( this.inherited_value );
            }
            else {
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        this.setStateInheritance( this.state_inheritance );
        if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.component_btn_default.isOn() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return;
        if ( inherited_value === '1' ) {
            _to_return = _( "element.true" );
        }
        else {
            _to_return = _( "element.false" );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
        this._computeInheritedLabel();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    //********************************************  SAVE     *********************************************************//
    isFlatValueOn             : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return this.component_checkbox.isCheckedDefault();
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( this.component_btn_inheritance.isSet() ) {
                    return this.component_checkbox.isCheckedInheritance();
                }
                return this.component_checkbox.isCheckedDefault();
        }
        return this.component_checkbox.isCheckedUser();
    },
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return '';
        }
        var _to_return = this.component_checkbox.isCheckedUser() ? '1' : '0';
        return _to_return;
    }
};

PROPERTY.getInterfacePrototype( PROPERTY.CheckboxSample );
//******************************  END  checkbox-sample-prop.js   **************************

//******************************  START  data-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/data-prop.js *
'use strict';

PROPERTY.Data = function ( key, value, group_data ) {
    //uuid
    //name
    //dom_element
    //component_input_key
    //component_input
    //group_data
    this.value = value;
    if ( this.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
        this.custom_selected = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        this.value           = "";
    }
    this.inherited_data = null;
    this.type           = PROPERTY.CONST.TYPES.DATA;
    this.is_valid       = true;
    this.status         = PROPERTY.CONST.DATA.STATUS.NONE;
    this.setGroupData( group_data );
    this.setName( key );
    this.buildUUID();
    this._computeIsValid();
    this.timeout_ask_compute_after_change;
    this.timeout_ask_compute_after_change_key;
};

PROPERTY.Data.prototype = {
    init                       : function () {
        this.tab_parent_id = "id-shinken-window-datas";
        this._initDomElements();
        this._initErrorWarning();
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, this.dom_element, this.type );
        this._computeLabelBtnInheritance( this.inherited_data );
        this._computeValuePlaceholder();
        this.component_btn_inheritance.askUpdateHTML();
        this._computeState();
        if ( this.isDfeData() && this.state_inheritance && !this.component_input.original_value ) {
            this.component_input.original_value = this.getValueInherited();
        }
    },
    initWithDomElement         : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, this.dom_element, this.type );
        this.component_input           = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input" ), this );
        this._computeLabel();
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
        this._computeState();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange      : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.custom_selected = "";
        var self             = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            if ( self.component_input_protected && dom_element ) {
                var _tag = dom_element.tagName;
                switch ( _tag ) {
                    case 'TEXTAREA':
                        self.component_input_protected.dom_element.value = dom_element.value;
                        break;
                    case 'INPUT':
                        self.component_input.dom_element.value = dom_element.value;
                        break;
                }
            }
            self.component_input.setValue();
            self.setStateInheritance( !self.component_input.getValue() );
            if ( self.is_protected ) {
                self.setIsProtected( PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED );
            }
            self._computeState();
            MANAGER.__instance_macro_distributor.changeMacro( self, self.component_input.getValue() );
            fire_element_is_modifie();
            MANAGER.ListenerEventManager.afterActionProperty( self );
        }, 200 );
    },
    askComputeKeyAfterChange   : function () {
        if ( this.is_disabled ) {
            return;
        }
        if ( !this.is_editable_key ) {
            this.component_input_key.dom_element.value = this.component_input_key.current_value;
            return;
        }
        var self = this;
        if ( self.timeout_ask_compute_after_change_key ) {
            clearTimeout( self.timeout_ask_compute_after_change_key );
        }
        self.timeout_ask_compute_after_change_key = setTimeout( function () {
            var _old_name = self.name;
            self.component_input_key.setValue();
            self.setLabel( self.component_input_key.getValue() );
            self.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( self.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
            MANAGER.__instance_macro_distributor.renamedMacro( _old_name, self.name, self.component_input.getValue() );
            self.checkErrorWarning();
            fire_element_is_modifie();
            MANAGER.ListenerEventManager.afterActionProperty( self );
        }, 200 );
    },
    clickOnBtnInheritance      : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
        this.updateView();
        MANAGER.__instance_macro_distributor.changeMacro( this, this.state_inheritance ? this.getValueInherited() : this.component_input.getValue() );
    },
    delete                     : function () {
        this.resetWarningError();
        delete MANAGER.__instance_property_distributor.elements[ this.is_override ? this.name : this.uuid ];
        DOM.Service.removeElement( this.dom_element );
        MANAGER.__instance_macro_distributor.deleteMacroContent( this.name );
        App.Elements.ChecksTab.askInit( { data_change: true, property: this } );
        fire_element_is_modifie();
        
    },
    onFocus                    : function () {
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
            this.component_input.dom_element.value = "";
        }
    },
    onFocusOut                 : function () {
        var self = this;
        setTimeout( function () {
            if ( self.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
                self.component_input.dom_element.value = self.component_input.original_value;
            }
        }, 500 );
    },
    //********************************************  SETTER GETTER   **************************************************//
    isLocalData                : function () {
        if ( !this.group_data ) {
            return false;
        }
        return this.group_data.type === PROPERTY.CONST.DATA.GROUP.LOCALE;
    },
    isDfeData                  : function () {
        if ( !this.group_data ) {
            return false;
        }
        return this.group_data.type === PROPERTY.CONST.DATA.GROUP.DFE;
    },
    setGroupData               : function ( to_set ) {
        if ( this.isLocalData() && to_set.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            delete MANAGER.__instance_property_distributor.elements[ this.uuid ];
            this.uuid   = this.name;
            this.status = PROPERTY.CONST.DATA.STATUS.NONE;
            MANAGER.__instance_property_distributor.setElement( this.uuid, this );
        }
        if ( this.isDfeData() ) {
            return;
        }
        this.group_data = to_set;
        if ( this.group_data ) {
            this.group_data_uuid = this.group_data.uuid;
        }
    },
    setName                    : function ( to_set ) {
        this.name = to_set;
        if ( this.name ) {
            this._computeLabel();
        }
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
    },
    getLabel                   : function () {
        return this.label;
    },
    setLabel                   : function ( to_set ) {
        this.label = SHINKEN.TOOLS.STRING.toUpperCase( to_set );
        if ( !this.is_override ) {
            this.name = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL + this.label;
        }
    },
    setStatus                  : function ( to_set ) {
        this.status = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'status', this.status );
        }
    },
    getValueInherited          : function () {
        if ( !this.inherited_data ) {
            return "";
        }
        return SHINKEN.TOOLS.STRING.unescape_xss( this.inherited_data.value );
    },
    getFlatValue               : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.component_btn_inheritance.isSet() ? this.getValueInherited() : '';
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                return this.component_input.getValue();
        }
    },
    setInheritedData           : function ( to_set ) {
        this.inherited_data = to_set;
    },
    isProtected                : function () {
        return !!this.is_protected;
    },
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'isProtected', this.is_protected );
            this.component_input.setIsProtected( this.is_protected );
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance     : function () {
        if ( this.state_inheritance !== undefined ) {
            return;
        }
        var _value = this.getValue();
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            _value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        this.setStateInheritance( !_value );
        this.updateView();
    },
    _computeState              : function () {
        this._computeBtnInheritance();
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.getValue() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.computeWindowsDataCounter();
        this.checkErrorWarning();
    },
    _computeLabel              : function () {
        var _name = this.is_override ? this.override_prop_name : this.name;
        if ( SHINKEN.TOOLS.STRING.startsWith( _name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
            this.setLabel( _name.substr( 1 ) );
        }
        else {
            this.setLabel( _name );
        }
    },
    _computeValuePlaceholder   : function () {
        var _label = '';
        if ( this.inherited_data ) {
            if ( this.is_protected ) {
                _label = SHINKEN.TOOLS.ENCRYPTION.getLabelHidden();
            }
            else {
                _label = this.getValueInherited();
                if ( _label === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label = _( 'element.forced_default' );
                }
                _label += ' [ ' + _( 'element.in_template' ) + ' ' + this.inherited_data.template_name + ' ]';
            }
        }
        if ( _label ) {
            this.component_input.setPlaceholder( _label );
        }
    },
    _computeLabelBtnInheritance: function ( inherited_data ) {
        if ( !inherited_data ) {
            return false;
        }
        if ( this.is_protected ) {
            inherited_data.label = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
        }
        return this.component_btn_inheritance.setTemplateProperty( inherited_data );
    },
    _computeIsValid            : function () {
        switch ( this.name ) {
            case '_id':
            case '_ID':
            case '_SYNC_KEYS':
            case '__SYNC_IDX__':
            case '_SE_UUID':
            case '_SE_UUID_HASH':
                this.is_valid = false;
        }
    },
    _initDomElements           : function () {
        var _template = this.getTemplateHTML().outerHTML;
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$label", this.label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$value", this.value );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "shinken-hidden", "" );
        
        var _to_return = DOM.Service.createElement( "tbody", {}, _template );
        
        this.dom_element = _to_return.firstChild;
        this.dom_element.classList.add( PROPERTY.CONST.CLASS.SKINKEN_LINE );
        if ( !this.isLocalData() ) {
            this.dom_element.classList.add( 'shinken-hidden' );
        }
        
        if ( MANAGER.__instance_element_distributor.current_element.work_area_status === OBJECT.CONST.ELEMENT.WORK_AREA_STATUS.PROPOSED
             || MANAGER.__instance_element_distributor.current_element.editable === "0" ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        
        this.dom_element.dataset.status    = this.status;
        this.dom_element.dataset.name      = this.uuid;
        this.dom_element.dataset.groupType = this.group_data.type;
        this._computeIsEditableKey();
        this.dom_element.dataset.isProtected = this.is_protected;
        this.dom_element.removeAttribute( 'id' );
        this.component_input_key = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input-key" ), this );
        if ( this.isLocalData() && !this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated() ) {
            this.component_input           = new COMPONENT.Input( this.dom_element.querySelector( "textarea.shinken-input" ), this );
            this.component_input_protected = new COMPONENT.Input( this.dom_element.querySelector( "input.shinken-input" ), this );
            this.component_input_protected.setIsProtected( true );
        }
        else if ( this.is_protected ) {
            this.component_input = new COMPONENT.Input( this.dom_element.querySelector( "input.shinken-input" ), this );
            DOM.Service.removeElement( this.dom_element.querySelector( "textarea.shinken-input" ) );
        }
        else {
            this.component_input = new COMPONENT.Input( this.dom_element.querySelector( "textarea.shinken-input" ), this );
            DOM.Service.removeElement( this.dom_element.querySelector( "input.shinken-input" ) );
        }
        this.component_input.setIsProtected( this.is_protected );
        if ( this.modified_value_before_prop_use_modification ) {
            this.component_input.dom_element.value = this.modified_value_before_prop_use_modification;
            this.component_input.setValue();
            this.modified_value_before_prop_use_modification = "";
        }
        if ( this.isDfeData() ) {
            this.buildHtmlCheckDfe();
        }
    },
    computeWindowsDataCounter  : function () {
        if ( this.group_data ) {
            this.group_data.updateCounterWith( this.uuid, this.state );
        }
        if ( !this.is_override ) {
            return;
        }
        var _counter_user  = 0;
        var _counter_total = 1;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                _counter_user = 1;
                break;
        }
        var window = MANAGER.__instance_window_distributor.findParentWindow( this.override_check_uuid_final );
        window.list[ WINDOW.CONST.ELEMENT.DATAS + '-override' ].setCounterUserWithProperty( this.name, _counter_user, _counter_total );
    },
    _computeIsEditableKey      : function () {
        this.is_editable_key = true;
        if ( this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            this.is_editable_key = false;
        }
        else if ( this.is_protected ) {
            this.is_editable_key = false;
        }
        this.dom_element.dataset.editableKey = this.is_editable_key;
    },
    buildUUID                  : function () {
        if ( !this.group_data || this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            this.uuid = this.name;
        }
        else {
            this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        }
    },
    unset                      : function () {
        this.setValueFromUser( "" );
    },
    setValueFromUser           : function ( value ) {
        this.component_input.dom_element.value = value;
        this.askComputeAfterChange();
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  VALIDATION  *********************************************************//
    computeErrorsSpecifics     : function () {
        this.validateKeyInput();
        this.validateValueInput();
    },
    setErrorsSpecific          : function () {
        if ( !this.is_override && this.group_data.type === PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            switch ( this.component_input_key.status ) {
                case COMPONENT.CONST.STATUS.ERROR:
                    this.counter_temp_error++;
                    break;
                case COMPONENT.CONST.STATUS.WARNING:
                    this.counter_temp_warning++;
                    break;
            }
        }
        switch ( this.component_input.status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.counter_temp_error++;
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.counter_temp_warning++;
                break;
        }
        if ( this.group_data ) {
            this.group_data.setError( this.uuid, this.counter_temp_error );
            this.group_data.setWarning( this.uuid, this.counter_temp_warning );
        }
    },
    validateKeyInput           : function () {
        if ( this.component_input_key && !this.component_input_key.need_validation ) {
            return;
        }
        if ( this.is_override ) {
            return;
        }
        if ( this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            return;
        }
        var _result_validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( [ PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA ], this.component_input_key.getValue() );
        this.component_input_key.updateShinkenTooltip( _result_validator );
    },
    validateValueInput         : function () {
        if ( !this.component_input.need_validation ) {
            return;
        }
        var _to_set;
        this.component_input.setStatus( COMPONENT.CONST.STATUS.NONE );
        if ( this.is_override ) {
            _to_set = COMPONENT.CONST.STATUS.NONE;
            if ( this.dom_element.classList.contains( 'shinken-disabled-and-unknown' ) ) {
                if ( !this.dom_element.classList.contains( 'inherit-service-override' ) ) {
                    _to_set = COMPONENT.CONST.STATUS.WARNING;
                }
                else if ( this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE ) {
                    _to_set = COMPONENT.CONST.STATUS.WARNING;
                }
            }
            this.component_input.setStatus( _to_set );
        }
        else {
            switch ( this.group_data.type ) {
                case PROPERTY.CONST.DATA.GROUP.DFE:
                    var _value                                   = this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ? this.getValueInherited() : this.getValue();
                    App.DFE._duplicateSplittedValue[ this.name ] = App.DFE.validatorDFE( App.DFE.splitDFE( this.name, _value ) );
                    var _message                                 = App.DFE.setOutputDFE( App.DFE._duplicateSplittedValue[ this.name ], this.name, this.group_data.label );
                    _message.is_dfe                              = true;
                    
                    if ( this.component_input.original_value && this.getFlatValue() !== this.component_input.original_value ) {
                        var _messages_deleted = App.DFE.getMessageDeletedElements( App.DFE._duplicateSplittedValue[ this.name ]._dfe_elem, App.DFE.validatorDFE( App.DFE.splitDFE( this.name, this.component_input.original_value ) )._dfe_elem, this.list_check_link );
                        if ( _messages_deleted ) {
                            _message.property_name = this.name;
                            _message.addMessages( _messages_deleted );
                            _message.footer = _( 'element.tooltip_dfe_deleted_part_2' );
                        }
                    }
                    if ( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON ) {
                        var _status      = _message.getStatus();
                        var _parent_name = true;
                        if ( this.component_btn_inheritance.list_template_property ) {
                            _parent_name = this.component_btn_inheritance.list_template_property.template_name;
                        }
                        this.setInheritanceStatus( _status, _message.buildMessage( false, _parent_name ) );
                        if ( _status === COMPONENT.CONST.STATUS.ERROR ) {
                            this.counter_temp_error++;
                        }
                        else if ( _status === COMPONENT.CONST.STATUS.WARNING ) {
                            this.counter_temp_warning++;
                        }
                        this.component_input.updateShinkenTooltip( _message );
                    }
                    else {
                        this.setInheritanceStatus( "", "" );
                        this.component_input.updateShinkenTooltip( _message );
                    }
                    
                    break;
            }
            App.Elements.ChecksTab.askInit( { data_change: true, property: this } );
        }
    },
    
    //********************************************  OTHER  *********************************************************//
    getTemplateHTML  : function () {
        if ( !PROPERTY.CONST.data_template_html ) {
            PROPERTY.CONST.data_template_html = document.getElementById( 'shinken-element-property-line-data-template' );
        }
        return PROPERTY.CONST.data_template_html;
    },
    resetWarningError: function () {
        if ( this.group_data ) {
            this.group_data.setError( this.uuid, 0 );
            this.group_data.setWarning( this.uuid, 0 );
            this.group_data.updateCounterWith( this.uuid );
        }
        if ( this.is_override ) {
            var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( this.override_check_uuid_final );
            _parent_window.list[ WINDOW.CONST.ELEMENT.DATAS + '-override' ].setWarning( this.uuid );
            _parent_window.list[ WINDOW.CONST.ELEMENT.DATAS + '-override' ].setError( this.uuid );
            var _window = _parent_window.getElementByID( this.tab_parent_id );
            _window.setError( this.uuid, 0, this );
            _window.setWarning( this.uuid, 0, this );
        }
    },
    //********************************************  HELP    **********************************************************//
    mouseEnter       : function () {
        if ( !this.getLabel() ) {
            return;
        }
        MANAGER.HelpManager.setActive( this.name, this.getLabel(), this.isDfeData() ? 'element.tooltip_dfe_common' : 'element.help_text_data' );
    },
    //********************************************  VIEW    **********************************************************//
    updateView       : function () {
        this.component_input.updateView( this.state_inheritance );
    },
    buildHtmlCheckDfe: function () {
        var _checks_dfe       = MANAGER.__instance_element_distributor.getAllChecksDFE();
        var _checks_candidate = SHINKEN.TOOLS.ARRAY.filterWith( _checks_dfe, PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME, this.name );
        var _size             = _checks_dfe.length;
        var _size_candidate   = _checks_candidate.length;
        
        var counter          = this._drawCounter( _size_candidate, _size );
        var label            = (_size_candidate > 1) ? _( 'element.used_by_checks' ) : _( 'element.used_by_check' );
        var columnUsedHead   = '<p style="padding-left: 8px;">' + label + counter + '</p>';
        var counter_unused   = this._drawCounter( _size - _size_candidate, _size );
        var label_unused     = (_size - _size_candidate > 1) ? _( 'element.unused_by_checks' ) : _( 'element.unused_by_check' );
        var columnUnusedHead = (_size - _size_candidate) ? '<p style="padding-left: 8px; ">' + label_unused + counter_unused + '</p>' : '';
        
        var columnUsedContent   = '';
        var columnUnusedContent = '';
        var current_check;
        
        this.list_check_link = []; // Use for compute the warning message of deleted DFE checks when user change DFE data value
        for ( var i = 0; i < _size; i++ ) {
            current_check = _checks_dfe[ i ];
            var _label    = "";
            if ( !current_check.isEnabled() ) {
                _label = current_check.getName() + "<span class='shinken-warning'>" + _( "element.disabled" ) + "</span>";
            }
            if ( current_check[ PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ] === this.name ) {
                this.list_check_link.push( current_check.uuid );
                columnUsedContent += SHINKEN.TOOLS.buildLinkShinkenElement( current_check, _label, 'tag-check hide-if-collapse shinken-space' ).outerHTML;
            }
            else {
                columnUnusedContent += SHINKEN.TOOLS.buildLinkShinkenElement( current_check, _label, 'tag-check hide-if-collapse shinken-space' ).outerHTML;
            }
        }
        
        var _to_return = DOM.Service.createElement( "tr", { class: 'shinken-data-dfe-list-check-container shinken-collapse', onclick: 'MANAGER.EventManager.clickDataCollapseButton(this)' } );
        var _cell_1    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-used' }, columnUsedHead + columnUsedContent );
        var _cell_2    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-unused' }, columnUnusedHead + columnUnusedContent );
        var _cell_3    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-collapse' }, '<span class="shinken-dfe-collapse-btn"><span class="icon-white icon-plus-sign show-if-collapse"></span><span class="icon-white icon-minus-sign hide-if-collapse"></span></span>' );
        _to_return.appendChild( _cell_1 );
        _to_return.appendChild( _cell_2 );
        _to_return.appendChild( _cell_3 );
        
        this.dom_element.querySelector( '.shinken-element-property-line-data-table' ).appendChild( _to_return );
    },
    
    _drawCounter      : function ( value, total, className ) {
        className = (className) ? className : 'badge data-counter-active';
        var s     = '';
        if ( value != 0 ) {
            s = ' [ <span class="' + className + '">' + value + '</span> /' + total + ' ]';
        }
        else {
            s = ' [ ' + total + ' ]';
        }
        return s;
    },
    //********************************************  LIST CHECK    **********************************************************//
    setCollapseCheck  : function ( to_set ) {
        var _element = this.dom_element.querySelector( '.shinken-data-dfe-list-check-container' );
        if ( !_element ) {
            return;
        }
        if ( to_set ) {
            _element.classList.add( 'shinken-collapse' );
            _element.classList.remove( 'shinken-not-collapse' );
        }
        else {
            _element.classList.remove( 'shinken-collapse' );
            _element.classList.add( 'shinken-not-collapse' );
        }
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal: function () {
        if ( !this.is_valid ) {
            return "";
        }
        if ( this.name === PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) {
            return '';
        }
        var _to_return = this.getValue();
        if ( _to_return === "" && this.component_btn_inheritance.isSet() ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED && SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated() ) {
            return SHINKEN.TOOLS.STRING.b64Encode( _to_return );
        }
        return _to_return;
    }
};
PROPERTY.getInterfacePrototype( PROPERTY.Data );
//******************************  END  data-prop.js   **************************

//******************************  START  multi-line-object-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/multi-line-object-prop.js *
'use strict';

PROPERTY.MultiLine           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // rules
    // rules_mapping
    // type
    // component_input
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    // separator_line_html
    // is_set
    this.init( dom_element );
    this.timeout_ask_compute_after_change;
};
PROPERTY.MultiLine.prototype = {
    init                          : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.dom_template              = this.dom_element.querySelector( '.shinken-multi-line-object-template' );
        this.dom_container             = this.dom_element.querySelector( '.shinken-multi-line-object-container' );
        this.dom_output_cfg            = this.dom_element.querySelector( '.shinken-multi-line-object-stringify-result' );
        this.dom_cfg_inherited_label   = this.dom_element.querySelector( '.shinken-cfg-inherited-label-container' );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.getParentName(), dom_element, this.type );
        this.separator_line_saved      = dom_element.dataset.separatorLineSaved;
        this.separator_key_value_saved = dom_element.dataset.separatorKeyValueSaved;
        this.separator_line_html       = dom_element.dataset.separatorLineHtml;
        this.separator_key_value_html  = dom_element.dataset.separatorKeyValueHtml;
        this.line_type                 = dom_element.dataset.lineType;
        this.is_set                    = dom_element.dataset.isSet === "true";
        switch ( this.separator_line_html ) {
            case "BACK_TO_LINE":
                this.separator_line_html = "<br>";
                break;
        }
        if ( this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ) {
            this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-prop-cell-action .shinken-input" ), this );
        }
        this.initLines();
    },
    initLines                     : function () {
        this.lines_object          = [];
        this.lines_object_mapping  = {};
        var _existing_line_objects = this.dom_container.querySelectorAll( '.shinken-multi-line-object-row' );
        for ( var i = 0, _size_i = _existing_line_objects.length; i < _size_i; i++ ) {
            var _new_line_object;
            switch ( this.line_type ) {
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    _new_line_object = new COMPONENT.OutputRule( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    _new_line_object = new COMPONENT.UrlLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.PERIOD_ADVANCED_NAME:
                    _new_line_object = new COMPONENT.KeyValueLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.PERIOD_DAY_NAME:
                    _new_line_object = new COMPONENT.TimePeriodDayLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
            }
            var _index                                         = this.lines_object.push( _new_line_object );
            this.lines_object_mapping[ _new_line_object.uuid ] = _index - 1;
        }
        this.computeValue();
    },
    rebuildMapping                : function () {
        this.lines_object_mapping = {};
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            this.lines_object_mapping[ this.lines_object[ i ].uuid ] = i;
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnAddLine                : function () {
        var _to_add = DOM.Service.cloneElement( this.dom_template, { class: "shinken-multi-line-object-row" } );
        this.dom_container.appendChild( _to_add );
        var _new_line;
        switch ( this.line_type ) {
            case PROPERTY.CONST.NAME.OUTPUT_RULES:
                _new_line = new COMPONENT.OutputRule( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                _new_line = new COMPONENT.UrlLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.PERIOD_ADVANCED_NAME:
                _new_line = new COMPONENT.KeyValueLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.PERIOD_DAY_NAME:
                _new_line = new COMPONENT.TimePeriodDayLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
        }
        var _index                                  = this.lines_object.push( _new_line );
        this.lines_object_mapping[ _new_line.uuid ] = _index - 1;
        this.setStateInheritance( !this.lines_object.length );
        this.computeValue();
        return _new_line;
    },
    clickOnSelector               : function ( event ) {
        var _line_object = this.getLineObjectViaChildrenElement( event.target );
        if ( !_line_object ) {
            return;
        }
        _line_object.clickOnSelector( DOM.Service.findParentElementWithClass( event.target, "shinken-select-container", 10 ).dataset.name );
        this.hidePopup( _line_object.uuid );
    },
    clickOnItemSelector           : function ( key_name, element ) {
        var _line_object = this.getLineObjectViaChildrenElement( element );
        if ( !_line_object ) {
            return;
        }
        _line_object.clickOnItemSelector( key_name, element.dataset.state );
        this.computeValue();
    },
    askComputeAfterChange         : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( dom_element.classList.contains( 'shinken-is-main-input' ) ) {
            this.askComputeAfterChangeMainInput();
        }
        else {
            var _line_object = this.getLineObjectViaChildrenElement( dom_element );
            _line_object.askComputeAfterChange( dom_element, this );
        }
    },
    askComputeAfterChangeMainInput: function () {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.component_input.setValue();
            self.component_input.validateValueInput();
            self.computeValue();
            MANAGER.ListenerEventManager.afterActionProperty( self );
        }, 200 );
    },
    deleteLine                    : function ( dom_element ) {
        var _line_object = this.getLineObjectViaChildrenElement( dom_element );
        if ( !_line_object ) {
            return;
        }
        _line_object.delete();
        var _index = this.lines_object_mapping[ _line_object.uuid ];
        this.lines_object.splice( _index, 1 );
        this.rebuildMapping();
        this.setStateInheritance( !this.lines_object.length );
        this.computeValue();
    },
    deleteAllLines                : function () {
        for ( var i = this.lines_object.length - 1; i >= 0; i-- ) {
            this.deleteLine( this.lines_object[ i ].dom_element );
        }
    },
    ////********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance        : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.value;
        this.setStateInheritance( _is_inheritable );
    },
    _computeState                 : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            _to_set = this.lines_object.length ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.value && !this.lines_object.length ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    computeValue                  : function () {
        this.value = "";
        var _current_value;
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            _current_value = this.lines_object[ i ].getValue();
            if ( _current_value === "" ) {
                continue;
            }
            if ( this.value ) {
                this.value += this.separator_line_saved;
            }
            this.value += _current_value;
        }
        
        if ( this.component_input ) {
            this.value = this.value ? this.component_input.getValue() + this.separator_line_saved + this.value : this.component_input.getValue();
        }
        if ( this.dom_output_cfg ) {
            this.updateCfgDomElement();
        }
        this._computeState();
        this.computeIsSet();
    },
    updateCfgDomElement           : function () {
        if ( !this.dom_output_cfg ) {
            return;
        }
        var _to_write = "";
        if ( this.component_input ) {
            _to_write += this.component_input.getValue();
            if ( this.lines_object.length ) {
                _to_write += this.separator_line_html;
            }
        }
        
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            if ( i ) {
                _to_write += this.separator_line_html;
            }
            _to_write += this.lines_object[ i ].getCfgValue();
        }
        this.dom_output_cfg.innerHTML = _to_write;
    },
    computeIsSet                  : function () {
        this.is_set = !!this.lines_object.length;
        DOM.Service.setDataSet( this.dom_element, 'isSet', this.is_set );
    },
    _updateCfgInheritedLabel      : function ( inherited_value ) {
        var _span_property_name = DOM.Service.createElement( 'span', { class: 'shinken-multi-line-object-stringify-property' }, this.name );
        var _span_value         = DOM.Service.createElement( 'span', { class: 'shinken-multi-line-object-inherited-value' }, inherited_value );
        this.dom_cfg_inherited_label.appendChild( _span_property_name );
        this.dom_cfg_inherited_label.appendChild( _span_value );
    },
    
    ////********************************************  VALIDATION      **************************************************//
    setErrorsSpecific              : function () {
        //if (this.component_input) {
        //    this.counter_temp_error += this.component_input.error_number;
        //    this.counter_temp_warning += this.component_input.warning_number;
        //}
    },
    ////********************************************  SETTER GETTER   **************************************************//
    getLineObjectViaChildrenElement: function ( dom_element ) {
        var _dom_line_object = DOM.Service.findParentElementWithClass( dom_element, "shinken-multi-line-object-row", 20 );
        if ( !_dom_line_object ) {
            return null;
        }
        var _to_return = this.getLineObjectViaUUID( _dom_line_object.dataset.uuid );
        return _to_return || null;
    },
    getLineObjectViaUUID           : function ( uuid ) {
        var _index = this.lines_object_mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.lines_object[ _index ];
    },
    unset                          : function () {
        this.deleteAllLines();
    },
    updateWithTemplateSpecific     : function () {
        this._computeState();
    },
    setValueFromUser               : function ( value ) {
        this.deleteAllLines();
        
        var _lines = value.split( this.separator_line_saved );
        if ( this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ) {
            this.component_input.dom_element.value = _lines[ 0 ];
            this.askComputeAfterChange( this.component_input.dom_element );
            _lines.splice( 0, 1 );
        }
        
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            if ( _lines[ i ] ) {
                var __new_line = this.clickOnAddLine();
                __new_line.setValueFromUser( _lines[ i ] );
            }
        }
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                      : function ( _uuid_exception ) {
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            if ( this.lines_object[ i ].uuid !== _uuid_exception ) {
                this.lines_object[ i ].hidePopup();
            }
        }
    },
    ////********************************************  SAVE     *********************************************************//
    getDataToSaveFinal             : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return '';
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
            default:
                return this.value || '';
        }
    }
};

PROPERTY.getInterfacePrototype( PROPERTY.MultiLine );
//******************************  END  multi-line-object-prop.js   **************************

//******************************  START  multi-select-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/multi-select-prop.js *
'use strict';

PROPERTY.MultiSelect           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // default_value
    // type
    // component_select
    // component_btn_inheritance
    // state
    // state_plus
    // state_inheritance
    // inherited_value
    // default_value
    // default_label
    // none_label
    // limit_rest
    // is_limit_reached
    // last_list_element_selected
    // has_everybody_default
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.MultiSelect.prototype = {
    init                           : function ( element ) {
        this.initDomElement( element );
        this.state_plus                = SHINKEN.DOM.getDataInteger( element, 'statePlus' );
        this.has_plus                  = this.state_plus !== COMPONENT.CONST.BTN_STATE.DISABLED;
        this.component_select          = new COMPONENT.Select( element, PROPERTY.CONST.TYPES.MULTI_SELECT, this.is_override, this.name );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, element, this.type );
        this.limit_rest                = 0;
        this.is_limit_reached          = false;
        this.component_btn_inheritance.setHasArborescence( this.has_plus );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    setErrorsSpecific              : function () {
        this.counter_temp_error   = this.component_select.getErrors( this.state, this.name ) || 0;
        this.counter_temp_warning = this.component_select.getWarnings( this.state, this.name ) || 0;
    },
    clickOnBtnPlus                 : function () {
        if ( this.is_disabled ) {
            return false;
        }
        var _to_set;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _to_set = COMPONENT.CONST.BTN_STATE.OFF;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                _to_set = COMPONENT.CONST.BTN_STATE.DISCREET;
                break;
            default:
                _to_set = COMPONENT.CONST.BTN_STATE.ON;
                break;
            
        }
        this.setStatePlus( _to_set );
        this.updateView();
    },
    clickOnSelector                : function () {
        if ( this.is_disabled ) {
            return false;
        }
        this.component_select.clickOnSelector();
    },
    clickOnAllItemsSelector        : function ( limit ) {
        var _keys = Object.keys( this.component_select.list_element.list_mapping );
        var _size = _keys.length;
        if ( limit && _size > limit ) {
            _size = limit;
        }
        var _current_key;
        for ( var i = 0; i < _size; i++ ) {
            _current_key = _keys[ i ];
            switch ( _current_key ) {
                case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    break;
                default:
                    this.clickOnItemSelector( _current_key );
            }
        }
    },
    clickOnItemSelector            : function ( key_name ) {
        if ( this.is_disabled || !key_name ) {
            return false;
        }
        this.setLastItemSelected( key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.component_select.cleanAllTags();
                this.component_select.cleanAllItemsSelected();
                this.state_plus = COMPONENT.CONST.BTN_STATE.DISCREET;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.ON;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.ON;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                this.component_select.cleanAllTags();
                this.state_plus = this.is_override ? COMPONENT.CONST.BTN_STATE.DISCREET : COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.component_select.cleanAllTags();
                this.state_plus = this.is_override ? COMPONENT.CONST.BTN_STATE.DISCREET : COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            default:
                if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                    this.component_select.cleanAllTags();
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                }
                this.component_select.clickOnItemSelector( this.name, key_name );
        }
        this.updateView();
        DOM.Service.setDataSet( this.dom_element, 'lastSelected', this.last_list_element_selected );
        return true;
    },
    clickOnDeleteItemSelector      : function ( key_name, synchronise ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.component_select.clickOnDeleteItemSelector( key_name );
        var _first_tag_remaining = this.component_select.getActiveListForUser().getTagByIndex( 0 );
        if ( _first_tag_remaining ) {
            this.setLastItemSelected( _first_tag_remaining.element.name );
        }
        else if ( this.is_override ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE );
            this.setStatePlus( COMPONENT.CONST.BTN_STATE.DISCREET );
        }
        else {
            this.setLastItemSelected( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ? PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
        }
        this.updateView();
    },
    specificTreatment              : function () {
        this.is_all_selection_disabled = false;
        var _tag_information_status    = COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
        var _name                      = this.is_override ? this.override_prop_name : this.name;
        switch ( _name ) {
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
            case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
            case PROPERTY.CONST.NAME.ESCALATIONS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
                if ( this.hasInvalidElementForProduction() ) {
                    _tag_information_status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER;
                }
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                var _is_all_disabled = this.isAllElementsSelectedDisabled();
                if ( this.has_everybody_default ) {
                    if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ||
                         this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
                         this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ||
                         _is_all_disabled ) {
                        if ( _is_all_disabled ) {
                            this.is_all_selection_disabled = true;
                        }
                        var _property_group = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
                        if ( _property_group.getValueAndValueInherited() ) {
                            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.USER_GROUP_COHERENCY );
                            return;
                        }
                        else if ( _is_all_disabled ) {
                            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED );
                            return;
                        }
                    }
                }
                break;
            case PROPERTY.CONST.NAME.PARENTS:
                var _tags_inherited = this.component_select.list_elements_inherited.tags;
                var _size           = _tags_inherited.length;
                var _current;
                var _current_name;
                if ( this.state_inheritance ) {
                    for ( var i = 0; i < _size; i++ ) {
                        _current      = _tags_inherited[ i ];
                        _current_name = _current.getName();
                        if ( _current_name === MANAGER.__instance_element_distributor.current_element.getName() ) {
                            _current.addClass( 'tag-error' );
                            _current.setMessageTooltip( _( 'element.tooltip_infinity_loop' ) );
                            _current.setState( COMPONENT.CONST.TAG.STATE.UNKNOWN );
                        }
                    }
                }
                if ( this.hasInvalidElementForProduction() ) {
                    _tag_information_status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER;
                }
                break;
        }
        this.tag_information.setStatus( _tag_information_status );
    },
    updateAllTemplatesCustonmTags  : function ( templates_properties ) {
        if ( !templates_properties ) {
            return;
        }
        var _size = templates_properties.length;
        var _current;
        var _current_tag;
        var _size_tags;
        for ( var i = 0; i < _size; i++ ) {
            _current   = templates_properties[ i ];
            _size_tags = _current.tags.length;
            for ( var j = 0; j < _size_tags; j++ ) {
                _current_tag = _current.tags[ j ];
                if ( _current_tag.isDefaultTag() ) {
                    _current_tag.updateTagWithNoneTags( this.default_label );
                }
                else if ( _current_tag.isNullTag() ) {
                    _current_tag.updateTagWithNoneTags( this.none_label );
                }
            }
        }
        
    },
    updateWithTemplateSpecific     : function () {
        if ( this.component_btn_inheritance.isSet() ) {
            this.component_select.updateWithTemplateSpecific( this.component_btn_inheritance.getTags() );
        }
        this.updateView();
    },
    clickOnBtnInheritance          : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                this.setStateInheritance( false );
                break;
            default:
                this.setStateInheritance( true );
                break;
        }
        if ( this.state_inheritance ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.component_select.list_element_selected.hasUserTag() ) {
                var _last_element_selected = this.component_select.list_element.getFirstSelectedElement();
                this.setLastItemSelected( _last_element_selected.element.name );
            }
            else {
                this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
        }
        this.updateView();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStatePlus                   : function ( to_set ) {
        this.state_plus = to_set;
    },
    getValueInherited              : function () {
        return this.component_select.list_elements_inherited.getValue();
    },
    getValueAndValueInherited      : function () {
        var _to_return;
        var _value     = "";
        var _inherited = "";
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _value     = this.getValue();
                _inherited = this.getValueInherited();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _inherited = this.getValueInherited();
                break;
            default :
                _value = this.getValue();
                break;
        }
        _to_return = _value;
        if ( _value && _inherited ) {
            _to_return += ',';
        }
        _to_return += _inherited;
        return _to_return;
    },
    isSetOrIsSetHerited            : function () {
        if ( this.component_select.isSet() ) {
            return true;
        }
        if ( this.component_btn_inheritance.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return false;
        }
        return this.component_select.list_elements_inherited.hasUserTag();
    },
    unset                          : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser               : function ( value ) {
        this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.NONE );
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( value, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ) {
            value = value.substr( 1 );
            this.clickOnBtnPlus();
        }
        var _values = value.split( ',' );
        for ( var i = 0, _size = _values.length; i < _size; i++ ) {
            this.clickOnItemSelector( _values[ i ] );
        }
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    isAllElementsSelectedDisabled  : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                return this.component_select.isAllElementsSelectedDisabled();
        }
        return false;
    },
    hasInvalidElementForProduction : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                return this.component_select.hasInvalidElementForProduction();
        }
        return false;
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                      : function () {
        this.component_select.hidePopup();
    },
    updateView                     : function () {
        this._computeState();
        this.specificTreatment();
        this._computeLimitReached();
        this._computeLabelSelect();
        this.checkErrorWarning();
    },
    finalActionAfterOverrideLoading: function () {
        if ( !this.is_override ) {
            return;
        }
        var _check          = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override_check_uuid );
        var _value_on_check = _check.getValuesSplitted( this.override_prop_name );
        var _tag;
        var _current;
        for ( var i = 0, _size_i = _value_on_check.length; i < _size_i; i++ ) {
            _current = _value_on_check[ i ];
            _current = this.component_select.list_element.getElement( _current );
            switch ( _current.name ) {
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    this.dom_element.querySelector( '.shinken-value-from-check' ).appendChild( DOM.Service.createElement( 'span', {}, _current.getLabel() ) );
                    break;
                default:
                    _tag = new COMPONENT.Tag();
                    _tag.setElement( _current );
                    _tag.buildHTML();
                    this.dom_element.querySelector( '.shinken-value-from-check' ).appendChild( DOM.Service.createElement( 'div', { class: 'droppable' }, _tag.dom_element.outerHTML ) );
            }
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance         : function () {
        if ( this.state ) {
            return;
        }
        if ( this.is_not_heritable ) {
            return;
        }
        if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            return;
        }
        var _is_set = this.component_select.isSet();
        if ( _is_set ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        else {
            switch ( this.custom_selected ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                    break;
                default:
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    _computeState                  : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                if ( !this.state_plus && !this.component_select.isSet() ) {
                    _to_set                         = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    this.last_list_element_selected = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                break;
        }
        if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
            _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER;
        }
        this.setState( _to_set );
    },
    _computeLabelSelect            : function () {
        if ( this.is_override && this.is_disabled ) {
            return;
        }
        var _title_to_set = _( 'element.selected_values' );
        var _element_list;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                var _inherited_tag = this.component_btn_inheritance.getTags()[ 0 ];
                switch ( _inherited_tag.getName() ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        _element_list = this.component_select.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE );
                        _title_to_set = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, _element_list.getLabel() );
                        break;
                    default:
                        _element_list = this.component_select.list_element.getElement( this.last_list_element_selected );
                        _title_to_set = _element_list.getLabel();
                        break;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _element_list = this.component_select.list_element.getElement( this.last_list_element_selected );
                _title_to_set = _element_list.getLabel();
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                if ( this.component_btn_inheritance.isSet() ) {
                    this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
                }
                _element_list = this.component_select.list_element.getElement( this.last_list_element_selected );
                _title_to_set = _element_list.getLabel();
                break;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER ) {
            _element_list = this.component_select.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE );
            _title_to_set = _element_list.getLabel();
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS ) {
            _element_list = this.component_select.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE );
            _title_to_set = _element_list.getLabel();
        }
        if ( this.is_all_selection_disabled ) {
            if ( this.is_override ) {
                _title_to_set = "<span>" + _( 'element.in_check' ) + "</span>&nbsp;&nbsp;" + "<span class='shinken-only-disabled-tags'>" + _( 'element.selected_values_disabled' ) + "</span>";
            }
            else {
                _title_to_set = "<span>" + _( 'element.default' ) + "<span class='shinken-between-bracket shinken-default-label'>" + this.none_label + "</span></span>&nbsp;&nbsp;" + "<span class='shinken-only-disabled-tags'>" + _( 'element.selected_values_disabled' ) + "</span>";
            }
        }
        _title_to_set = '<span class="shinken-multiselect-title">' + _title_to_set + '</span>';
        if ( this.is_limit_reached ) {
            var _title_option = ' ( ' + _( 'element.maximum_of' ) + ' ' + this.component_select.getMaximumSelected() + ' ' + _( 'element.reached' ) + ' )';
            _title_to_set += DOM.Service.createElement( 'span', {}, _title_option ).outerHTML;
            this.component_select.addClassLimit();
        }
        else {
            this.component_select.removeClassLimit();
        }
        this.component_select.setTitle( _title_to_set );
    },
    _computeLimitReached           : function () {
        if ( !this.component_select.getMaximumSelected() ) {
            return;
        }
        var limit = -1;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                limit = this.component_select.isLimitReached();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                limit = this.component_select.isLimitReachedForSelected();
                break;
        }
        
        this.limit_rest       = limit;
        this.is_limit_reached = limit >= 0;
        this.component_select.disabledTagsOutOfLimit( this.limit_rest );
    },
    //************************************************  INHERITANCE **************************************************//
    setStateInheritanceSpecific    : function () {
        if ( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.state_plus = COMPONENT.CONST.BTN_STATE.OFF;
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE && this.component_btn_inheritance.isSet() ) {
                this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
        }
    },
    cleanBeforeUpdate              : function () {
        this.component_select.list_elements_inherited.emptyList();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAtMinimum           : function ( property ) {
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                if ( this.isSetOrIsSetHerited() ) {
                    break;
                }
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                var _view_contact = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
                if ( _view_contact.has_everybody_default ) {
                    switch ( _view_contact.last_list_element_selected ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            return;
                    }
                }
                break;
        }
        
        switch ( property.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                this.clickOnItemSelector( property.last_list_element_selected );
                return;
        }
        if ( property.state_plus === COMPONENT.CONST.BTN_STATE.ON && this.state_plus === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnBtnPlus();
        }
        if ( property.state_inheritance && !this.state_inheritance ) {
            if ( this.component_select.isSet() ) {
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                        break;
                    default:
                        this.clickOnBtnPlus();
                        break;
                }
            }
            else {
                this.clickOnBtnInheritance();
            }
        }
        var _missings = this.component_select.getMissingItemSelectorWith( property );
        var _size     = _missings.length;
        
        if ( !property.state_inheritance && this.state_inheritance && _size && this.state_plus === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnBtnPlus();
        }
        
        for ( var i = 0; i < _size; i++ ) {
            this.clickOnItemSelector( _missings[ i ] );
        }
    },
    synchronizeAtMaximum           : function ( property ) {
        if ( property.has_everybody_default ) {
            switch ( property.last_list_element_selected ) {
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    return;
            }
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                return;
        }
        switch ( property.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.clickOnItemSelector( property.last_list_element_selected );
                return;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.clickOnItemSelector( this.component_btn_inheritance.isSet() ? property.last_list_element_selected : PROPERTY.CONST.CUSTOM_SELECT.NONE );
                return;
        }
        var _extras = this.component_select.getExtraItemSelectorWith( property );
        var _size   = _extras.length;
        
        for ( var i = 0; i < _size; i++ ) {
            this.clickOnDeleteItemSelector( _extras[ i ], true );
        }
        switch ( property.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
                    this.clickOnBtnPlus();
                }
                if ( !this.component_select.isSet() && this.component_btn_inheritance.isSet() ) {
                    this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
                }
                else if ( this.component_select.isSet() && this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
        }
        
    },
    //********************************************  DRAGGING *********************************************************//
    resetDragging                  : function () {
        fire_element_is_modifie();
        this.dom_element.classList.remove( 'dragging-on' );
        this.component_select.resetDragging();
        if ( this.name === PROPERTY.CONST.NAME.USE ) {
            MANAGER.ListenerEventManager.afterActionGlobal( this );
        }
    },
    dragStartShinken               : function ( type_element, key_name ) {
        this.dom_element.classList.add( 'dragging-on' );
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.component_select.dragStartShinken( type_element, key_name );
        }
    },
    //********************************************  FILTER   *********************************************************//
    doFilter                       : function ( filter ) {
        this.component_select.doFilter( filter );
    },
    cleanFilter                    : function () {
        this.component_select.cleanFilter();
    },
    //********************************************  KEY EVENT   ******************************************************//
    keydown                        : function ( event ) {
        var key = event.keyCode;
        switch ( key ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.component_select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.component_select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.component_select.validAutoSelect();
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.SPACE:
                if ( this.name === PROPERTY.CONST.NAME.USE ) {
                    event.preventDefault();
                    event.stopPropagation();
                    this.addTagWithFilterName();
                }
                break;
        }
    },
    //********************************************  SPECIFIC   ******************************************************//
    addTagWithFilterName           : function () {
        var _name = SHINKEN.TOOLS.STRING.removeXss( this.component_select.list_element.current_filter );
        _name     = SHINKEN.TOOLS.STRING.trim( _name );
        if ( !_name ) {
            return;
        }
        var _element = this.component_select.validOrCreateTag( _name, this.name );
        if ( _element.is_selected ) {
            console.warn( "[already selected]", _element );
        }
        else {
            this.clickOnItemSelector( _element.getName() );
            MANAGER.ListenerEventManager.afterActionProperty( this );
        }
        this.component_select.pulsateTag( _element.getName() );
        this.component_select.list_element.current_filter = "";
        this.hidePopup();
        this.cleanFilter();
    },
    //********************************************  SAVE     *********************************************************//
    getSplittedValueUser           : function () {
        return this.value;
    },
    getDataToSaveFinal             : function () {
        var _to_return      = {};
        _to_return.links    = this.component_select.getValueToSave();
        _to_return.has_plus = (this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER || this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS);
        return _to_return;
    },
    getDataToSave                  : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return this.last_list_element_selected;
        }
        return this.getDataToSaveFinal();
    }
};
PROPERTY.getInterfacePrototype( PROPERTY.MultiSelect );
//******************************  END  multi-select-prop.js   **************************

//******************************  START  range-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/range-prop.js *
'use strict';

PROPERTY.Range           = function ( dom_element ) {
    // active
    // dom_element
    // name
    // value
    // inherited_value
    // default_value
    // is_null_value
    // type
    // component_input_range
    // component_btn_default
    // component_btn_inheritance
    // state
    // state_inheritance
    // tab_parent_id
    // error_counter
    // warning_counter
    this.init( dom_element );
};
PROPERTY.Range.prototype = {
    init                        : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input_range = new COMPONENT.InputRange( dom_element, this.name );
        this.component_btn_default = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        if ( this.is_override ) {
            this.component_btn_no_override = new COMPONENT.Button( dom_element.querySelector( ".shinken-no-override-btn" ) );
        }
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onMoveRangeCursor           : function ( value_to_set, event ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input_range.setValueFromUser( value_to_set );
        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        if ( event || value_to_set !== null ) {
            this._computeState();
        }
    },
    clickOnRadioBtn             : function ( value ) {
        if ( this.is_disabled ) {
            return;
        }
        var _value_to_set;
        switch ( value ) {
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                var _btn_status = this.component_btn_default.getState();
                switch ( _btn_status ) {
                    case 0:
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        _value_to_set = this.component_btn_default.getValue();
                        break;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                var _btn_status = this.component_btn_no_override.getState();
                switch ( _btn_status ) {
                    case 0:
                        this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        _value_to_set = this.component_btn_no_override.getValue();
                        break;
                    case 1:
                        break;
                }
                break;
        }
        this.component_input_range.setValue( _value_to_set );
        this._computeState();
    },
    changeDefaultButtonStatus   : function ( value ) {
        this.component_btn_default.setState( value );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', value );
        if ( this.is_override ) {
            this.component_btn_no_override.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
    },
    changeNoOverrideButtonStatus: function ( value ) {
        this.component_btn_no_override.setState( value );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.OFF );
    },
    clickOnBtnInheritance       : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance      : function () {
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_SET ) {
            return;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT ) {
            if ( this.component_btn_inheritance.isSet() ) {
                return;
            }
        }
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                this.component_input_range.setValue( this.inherited_value );
            }
        }
    },
    updateWithTemplateSpecific  : function () {
        this._computeState();
        this._computeInheritedLabel();
    },
    _computeState               : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.component_btn_no_override.isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( this.component_btn_default.isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else {
            if ( this.component_btn_default.isOn() ) {
                _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    _computeInheritedLabel      : function ( inherited_value ) {
        var _to_return;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        inherited_value = this.default_value;
                        break;
                }
                _to_return = inherited_value + this.component_input_range.unit;
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        return _( "element.business_impact_" + this.default_value );
                }
                _to_return = _( "element.business_impact_" + inherited_value );
                break;
        }
        return _to_return;
    },
    //********************************************  GET / SET  **************************************************//
    unset                       : function () {
        this.setValueFromUser( "" );
    },
    setValueFromUser            : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnRadioBtn( value );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            default:
                this.onMoveRangeCursor( parseInt( value ) );
                break;
        }
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  INHERITANCE **************************************************//
    setStateInheritanceSpecific : function () {
        var _value_to_set;
        if ( this.state_inheritance ) {
            _value_to_set = this.inherited_value;
        }
        else if ( this.component_btn_default.isOn() ) {
            _value_to_set = this.component_btn_default.getValue();
        }
        else {
            _value_to_set = this.component_input_range.getValueFromUser();
        }
        this.component_input_range.setValue( _value_to_set );
    },
    //********************************************  VALIDATION  *********************************************************//
    setErrorsSpecific           : function () {
        this.counter_temp_error = 0;
        if ( this.name === PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ) {
            MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ).checkErrorWarning();
            return;
        }
        if ( this.override_prop_name === PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ) {
            var _high_threshold = MANAGER.__instance_property_distributor.getElement( PROPERTY.BuildOverrideName( PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD, this ) );
            if ( _high_threshold ) {
                _high_threshold.checkErrorWarning();
            }
            return;
        }
        if ( this.name === PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ) {
            var _high_value = this.component_input_range.getValue();
            var _low_value  = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ).component_input_range.getValue();
            if ( parseInt( _high_value ) < parseInt( _low_value ) ) {
                this.counter_temp_error = 1;
            }
        }
        else if ( this.override_prop_name === PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ) {
            var _high_value = this.component_input_range.getValue();
            var _low_value  = MANAGER.__instance_property_distributor.findElement( PROPERTY.BuildOverrideName( PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD, this ) ).component_input_range.getValue();
            if ( parseInt( _high_value ) < parseInt( _low_value ) ) {
                this.counter_temp_error = 1;
            }
        }
        if ( this.counter_temp_error ) {
            this.counter_error_tooltip = _( "element.incoherent_flapping_values" );
        }
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAtMinimum        : function ( property ) {
        var _property_value = parseInt( property._computeValueForSynchronize() );
        var _current_value  = parseInt( this.component_input_range.getValue() );
        if ( _current_value < _property_value ) {
            this.onMoveRangeCursor( _property_value );
        }
    },
    synchronizeAtMaximum        : function ( property ) {
        var _property_value = parseInt( property._computeValueForSynchronize() );
        var _current_value  = parseInt( this.component_input_range.getValue() );
        if ( _current_value > _property_value ) {
            this.onMoveRangeCursor( _property_value );
        }
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal          : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return '';
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        return this.getValue();
    }
};
PROPERTY.getInterfacePrototype( PROPERTY.Range );
//******************************  END  range-prop.js   **************************

//******************************  START  single-select-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/single-select-prop.js *
'use strict';

PROPERTY.SingleSelect           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // inherited_value
    // custom_selected
    // type
    // component_select
    // component_btn_default
    // component_btn_inheritance
    // state
    // state_inheritance
    // tab_parent_id
    // error_counter
    // warning_counter
    this.init( dom_element );
};
PROPERTY.SingleSelect.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_select          = new COMPONENT.Select( dom_element, PROPERTY.CONST.TYPES.SINGLE_SELECT );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.component_select.buildLinkOpenNewTab( this.item_type, this.link_id );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    setErrorsSpecific         : function () {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
        var _selected_element;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            default:
                _selected_element = this.component_select.getLastSelectedElement();
                break;
        }
        if ( _selected_element ) {
            this.counter_temp_error = _selected_element.element.getError();
        }
        this.tag_information.setStatus( this.counter_temp_error ? COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE );
    },
    clickOnSelector           : function () {
        this.component_select.clickOnSelector();
    },
    clickOnItemSelector       : function ( key_name ) {
        this.setLastListElementSelected( key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            default:
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_select.clickOnItemSelector( this.name, key_name );
        }
        this.component_select.buildLinkOpenNewTab( this.item_type, this.link_id );
        this.updateView();
        return true;
    },
    clickOnBtnInheritance     : function () {
        this.setStateInheritance( !this.state_inheritance );
        if ( this.state_inheritance ) {
            this.setLastListElementSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE && !this.component_select.last_selected_key_name ) {
                this.component_select.clickOnItemSelector( this.name, PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
            this.setLastListElementSelected( this.component_select.getLastSelectedElementName() );
        }
        this._computeState();
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        var _value        = this.component_select.getValue();
        var _is_inherited = (this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE && !_value);
        
        if ( _is_inherited ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
    },
    _computeState             : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
        }
        this.setState( _to_set );
        this._computeLabelSelect();
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return = inherited_value;
        if ( this.getName() === PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ) {
            _to_return = _( 'element.' + inherited_value );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this.updateView();
    },
    //********************************************  GET / SET    **********************************************************//
    setLastListElementSelected: function ( to_set ) {
        this.setLastItemSelected( to_set );
        this.link_id = '';
        if ( this.last_list_element_selected ) {
            var _selected_element = this.component_select.list_element.getListSelectElement( this.last_list_element_selected ).getElement();
            if ( _selected_element.uuid ) {
                this.link_id = _selected_element.uuid;
                this.link_id += _selected_element.state === COMPONENT.CONST.TAG.STATE.NEW ? "?new=1" : '';
            }
        }
        DOM.Service.setDataSet( this.dom_element, 'linkId', this.link_id );
    },
    unset                     : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser          : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        this.clickOnItemSelector( value );
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    getValueInherited         : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                 : function () {
        this.component_select.hidePopup();
    },
    updateView                : function () {
        this._computeState();
    },
    _computeLabelSelect       : function () {
        var _title_to_set;
        var _element_list;
        var _selected_element;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                _element_list                              = this.component_select.list_element.getElement( this.last_list_element_selected );
                _title_to_set                              = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, this.component_btn_inheritance.list_template_property[ 0 ].label );
                this.component_select.dom_select.className = "shinken-select-selector";
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _element_list                              = this.component_select.list_element.getElement( this.last_list_element_selected );
                _title_to_set                              = _element_list.getLabel();
                this.component_select.dom_select.className = "shinken-select-selector";
                break;
            default:
                _selected_element = this.component_select.getLastSelectedElement();
                if ( _selected_element ) {
                    _title_to_set = SHINKEN.TOOLS.STRING.trimExtented( _selected_element.dom_element.innerText );
                }
                this.component_select.dom_select.className = "shinken-select-selector" + _selected_element.element.getClass();
        }
        this.component_select.setTitle( _title_to_set );
        this.checkErrorWarning();
    },
    //********************************************  FILTER   *********************************************************//
    doFilter                  : function ( filter ) {
        this.component_select.doFilter( filter );
    },
    //********************************************  KEY EVENT   ******************************************************//
    keydown                   : function ( event ) {
        var key = event.keyCode;
        switch ( key ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.component_select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.component_select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.component_select.validAutoSelect();
                event.preventDefault();
                break;
        }
        
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return this.last_list_element_selected;
        }
        if ( !this.link_id ) {
            return this.component_select.getValue();
        }
        var _to_return      = {};
        _to_return.links    = [ this.component_select.getValueToSave() ];
        _to_return.has_plus = false;
        return _to_return;
    }
};

PROPERTY.getInterfacePrototype( PROPERTY.SingleSelect );
//******************************  END  single-select-prop.js   **************************

//******************************  START  single-select-with-input-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/single-select-with-input-prop.js *
'use strict';

PROPERTY.SingleSelectWithInput           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // inherited_value
    // custom_selected
    // type
    // component_select
    // component_btn_default
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_arg_input
    // tab_parent_id
    // error_counter
    // warning_counter
    this.timeout_ask_compute_after_change;
    this.init( dom_element );
};
PROPERTY.SingleSelectWithInput.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_select          = new COMPONENT.Select( dom_element, PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT );
        this.component_input           = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), this );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.component_select.buildLinkOpenNewTab( this.item_type, this.link_id );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    setErrorsSpecific         : function () {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
        var _selected_element;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            default:
                _selected_element = this.component_select.getLastSelectedElement();
                break;
        }
        if ( _selected_element ) {
            this.counter_temp_error = _selected_element.element.getError();
        }
        this.tag_information.setStatus( this.counter_temp_error ? COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE );
        if ( !this.counter_temp_error && this.is_required ) {
            var _message            = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init( this, this.last_list_element_selected );
            this.counter_temp_error = _message.messages_error.length;
            if ( this.counter_temp_error ) {
                this.counter_error_tooltip = _message.buildMessage();
            }
        }
    },
    clickOnSelector           : function () {
        this.component_select.clickOnSelector();
    },
    clickOnItemSelector       : function ( key_name ) {
        this.setLastListElementSelected( key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.setStateInheritance( true );
                this.component_select.clickOnItemSelector( this.name, key_name );
                this.component_input.updateView( this.state_inheritance );
                break;
            default:
                this.setStateInheritance( false );
                this.component_input.updateView( false );
        }
        this.component_select.clickOnItemSelector( this.name, key_name );
        this.component_select.buildLinkOpenNewTab( this.item_type, this.link_id );
        this.updateView();
        return true;
    },
    clickOnBtnInheritance     : function () {
        this.setStateInheritance( !this.state_inheritance );
        if ( this.state_inheritance ) {
            this.setLastListElementSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE && !this.component_select.last_selected_key_name ) {
                this.component_select.clickOnItemSelector( this.name, PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
            this.setLastListElementSelected( this.component_select.getLastSelectedElementName() );
        }
        this._computeState();
        this.component_input.updateView( this.state_inheritance );
    },
    askComputeAfterChange     : function () {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange();
        }, 200 );
    },
    computeAfterChange        : function () {
        this.component_input.setValue();
        if ( this.state_inheritance ) {
            this.clickOnItemSelector( this.inherited_cmd_name );
        }
        else {
            this._computeState();
        }
        if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            App.Elements.ChecksTab.askInit( { override_command_change: true, property: this } );
        }
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        var _value        = this.component_select.getValue();
        var _is_inherited = (this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE && !_value);
        if ( _is_inherited ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        
        this.setStateInheritance( _is_inherited );
        this.component_input.updateView( _is_inherited );
        var _state_property = _is_inherited ? PROPERTY.CONST.STATE_PROPERTY.INHERITANCE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.setState( _state_property );
        
    },
    _computeState             : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                if ( this.is_override && this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND && this.component_input.getValue() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
                }
                else {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
        }
        this.setState( _to_set );
        this._computeLabelSelect();
        this._computeStateInput();
    },
    _computeStateInput        : function () {
        var _state = 1;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _state = 0;
                break;
        }
        DOM.Service.setDataSet( this.dom_element, 'stateInput', _state );
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return = inherited_value;
        if ( this.getName() === PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ) {
            _to_return = _( 'element.' + inherited_value );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this.updateView();
    },
    //********************************************  GET / SET    **********************************************************//
    setLastListElementSelected: function ( to_set ) {
        this.setLastItemSelected( to_set );
        this.link_id = '';
        if ( this.last_list_element_selected ) {
            var _selected_element = this.component_select.list_element.getListSelectElement( this.last_list_element_selected ).getElement();
            
            if ( _selected_element.uuid ) {
                this.link_id = _selected_element.uuid;
                this.link_id += _selected_element.state === COMPONENT.CONST.TAG.STATE.NEW ? "?new=1" : '';
            }
        }
        DOM.Service.setDataSet( this.dom_element, 'linkId', this.link_id );
    },
    unset                     : function () {
        this.setValueFromUser( '', '' );
    },
    setValueFromUser          : function ( value, arg_value ) {
        arg_value = arg_value || '';
        if ( this.is_override ) {
            arg_value = value;
            value     = "";
        }
        this.component_input.dom_element.value = arg_value;
        this.computeAfterChange();
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        this.clickOnItemSelector( value );
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                 : function () {
        this.component_select.hidePopup();
    },
    updateView                : function () {
        this._computeState();
    },
    _computeLabelSelect       : function () {
        var _title_to_set;
        var _element_list;
        var _selected_element;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                _element_list                              = this.component_select.list_element.getElement( this.last_list_element_selected );
                _title_to_set                              = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, this.component_btn_inheritance.list_template_property[ 0 ].label );
                this.component_select.dom_select.className = "shinken-select-selector";
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                _element_list                              = this.component_select.list_element.getElement( this.last_list_element_selected );
                _title_to_set                              = _element_list.getLabel();
                this.component_select.dom_select.className = "shinken-select-selector";
                break;
            default:
                _selected_element = this.component_select.getLastSelectedElement();
                if ( _selected_element ) {
                    _title_to_set = SHINKEN.TOOLS.STRING.trimExtented( _selected_element.dom_element.innerText );
                }
                this.component_select.dom_select.className = "shinken-select-selector" + _selected_element.element.getClass();
        }
        this.component_select.setTitle( _title_to_set );
        this.checkErrorWarning();
    },
    //********************************************  FILTER   *********************************************************//
    doFilter                  : function ( filter ) {
        this.component_select.doFilter( filter );
    },
    //********************************************  KEY EVENT   ******************************************************//
    keydown                   : function ( event ) {
        var key = event.keyCode;
        switch ( key ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.component_select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.component_select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.component_select.validAutoSelect();
                event.preventDefault();
                break;
        }
        
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal        : function () {
        var _args_value;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return '';
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _args_value = this.component_input.getValue();
                if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                    return _args_value;
                }
                if ( this.override_prop_name === PROPERTY.CONST.NAME.EVENT_HANDLER ) {
                    return '';
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            
        }
        var _to_return       = {};
        _to_return.node      = {};
        _to_return.node.args = this.component_input.getValue();
        _to_return.node.link = this.component_select.getValueToSave();
        _to_return.raw_value = _to_return.node.args ? this.component_select.getValue() + PROPERTY.CONST.CHECK_COMMAND.SEPERATOR + _to_return.node.args : this.component_select.getValue();
        return _to_return;
    }
};

PROPERTY.getInterfacePrototype( PROPERTY.SingleSelectWithInput );
//******************************  END  single-select-with-input-prop.js   **************************

//******************************  START  string-input-prop.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/string-input-prop.js *
'use strict';

PROPERTY.StringInput           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_input
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    this.timeout_ask_compute_after_change;
    this.init( dom_element );
};
PROPERTY.StringInput.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input           = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), this );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.name ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
        if ( this.getName() === PROPERTY.CONST.NAME.PREFIX ) {
            this.component_input.setExtraTooltip( _( "sync.extra_tooltip_rename_prefix" ) );
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange     : function () {
        if ( this.is_disabled ) {
            return;
        }
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.component_input.setValue( self.name === PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME );
            self.setStateInheritance( !self.component_input.getValue() );
            self._computeState();
            MANAGER.ListenerEventManager.afterActionProperty( self );
        }, 200 );
    },
    onFocus                   : function () {
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
            this.component_input.dom_element.value = "";
        }
    },
    onFocusOut                : function () {
        var self = this;
        setTimeout( function () {
            if ( self.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED && !self.component_input.hasBeenChanged() ) {
                self.component_input.dom_element.value = self.component_input.original_value;
            }
        }, 500 );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.getValue();
        this.setStateInheritance( _is_inheritable );
        this.component_input.updateView( _is_inheritable );
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.getValue() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    //********************************************  VALIDATION      **************************************************//
    computeErrorsSpecifics    : function () {
        this.component_input.validateValueInput();
    },
    setErrorsSpecific         : function () {
        this.counter_temp_error   = this.component_input.error_number;
        this.counter_temp_warning = this.component_input.warning_number;
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    setIsProtected            : function ( to_set ) {
        this.is_protected = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'isProtected', this.is_protected );
            this.component_input.setIsProtected( this.is_protected );
        }
    },
    unset                     : function () {
        this.setValueFromUser( "" );
    },
    setValueFromUser          : function ( value ) {
        this.component_input.dom_element.value = value;
        this.askComputeAfterChange();
        MANAGER.ListenerEventManager.afterActionProperty( this );
    },
    getValueInherited         : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    //********************************************  INHERITANCE     **************************************************//
    updateWithTemplateSpecific: function () {
        this._computeState();
    },
    cleanBeforeUpdate         : function () {
        this.component_input.setPlaceholder();
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                
                return '';
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                if ( this.is_protected && this.component_input.hasBeenChanged() ) {
                    return SHINKEN.TOOLS.STRING.b64Encode( this.getValue() );
                }
                return this.getValue();
        }
    }
};

PROPERTY.getInterfacePrototype( PROPERTY.StringInput );
//******************************  END  string-input-prop.js   **************************

//******************************  START  validator.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/property/validator.js *
PROPERTY.CONST.VALIDATOR = {
    MESSAGES: {
        required       : _( "element.tooltip_required" ),
        url            : _( "element.tooltip_url" ),
        notes_multi_url: _( "element.tooltip_missing_url" ),
        forbidden      : _( "element.tooltip_forbidden" ),
        replace        : _( "element.tooltip_replace" )
    },
    REGEXS  : {
        xss_exclude_characters           : /[<>&"\'/]/,
        xss_exclude_characters_url       : /[<>"\']/,
        url                              : /(ftp|https?):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/,
        restrict                         : /[~!$%^&*\"\'|<>?,()=/+\\]/,
        restrict_check                   : /[~!%^&*\"\'|<>?,()=+]/, // The $ and / is allowed
        restrict_check_exclude           : /[~!%^&\"\'|<>?()=+]/, // The $ and / is allowed
        restrict_host_group_name         : /[~%^*\"\'<>?=]/,
        restrict_data                    : /[^0-9a-zA-Z_-]/,
        restrict_positive_integer        : /^[1-9][0-9]*$/,
        restrict_positive_integer_or_zero: /^[0-9][0-9]*$/,
        key_data                         : /[$]KEY[$]/,
        time_period_format               : /^([0-9][0-9]:[0-9][0-9]\-[0-9][0-9]:[0-9][0-9]\,*){1,}$/
    },
    TYPE    : {
        NOT_EMPTY                                : {
            NAME: "not_empty"
        },
        NOT_NULL                                 : {
            NAME: "not_null"
        },
        RESULT_OK                                : {
            NAME: "result_ok"
        },
        REQUIRED                                 : {
            NAME: "required"
        },
        URL                                      : {
            NAME: "url"
        },
        NOTES_MULTI_URL                          : {
            NAME: "notes_multi_url"
        },
        RESTRICT                                 : {
            NAME   : "restrict",
            MESSAGE: '~!$%^&*\"\'|<>?,()=/+'
        },
        XSS_BLOCK                                : {
            NAME   : "xss_block",
            MESSAGE: '<>&"\'/'
        },
        XSS_BLOCK_URL                            : {
            NAME   : "xss_block_url",
            MESSAGE: '<>"\''
        },
        XSS_REPLACE                              : {
            NAME   : "xss_replace",
            MESSAGE: '<>&"\'/'
        },
        RESTRICT_CHECK                           : {
            NAME   : "restrict_check",
            MESSAGE: '~!%^&*"\'|<>?,()=+'
        },
        RESTRICT_CHECK_EXCLUDE                   : {
            NAME   : "restrict_check_exclude",
            MESSAGE: '~!%^&"\'|<>?()=+'
        },
        RESTRICT_HOST_GROUP_NAME                 : {
            NAME   : "restrict_host_group_name",
            MESSAGE: '~%^*"\'<>?='
        },
        RESTRICT_DATA                            : {
            NAME: "restrict_data"
        },
        RESTRICT_POSITIVE_INTEGER                : {
            NAME: "restrict_positive_integer"
        },
        RESTRICT_POSITIVE_INTEGER_OR_ZERO        : {
            NAME: "restrict_positive_integer_or_zero"
        },
        RESTRICT_INTEGER_WITH_MINUS_ONE          : {
            NAME     : "restrict_integer_with_minus_one",
            MINUS_ONE: '-1'
        },
        RESTRICT_HOST_NOTIFICATION_OPTIONS       : {
            NAME          : "restrict_host_notification_options",
            VALIDE_OPTIONS: [ 'd', 'u', 'r', 'f', 's', 'n' ]
        },
        RESTRICT_CHECK_NOTIFICATION_OPTIONS      : {
            NAME          : "restrict_check_notification_options",
            VALIDE_OPTIONS: [ 'w', 'u', 'c', 'r', 'f', 's', 'n' ]
        },
        RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK: {
            NAME            : "restrict_flap_detection_options_check",
            VALIDE_OPTIONS  : [ 'o', 'w', 'c', 'u' ],
            REQUIRED_OPTIONS: [ 'o' ]
        },
        RESTRICT_FLAP_DETECTION_OPTIONS_FOR_HOST : {
            NAME            : "restrict_flap_detection_options_host",
            VALIDE_OPTIONS  : [ 'o', 'd', 'u' ],
            REQUIRED_OPTIONS: [ 'o' ]
        },
        RESTRICT_ESCALATION_OPTIONS              : {
            NAME          : "restrict_escaltion_options",
            VALIDE_OPTIONS: [ 'd', 'r', 'f', 's', 'n' ]
        },
        RESTRICT_DFE_VALUE                       : {
            NAME: 'restrict_dfe_value'
        },
        RESTRICT_TIMEPERIOD_DAYS                 : {
            NAME: "restrict_timeperiod_days"
        },
        IP_RANGE                                 : {
            NAME: "ip_range_validator"
        },
        PORT_RANGE                               : {
            NAME: "port_range_validator"
        }
    }
};

SHINKEN.TOOLS.SHINKEN_VALIDATOR = {
    init_with_name           : function ( validation_keys, value ) {
        var _prop = MANAGER.__instance_property_distributor.getElement( validation_keys.prop_name );
        return this.init( _prop, value, validation_keys.component_name );
    },
    init                     : function ( property, value, component_name ) {
        if ( !property ) {
            return new OBJECT.Messages();
        }
        
        var _validations_type = [];
        var name_property     = property.is_override ? property.override_prop_name : property.name;
        switch ( name_property ) {
            case PROPERTY.CONST.NAME.SERVICE_EXCLUDES:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_EXCLUDE );
                break;
            case PROPERTY.CONST.NAME.SERVICE_DESCRIPTION:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK );
                break;
            case PROPERTY.CONST.NAME.NAME:
                if ( MANAGER.__instance_element_distributor.current_element.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS ) {
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK );
                }
                else {
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT );
                }
                break;
            case PROPERTY.CONST.NAME.HOST_NAME:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME );
                        break;
                    default:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.COMMAND_NAME:
            case PROPERTY.CONST.NAME.PREFIX:
            case PROPERTY.CONST.NAME.SYNC_NAME:
            case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATION_NAME:
            case PROPERTY.CONST.NAME.CONTACT_NAME:
            case PROPERTY.CONST.NAME.CONTACTGROUP_NAME:
            case PROPERTY.CONST.NAME.ESCALATION_NAME:
            case PROPERTY.CONST.NAME.NOTIFICATIONWAY_NAME:
            case PROPERTY.CONST.NAME.MACROMODULATION_NAME:
            case PROPERTY.CONST.NAME.RESULTMODULATION_NAME:
            case PROPERTY.CONST.NAME.TIMEPERIOD_NAME:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT );
                break;
            case PROPERTY.CONST.NAME.HOSTGROUP_NAME:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME );
                break;
            case PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA );
                break;
            case PROPERTY.CONST.NAME.DEFAULT_VALUE:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DFE_VALUE );
                break;
            case PROPERTY.CONST.NAME.PACK:
            case PROPERTY.CONST.NAME.ADDRESS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK );
                break;
            case PROPERTY.CONST.NAME.NOTE_URL:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.URL );
                break;
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                switch ( component_name ) {
                    case "shinken-name-urlmulti":
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK );
                        break;
                    case "shinken-url-urlmulti":
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL );
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NOTES_MULTI_URL );
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.URL );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
            case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER_OR_ZERO );
                break;
            case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
            case PROPERTY.CONST.NAME.CHECK_INTERVAL:
            case PROPERTY.CONST.NAME.RETRY_INTERVAL:
            case PROPERTY.CONST.NAME.WARNING_THRESHOLD_CPU_USAGE:
            case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
            case PROPERTY.CONST.NAME.DEFINITION_ORDER:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER );
                break;
            case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
            case PROPERTY.CONST.NAME.TIMEOUT:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_INTEGER_WITH_MINUS_ONE );
                break;
            case PROPERTY.CONST.NAME.HOST_NOTIFICATION_OPTIONS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_NOTIFICATION_OPTIONS );
                break;
            case PROPERTY.CONST.NAME.SERVICE_NOTIFICATION_OPTIONS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS );
                break;
            case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                    case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
                    case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK );
                        break;
                    default:
                        if ( property.is_override ) {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK );
                        }
                        else {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_HOST );
                        }
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS );
                        break;
                    default:
                        if ( property.is_override ) {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS );
                        }
                        else {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_NOTIFICATION_OPTIONS );
                        }
                        break;
                }
                break;
            // TODO A réactiver quand le ticket 3703 sera effectué
            //case PROPERTY.CONST.NAME.ESCALATION_OPTIONS:
            //    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_ESCALATION_OPTIONS );
            //    break;
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.MONDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.TUESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.WEDNESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.THURSDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.FRIDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SATURDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SUNDAY:
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_TIMEPERIOD_DAYS );
                break;
            case PROPERTY.CONST.NAME.IP_RANGE:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.IP_RANGE );
                break;
            case PROPERTY.CONST.NAME.PORT_RANGE:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.PORT_RANGE );
                break;
        }
        
        if ( !MANAGER.__instance_element_distributor.current_element.is_creation && property.is_required && property.component_btn_inheritance.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            switch ( property.type ) {
                case PROPERTY.CONST.TYPES.MULTI_SELECT:
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NOT_NULL );
                    break;
                default:
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NOT_EMPTY );
                    break;
            }
        }
        return this._compute_validation( _validations_type, value );
    },
    _compute_validation      : function ( _validations_type, value, _to_return ) {
        if ( !_to_return ) {
            _to_return = new OBJECT.Messages();
        }
        var _validation_type;
        var _validation_type_name;
        for ( var i = 0; i < _validations_type.length; i++ ) {
            _validation_type      = _validations_type[ i ];
            _validation_type_name = _validation_type.NAME;
            switch ( _validation_type_name ) {
                case PROPERTY.CONST.VALIDATOR.TYPE.REQUIRED.NAME:
                    if ( !value ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.required, _( 'element.this_field' ) ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.NOTES_MULTI_URL.NAME:
                    if ( !value ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.notes_multi_url );
                        return _to_return;
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.URL.NAME:
                    if ( value ) {
                        if ( SHINKEN.TOOLS.STRING.startsWith( value, 'http://' ) ) {
                            if ( value.length < 8 ) {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url );
                            }
                        }
                        else if ( SHINKEN.TOOLS.STRING.startsWith( value, 'https://' ) ) {
                            if ( value.length < 9 ) {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url );
                            }
                        }
                        else {
                            var _split_command = MANAGER.__instance_macro_distributor.splitCommand( value );
                            if ( _split_command.length && typeof _split_command[ 0 ] === 'object' ) {
                            
                            }
                            else {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url );
                            }
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.xss_exclude_characters ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.xss_exclude_characters_url ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.XSS_REPLACE.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.xss_exclude_characters ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.replace, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_EXCLUDE.NAME:
                    if ( value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_check_exclude ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK.NAME:
                    value = value.replace( PROPERTY.CONST.VALIDATOR.REGEXS.key_data, "" );
                    if ( value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_check ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    else if ( value.match( '[$]' ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_dollar' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_host_group_name ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA.NAME:
                    if ( value ) {
                        if ( value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_data ) ) {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_special_chars' ) );
                        }
                        else if ( !SHINKEN.TOOLS.STRING.isUpperCase( value ) ) {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_not_in_upper_case' ) );
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER_OR_ZERO.NAME:
                    if ( value && !value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_positive_integer_or_zero ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_letter_2' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER.NAME:
                    if ( value && !value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_positive_integer ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_letter' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_INTEGER_WITH_MINUS_ONE.NAME:
                    if ( value && !value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_positive_integer ) && value !== _validation_type.MINUS_ONE ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_letter_except_minus_one' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS.NAME:
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_NOTIFICATION_OPTIONS.NAME:
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK.NAME:
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_HOST.NAME:
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_ESCALATION_OPTIONS.NAME:
                    if ( value ) {
                        _to_return = this._validation_options( value, _validation_type );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DFE_VALUE.NAME:
                    if ( value ) {
                        var _validator_dfe = App.DFE.validatorDFE( App.DFE.splitDFE( PROPERTY.CONST.NAME.DEFAULT_VALUE, value, true ) );
                        _to_return         = _validator_dfe._messages.hasError() ? _validator_dfe._messages : _validator_dfe._dfe_elem[ 0 ]._messages;
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_TIMEPERIOD_DAYS.NAME:
                    if ( value ) {
                        _to_return = this._validate_timeperiod_day( value );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.NOT_EMPTY.NAME:
                    if ( !SHINKEN.TOOLS.STRING.trimExtented( value ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_not_empty' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.NOT_NULL.NAME:
                    switch ( value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                            _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_not_empty' ) );
                            break;
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.IP_RANGE.NAME:
                    if ( SHINKEN.TOOLS.STRING.trimExtented( value ) ) {
                        _to_return = this._validate_ip_ranges_input( value );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.PORT_RANGE.NAME:
                    _to_return = this._validate_port_range( value );
                    break;
            }
        }
        return _to_return;
    },
    //**************************************   OPTIONS          **************************************//
    _validation_options      : function ( value, validation_type ) {
        var _to_return    = new OBJECT.Messages();
        var _split_values = value.split( ',' );
        var _current;
        var _size         = _split_values.length;
        
        for ( var i = 0; i < _size; i++ ) {
            _current = _split_values[ i ];
            if ( !_current ) {
                _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_invalide_space_notification_options' ) );
            }
            else if ( !SHINKEN.TOOLS.ARRAY.contains( validation_type.VALIDE_OPTIONS, _current ) ) {
                _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_invalide_notification_options' ), _current ) );
            }
        }
        for ( var i = 0; i < _size - 1; i++ ) {
            _current = _split_values[ i ];
            if ( _current && SHINKEN.TOOLS.ARRAY.contains( _split_values.slice( i + 1 ), _current ) ) {
                _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_duplicate_notification_options' ), _current ) );
            }
        }
        if ( _to_return.hasMessage() ) {
            _to_return.footer = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_invalide_notification_options_footer' ), validation_type.VALIDE_OPTIONS.join( ',' ) );
        }
        if ( validation_type.REQUIRED_OPTIONS ) {
            for ( var i = 0, _size_i = validation_type.REQUIRED_OPTIONS.length; i < _size_i; i++ ) {
                _current = validation_type.REQUIRED_OPTIONS[ i ];
                if ( !SHINKEN.TOOLS.ARRAY.contains( _split_values, _current ) ) {
                    _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_missing_required_notification_options' ), _current ) );
                }
            }
        }
        
        return _to_return;
    },
    //**************************************   IP RANGE     **************************************//
    _validate_ip_ranges_input: function ( value ) {
        var _to_return = new OBJECT.Messages();
        
        var _split = value.split( ' ' );
        for ( var i = 0, _size_i = _split.length; i < _size_i; i++ ) {
            this._validate_ip_ranges_part( _split[ i ], _to_return );
        }
        return _to_return;
    },
    _validate_ip_ranges_part : function ( value, messages ) {
        if ( !value ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'help-discovery.validator-ip-too-much-space' ) );
            return;
        }
        var _split = value.split( '-' );
        var _size  = _split.length;
        switch ( _size ) {
            case 0:
                return;
            case 1:
                _split = value.split( '/' );
                _size  = _split.length;
                switch ( _size ) {
                    case 1:
                        this._validate_ip_range( value, messages );
                        return;
                    case 2:
                        this._validate_ip_range( _split[ 0 ], messages );
                        if ( !_split[ 1 ] ) {
                            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), value ) );
                        }
                        else {
                            this._validate_ip_range_digit( _split[ 1 ], messages, 32, 16 );
                        }
                        return;
                    default:
                        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), value ) );
                        break;
                }
                return;
            case 2:
                var _is_valid       = this._validate_ip_range( _split[ 0 ], messages );
                var _last_digit_int = parseInt( _split[ 0 ].split( "." )[ 3 ] );
                if ( !_split[ 1 ] ) {
                    messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), value ) );
                }
                else if ( _is_valid && _last_digit_int > _split[ 1 ] ) {
                    messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-not-inferior-to' ), _last_digit_int, "<span class='shinken-highlight-data-user shinken-between-bracket'>" + _split[ 1 ] + "</span>" ) );
                    return;
                }
                else {
                    this._validate_ip_range_digit( _split[ 1 ], messages );
                    return;
                }
                break;
            default:
                messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), value ) );
                break;
            
        }
    },
    _validate_ip_range       : function ( ip_range, messages ) {
        var _split = ip_range.split( "." );
        var _size  = _split.length;
        
        if ( _size !== 4 ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), ip_range ) );
            return false;
        }
        var _to_return = true;
        for ( var i = 0; i < _size; i++ ) {
            if ( !_split[ i ] ) {
                messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), ip_range ) );
                _to_return = false;
            }
        }
        
        for ( var i = 0; i < _size; i++ ) {
            if ( !this._validate_ip_range_digit( _split[ i ], messages ) ) {
                _to_return = false;
            }
        }
        return _to_return;
    },
    _validate_ip_range_digit : function ( ip_range_digit, messages, high_limit, low_limit ) {
        if ( !high_limit ) {
            high_limit = 255;
        }
        if ( !SHINKEN.TOOLS.STRING.isInteger( ip_range_digit ) ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), ip_range_digit ) );
            return false;
        }
        if ( parseInt( ip_range_digit ) > high_limit ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-not-inferior-to' ), ip_range_digit, high_limit ) );
            return false;
        }
        else if ( low_limit && parseInt( ip_range_digit ) < low_limit ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-not-superior-to' ), ip_range_digit, low_limit ) );
            return false;
        }
        return true;
    },
    //**************************************   PORT RANGE      **************************************//
    _validate_port_range     : function ( value ) {
        var _to_return = new OBJECT.Messages();
        var _split     = value.split( ',' );
        var _size      = _split.length;
        
        if ( _size == 0 ) {
            return _to_return;
        }
        
        for ( var i = 0; i < _size; i++ ) {
            var _rangeSplit = _split[ i ].split( '-' );
            var _rangeSize  = _rangeSplit.length;
            switch ( _rangeSize ) {
                case 1:
                    if ( _rangeSplit[ 0 ].length == 0 ) {
                        if ( _size == 1 ) {
                            return _to_return;
                        }
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'help-discovery.validator-ip-range-empty' ) );
                        break;
                    }
                    if ( !SHINKEN.TOOLS.STRING.isInteger( _rangeSplit[ 0 ] ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), _split[ i ] ) );
                        break;
                    }
                    this._validate_ip_range_digit( _rangeSplit[ 0 ], _to_return, 65535, 1 );
                    break;
                case 2:
                    if ( !SHINKEN.TOOLS.STRING.isInteger( _rangeSplit[ 0 ] ) || !SHINKEN.TOOLS.STRING.isInteger( _rangeSplit[ 1 ] ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), _split[ i ] ) );
                        break;
                    }
                    if ( parseInt( _rangeSplit[ 0 ] ) >= parseInt( _rangeSplit[ 1 ] ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-not-inferior-to' ), _rangeSplit[ 0 ], "<span class='shinken-highlight-data-user shinken-between-bracket'>" + _rangeSplit[ 1 ] + "</span>" ) );
                    }
                    this._validate_ip_range_digit( _rangeSplit[ 0 ], _to_return, 65535, 1 );
                    this._validate_ip_range_digit( _rangeSplit[ 1 ], _to_return, 65535, 1 );
                    break;
                default:
                    _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'help-discovery.validator-ip-range-wrong-format' ), _split[ i ] ) );
                    break;
            }
        }
        return _to_return;
    },
    //**************************************   TIME PERIOD      **************************************//
    _validate_timeperiod_day : function ( value ) {
        var _to_return          = new OBJECT.Messages();
        var timeperiod_splitted = DATE_TIME.splitTimeperiodDay( value, _to_return );
        _to_return.addMessages( this._analyseTimeperiod( timeperiod_splitted ) );
        if ( SHINKEN.TOOLS.STRING.contains( value, SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE ) ) {
            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, _( "timeperiods.timeperiod_no_spaces_in_ranges" ) );
        }
        return _to_return;
    },
    _analyseTimeperiod       : function ( timeperiod_splitted ) {
        var _size      = timeperiod_splitted.length;
        var _to_return = [];
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = this._analyseTimeperiodRange( timeperiod_splitted[ i ] );
            if ( _current_message ) {
                _to_return.push( _current_message );
            }
        }
        
        if ( !_to_return.length && _size > 1 ) {
            var _current_range = timeperiod_splitted[ 0 ];
            var last_end_time  = _current_range[ 1 ];
            for ( var i = 1; i < _size; i++ ) {
                _current_range = timeperiod_splitted[ i ];
                if ( DATE_TIME.isValidRangeTimeperiod( last_end_time, _current_range[ 0 ] ) ) {
                    last_end_time = _current_range[ 1 ];
                }
                else {
                    _to_return.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( "element.tooltip_timeperiod_invalid" ) ) );
                }
            }
        }
        
        return _to_return;
    },
    _analyseTimeperiodRange  : function ( range ) {
        var _size = range.length;
        if ( _size !== 2 ) {
            return new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( "element.tooltip_timeperiod_two_hour_missing" ) );
        }
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = this._analyseTimeperiodTime( range[ i ] );
            if ( _current_message ) {
                return _current_message;
            }
        }
        if ( !DATE_TIME.isValidRangeTimeperiod( range[ 0 ], range[ 1 ] ) ) {
            return new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "element.tooltip_timeperiod_superior_hour" ), DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE, range ) ) );
        }
        
    },
    _analyseTimeperiodTime   : function ( time ) {
        if ( time.invalid ) {
            return new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_timeperiod_time_format_invalid' ) );
        }
        if ( time.hour === "24" && time.min === "00" ) {
            return;
        }
        var _hour_is_valid = DATE_TIME.isValid( DATE_TIME.FORMAT.TYPE_VALIDATION.HOUR, time.hour );
        var _min_is_valid  = DATE_TIME.isValid( DATE_TIME.FORMAT.TYPE_VALIDATION.MIN, time.min );
        if ( !_hour_is_valid || !_min_is_valid ) {
            return new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "element.tooltip_timeperiod_time_invalid" ), DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time ) ) );
        }
        
    }
};



//******************************  END  validator.js   **************************

//******************************  START  shinken-saving-log.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken-saving-log.js *
var KEY_SESSION_STORAGE_SAVING_LOG_MSG = "message_saving_log";
var TIMEOUT_SAVING_LOG_SUCCESS         = 2000;

function hide_saving_log () {
    var _saving_log     = document.getElementById( "saving-log" );
    var _saving_log_msg = document.getElementById( "saving-log-msg" );
    
    SHINKEN.DOM.hide( _saving_log );
    _saving_log_msg.innerHTML = null;
    
    App.Scope.resetAdjustHeight( $( '.container_host_info' ) );
    $( window ).trigger( 'resize' );
}

function show_saving_log ( title, content, saving_log_class, show_close_btn, modal_title, modal_content ) {
    var _saving_log = document.getElementById( "saving-log" );
    
    if ( !_saving_log ) {
        console.error( "Cannot display message [" + modal_title + "]:[" + modal_content + "]" );
        return;
    }
    
    var _saving_log_msg          = document.getElementById( "saving-log-msg" );
    var _saving_log_title_text   = document.getElementById( "saving-log-title-text" );
    var _close_saving_log        = document.getElementById( "close-saving-log" );
    var _saving_log_modal_button = document.getElementById( "saving-log-modal-button" );
    var _saving_log_modal_header = document.getElementById( "saving-log-modal-header" );
    var _saving_log_modal_body   = document.getElementById( "saving-log-modal-body" );
    
    _saving_log.className            = "alert saving-log " + saving_log_class;
    _saving_log_title_text.innerHTML = title;
    _saving_log_msg.innerHTML        = content;
    
    SHINKEN.DOM.show( _saving_log );
    if ( show_close_btn ) {
        SHINKEN.DOM.show( _close_saving_log );
    }
    else {
        SHINKEN.DOM.hide( _close_saving_log );
    }
    
    if ( modal_content ) {
        SHINKEN.DOM.show( _saving_log_modal_button );
        _saving_log_modal_body.innerHTML = modal_content;
        
        if ( modal_title ) {
            _saving_log_modal_header.innerHTML = modal_title;
            SHINKEN.DOM.show( _saving_log_modal_button, 'inline-block' );
        }
        else {
            SHINKEN.DOM.hide( _saving_log_modal_header );
        }
    }
    else {
        SHINKEN.DOM.hide( _saving_log_modal_button );
    }
    
    App.Scope.adjustHeight( $( '#saving-log' ), $( '.container_host_info' ), $( '#right-column' ), false );
    $( window ).trigger( 'resize' );
    
    var _area_draggable = document.getElementsByClassName( 'elements-panel' )[ 0 ];
    if ( _area_draggable ) {
        SHINKEN.MODAL.setDraggable( true, _area_draggable );
    }
    else {
        console.warn( "[warn]", "[Zone _area_draggable not found]" );
    }
}

function finallyLoading () {
    var _show_close_btn = true;
    
    var msg = sessionStorage.getItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG );
    if ( !msg ) {
        return;
    }
    msg = JSON.parse( msg );
    
    var modal_title   = msg.title;
    var modal_content = '';
    var log_text      = '';
    
    if ( msg.messages ) {
        modal_content = '<ul>';
        for ( var i = 0; i < msg.messages.length; i++ ) {
            if ( i === 0 ) {
                log_text += msg.messages[ i ];
            }
            modal_content += "<li>" + msg.messages[ i ] + "</li>";
        }
        modal_content += '</ul>';
        if ( msg.messages.length === 1 ) {
            modal_title   = null;
            modal_content = null;
        }
    }
    
    if ( !msg.is_persistent ) {
        _show_close_btn = msg.is_persistent;
        setTimeout( hide_saving_log, TIMEOUT_SAVING_LOG_SUCCESS );
    }
    show_saving_log( modal_title, log_text, msg.type, _show_close_btn, modal_title, modal_content );
    sessionStorage.removeItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG );
    
    $( window ).trigger( 'resize' );
}

window.onload = function () {
    finallyLoading();
};
//******************************  END  shinken-saving-log.js   **************************

//******************************  START  communication.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/communication.js *
var COMMUNICATION             = {};
COMMUNICATION.MESSAGE         = {};
COMMUNICATION.QUERY           = {};
COMMUNICATION.MESSAGE.SUCCESS = 'success';
COMMUNICATION.MESSAGE.ERROR   = 'error';
COMMUNICATION.MESSAGE.WARNING = 'warning';
COMMUNICATION.CODE            = {};
COMMUNICATION.CODE.SUCCESS    = 200;
COMMUNICATION.CODE.WARNING    = 202;
COMMUNICATION.RETURN_CODE     = {
    ELEMENT_UNKNOWN: "element-unknown"
};

COMMUNICATION.QUERY.GET = {
    SEPARATOR: {
        GET_BEGINNER: '?',
        GET_ADD     : '&',
        PARAM_SETTER: '=',
        SLASH       : '/'
    },
    SOURCE   : {
        LIST                 : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ORDER            : {
            URL    : "/api/sources/setorder",
            OPTIONS: {
                TIMESTAMP: "?ts=",
                ORDER    : "&order="
            }
        },
        REFRESH              : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ENABLED          : {
            URL    : "/api/sources/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&sname=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        SET_DISCOVERY_ENABLED: {
            URL    : "/api/sources/conf/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                CONF_ID    : "&conf_id=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        FORCE_IMPORT         : {
            URL    : "/api/sources/forceimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        CLEAN_IMPORT         : {
            URL    : "/api/sources/cleanimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        REFRESH_UNIQUE       : {
            URL    : "/api/sources/unique_source/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        ANALYZER             : {
            LAUNCH_BATCH      : "/api/analyzers/launch_analyze_batch",
            STOP_ANALYSE_BATCH: "/api/analyzers/stop_analyze_batch",
            GET_RESULTS       : "/api/analyzers/get_analyze_jobs_result"
        },
        REDIRECT_DETAIL      : {
            URL    : "/sources/",
            OPTIONS: {
                TAB_DETAIL         : "tab=tab-detail-last-run",
                TAB_SUMMARY_OLD_RUN: "tab=tab-summary-old-run",
                FILTER_STATUS      : "filter=status:"
            }
        }
    },
    OVERRIDE : {
        BASE: '/elements/service_overrides/'
    }
};
//******************************  END  communication.js   **************************

//******************************  START  modal.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/modal.js *
SHINKEN.MODAL = (function ( self ) {
    "use strict";
    
    var getDomElementAnchor = function () {
        if ( !self.dom_element_anchor ) {
            self.dom_element_anchor = document.getElementsByClassName( self.MODAL_ANCHOR )[ 0 ];
        }
        return self.dom_element_anchor;
    };
    
    var move        = function ( xpos, ypos ) {
        self.getElement().style.top  = ypos + 'px';
        self.getElement().style.left = xpos + 'px';
    };
    var startMoving = function ( container, evt ) {
        evt                    = evt || window.event;
        var modal              = self.getElement();
        var bounding_modal     = modal.getBoundingClientRect();
        var bounding_container = container.getBoundingClientRect();
        var posX               = evt.clientX;
        var posY               = evt.clientY;
        var divTop             = bounding_modal.top;
        var divLeft            = bounding_modal.left;
        var eWi                = parseInt( bounding_modal.width );
        var eHe                = parseInt( bounding_modal.height );
        var cTop               = parseInt( bounding_container.top );
        var cLeft              = parseInt( bounding_container.left );
        var cWi                = parseInt( bounding_container.width );
        var cHe                = parseInt( bounding_container.height );
        var diffX              = posX - divLeft;
        var diffY              = posY - divTop;
        document.onmousemove   = function ( evt ) {
            evt      = evt || window.event;
            var posX = evt.clientX,
                posY = evt.clientY,
                aX   = posX - diffX,
                aY   = posY - diffY;
            if ( aX < cLeft ) {
                aX = cLeft;
            }
            if ( aY < cTop ) {
                aY = cTop;
            }
            if ( aX + eWi > cWi + cLeft ) {
                aX = cWi - eWi + cLeft;
            }
            if ( aY + eHe > cHe + cTop ) {
                aY = cHe - eHe + cTop;
            }
            move( aX, aY );
        };
    };
    var stopMoving  = function ( container ) {
        document.onmousemove = function () {
        };
    };
    
    self.MODAL_ID           = "shinken-modal";
    self.MODAL_ANCHOR       = "shinken-modal-anchor";
    self.dom_element        = null;
    self.dom_element_anchor = null;
    self.is_visible         = false;
    
    self.toggle     = function () {
        self.is_visible ? self.hide() : self.show();
    };
    self.show       = function () {
        self.is_visible = true;
        SHINKEN.DOM.show( self.getElement() );
    };
    self.hide       = function () {
        self.is_visible = false;
        SHINKEN.DOM.hide( self.getElement() );
    };
    self.getElement = function () {
        if ( !self.dom_element ) {
            self.dom_element = document.getElementById( self.MODAL_ID );
        }
        return self.dom_element;
    };
    
    self.setDraggable = function ( isDraggable, container ) {
        if ( isDraggable ) {
            getDomElementAnchor().onmousedown = function ( e ) {
                startMoving( container, e );
            };
            getDomElementAnchor().onmouseup   = function ( e ) {
                stopMoving( container );
            };
        }
        else {
            getDomElementAnchor().onmousedown = null;
            getDomElementAnchor().onmouseup   = null;
        }
    };
    
    return self;
})( SHINKEN.MODAL || {} );

//******************************  END  modal.js   **************************

//******************************  START  navigator-service.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/service/navigator-service.js *
SHINKEN.NAVIGATOR = (function ( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function () {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden () {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function ( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function () {
        return navigator.isHidden;
    };
    self.init                 = function () {
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
        }
        else if ( window.navigator.userAgent.indexOf( 'Trident' ) !== -1 ) {
            navigator.isIE = true;
        }
        
        logNavigateur();
    };
    self.shinken_beforeunload = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    function logNavigateur () {
        var toReturn = "Navigateur detected = ";
        if ( navigator.isChrome ) {
            toReturn += "CHROME";
        }
        if ( navigator.isFireFox ) {
            toReturn += "FIREFOX";
        }
        if ( navigator.isIE ) {
            toReturn += "INTERNET EXPLORER";
        }
        //console.info( toReturn );
    }
    
    return self;
})( SHINKEN.NAVIGATOR || {} );


SHINKEN.NAVIGATOR.init();

//******************************  END  navigator-service.js   **************************

//******************************  START  forms.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/plugins/elements/htdocs/js/forms.js *
/**
 * Copyright (C) 2013-2018:
 * This file is part of Shinken Enterprise, all rights reserved.
 **/


var must_save_in_work_area = false;
var prev_action            = '';

var ACTION_DELETE_WORKING_AREA_ENTRY = 'delete_working_area_entry';
var ACTION_DELETE_ENTRY              = 'delete_entry';
var ACTION_SAVE_WORKING_AREA_ENTRY   = 'save_working_area_entry';
var ACTION_SAVE_ENTRY                = 'save_entry';
var ACTION_SUBMIT_TO_STAGGING        = 'submit_to_stagging';
var ACTION_APPLY_WORK_AREA           = 'apply_work_area';
var ACTION_APPLY_DELETE_WORK_AREA    = 'apply_delete_work_area';
var ACTION_REJECT_WORK_AREA          = 'reject_work_area';
var ACTION_UNLOCK_WORK_AREA          = 'unlock_work_area';

function go_next_page ( next_page ) {
    location.assign( next_page );
}

function validate_pending () {
    // with_change, submit_to_stagging
    submit_form( false, false );
}

function is_blank ( str ) {
    return (!str || /^\s*$/.test( str ));
}

function delete_ui_entry ( is_discovery ) {
    var bypass_work_area        = MANAGER.WorkFlowManager.getState();
    var but_we_bypass_work_area = false;
    if ( bypass_work_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING ) {
        but_we_bypass_work_area = true;
    }
    
    // We do not want to be prompt when we will exit the page, as we are ok to save
    
    if ( confirm( _( 'element.sure' ) ) ) {
        disable_page_off_warning();
        if ( is_discovery ) {
            submit_delete_discovery_form();
        }
        else if ( must_save_in_work_area && !but_we_bypass_work_area ) {
            // We do not want to be prompt when we will exit the page, as we are ok to save
            really_delete_working_area_entry();
            MANAGER.__instance_loading.showLoading( _( 'element.delete_in_progress' ) );
        }
        else {
            really_delete_staging_entry();
        }
    }
}

function fire_element_is_modifie () {
    if ( !MANAGER.__instance_loading.isReady() ) {
        return;
    }
    if ( MANAGER.__instance_element_distributor.current_element.phase === OBJECT.CONST.ELEMENT.PHASE.EDITING ) {
        return;
    }
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.EDITING );
    
    is_edit_mode_on = true;
    $( "#element-btn-save" ).removeClass( "hide" );
    $( "#id-shinken-btn-save" ).removeClass( "shinken-disabled" );
    $( "#element-btn-submit-to-stagging" ).removeClass( "hide" );
    $( "#element-btn-unlock-work-area" ).removeClass( "hide" );
    $( "#element-btn-cancel  > a > span" ).html( _( 'element.cancel' ) );
    $( "#empty-separator" ).addClass( "hide" );
    if ( $( "#left-column" ).data( 'type' ) === "hosts" ) {
        $( "#right-column" ).addClass( "working-area" );
        $( ".working-area-banner" ).removeClass( "hidden" );
        $( ".staging-area-banner" ).addClass( "hidden" );
    }
    hide_saving_log();
    // We calculate the size of the left panel.
    $( window ).trigger( 'resize' );
}

function mapping ( prev_action, is_admin, item_type, item_id, has_item_in_staging ) {
    console.log( "mapping with [" + prev_action + "] [" + is_admin + "] [" + item_type + "] [" + item_id + "] [" + has_item_in_staging + "]" );
    
    if ( prev_action === ACTION_DELETE_WORKING_AREA_ENTRY ) {
        if ( is_admin && has_item_in_staging ) {
            return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + "');";
        }
        else {
            return "go_next_page('/elements/working_area/" + item_type + "');";
        }
    }
    else if ( prev_action === ACTION_DELETE_ENTRY ) {
        return "go_next_page('/elements/" + item_type + "');";
    }
    else if ( prev_action === ACTION_SAVE_WORKING_AREA_ENTRY ) {
        var _get_path = SHINKEN.HIGHWAY.getParams();
        if ( _get_path[ 'tab' ] === 'changes' ) {
            delete _get_path[ 'tab' ];
        }
        if ( _get_path[ 'new' ] ) {
            delete _get_path[ 'new' ];
        }
        return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + SHINKEN.HIGHWAY.buildParamsToUrl( _get_path ) + "');";
    }
    else if ( prev_action === ACTION_SAVE_ENTRY ) {
        var _get_path = SHINKEN.HIGHWAY.getParams();
        if ( _get_path[ 'new' ] ) {
            delete _get_path[ 'new' ];
        }
        return "go_next_page('/elements/" + item_type + "/" + item_id + SHINKEN.HIGHWAY.buildParamsToUrl( _get_path ) + "');";
    }
    else if ( prev_action === ACTION_SUBMIT_TO_STAGGING ) {
        if ( is_admin ) {
            return "go_next_page('/elements/" + item_type + "/" + item_id + "');";
        }
        else {
            return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + "');";
        }
    }
    else if ( prev_action === ACTION_APPLY_WORK_AREA ) {
        return "go_next_page('/elements/" + item_type + "/" + item_id + "');";
    }
    else if ( prev_action === ACTION_APPLY_DELETE_WORK_AREA ) {
        return "go_next_page('/elements/" + item_type + "');";
    }
    else if ( prev_action === ACTION_REJECT_WORK_AREA ) {
        return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + "');";
    }
    else if ( prev_action === ACTION_UNLOCK_WORK_AREA ) {
        if ( has_item_in_staging ) {
            return "go_next_page('/elements/" + item_type + "/" + item_id + "');";
        }
        else {
            return "go_next_page('/elements/working_area/" + item_type + "');";
        }
    }
    else {
        return "go_next_page('/elements/" + item_type + "');";
    }
    
}

function shinken_toggle_change_diff_state ( key ) {
    if ( shinken_property_changes_list[ key ] ) {
        shinken_property_changes_list[ key ] = false;
        document.getElementById( 'tr-change-' + key ).classList.add( "shinken-is-disabled" );
    }
    else {
        shinken_property_changes_list[ key ] = true;
        document.getElementById( 'tr-change-' + key ).classList.remove( "shinken-is-disabled" );
    }
}

//********************************************  GENERAL     *********************************************************//
function getCurrentObjectFromProperty ( with_change, submit_comment ) {
    var _item      = {};
    _item[ '_id' ] = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    //TODO DOIT ÊTRE MIS DANS LE DISTRIBUTOR MANAGER
    var _elements = MANAGER.__instance_property_distributor.getAllElements();
    var _current_name;
    var _current_value;
    
    var _override_values = [];
    for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
        _current       = _elements[ i ];
        _current_value = _current.getDataToSave();
        if ( _current_value ) {
            if ( _current.is_override ) {
                _override_values.push( _current );
            }
            else {
                _item[ _current.getName() ] = _current_value;
            }
        }
    }
    //TODO DOIT ÊTRE MIS DANS LE DISTRIBUTOR MANAGER
    var _size_override   = _override_values.length;
    var _current;
    var _shinken_element = MANAGER.__instance_element_distributor.current_element;
    
    
    if ( !_shinken_element.override && _size_override ) { //PAS D'existant mais on en rajoute
        _shinken_element.override = new OBJECT.ServiceOverrides();
    }
    if ( _shinken_element.override && (_shinken_element.override.size || _size_override) ) { //existant aprés tout la gestion??
        _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ] = _shinken_element.override.getDataToSave( _override_values );
        if ( _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ] === null ) {
            delete _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ];
        }
    }
    if ( _shinken_element.exclude && _shinken_element.exclude.size ) {
        _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_EXCLUDES_BY_ID ] = _shinken_element.exclude.getDataToSave();
    }
    if ( submit_comment ) {
        _item[ '__COMMENT__' ] = submit_comment;
    }
    
    //TODO DOIT ÊTRE MIS DANS LE DISTRIBUTOR MANAGER
    if ( with_change ) {
        var _keys = Object.keys( shinken_property_changes_list );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( shinken_property_changes_list[ _current_key ] ) {
                var new_value = $( '#change-input-' + _current_key ).val();
                if ( new_value === "" ) {
                    delete _item[ _current_key ];
                }
                else {
                    if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( _current_key ) ) {
                        _item[ _current_key ] = SHINKEN.TOOLS.STRING.b64Encode( 'protected_field_value_from_changes' );
                    }
                    else {
                        _item[ _current_key ] = new_value;
                    }
                }
            }
        }
    }
    return _item;
}

function get_current_object ( with_change, submit_comment ) {
    var res                                                = {};
    res[ 'protect_fields__substrings_matching_fields' ]    = JSON.stringify( SHINKEN.TOOLS.ENCRYPTION.getProtectedKeys() );
    res[ 'protect_fields__activate_interface_encryption' ] = SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated();
    res[ 'item' ]                                          = JSON.stringify( getCurrentObjectFromProperty( with_change, submit_comment ) );
    
    return res;
}

function submit_form ( with_change, submit_to_stagging, comment_txt, is_discovery ) {
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.ON_SAVING );
    
    disable_page_off_warning();
    // Get defaul params
    if ( typeof (with_change) === 'undefined' ) {
        with_change = false;
    }
    if ( typeof (submit_to_stagging) === 'undefined' ) {
        submit_to_stagging = false;
    }
    if ( typeof (comment_txt) === 'undefined' ) {
        comment_txt = '';
    }
    var f         = document.forms[ 'form-element' ];
    var item_type = f.dataset.type;
    var _id       = MANAGER.__instance_element_distributor.current_element.getUUID();
    var item_dump = get_current_object( with_change, comment_txt );
    
    //console.log( "item_dump", item_dump );
    
    if ( is_discovery ) {
        delete item_dump[ "protect_fields__activate_interface_encryption" ];
        delete item_dump[ "protect_fields__substrings_matching_fields" ];
        $.post( '/sources/' + SOURCE_NAME + '/discovery/save/', item_dump ).success( form_success_network_range ).error( form_errors_network_range );
        return;
    }
    
    var bypass_work_area = MANAGER.WorkFlowManager.getState();
    var params_list      = [];
    var params_string    = "";
    
    if ( bypass_work_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING && MANAGER.__instance_element_distributor.current_user.is_admin ) {
        params_list.push( "bypass_work_area=1" );
    }
    
    if ( is_pending ) {
        params_list.push( "pending=1" );
    }
    
    if ( with_change ) {
        params_list.push( 'with_change=1' );
    }
    
    if ( MANAGER.__instance_element_distributor.current_element.is_creation ) {
        params_list.push( 'in_creation=1' );
    }
    
    prev_action = ACTION_SAVE_ENTRY;
    //console.log( 'Clean Dump data to send' + dump( item_dump ) );
    if ( (!MANAGER.__instance_element_distributor.current_user.is_admin && item_type === "hosts") || bypass_work_area !== MANAGER.CONST.STATE.WORK_FLOW.STAGING && must_save_in_work_area === true ) {
        prev_action = ACTION_SAVE_WORKING_AREA_ENTRY;
        if ( submit_to_stagging ) {
            prev_action = ACTION_SUBMIT_TO_STAGGING;
            MANAGER.__instance_loading.showLoading( _( 'element.submit_to_stagging_in_progress' ) );
            params_list.push( 'submit_to_stagging=1' );
        }
        else {
            MANAGER.__instance_loading.showLoading( _( 'element.save_in_progress' ) );
        }
        if ( params_list.length > 0 ) {
            params_string = '?' + params_list.join( "&" );
        }
        $.post( '/element/q/' + item_type + '/save_in_work_area/' + _id + params_string, item_dump ).success( form_success ).error( form_error );
    }
    else {
        if ( params_list.length > 0 ) {
            params_string = '?' + params_list.join( "&" );
        }
        MANAGER.__instance_loading.showLoading( _( 'element.save_in_progress' ) );
        $.post( '/element/q/' + item_type + '/save/' + _id + params_string, item_dump ).success( form_success ).error( form_error );
    }
}

function disable_page_off_warning () {
    is_edit_mode_on = false;
    $( "#element-btn-cancel > a > span" ).html( _( 'element.back' ) );
    $( "#empty-separator" ).addClass( "hide" );
}

//********************************************  ELEMENT     *********************************************************//
function form_success ( data ) {
    console.log( 'Form send in success mode' );
    var current_time        = new Date();
    var f                   = document.forms[ 'form-element' ];
    var item_type           = f.dataset[ 'type' ];
    var item_id             = MANAGER.__instance_element_distributor.current_element.getUUID();
    var has_item_in_staging = data[ 'has_item_in_staging' ] === true;
    var has_changes         = data[ 'has_changes' ] === true;
    var message             = [];
    
    MANAGER.__instance_loading.removeLoading();
    if ( data.rc === COMMUNICATION.CODE.WARNING ) {
        // Maybe the backend is not happy, but only warn us
        message[ 0 ] = data.text + ' ' + _( 'element.object_saved' ) + ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
        
        if ( has_changes ) {
            message[ 1 ] = data[ 'message_has_changes' ];
        }
        
        
        var msg = {
            'type'         : COMMUNICATION.MESSAGE.WARNING,
            'is_persistent': true,
            'title'        : message
        };
        MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED );
        sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
        setTimeout( mapping( prev_action, MANAGER.__instance_element_distributor.current_user.is_admin, item_type, item_id, has_item_in_staging ) );
    }
    else if ( data.rc !== COMMUNICATION.CODE.SUCCESS ) {
        MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED );
        // Maybe the backend is not happy for something and doesn't want to save data
        show_saving_log( data.text, '', 'alert-error', false );
        SHINKEN.DOM.remove_class_for( '.btn', 'disabled' );
    }
    else {
        MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.RELOADING );
        // Ok no error, let's go!
        message[ 0 ] = '' + data.text + ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
        if ( has_changes ) {
            message[ 1 ] = data[ 'message_has_changes' ];
        }
        var msg = {
            'type'         : COMMUNICATION.MESSAGE.SUCCESS,
            'is_persistent': has_changes,
            'title'        : message
        };
        sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
        setTimeout( mapping( prev_action, MANAGER.__instance_element_distributor.current_user.is_admin, item_type, item_id, has_item_in_staging ) );
    }
}

function form_error ( arg1, arg2, arg3 ) {
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED );
    MANAGER.__instance_loading.removeLoading();
    
    SHINKEN.DOM.remove_class_for( '.btn', 'disabled' );
    SHINKEN.DOM.remove_class_for( '#element-btn-save', 'hide' );
    SHINKEN.DOM.remove_class_for( '#element-btn-submit-to-stagging', 'hide' );
    SHINKEN.DOM.set_inner_HTML_for( '#element-btn-cancel > a > span', _( 'element.cancel' ) );
    SHINKEN.DOM.add_class_for( '#empty-separator', 'hide' );
    if ( arg1.status != COMMUNICATION.CODE.SUCCESS ) {
        var _text_to_display = arg1.status + ' ' + arg1.statusText;
        if ( arg1.status === 0 ) {
            _text_to_display = _( 'element.backend_unreacheable' );
        }
        show_saving_log( _( 'element.error_save' ) + '</br>' + _text_to_display, '', 'alert-error', false );
    }
    $( window ).trigger( 'resize' );
}

function apply_changes () {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    // with_change, submit_to_stagging
    submit_form( true, false );
}

function really_delete_staging_entry () {
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    //var item_id   = f[ '_id' ].value;
    var item_id   = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    // Sample for bool: $('button[name="process_perf_data"].active').val();
    var res     = {};
    prev_action = ACTION_DELETE_ENTRY;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/delete/' + item_id, res ).success( form_success ).error( form_error );
}

//********************************************  ELEMENT HOST     *********************************************************//
function submit_to_stagging ( is_with_comment ) {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    if ( MANAGER.__instance_element_distributor.current_element.is_new ) {
        App.HistoryManager.rollback();
    }
    
    if ( is_with_comment ) {
        var _comment = document.getElementById( "comment-to-submit-for-staging-input" ).value;
        // with_change, submit_to_stagging
        submit_form( false, true, _comment );
    }
    else {
        submit_form( false, true );
    }
    
    close_comment_to_submit_to_stagging();
}

function show_comment_to_submit_to_stagging ( element ) {
    var _element  = document.getElementById( "comment-to-submit-for-staging" );
    var _bounding = element.getBoundingClientRect();
    _element.classList.add( "active" );
    _element.style.top  = _bounding.top + 'px';
    _element.style.left = (_bounding.right + 8) + 'px';
    document.getElementById( "comment-to-submit-for-staging-input" ).focus();
}

function close_comment_to_submit_to_stagging ( e ) {
    if ( e ) {
        e.stopPropagation();
    }
    document.getElementById( "comment-to-submit-for-staging" ).classList.remove( "active" );
    document.getElementById( "comment-to-submit-for-staging-input" ).value = "";
}

function apply_work_area ( propose_delete ) {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    //var item_id   = f[ '_id' ].value;
    var item_id   = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    if ( propose_delete ) {
        prev_action = ACTION_APPLY_DELETE_WORK_AREA;
    }
    else {
        prev_action = ACTION_APPLY_WORK_AREA;
    }
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/apply_work_area/' + item_id + '?ts=' + Date.now(), {} )
     .success( form_success )
     .error( form_error );
}

function reject_work_area () {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    
    var item_sumbit = document.forms[ 'form-element' ];
    var item_type   = $( item_sumbit ).data( 'type' );
    var item_id     = MANAGER.__instance_element_distributor.current_element.getUUID();
    var comment     = $( '#comments-reject' ).val();
    
    comment     = SHINKEN.TOOLS.STRING.cleanXss( comment );
    prev_action = ACTION_REJECT_WORK_AREA;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/reject_submit/' + item_id + '?ts=' + Date.now(), { 'comment': comment } )
     .success( form_success )
     .error( form_error );
}

function really_delete_working_area_entry () {
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    
    var item_id = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    var res     = {};
    prev_action = ACTION_DELETE_WORKING_AREA_ENTRY;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/elements/delete/working_area/' + item_type + '/' + item_id, res ).success( form_success ).error( form_error );
}

function unlock_work_area () {
    if ( confirm( _( 'element.sure' ) ) ) {
        // We do not want to be prompt when we will exit the page, as we are ok to save
        disable_page_off_warning();
        // and do the job
        really_unlock_work_area();
    }
}

function really_unlock_work_area () {
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    var item_id   = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    var res     = {};
    prev_action = ACTION_UNLOCK_WORK_AREA;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/unlock_work_area/' + item_id, res ).success( form_success ).error( form_error );
}

//********************************************  SOURCE RANGE     *********************************************************//
function form_success_network_range ( is_delete ) {
    var current_time = new Date();
    var message      = is_delete ? _( 'element.object_deleted' ) : _( 'element.object_saved' );
    message += ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
    show_saving_log( message, '', 'alert-success', false );
    setTimeout( "location.assign('/sources/' + SOURCE_NAME + '?tab=tab-network-scan');", 1000 );
}

function form_errors_network_range ( arg1, arg2, arg3 ) {
    show_saving_log( _( 'element.error_save' ) + '</br>' + arg1.responseText, '', 'alert-error', false );
    
}

function submit_delete_discovery_form () {
    var data = { _id: MANAGER.__instance_element_distributor.current_element.getUUID() };
    $.post( '/sources/' + SOURCE_NAME + '/discovery/delete/', data ).success( form_success_network_range( true ) ).error( form_errors_network_range );
}

//********************************************  SOURCE RANGE     *********************************************************//
function _private_getCfgFileTemplateForCurrentElementNbTap ( property ) {
    var _number = 2;
    var _size   = property.length;
    switch ( _size ) {
        case 2:
        case 3:
            _number += 1;
        case 4:
        case 5:
        case 6:
        case 7:
            _number += 1;
        case 8:
        case 9:
        case 10:
        case 11:
            _number += 1;
        case 12:
        case 13:
        case 14:
        case 15:
            _number += 1;
        case 16:
        case 17:
        case 18:
        case 19:
            _number += 1;
        case 20:
        case 21:
        case 22:
        case 23:
            _number += 1;
            break;
    }
    var _to_return = "";
    for ( var i = 0; i < _number; i++ ) {
        _to_return += "\t";
    }
    return _to_return;
}

function getCfgFileTemplateForCurrentElement () {
    var _values = getCurrentObjectFromProperty();
    var _object = MANAGER.__instance_element_distributor.current_element;
    var _type   = SHINKEN.TOOLS.STRING.getSubStringUntil( _object.getHelpType(), 0, 1 );
    
    switch ( _object.getType() ) {
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
        case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            _values[ "register" ] = "0";
            break;
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            _type                   = 'host';
            _values[ "register" ]   = "0";
            _values[ "is_cluster" ] = "1";
            break;
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            _type                   = 'host';
            _values[ "is_cluster" ] = "1";
            break;
    }
    
    
    _values[ "_SE_UUID" ]      = "core-" + _type + "-" + _object.getUUID();
    _values[ "_SE_UUID_HASH" ] = SHINKEN.TOOLS.MD5.MD5( _values[ "_SE_UUID" ] );
    
    var _to_return = 'define ' + _type + "{\n";
    var _keys      = Object.keys( _values );
    _keys.sort();
    var _current_key;
    var _current_value;
    var _temp_current_value;
    for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
        _current_key   = _keys[ i ];
        _current_value = _values[ _current_key ];
        if ( _current_key === PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ) {
            _current_value = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL + _current_value;
        }
        if ( _current_value === undefined || _current_value === '' || _current_key === '_id' ) {
            continue;
        }
        if ( typeof _current_value !== 'string' ) {
            _temp_current_value = "";
            if ( _current_value.has_plus ) {
                _temp_current_value += PROPERTY.CONST.STATE_VALUE_PLUS.ON;
            }
            if ( _current_value.links ) {
                if ( _current_key === OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ) {
                    for ( var j = 0, _size_j = _current_value.links.length; j < _size_j; j++ ) {
                        _temp_current_value += '\t' + _current_key + _private_getCfgFileTemplateForCurrentElementNbTap( _current_key );
                        var _check = _current_value.links[ j ].check_link.name;
                        if ( !_check ) {
                            var _temp_check_object = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current_value.links[ j ].check_link._id );
                            if ( _temp_check_object ) {
                                _check = _temp_check_object.getName();
                            }
                        }
                        _temp_current_value += _check + ',' + _current_value.links[ j ].key + ' ' + MANAGER.__instance_element_distributor.getElementValueOfLink( _current_value.links[ j ].value ) + '\n';
                    }
                }
                else {
                    for ( var j = 0, _size_j = _current_value.links.length; j < _size_j; j++ ) {
                        if ( j ) {
                            _temp_current_value += ',';
                        }
                        _temp_current_value += _current_value.links[ j ].name;
                    }
                }
            }
            else if ( _current_value.node ) {
                _temp_current_value = _current_value.raw_value;
            }
            else if ( _current_value.node ) {
                _temp_current_value = _current_value.raw_value;
            }
            
            _current_value = _temp_current_value;
        }
        if ( _current_key === OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ) {
            _to_return += _current_value;
        }
        else {
            _to_return += "\t" + _current_key + _private_getCfgFileTemplateForCurrentElementNbTap( _current_key ) + _current_value + "\n";
        }
    }
    _to_return += "}\n";
    return _to_return;
}

//******************************  END  forms.js   **************************

//******************************  START  element-window.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/window/element-window.js *
'use strict';

WINDOW.Element           = function ( name, dom_element, is_menu ) {
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init                      : function () {
        this.initDomElement();
        if ( this.is_menu ) {
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters             = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current                                      = _dom_element_counters[ i ];
                this.counters[ _current.dataset.counterType ] = new SHINKEN.OBJECT.Counter();
                this.counters[ _current.dataset.counterType ].init( _current );
            }
        }
        else {
            this.errors   = new SHINKEN.OBJECT.Counter();
            this.warnings = new SHINKEN.OBJECT.Counter();
            this.override = new SHINKEN.OBJECT.Counter();
            this.errors.init( this.dom_element.querySelector( '.shinken-error-counter' ) );
            this.warnings.init( this.dom_element.querySelector( '.shinken-warning-counter' ) );
            this.override.init( this.dom_element.querySelector( '.shinken-override-counter' ) );
            
            var _dom_element_user_counter = this.dom_element.querySelector( '.shinken-window-user-counter' );
            if ( _dom_element_user_counter ) {
                this.user_counter = new SHINKEN.OBJECT.Counter();
                this.user_counter.init( _dom_element_user_counter );
            }
            var _dom_element_total_counter = this.dom_element.querySelector( '.shinken-window-total-counter' );
            if ( _dom_element_total_counter ) {
                this.total_counter = new SHINKEN.OBJECT.Counter( null, true );
                this.total_counter.init( _dom_element_total_counter );
            }
        }
    },
    initDomElement            : function () {
        this.id                 = this.dom_element.getAttribute( 'id' );
        this.dom_element_target = document.getElementById( this.id + '-target' );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName                   : function () {
        return this.name;
    },
    getID                     : function () {
        return this.id;
    },
    setHasRequired            : function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setCounterUserWithGroup   : function ( name, user_counter, total_counter ) {
        this.user_counter.update( name, user_counter.counter_final );
        this.total_counter.update( name, total_counter.counter_final );
    },
    setCounterUserWithProperty: function ( name, user_counter_value, total_counter_value ) {
        this.user_counter.update( name, user_counter_value );
        this.total_counter.update( name, total_counter_value );
    },
    setActive                 : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    //********************************************  COUNTER MENU   **************************************************//
    updateCounter             : function ( name, value ) {
        this.counters[ name ].update( "counter", value );
    },
    //********************************************  ERRORS   **************************************************//
    getParentCounter          : function ( prop_override ) {
        if ( !this.parent_counter_object ) {
            if ( prop_override ) {
                this.parent_counter_object = App.Elements.ChecksTab.getCheckInHostElement( prop_override.override_check_uuid_final );
            }
            else {
                this.parent_counter_object = MANAGER.__instance_button_distributor.findButton( COMPONENT.CONST.BTN_NAME.SAVE );
            }
        }
        return this.parent_counter_object;
    },
    setError                  : function ( data_name, nb_error, prop_override ) {
        this.errors.update( data_name, nb_error );
        var _container = this.getParentCounter( prop_override );
        if ( _container ) {
            if ( prop_override ) {
                _container.setErrorOverride( this.name, this.errors.counter_final );
            }
            else {
                _container.setError( this.name, this.errors.counter_final );
            }
        }
    },
    setWarning                : function ( data_name, nb_warning, prop_override ) {
        this.warnings.update( data_name, nb_warning );
        var _container = this.getParentCounter( prop_override );
        if ( _container ) {
            if ( prop_override ) {
                _container.setWarningOverride( this.name, this.warnings.counter_final );
            }
            else {
                _container.setWarning( this.name, this.warnings.counter_final );
            }
        }
    },
    setOverride               : function ( data_name, nb_override, id_button ) {
        this.override.update( data_name, nb_override );
        var _bn_set_override = MANAGER.__instance_button_distributor.findButton( id_button );
        if ( _bn_set_override ) {
            _bn_set_override.setOverride( data_name, nb_override );
        }
    },
    resetErrors               : function () {
        this.warnings.reset();
        this.errors.reset();
        var _container = this.getParentCounter();
        if ( _container ) {
            _container.setError( this.name, this.errors.counter_final );
            _container.setWarning( this.name, this.warnings.counter_final );
        }
    }
};
//******************************  END  element-window.js   **************************

//******************************  START  element-window-group.js   **************************
//* /usr/lib/python2.7/site-packages/shinken/synchronizer/htdocs/js/shinken/window/element-window-group.js *
'use strict';

WINDOW.ElementGroup           = function ( name ) {
    //dom_element
    //size
    this.name = name;
    this.list = {};
    this.init();
};
WINDOW.ElementGroup.prototype = {
    init          : function () {
        this.dom_element = document.querySelector( '.' + WINDOW.CONST.CLASS.WINDOW_GROUP + '[data-name="' + this.name + '"]' );
        this.initWindows();
    },
    initWindows   : function () {
        var _dom_elements = this.dom_element.querySelectorAll( '.' + WINDOW.CONST.CLASS.WINDOW_TAB + '[data-group-name="' + this.name + '"]' );
        this.size         = _dom_elements.length;
        var _current;
        var _current_name;
        for ( var i = 0; i < this.size; i++ ) {
            _current                   = _dom_elements[ i ];
            _current_name              = _current.dataset.name;
            this.list[ _current_name ] = new WINDOW.Element( _current_name, _current );
        }
    },
    clickOnWindow : function ( window_name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            _current.setActive( _current.getName() === window_name );
        }
        if ( window_name === 'datas-override' ) {
            MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_WINDOW_DATA_OVERRIDE, this.name );
        }
    },
    getElementByID: function ( id ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getID() === id ) {
                return _current;
            }
        }
        return null;
    }
};
//******************************  END  element-window-group.js   **************************
