%if code_http != 200:
    <head>
        <style type="text/css">
            @font-face {
                font-family : "shinkenicons";
                src         :
                        url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
                        url("/static/{{app.http_start_time}}/font/shinkenicons.ttf") format("truetype");
                font-weight : normal;
                font-style  : normal;
            }
        </style>
        <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinkon.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/graphs/css/widget_graphs.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/unauthorized.css" rel="stylesheet">

        <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/en.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/fr.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/main.js"></script>

        %if code_http == 403:
            <title>{{app._('unauthorized.403_title')}}</title>
        %elif code_http == 404:
            <title>{{app._('unauthorized.404_title')}}</title>
        %elif code_http == 401:
            <title>{{app._('unauthorized.401_title')}}</title>
        %elif code_http == 500:
            <title>{{app._('unauthorized.500_title')}}</title>
        %end
    </head>

    <body>
        <div class="unauthorized">
            %if code_http == 403:
                <div>{{app._('unauthorized.403_text')}}</div>
                <i class="shinkon-lock"></i>
            %elif code_http == 404:
                <div>{{app._('unauthorized.404_text')}}</div>
                <i class="shinkon-warning"></i>
            %elif code_http == 401:
                <div>{{app._('unauthorized.401_text')}}</div>
                <i class="shinkon-warning"></i>
            %elif code_http == 500:
                <div>{{app._('unauthorized.500_text')}}</div>
                <i class="shinkon-warning"></i>
            %end
        </div>
        <script>
            top.postMessage ( '{"code_http":"{{code_http}}", "uuid":"{{uuid}}"}', '*' );
        </script>
    </body>
%else:
    %helper = app.helper
    %datamgr = app.datamgr

    %rebase widget globals(), js=[], title='All critical impacts for your business', css=['threed/css/threed.css','css/unauthorized.css'], refresh=True, menu_part = '/dashboard', user=user

    <style type="text/css">
        body {
            padding:0px;
            margin:0px;
        }
    </style>

    <script>
        top.postMessage ( '{{name_elt_info}}', '*' );
        var data_graph = {{graph}};
        var main_focus = '{{imp_name}}';
        refresh_timeout = 600;
        inside_widget = true;
        var static_pth = '/static/{{app.http_start_time}}';
    </script>

    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/Grapher2D.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/Control.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/Tween.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/Three.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/Detector.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/TrackballControls.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/engine.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/3d.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/threed/js/bar.js"></script>

    <div class='span12 hide' style='display:none;'></div>
    <div id="graphs"></div>
    <div class='span12 nomargin'>

        <div class='span12 nomargin' style="position:relative;">
            <div id='waiting' style='position:absolute;right:50%;z-index=10;'>Loading data...</div>
            <div id="container" class='' ></div>
        </div>

        <div class='hide span3 well nomargin gray-back top-box-gray' style='position:relative;display:none;'>
            <img src="/static/{{app.http_start_time}}/eltdetail/images/corner-bottom-right.png" style="position:absolute;right:0%;bottom:0%;">
            %for imp in impacts:
                <div class="pull-left row-fluid">
                    %if imp == impact:
                        <div class='pull-left' style="min-width:10px;min-height:30px;background-image: url(/static/{{app.http_start_time}}/eltdetail/images/tab-label.png);background-repeat: no-repeat;background-position: 0 0.16em;margin-left:-10px;padding-top: 0px;"></div>
                    %end

                    <div class="img_status pull-left" style="">
                        <img style="width: 32px;height: 32px;" src="{{helper.get_icon_state(helper.get_small_icon_state(imp))}}">
                    </div>
                    <div class="pull-right">
                        %for j in range(0, imp.business_impact-2):
                            <img src='/static/{{app.http_start_time}}/images/star.png' alt="star">
                        %end
                    </div>

                    <span class="alert-small alert-{{imp.state.lower()}}">{{imp.state}}</span> <a href="/360/{{imp.uuid}}">{{imp.get_name()}}</a>
                </div>
            %end
        </div>

        <div class='hide span3 well nomargin gray-back top-box-gray' style='position:relative;margin-top:30px!important;display:none;'>
            <p style="display:none;" id='stable'>?</p>
            <p class='applytooltip' data-toggle="tooltip" data-placement="bottom" data-original-title="Plug a leap motion device to move the graph with your hands" style="display:inline;"><img src='/static/{{app.http_start_time}}/threed/img/leap.png'/> <span id='leap_detection'>missing</span></p>
            <div id='leap-gauge' class='hide'>
                <p style="display:none;">Null:<canvas id="bar_null" width="70" height="30"></canvas></p>
                <p style="display:inline;">Move:<canvas id="bar_pan" width="70" height="30"></canvas></p>
                <p style="display:inline;">Rotate:<canvas id="bar_rotate" width="70" height="30"></canvas></p>
                <p style="display:none;">Zoom:<canvas id="bar_zoom" width="70" height="30"></canvas></p>
            </div>
        </div>
    </div>
    <div id='bottom-panel'  class='span12 gray-back top-box-gray nomargin hide' style='display:none;'></div>
%end
