#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.


class Shard(object):
    def __init__(self, serialized_configuration, shard_id, host_names):
        self.id = shard_id
        self.serialized_configuration = serialized_configuration
        self.is_assigned = False
        self.assigned_to = None
        self.managed_host_names = host_names
        self._managed_host_names_index = set(host_names)
        
        # We try to remember each "push", so we can know with configuration ids+flavor
        # if a satellite already got it or not :)
        self.push_flavor = 0
    
    
    def get_serialized_configuration(self):
        return self.serialized_configuration
    
    
    def get_managed_host_names(self):
        return self.managed_host_names
    
    
    def has_host_name(self, host_name):
        return host_name in self._managed_host_names_index
