#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn, List
from shinkensolutions.api.synchronizer import SourceTranslatePart
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.shinken_object import ShinkenObject
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.component.option_select import OptionSelectComp


class SelectComp(ShinkenObject):
    def __init__(self, translator, options=None, _id=""):
        # type: (SourceTranslatePart, List[OptionSelectComp], str) -> None
        super(SelectComp, self).__init__(translator)
        self.options = options if options else []
        self.label = ""
        self._id = _id
        self.mapping_options = {}
        self.compute_options_mapping()
        self.select_search_input = None
        self.select_search_input_info = None
        self.label_info = None
        self.has_header = False
        self.has_list_pop_info = False
    
    
    def get_id(self):
        return self._id
    
    
    def add_option(self, to_add):
        if to_add.get_id() not in self.mapping_options:
            self.mapping_options[to_add.get_id()] = to_add
            self.options.append(to_add)
    
    
    def compute_options_mapping(self):
        for option in self.options:
            self.mapping_options[option.get_id()] = option
    
    
    def set_label(self, to_set):
        # type: (str)-> NoReturn
        self.label = to_set
    
    
    def set_label_info(self, to_set):
        # type: (str)-> NoReturn
        self.label_info = to_set
    
    
    def set_has_list_pop_info(self, to_set):
        # type: (bool)-> NoReturn
        self.has_list_pop_info = to_set
    
    def get_html(self, value_selected=[]):
        # type: (List, str)-> str
        options_list = []
        
        _options_size = 0
        for option in self.options:
            class_to_add = ""
            
            if option.get_value() in value_selected:
                self.set_label(option.get_label())
                class_to_add = "shinken-selected"
            options_list.append(option.get_html(class_to_add=class_to_add))
            
            if option.is_shinken_element_option():
                _options_size += 1
        
        _caret = '''<span class="caret"></span>'''
        selector_html = ['''<div class="shinken-select-selector shinken-select-selector-status shinken-user-select-none" onclick="MANAGER.EventManager.clickOnSelector(event)">''',
                         '''<div class="shinken-selector-label shinken-space">%s</div>''' % self.label,
                         _caret,
                         '''</div>'''
                         ]
        
        pop_up_information = ['''<td class="shinken-list-select-info-cell">''',
                              '''<div class="shinken-list-select-info-container">''',
                              '''%s''' % self.select_search_input_info.get_html() if self.select_search_input_info else '',
                              '''<div class="shinken-list-select-info-label">%s</div>''' % self.label_info if self.label_info else '',
                              '''<div class="shinken-list-select-info-elements-container"></div>''',
                              '''</div>''',
                              '''</td>'''
                              ]
        
        options_list_html = ['''<div class="shinken-list-select %s">''' % ('shinken-has-select-header' if self.has_header else ''),
                             '''<table class="shinken-table-list-select">''',
                             '''<tr>''',
                             '''<td class="shinken-list-select-cell">''',
                             '''<div class="shinken-list-select-container">''',
                             '''<div class="list-select-header">''',
                             '''%s''' % self.select_search_input.get_html() if self.select_search_input else '',
                             '''</div>''',
                             '''<div class="list-select-content shinken-user-select-none" >''',
                             '''%s''' % ''.join(options_list),
                             '''</div>''',
                             '''</div>''',
                             '''</td>'''
                             '''%s''' % ''.join(pop_up_information) if self.has_list_pop_info else '',
                             '''</tr>'''
                             '''</table>'''
                             '''</div>'''
                             ]
        _to_return = [''.join(selector_html),
                      ''.join(options_list_html)]
        
        _to_return = ''.join(_to_return)
        return _to_return
