#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.


import os

from shinken.misc.type_hint import NoReturn, Optional, Set
from shinken.objects.config import Config
from .abstract_component import AbstractComponent


class ConfigurationComponent(AbstractComponent):
    
    def __init__(self, conf, host_name, http_start_time):
        # type: (Config , str, int) -> None
        self._conf = conf
        self._daemon_conf = None
        self._list_existing_template_icons = None  # type: Optional[Set]
        self.lang = getattr(self._conf, 'lang', 'en')
        self.share_folder_adress = getattr(self._conf, 'share_dir', '/var/lib/shinken/share')
        self.host_name = host_name
        self.daemon_name = 'daemon_name not set'
        self.http_start_time = http_start_time
    
    # *****************************   INIT  ************************************************************#
    def init(self):
        # type: () -> NoReturn
        self._daemon_conf = next((sync for sync in self._conf.synchronizers.enabled() if sync.is_me(self.host_name)), None)
        
        self.lang = getattr(self._conf, 'lang', 'en')
        self.daemon_name = self._daemon_conf.get_name()
        self.load_existing_template_icons()
    
    
    # *****************************   TEMPLATE ICONS  ************************************************************#
    def load_existing_template_icons(self):
        # type: () -> NoReturn
        self._list_existing_template_icons = set()
        _sets_folders = os.path.join(self.share_folder_adress, 'images', 'sets')
        for _current in os.listdir(_sets_folders):
            _file = os.path.join(_sets_folders, _current)
            if os.path.isdir(_file) and os.path.exists(os.path.join(_file, 'tag.png')):
                self._list_existing_template_icons.add(_current)
    
    
    def is_existing_template_icons(self, template_name):
        # type: () -> bool
        return template_name in self._list_existing_template_icons
