#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.log import logger

CALLBACK_LOG = False


class Callback(object):
    def log(self, item_type, item_state, item_id, action, text):
        if CALLBACK_LOG:
            logger.debug('[callback][%-26s:%-15s:%-20s:%s] - %s' % (item_type, item_state, item_id, action, text))


class PreSaver(Callback):
    def called_before_save(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()


class PostSaver(Callback):
    def called_after_save(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()


class PostLoader(Callback):
    def called_after_load(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()


class PreDeleter(Callback):
    def called_before_delete(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()


class PostDeleter(Callback):
    def called_after_delete(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()


class PostMover(Callback):
    def called_after_move(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()


class PreMover(Callback):
    def called_before_move(self, item_id='', item_type='', item_state='', item=None, old_item=None, user=None, action='', datamanagerV2=None):
        raise NotImplementedError()
