#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from ...dao import DataException
from ..helpers import get_name_from_type
import time


class TrashManager(object):
    COLLECTION_NAME = 'deleted_items'
    
    
    def __init__(self):
        self.mongo = None
    
    
    def set_mongo(self, mongo):
        self.mongo = mongo
    
    
    def save_deleted_item(self, item, item_type, user):
        if not item:
            raise DataException('[%s] save_deleted_item : Please set item' % self.__class__.__name__)
        if not item_type:
            raise DataException('[%s] save_deleted_item : Please set item_type' % self.__class__.__name__)
        if not user:
            raise DataException('[%s] save_deleted_item : Please set user' % self.__class__.__name__)
        
        data_to_save = {
            '_id'      : '%s-%s' % (item_type, item['_id']),
            'item_type': item_type,
            'item_id'  : item['_id'],
            'user'     : user['_id'],
            'date'     : time.time(),
            'name'     : get_name_from_type(item_type, item),
        }
        collection = getattr(self.mongo, TrashManager.COLLECTION_NAME)
        collection.save(data_to_save)
    
    
    def find_deleted_items_by_id(self, item_id, item_type):
        if not item_id:
            raise DataException('[%s] find_item_by_id : Please set item_id' % self.__class__.__name__)
        if not item_type:
            raise DataException('[%s] find_item_by_id : Please set item_type' % self.__class__.__name__)
        _id = '%s-%s' % (item_type, item_id)
        where = {'_id': _id}
        collection = getattr(self.mongo, TrashManager.COLLECTION_NAME)
        item = collection.find_one(where)
        return item


trash_manager = TrashManager()
