#!/usr/bin/python

# -*- coding: utf-8 -*-


import re

from shinken.misc.datamanager import DataManager
from shinken.objects import Businessimpactmodulations, NotificationWays, Escalations, MacroModulations
from shinken.objects import Hosts, Services, Command, Commands, Timeperiods, Hostgroups, Servicegroups, Contactgroups, Resultmodulations


class FakeRegenerator(object):
    def __init__(self):
        return


class DataManagerSKonf(DataManager):
    def __init__(self):
        self.rg = FakeRegenerator()
        self.db = None
    
    
    def load_conf(self, cfg):
        # Do NOT load hosts or services from here
        ts = ['contacts']
        for t in ts:
            v = getattr(cfg, t)
            setattr(self.rg, t, v)
        # But still give them
        self.rg.hosts = Hosts([])
        self.rg.services = Services([])
        _bp_rule = Command({'command_name': 'bp_rule', 'command_line': 'bp_rule'})
        self.rg.commands = Commands([_bp_rule])
        self.rg.timeperiods = Timeperiods([])
        # self.rg.contacts = Contacts([])
        self.rg.hostgroups = Hostgroups([])
        self.rg.servicegroups = Servicegroups([])
        self.rg.contactgroups = Contactgroups([])
        self.rg.businessimpactmodulations = Businessimpactmodulations([])
        self.rg.notificationways = NotificationWays([])
        self.rg.escalations = Escalations([])
        self.rg.macromodulations = MacroModulations([])
        self.rg.resultmodulations = Resultmodulations([])
    
    
    # Get an object and return a dict with it's properties
    def unclass(self, o):
        d = {}
        if o is None:
            return d
        
        # Get even a partial dict of object properties
        properties = o.__class__.properties.keys()
        # TODO: we can't add register to properties, find why
        properties.append('register')
        for prop in properties:
            if hasattr(o, prop):
                d[prop] = getattr(o, prop)
        customs = getattr(o, 'customs', {})
        for (k, v) in customs.iteritems():
            print "SET CUSTOM", k, v
            d[k] = v
        # Inner object are NOT editable by skonf!
        d['editable'] = '0'
        
        # For service we must set the _id like it should :)
        if o.__class__.my_type == 'service':
            print "SET AN INNER ID FOR", o.get_name(), o.id
            d['_id'] = 'inner-%s' % o.id
        
        return d
    
    
    def load_db(self, db):
        self.db = db


    def get_in_db(self, table, key, value, is_tpl=False, pending=False, by_id=False):
        if pending:
            col = getattr(self.db, 'newelements-' + table[:-1])
        else:
            col = getattr(self.db, 'configuration-stagging-' + table[:-1])

        if by_id:
            r = col.find_one({'_id': value})
        else:
            r = col.find_one({key: value})
        return r
    
    
    def get_number_of_pending(self, table, only_tpls, where={}):
        col = getattr(self.db, 'newelements-' + table[:-1])
        where = where.copy()  # as we will edit it, do not risk to change user dict
        if only_tpls:
            where.update({'register': '0'})  # we want real templates
            return col.find(where, {'_id': 1}).count()
        else:
            where.update({'register': {'$ne': '0'}})  # ok, we just do not want templates :)
            return col.find(where, {'_id': 1}).count()
    
    
    # Useful for ACL
    def get_all_host_templates(self, huse):
        print "ACL get_all_host_templates::", huse
        col = getattr(self.db, 'configuration-stagging-host')
        r = col.find({'register': '0', 'name': {'$in': huse}})
        r = list(r)
        print "ACL Founded host templates", r
        return r
    
    
    # Useful for ACL
    def get_all_contactgroups(self):
        col = getattr(self.db, 'configuration-stagging-contactgroup')
        r = col.find({})
        r = list(r)
        print "ACL Founded all contactgroups", r
        return r
    
    
    def get_all_in_db(self, table, pending=False, where={}):
        # If pending look in the newelements-* collection
        if pending:
            col = getattr(self.db, 'newelements-' + table[:-1])
        else:  # ok we should look at the stagging one so :)
            col = getattr(self.db, 'configuration-stagging-' + table[:-1])
        # print "GET ALL FROM", table, col, where
        r = col.find(where)  # even if where is {}, we select all
        return r
    
    
    def get_count_in_db(self, table, pending=False, where={}):
        # If pending look in the newelements-* collection
        if pending:
            col = getattr(self.db, 'newelements-' + table[:-1])
        else:  # ok we should look at the stagging one so :)
            col = getattr(self.db, 'configuration-stagging-' + table[:-1])
        # print "GET ALL FROM", table, col, where
        nb = col.find(where).count()  # even if where is {}, we select all
        return nb
    
    
    def select_in_db(self, table, where, pending=False):
        # If pending look in the newelements-* collection
        if pending:
            col = getattr(self.db, 'newelements-' + table[:-1])
        else:  # ok we should look at the stagging one so :)
            col = getattr(self.db, 'configuration-stagging-' + table[:-1])
        r = col.find(where)
        return r
    
    
    # If pending true give all item new in newelements collections.
    # If pending false give all item new in stagging collections.
    def get_generics(self, table, pending=False, where={}):
        r = []
        for i in self.get_all_in_db(table, pending=pending, where=where):
            r.append(i)
        return r
    
    
    # Give all item in newelements and stagging collections
    def get_all_generics(self, table, where={}):
        r = []
        for i in self.get_all_in_db(table, pending=True, where=where):
            i['_CHANGE'] = 'new'
            r.append(i)
        for i in self.get_all_in_db(table, pending=False, where=where):
            i['_CHANGE'] = 'empty'
            r.append(i)
        return r
    
    
    # Give all host (with template) new in newelements and stagging collections
    def get_all_hosts(self):
        return self.get_all_generics('hosts')
    
    
    # Give all host template new in newelements and stagging collections
    def get_all_hosts_template(self):
        return self.get_all_generics('hosts', where={'register': '0'})
    
    
    # Give all services template new in newelements and stagging collections
    def get_all_services_template_for_service(self):
        return self.get_all_generics('services', where={'register': '0'})
    
    
    # Give all services template new in newelements and stagging collections
    def get_all_services_template_for_service_template(self):
        return self.get_all_generics('services', where={'register': '0', 'name': {"$exists": True, "$ne": ""}})
    
    
    # Give all timeperiods new in newelements and stagging collections
    def get_all_timeperiods(self):
        return self.get_all_generics('timeperiods')
    
    
    # Give all contact template new in newelements and stagging collections
    def get_all_contacts_template(self):
        return self.get_all_generics('contacts', where={'register': '0', 'name': {'$not': re.compile('^shinken-contact$')}})
    
    
    # Merge internal and db hosts in the same list
    def get_hosts(self):
        return self.get_generics('hosts')
    
    
    def get_hostgroups(self):
        return self.get_generics('hostgroups')
    
    
    def get_contacts(self):
        return self.get_generics('contacts')
    
    
    def get_contactgroups(self):
        return self.get_generics('contactgroups')
    
    
    def get_timeperiods(self):
        return self.get_generics('timeperiods')
    
    
    def get_businessimpactmodulations(self):
        return self.get_generics('businessimpactmodulations')
    
    
    def get_macromodulations(self):
        return self.get_generics('macromodulations')
    
    
    def get_notificationways(self):
        return self.get_generics('notificationways')
    
    
    def get_escalations(self):
        return self.get_generics('escalations')
    
    
    def get_commands(self):
        return self.get_generics('commands')
    
    
    def get_services(self):
        return self.get_generics('services')
    
    
    # Get a specific object
    def get_contact(self, cname, key='contact_name', pending=False, by_id=False):
        r = self.get_in_db('contacts', key, cname, pending=pending, by_id=by_id)
        return r
    
    
    def get_contacttpl(self, _id, pending=False, name=''):
        r = None
        if _id:
            r = self.get_in_db('contacts', '_id', _id, is_tpl=True, pending=pending)
        if name:
            r = self.get_in_db('contacts', 'name', name, is_tpl=True, pending=pending)
        return r
    
    
    # Get a specific object
    def get_contactgroup(self, cname, pending=False):
        '''r = self.rg.contactgroups.find_by_name(cname)
        if r:
            r = self.unclass(r)
            print "Will finally give an unclass", r
            return r
        '''
        r = self.get_in_db('contactgroups', '_id', cname, pending=pending)
        return r
    
    
    def get_host(self, _id, pending=False):
        r = self.get_in_db('hosts', '_id', _id, pending=pending)
        return r
    
    
    def get_hosttpl(self, _id, pending=False, name=''):
        r = None
        if _id:
            r = self.get_in_db('hosts', '_id', _id, is_tpl=True, pending=pending)
        if name:
            r = self.get_in_db('hosts', 'name', name, is_tpl=True, pending=pending)
        return r
    
    
    def get_servicetpl(self, hname, pending=False, name=''):
        r = None
        if hname:
            r = self.get_in_db('services', '_id', hname, pending=pending)
        if name:
            r = self.get_in_db('services', 'name', name, pending=pending)
        
        return r
    
    
    def get_hostgroup(self, _id, pending=False):
        r = self.get_in_db('hostgroups', '_id', _id, pending=pending)
        return r
    
    
    def get_command(self, cname, pending=False):
        '''
        for c in self.rg.commands:
            print "DUMP RAW COMMAND", c, c.__dict__
        r = self.rg.commands.find_by_name(cname)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('commands', '_id', cname, pending=pending)
        return r
    
    
    def get_timeperiod(self, cname, pending=False):
        '''
        for c in self.rg.timeperiods:
            print "DUMP RAW COMMAND", c, c.__dict__
        r = self.rg.timeperiods.find_by_name(cname)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('timeperiods', '_id', cname, pending=pending)
        return r
    
    
    def get_businessimpactmodulation(self, n, pending=False):
        '''r = self.rg.businessimpactmodulations.find_by_name(n)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('businessimpactmodulations', '_id', n, pending=pending)
        return r
    
    
    def get_macromodulation(self, n, pending=False):
        '''
        r = self.rg.macromodulations.find_by_name(n)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('macromodulations', '_id', n, pending=pending)
        return r
    
    
    def get_resultmodulation(self, n, pending=False):
        '''
        r = self.rg.resultmodulations.find_by_name(n)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('resultmodulations', '_id', n, pending=pending)
        return r
    
    
    def get_notificationway(self, n, pending=False):
        '''r = self.rg.notificationways.find_by_name(n)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('notificationways', '_id', n, pending=pending)
        return r
    
    
    def get_escalation(self, n, pending=False):
        '''r = self.rg.escalations.find_by_name(n)
        if r:
            r = self.unclass(r)
            print "Will finally give un unclass", r
            return r
        '''
        r = self.get_in_db('escalations', '_id', n, pending=pending)
        return r
    
    
    # Ok for service there is a trick. A service got by default
    # no KEY, so we got ids and uuid with inner-ID or uuid
    def get_service(self, _id, pending=False):
        # print "OK search the service uuid", _srv_id, "in the database"
        r = self.get_in_db('services', '_id', _id, pending=pending)
        return r
    
    
    def build_pack_tree(self, packs):
        
        # dirname sons packs
        t = ('', [], [])
        for p in packs:
            path = p.path
            dirs = path.split('/')
            dirs = [d for d in dirs if d != '']
            pos = t
            for d in dirs:
                print "In the level", d, " and the context", pos
                sons = pos[1]
                print "Get the sons to add me", sons
                
                if not d in [s[0] for s in sons]:
                    print "Add a new level"
                    print "Get the sons to add me", sons
                    node = (d, [], [])
                    sons.append(node)
                # Ok now search the node for d and take it as our new position
                for s in sons:
                    if s[0] == d:
                        print "We found our new position", s
                        pos = s
            
            # Now add our pack to this entry
            print "Add pack to the level", pos[0]
            pos[2].append(p)
        print "The whole pack tree", t
        return t
    
    
    def get_pack_tree(self, packs):
        t = self.build_pack_tree(packs)
        r = self._get_pack_tree(t)
        print "RETURN WHOLE PACK TREE", r
        return r
    
    
    def _get_pack_tree(self, tree):
        print "__get_pack_tree:: for", tree
        name = tree[0]
        sons = tree[1]
        packs = tree[2]
        
        
        # Sort our sons by they names
        def _sort(e1, e2):
            if e1[0] < e2[0]:
                return -1
            if e1[0] > e2[0]:
                return 1
            return 0
        
        
        sons.sort(_sort)
        
        res = []
        if name != '':
            res.append({'type': 'new_tree', 'name': name})
        for p in packs:
            res.append({'type': 'pack', 'pack': p})
        
        for s in sons:
            r = self._get_pack_tree(s)
            res.extend(r)
        if name != '':
            res.append({'type': 'end_tree', 'name': name})
        print "RETURN PARTIAL", res
        return res
    
    
    # We got a pack name, we look for all objects, and search where this
    # host template name is used
    def related_to_pack(self, pack):
        name = pack.get_name().strip()
        print "TRY TO MATCH PACK", name
        
        res = []
        for tname in pack.templates:
            print "Try to find a sub template of a pack", tname
            tname = tname.strip()
            # First try to match the host template
            tpl = None
            for h in self.get_hosts():
                print "Try to match pack with", h, name, h.get('register', '1') == '0', h.get('name', '') == name
                if h.get('register', '1') == '0' and h.get('name', '') == tname:
                    print "MATCH FOUND for", tname
                    tpl = h
                    break
            print "And now the services of this pack template", tname
            services = []
            for s in self.get_services():
                # I want only the templates
                if s.get('register', '1') != '0':
                    continue
                use = s.get('host_name', '')
                elts = use.split(',')
                elts = [e.strip() for e in elts]
                if tname in elts:
                    print "FOUND A SERVICE THAT MA5TCH", s.get('service_description', '')
                    services.append(s)
            res.append((tpl, services))
        
        return res


datamgr = DataManagerSKonf()
