App.Main = (function ( self ) {
    "use strict";
    var _sources_list;
    self.init = function () {
        if ( MANAGER.__instance_element_distributor.current_user.is_admin ) {
            
            _sources_list = JSON.parse( SHINKEN.TOOLS.STRING.b64Decode( sources ) );
            
            var _source_all = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
            _source_all.init( _sources_list );
            _source_all.sanatizeObject();
            _source_all.startAutoRefresh();
        }
    };
    
    return self;
})( App.Main || {} );

// --- Table list elements
function hook_call_configuration ( data ) {
    var detail      = data[ 'detail' ];
    var have_change = {};
    var new_item,
        change_item,
        stagging_item,
        display_new,
        display_change,
        block_with_change;
    
    var sub_type = {
        'elements'                 : [],
        'clusters'                 : [ 'clusters', 'clustertpls' ],
        'clustertpls'              : [],
        'hosts'                    : [ 'hosts', 'hosttpls', 'hostgroups' ],
        'hosttpls'                 : [],
        'hostgroups'               : [],
        'serviceshosts'            : [ 'serviceshosts', 'serviceshosttpls', 'servicesclusters', 'servicesclustertpls', 'servicetpls' ],
        'serviceshosttpls'         : [],
        'servicesclusters'         : [],
        'servicesclustertpls'      : [],
        'servicetpls'              : [],
        'contacts'                 : [ 'contacts', 'contacttpls', 'contactgroups' ],
        'contacttpls'              : [],
        'contactgroups'            : [],
        'escalations'              : [],
        'notificationways'         : [],
        'commands'                 : [],
        'businessimpactmodulations': [ 'businessimpactmodulations', 'macromodulations', 'resultmodulations' ],
        'macromodulations'         : [],
        'resultmodulations'        : [],
        'timeperiods'              : [],
        'packs'                    : [],
        'plugins'                  : []
    };
    
    for ( var item_type in detail ) {
        // console.log ( item_type );
        new_item      = detail[ item_type ][ 'new' ];
        change_item   = detail[ item_type ][ 'change' ];
        stagging_item = detail[ item_type ][ 'stagging' ];
        
        display_new    = new_item > 0;
        display_change = change_item > 0;
        if ( display_new ) {
            $( ".block-new-" + item_type ).show();
        }
        else {
            $( ".block-new-" + item_type ).hide();
        }
        if ( display_change ) {
            $( ".block-change-" + item_type ).show();
        }
        else {
            $( ".block-change-" + item_type ).hide();
        }
        
        have_change[ item_type ] = display_new || display_change;
        
        $( ".counter-stagging-" + item_type ).html( stagging_item );
        $( ".counter-change-" + item_type ).html( change_item );
        $( ".counter-new-" + item_type ).html( '+' + new_item );
    }
    
    for ( item_type in have_change ) {
        block_with_change = false;
        if ( sub_type[ item_type ].length > 1 ) {
            // console.log ( "sub_type[ " + item_type + " ] " + sub_type[ item_type ] );
            sub_type[ item_type ].forEach( function ( subtype ) {
                block_with_change = block_with_change || have_change[ subtype ];
                // console.log ( "have_change[ " + subtype + " ] " + have_change[ subtype ] );
            } );
        }
        else {
            block_with_change = have_change[ item_type ];
        }
        
        var $top_info_block = $( ".top-info-block-" + item_type );
        var $info_block     = $( ".info-block-" + item_type );
        
        $top_info_block.removeClass( 'col-block-details col-block' );
        $info_block.removeClass( 'block block-details' );
        
        if ( block_with_change ) {
            $top_info_block.addClass( 'col-block-details' );
            $info_block.addClass( 'block-details' );
            
            $( ".with-change-" + item_type ).show();
            $( ".no-change-" + item_type ).hide();
        }
        else {
            $top_info_block.addClass( 'col-block' );
            $info_block.addClass( 'block' );
            
            $( ".with-change-" + item_type ).hide();
            $( ".no-change-" + item_type ).show();
        }
    }
}
//********************************************  DOM IS READY   ******************************************************//
var doActionWhenDomReady = function ( e ) {
    App.Main.init();
    $( '[data-location]' ).on( 'mouseenter', function () {
        $( this ).parent().closest( '[data-location]' ).removeClass( 'hover' );
        $( this ).addClass( 'hover' );
    } ).on( 'mouseleave', function ( e ) {
        $( this ).parent().closest( '[data-location]' ).addClass( 'hover' );
        $( this ).removeClass( 'hover' );
    } ).on( 'click', function ( e ) {
        e.stopPropagation();
        location.assign( $( this ).data( "location" ) );
    } );
    MANAGER.__instance_loading.setIsReady( true );
};