//__lib__ lib_external
'use strict';

COMPONENT.InputRange           = function ( dom_element, property ) {
    // dom_input_range
    // component_label_input
    // value
    // value_from_user
    // min
    // max
    // unit
    // dom_label_value
    // type_range
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init                 : function ( dom_element, property ) {
        this.type_range      = dom_element.dataset.type;
        this.dom_input_range = dom_element.querySelector( ".shinken-range-container input" );
        switch ( property.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), property );
                if ( property.is_mass_change ) {
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                }
                this.value = this.dom_input_range.dataset.lastValueFromUser;
                break;
            
            default:
                this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
                this.value                 = parseInt( this.dom_input_range.dataset.lastValueFromUser ) + "";
                break;
        }
        this.value_from_user = property.is_mass_change ? '' : this.value;
        this.min             = this.dom_input_range.getAttribute( 'min' );
        this.max             = this.dom_input_range.getAttribute( 'max' );
        this.unit            = dom_element.dataset.unit;
        this.property_name   = property.getName();
        this.is_mass_change  = property.is_mass_change;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, parent || this );
    },
    setValue             : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = false;
        }
        this.value                 = to_set;
        this.dom_input_range.value = to_set;
        if ( this.component_input ) {
            if ( updateInputField && this.component_input.getValue() !== to_set ) {
                this.updateInput();
            }
            else if ( !updateInputField ) {
                this.emptyInput();
            }
        }
        else {
            this.updateLabel();
        }
    },
    setValueFromUser     : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = true;
        }
        if ( to_set === null || to_set === undefined ) {
            to_set = this.dom_input_range.value;
            if ( this.component_input && to_set !== "0" && to_set !== "100" ) {
                to_set += ".000";
            }
        }
        to_set               = to_set + '';
        this.value_from_user = to_set;
        this.setValue( to_set, updateInputField );
    },
    updateInput          : function () {
        this.component_input.dom_element.value = this.value;
        this.component_input.setValue();
        this.component_input.validateValueInput();
    },
    emptyInput           : function () {
        this.component_input.dom_element.value = '';
        this.component_input.setValue();
        this.component_input.resetCounters();
        this.component_input.setStatus( COMPONENT.CONST.STATUS.NONE );
        this.component_input.validateValueInput();
    },
    updateLabel          : function () {
        var _to_set;
        if ( this.is_mass_change && this.value === '' ) {
            _to_set = _( "mass-change.label.enter_a_value" );
        }
        else {
            switch ( this.type_range ) {
                case PROPERTY.CONST.TYPES.RANGE:
                    _to_set = this.value + this.unit;
                    break;
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    _to_set = _( "element.business_impact_" + this.value );
                    break;
            }
        }
        this.component_label_input.updateLabel( _to_set );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue             : function () {
        return this.value;
    },
    getValueFromUser     : function () {
        return this.value_from_user;
    },
    getComponents        : function () {
        var _to_return = [];
        if ( this.component_input ) {
            _to_return.push( this.component_input );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );