'use strict';

MANAGER.DistributorPropertyManager           = function () {
    this.init();
};
MANAGER.DistributorPropertyManager.prototype = {
    init                           : function () {
        this.reset();
    },
    reset                          : function () {
        this.elements           = {};
        this.last_element_focus = null;
    },
    createNewPropertyFrom                  : function ( property, synchronized_name ) {
        if ( !property ){
            return;
        }
        property.synchronized_elements = {};
        var _to_add = DOM.Service.cloneElement( property.dom_element, {"data-name" : PROPERTY.BuildSynchroName(property.getName(), synchronized_name ), "data-is-synchro" : true, "data-synchro-name" : synchronized_name} );
        DOM.Service.addElementAfterTo(_to_add, property.dom_element);
    },
    createElement                  : function ( name, selector, dom_element, synchronized_name ) {
        var _to_return = null;
        
        if ( !selector ) {
            if ( synchronized_name ){
                this.createNewPropertyFrom( this.getElement(name), synchronized_name);
                selector = '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE + '[data-name=' + PROPERTY.BuildSynchroName(name, synchronized_name ) + ']';
            }
            else {
                selector = '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE + '[data-name=' + name + ']';
            }
        }
        var _dom_element = dom_element;
        if ( !dom_element ) {
            try {
                var _dom_element = document.querySelector( selector );
            }
            catch ( e ) {
                console.log( 'Invalid name property' );
            }
        }
        
        if ( !_dom_element ) {
            return _to_return;
        }
        
        if ( !MANAGER.__instance_element_distributor.current_user ) {
            return _to_return;
        }
        
        var _type = _dom_element.dataset.type;
        switch ( _type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                _to_return = new PROPERTY.MultiSelect( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.BOOLEAN:
                _to_return = new PROPERTY.Boolean( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                _to_return = new PROPERTY.StringInput( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                _to_return = new PROPERTY.Range( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                _to_return = new PROPERTY.SingleSelect( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                _to_return = new PROPERTY.CheckboxSample( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _to_return = new PROPERTY.SingleSelectWithInput( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.DATA:
                _to_return = new PROPERTY.Data();
                _to_return.initWithDomElement( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                _to_return = new PROPERTY.CheckboxMulti( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _to_return = new PROPERTY.MultiLine( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                _to_return = new PROPERTY.StringInputWithDropDown( _dom_element );
                break;
            default:
                console.error( '[MANAGER.DistributorPropertyManager] This property type of [' + name + '] is not managed yet!', _type );
        }
        if ( synchronized_name ){
            this.elements[ PROPERTY.BuildSynchroName(name, synchronized_name ) ] = _to_return;
            MANAGER.HelpManager.cloneMapping( name, PROPERTY.BuildSynchroName(name, synchronized_name ) );
        }
        else {
            this.elements[ name ] = _to_return;
        }
        return _to_return;
    },
    findElement                    : function ( name, focusing, selector, dom_element, synchronized_name ) {
        if ( !name ) {
            return;
        }
        if ( name.startsWith( '@' ) ) { // Temp TODO test //sert a filtrer certain champs non visuel
            return;
        }
        var _to_return = this.getElement( name, synchronized_name );
        if ( !_to_return ) {
            _to_return = this.createElement( name, selector, dom_element, synchronized_name );
        }
        if ( focusing === -1 ) {
            this.setLastIntanceFocus();
        }
        else if ( focusing ) {
            this.setLastIntanceFocus( _to_return );
        }
        return _to_return;
    },
    getElement                     : function ( name, synchronized_name ) {
        if ( synchronized_name ){
            return this.elements[ PROPERTY.BuildSynchroName(name, synchronized_name ) ];
        }
        return this.elements[ name ];
    },
    setElement                     : function ( name, element ) {
        this.elements[ name ] = element;
    },
    getAllElements                 : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
    },
    getDataWithName                : function ( name_data ) {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        if ( !_to_return ){
            return null;
        }
        var _current;
        for ( var i = 0, _size = _to_return.length; i < _size; i++ ) {
            _current = _to_return[ i ];
            if ( _current.getName() === name_data ) {
                return _current;
            }
        }
        return null;
    },
    getAllDatasSorted              : function () {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        _to_return     = SHINKEN.TOOLS.ARRAY.sortArray( _to_return, "name" );
        return _to_return;
    },
    getAllOverrideProp             : function () {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "is_override", true );
        return _to_return;
    },
    getAllOverridePropByCheckId    : function ( uuid ) {
        var _to_return = this.getAllElements();
        var _to_return = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "override_check_uuid_final", uuid );
        return _to_return;
    },
    getAllDataOverridePropByCheckId: function ( uuid ) {
        var _to_return = this.getAllOverridePropByCheckId( uuid );
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        return _to_return;
    },
    getFirstOverridePropWithName   : function ( property_override_name ) { //FOR DOCUMENTATION
        var _to_return = this.getAllOverrideProp();
        for ( var i = 0, _size_i = _to_return.length; i < _size_i; i++ ) {
            if ( _to_return[ i ].override_prop_name === property_override_name ) {
                return _to_return[ i ];
            }
        }
        return null;
    },
    hasOverride                    : function ( check_in_page_host ) {
        var _overrides_prop = this.getAllOverrideProp();
        var _to_return      = false;
        var _current;
        var _current_value;
        for ( var i = 0, _size = _overrides_prop.length; i < _size; i++ ) {
            _current = _overrides_prop[ i ];
            _current_value = _current.getValue();
            if ( !_current_value || _current_value === PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ){
                continue;
            }
            if ( _current.override_check_uuid_final === check_in_page_host.getDomUUID() ) {
                _to_return             = true;
                if ( check_in_page_host.is_dfe ) {
                    _current.is_not_linked = false;
                }
            }
        }
        return _to_return;
    },
    deleteOverrideProp             : function ( check_in_page_host, host_in_page_host ) {
        var _datas = this.getAllElements();
        var _current_property;
        for ( var i = 0, _size_datas = _datas.length; i < _size_datas; i++ ) {
            _current_property = _datas[ i ];
            if ( _current_property.override_check_name === check_in_page_host.name ) {
                this.removeElement( _current_property.name, check_in_page_host, host_in_page_host );
            }
        }
    },
    removeElement                  : function ( name, check_in_page_host, host_in_page_host ) {
        var _to_remove = this.getElement( name );
        if ( _to_remove ) {
            if ( _to_remove.is_override && host_in_page_host && check_in_page_host ) {
                MANAGER.__instance_element_distributor.current_element.addOverrideByProperty( _to_remove, check_in_page_host, host_in_page_host );
            }
            delete this.elements[ name ];
        }
    },
    setLastIntanceFocus            : function ( _to_set ) {
        if ( this.last_element_focus && this.last_element_focus !== _to_set ) {
            if( this.last_element_focus.do_after_action_after_loosing_focus ){
                MANAGER.ListenerEventManager.afterActionProperty( this.last_element_focus );
                this.last_element_focus.do_after_action_after_loosing_focus = false;
            }
            this.hidePopups();
        }
        this.last_element_focus = _to_set;
    },
    getLastIntanceFocus            : function ( _to_set ) {
        return this.last_element_focus;
    },
    hidePopups                     : function () {
        if ( this.last_element_focus ) {
            this.last_element_focus.hidePopup();
            this.last_element_focus = null;
        }
    },
    finalyzeModel                  : function () {
        var _object = this.getElement( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        if ( _object ) {
            _object.getSelector().setMaximumSelected( PROPERTY.CONST.MAX_SELECTABLE_ITEMS.RESULT_MODULATIONS );
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
        if ( _object ) {
            _object.has_everybody_default = _object.default_value === 'everyone';
        }
    },
    finalyzeView                   : function () {
        MANAGER.__instance_element_distributor.list_templates.finalyzeView();
        
        var _object = this.getElement( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        if ( _object ) {
            _object.updateView();
        }
        //
        //var _object = this.getElement( PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS );
        //if ( _object ) {
        //    MANAGER.ListenerEventManager.afterActionProperty( _object );
        //}
        //
        //var _object = this.getElement( PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS );
        //if ( _object ) {
        //    MANAGER.ListenerEventManager.afterActionProperty( _object );
        //}
        var _object = this.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
        if ( _object ) {
            _object.updateView();
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.ENABLED );
        if ( _object ) {
            _object.updateView();
        }
    },
    unSetAllOverrideFor            : function ( check_in_page_host ) {
        var properties = this.getAllOverridePropByCheckId( check_in_page_host.getDomUUID() );
        var _size      = properties.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = properties[ i ];
            if ( _current.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                _current.unset();
            }
        }
    }
};
MANAGER.__instance_property_distributor      = new MANAGER.DistributorPropertyManager();
