'use strict';

PROPERTY.CheckboxMulti           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_checkbox
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    this.init( dom_element );
};
PROPERTY.CheckboxMulti.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_checkbox_read     = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.READ + '"]' ) );
        this.component_checkbox_create   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.CREATE + '"]' ) );
        this.component_checkbox_organize = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE + '"]' ) );
        this.component_checkbox_modify   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.MODIFY + '"]' ) );
        this.component_checkbox_delete   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.DELETE + '"]' ) );
        this.component_checkbox_all      = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.ALL + '"]' ) );
        this.component_btn_default       = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        this.component_btn_inheritance   = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.checkErrorWarning();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    checkErrorWarning         : function () {
    },
    askComputeAfterChange     : function () {
        this.setStateInheritance( false );
        this.component_checkbox.setChecked();
        this._computeState();
    },
    ___clickOnRadioBtn           : function () {
        var _is_on = this.component_btn_default.isOn();
        if ( _is_on ) {
            return;
        }
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.ON );  //UTILE ??
        this._computeState();
    },
    ___clickOnCheckboxInput      : function ( name ) {
        var _current;
        switch ( name ) {
            case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                _current = this.component_checkbox_read;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
                _current = this.component_checkbox_create;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
                _current = this.component_checkbox_organize;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
                _current = this.component_checkbox_modify;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                _current = this.component_checkbox_delete;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                _current = this.component_checkbox_all;
                break;
            
        }
        var _value = !_current.isCheckedUser();
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _value = !_current.isCheckedDefault();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( !this.component_btn_inheritance.isSet() ) {
                    _value = !_current.isCheckedDefault();
                }
                else {
                    _value = !_current.isCheckedInheritance();
                }
                break;
        }
        _current.setCheckedUser( _value );
        this.synchronizeAfterClick( name, _current );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAfterClick     : function ( name, checkbox ) {
        switch ( name ) {
            case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                if ( !checkbox.isCheckedUser() ) {
                    this.component_checkbox_create.setCheckedUser( false );
                    this.component_checkbox_organize.setCheckedUser( false );
                    this.component_checkbox_modify.setCheckedUser( false );
                    this.component_checkbox_delete.setCheckedUser( false );
                    this.component_checkbox_all.setCheckedUser( false );
                }
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
            case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
            case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
            case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                if ( checkbox.isCheckedUser() ) {
                    this.component_checkbox_read.setCheckedUser( true );
                }
                else {
                    this.component_checkbox_all.setCheckedUser( false );
                }
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                var _value = checkbox.isCheckedUser();
                this.component_checkbox_read.setCheckedUser( _value );
                this.component_checkbox_create.setCheckedUser( _value );
                this.component_checkbox_organize.setCheckedUser( _value );
                this.component_checkbox_modify.setCheckedUser( _value );
                this.component_checkbox_delete.setCheckedUser( _value );
                break;
            
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_SET ){
            return;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT ){
            if ( this.component_btn_inheritance.isSet() ){
                return;
            }
        }
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    computeInheritanceCheckbox: function () {
        var _splitted = this.inherited_value.split( ',' );
        for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
            switch ( _splitted[i] ) {
                case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                    this.component_checkbox_read.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
                    this.component_checkbox_create.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
                    this.component_checkbox_organize.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
                    this.component_checkbox_modify.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                    this.component_checkbox_delete.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                    this.component_checkbox_read.setCheckedInheritance( true );
                    this.component_checkbox_create.setCheckedInheritance( true );
                    this.component_checkbox_organize.setCheckedInheritance( true );
                    this.component_checkbox_modify.setCheckedInheritance( true );
                    this.component_checkbox_delete.setCheckedInheritance( true );
                    this.component_checkbox_all.setCheckedInheritance( true );
                    break;
            }
        }
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_btn_default.isOn() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                    break;
                default:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
            }
        }
        else if ( this.component_btn_default.isOn() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    ___unset                  : function () {
        this.___clickOnRadioBtn( '' );
        this._computeState();
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : '';
        }
        var _to_return = '';
        _to_return += this.component_checkbox_delete.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_modify.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_organize.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_create.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_read.isCheckedUser() ? '1' : '0';
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype(PROPERTY.CheckboxMulti ,PROPERTY.Interface);