'use strict';

SOURCE.Range           = function ( data, is_single_display ) {
    //name
    //state
    //enabled
    //description
    //ip_range
    //list_dom_element
    this.current_name      = '';
    this.is_single_display = !!is_single_display;
    this.init( data );
};
SOURCE.Range.prototype = {
    init                 : function ( data ) {
        this.initProperties();
        this.updateData( data );
        this.loadDomElements();
    },
    initProperties       : function () {
        this[ SOURCE.CONST.RANGE.NAME ]        = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.NAME );
        this[ SOURCE.CONST.RANGE.STATE ]       = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.STATE );
        this[ SOURCE.CONST.RANGE.ENABLED ]     = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.ENABLED );
        this[ SOURCE.CONST.RANGE.DESCRIPTION ] = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.DESCRIPTION );
        this[ SOURCE.CONST.RANGE.IP_RANGE ]    = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.IP_RANGE );
        this[ SOURCE.CONST.RANGE.SOURCE_NAME ] = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.SOURCE_NAME );
    },
    updateData           : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData              : function ( key, value ) {
        switch ( key ) {
            
            case SOURCE.CONST.RANGE.NAME:
                this.current_name = value;
            case SOURCE.CONST.RANGE.STATE:
            case SOURCE.CONST.RANGE.DESCRIPTION:
            case SOURCE.CONST.RANGE.IP_RANGE:
            case SOURCE.CONST.RANGE.SOURCE_NAME:
                this[ key ].updateValue( value );
                break;
            case SOURCE.CONST.RANGE.ENABLED:
                this[ key ].updateValue( value );
                if ( this.is_single_display && this.list_dom_element ) {
                    for ( var i = 0, _size_i = this.list_dom_element.length; i < _size_i; i++ ) {
                        this.list_dom_element[ i ].dataset.isActive = value ? "1" : "0";
                    }
                }
                break;
            
            case SOURCE.CONST.RANGE.ID:
                this[ key ] = value;
                break;
            
            //default:
            //    console.warn( "[setDataRange]", "[IGNORED DATA]", "[" + key + "]", value );
        }
    },
    getSourceName        : function () {
        return this[ SOURCE.CONST.RANGE.SOURCE_NAME ].value;
    },
    getName              : function () {
        return this[ SOURCE.CONST.RANGE.NAME ].value;
    },
    getId                : function () {
        return this[ SOURCE.CONST.RANGE.ID ];
    },
    getDomSelector       : function () {
        if ( this.is_single_display ) {
            return '.shinken-network-scan-row[data-id="' + this.getId() + '"]';
        }
        else {
            return '.line-source[data-name="' + this.getSourceName() + '"] .line-discovery[data-name="' + this.getName() + '"]';
        }
    },
    loadDomElements      : function () {
        this.list_dom_element = document.querySelectorAll( this.getDomSelector() );
        if ( !this.list_dom_element.length ) {
            var _self = this;
            setTimeout( function () {
                _self.loadDomElements();
            }, 1000 );
            return;
        }
        var _size = this.list_dom_element.length;
        this[ SOURCE.CONST.RANGE.NAME ].loadDomElements( this.list_dom_element, _size );
        this[ SOURCE.CONST.RANGE.ENABLED ].loadDomElements( this.list_dom_element, _size );
        this[ SOURCE.CONST.RANGE.IP_RANGE ].loadDomElements( this.list_dom_element, _size );
        this[ SOURCE.CONST.RANGE.DESCRIPTION ].loadDomElements( this.list_dom_element, _size );
    },
    createDomFromTemplate: function ( index_before ) {
        var _template = document.getElementById( "id-shinken-template-ip-range-discovery-lines" ).innerHTML;
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_name_$$$", this[ SOURCE.CONST.RANGE.NAME ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_source_name_$$$", this[ SOURCE.CONST.RANGE.SOURCE_NAME ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_id_$$$", this[ SOURCE.CONST.RANGE.ID ] );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_ip_range_$$$", this[ SOURCE.CONST.RANGE.IP_RANGE ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_note_$$$", this[ SOURCE.CONST.RANGE.DESCRIPTION ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_class_enable_$$$", this[ SOURCE.CONST.RANGE.ENABLED ].value ? 'conf-enabled' : 'conf-disabled' );
        var _source   = MANAGER.__instance_source_distributor.findSource( this[ SOURCE.CONST.RANGE.SOURCE_NAME ].value );
        for ( var i = 0, _size_i = _source.list_dom_element.length; i < _size_i; i++ ) {
            var _to_add = DOM.Service.createElement( "table", {}, _template );
            if ( index_before !== undefined ) {
                var _dom_existing = _source.list_dom_element[ i ].querySelectorAll( ".table-discovery-lines .line-discovery" )[ index_before ];
                if ( _dom_existing ) {
                    DOM.Service.insertElementBefore( _dom_existing, _to_add.firstElementChild.firstElementChild );
                    continue;
                }
            }
            DOM.Service.addElementTo( _to_add.firstElementChild.firstElementChild, _source.list_dom_element[ i ].querySelector( ".table-discovery-lines .shinken-target-ip-range-container" ) );
        }
        return this.loadDomElements();
    },
    isEnabled            : function () {
        return this[ SOURCE.CONST.RANGE.ENABLED ].value;
    },
    toogleEnable         : function () {
        var _is_enabled = !this.isEnabled();
        
        this.setData( SOURCE.CONST.RANGE.ENABLED, _is_enabled );
        
        var _enabled = _is_enabled ? COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.CONST.ENABLED : COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.CONST.DISABLED;
        
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.SOURCE_NAME
                     + this.getSourceName()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.CONF_ID
                     + this.getId()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.ENABLED
                     + _enabled,
            success: function ( data ) {
                if ( !self.is_single_display ) {
                    var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                    _sources.refresh();
                }
                else {
                    var _source = MANAGER.__instance_source_distributor.findSource( self.getSourceName() );
                    _source.askForRefresh();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    remove               : function () {
        for ( var i = 0, _size_i = this.list_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.removeElement( this.list_dom_element[ i ] );
        }
    }
};