PROPERTY.CONST.VALIDATOR.COMPLEX        = {
    EQUAL              : "=",
    NOT                : "!",
    AND                : "&",
    OR                 : "|",
    BEGIN              : ">",
    END                : "<",
    STAR               : "*",
    QUOTE              : '"',
    OPENING_PARENTHESIS: '(',
    CLOSING_PARENTHESIS: ')'
};
SHINKEN.TOOLS.SHINKEN_VALIDATOR_COMPLEX = {
    //**************************************   COMPLEX EXPRESSIONS    ********************************//
    _validate_filter_input_with_dropdown_focus: function ( value ) {
        var _to_return          = new OBJECT.Messages();
        _to_return.no_duplicate = true;
        if ( !value ) {
            return _to_return;
        }
        var _in_quotes                             = false;
        var _tmp                                   = "";
        var _tmp_to_validate                       = "";
        var _found_incompatible_modifiers_reported = false;
        
        for ( var i = 0; i < value.length; i++ ) {
            if ( value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
                continue;
            }
            if ( _in_quotes ) {
                _tmp += value[ i ];
                _tmp_to_validate += "X";
                continue;
            }
            
            if ( value.slice( i, i + 1 ).match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_filter_operators ) ) {
                if ( _tmp_to_validate === "" ) {
                    _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, _( "validator.filter.expression_two_successive_operators" ) );
                }
                if ( ((_tmp_to_validate.match( PROPERTY.CONST.VALIDATOR.REGEXS.compatible_filter_modifiers ) && _tmp_to_validate.indexOf( '=' ) !== -1) || SHINKEN.TOOLS.STRING.getNumberOccurence( _tmp_to_validate, '=' ) > 1) && !_found_incompatible_modifiers_reported ) {
                    _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_multiple_modifiers" ), _tmp ) );
                    _found_incompatible_modifiers_reported = true;
                }
                _tmp             = "";
                _tmp_to_validate = "";
            }
            else {
                _tmp += value[ i ];
                _tmp_to_validate += value[ i ];
            }
            
        }
        if ( _found_incompatible_modifiers_reported ) { // We already have incompatible modifiers so no need to check again
            return _to_return;
        }
        
        if ( (_tmp_to_validate.match( PROPERTY.CONST.VALIDATOR.REGEXS.compatible_filter_modifiers ) && _tmp_to_validate.indexOf( '=' ) !== -1) || SHINKEN.TOOLS.STRING.getNumberOccurence( _tmp_to_validate, '=' ) > 1 ) {
            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_multiple_modifiers" ), _tmp ) );
        }
        return _to_return;
    },
    
    _validate_filter_input_with_dropdown_not_focus: function ( value ) {
        var _to_return          = new OBJECT.Messages();
        _to_return.no_duplicate = true;
        if ( !value ) {
            return _to_return;
        }
        var _error_messages = [];
        this._parse_filter_expression( _error_messages, value );
        _to_return.addMessages( _error_messages );
        return _to_return;
    },
    isQuotedExpression                            : function ( value ) {
        return SHINKEN.TOOLS.STRING.startsWith( value, PROPERTY.CONST.VALIDATOR.COMPLEX.QUOTE ) && SHINKEN.TOOLS.STRING.endsWith( value, PROPERTY.CONST.VALIDATOR.COMPLEX.QUOTE );
    },
    isParenthesisExpression                       : function ( value ) {
        return SHINKEN.TOOLS.STRING.startsWith( value, PROPERTY.CONST.VALIDATOR.COMPLEX.OPENING_PARENTHESIS ) && SHINKEN.TOOLS.STRING.endsWith( value, PROPERTY.CONST.VALIDATOR.COMPLEX.CLOSING_PARENTHESIS );
    },
    hasOperatorBetweenParenthesis                 : function ( messages, value, _indexes_parenthesis ) {
        var _splitted = SHINKEN.TOOLS.STRING.extraTextNotBetween( value, _indexes_parenthesis );
        var _size     = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            var _current = _splitted[ i ];
            if ( i === 0 && (!_current || _current === PROPERTY.CONST.VALIDATOR.COMPLEX.NOT) ) {
                continue;
            }
            if ( (i === _size - 1) && !_current ) {
                continue;
            }
            var _indexes_AND = SHINKEN.TOOLS.STRING.indexesOf( _current, PROPERTY.CONST.VALIDATOR.COMPLEX.AND );
            var _indexes_OR  = SHINKEN.TOOLS.STRING.indexesOf( _current, PROPERTY.CONST.VALIDATOR.COMPLEX.OR );
            var _indexes_STAR  = SHINKEN.TOOLS.STRING.indexesOf( _current, PROPERTY.CONST.VALIDATOR.COMPLEX.STAR );
            if ( !(_indexes_OR.length + _indexes_AND.length + _indexes_STAR.length) ) {
                return false;
            }
        }
        return true;
    },
    countOperators                                : function ( messages, value ) {
        var _indexes_QUOTES = SHINKEN.TOOLS.STRING.indexesOf( value, PROPERTY.CONST.VALIDATOR.COMPLEX.QUOTE );
        var _to_return      = 0;
        _to_return += SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.EQUAL, _indexes_QUOTES ).length;
        if ( _to_return ) {
            _to_return += SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.STAR, _indexes_QUOTES ).length;
        }
        _to_return += SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.BEGIN, _indexes_QUOTES ).length;
        _to_return += SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.END, _indexes_QUOTES ).length;
        return _to_return;
    },
    containsUnexpectedOperators                   : function ( messages, value ) {
        var _indexes_QUOTES = SHINKEN.TOOLS.STRING.indexesOf( value, PROPERTY.CONST.VALIDATOR.COMPLEX.QUOTE );
        if ( SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.NOT, _indexes_QUOTES ).length ) {
            messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( 'validator.filter.expression_content_has_not_char' ) ) );
        }
    },
    cleanOperator                                 : function ( messages, value ) {
        var _start = value[ 0 ];
        switch ( _start ) {
            case PROPERTY.CONST.VALIDATOR.COMPLEX.BEGIN:
            case PROPERTY.CONST.VALIDATOR.COMPLEX.EQUAL:
            case PROPERTY.CONST.VALIDATOR.COMPLEX.NOT:
                this.containsUnexpectedOperators( messages, value.substring( 1 ) );
                this._parse_filter_expression( messages, value.substring( 1 ) );
                return true;
        }
        var _end = value[ value.length - 1 ];
        switch ( _end ) {
            case PROPERTY.CONST.VALIDATOR.COMPLEX.END:
                this._parse_filter_expression( messages, value.substring( 0, value.length - 1 ) );
                return true;
        }
    },
    parseSpecialValues                            : function ( messages, value ) {
        switch ( value ) {
            case PROPERTY.CONST.VALIDATOR.COMPLEX.NOT:
                messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_not_usable" ), value ) ) );
                return true;
            case PROPERTY.CONST.VALIDATOR.COMPLEX.EQUAL:
                messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( 'validator.filter.expression_only_equals' ) ) );
                return true;
            case PROPERTY.CONST.VALIDATOR.COMPLEX.OR:
            case PROPERTY.CONST.VALIDATOR.COMPLEX.AND:
                messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( 'validator.filter.expression_ends_with_operator' ) ) );
                return true;
            case PROPERTY.CONST.VALIDATOR.COMPLEX.BEGIN:
            case PROPERTY.CONST.VALIDATOR.COMPLEX.END:
                messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_only_operator" ), value ) ) );
                return true;
            case '>""':
            case '""<':
            case '""':
            case '!""':
            case '()':
                messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_useless" ), value ) ) );
                return true;
            case '=""':
                return true;
        }
    },
    _parse_filter_expression                      : function ( messages, value ) {
        //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", value );
        if ( typeof value !== "string" ) {
            return;
        }
        value = value.trim();
        if ( this.parseSpecialValues( messages, value ) ) {
            //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[1]", value );
            return;
        }
        
        var _original_value = SHINKEN.TOOLS.STRING.cleanXss( value );
        var _nb_caract      = value.length;
        
        var _indexes_QUOTES = SHINKEN.TOOLS.STRING.indexesOf( value, PROPERTY.CONST.VALIDATOR.COMPLEX.QUOTE );
        var _size_QUOTES    = _indexes_QUOTES.length;
        if ( _size_QUOTES % 2 ) {
            messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( "validator.filter.expression_quote_missing" ) ) );
            //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[2]", value );
            return;
        }
        
        if ( _size_QUOTES === 2 && this.isQuotedExpression( value ) ) {
            //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[3]", value );
            return;
        }
        var _indexes_open           = SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.OPENING_PARENTHESIS, _indexes_QUOTES );
        var _indexes_close          = SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.CLOSING_PARENTHESIS, _indexes_QUOTES );
        var _validation_parenthesis = SHINKEN.TOOLS.STRING.PARENTHESIS.isValid( _indexes_open, _indexes_close );
        if ( _validation_parenthesis ) {
            messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.for_expression" ), value, _validation_parenthesis ) ) );
            //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[4]", value );
            return;
        }
        var _indexes_parenthesis = SHINKEN.TOOLS.STRING.PARENTHESIS.getActiveIndexes( _indexes_open, _indexes_close );
        if ( _indexes_parenthesis.length === 2 && this.isParenthesisExpression( value ) ) {
            this._parse_filter_expression( messages, value.substring( 1, _nb_caract - 1 ) );
            return;
        }
        else if ( !this.hasOperatorBetweenParenthesis( messages, value, _indexes_parenthesis ) ) {
            messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_operator_missing" ), value ) ) );
            //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[6]", value );
            return;
        }
        
        
        var _indexes_AND = SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.AND, _indexes_QUOTES );
        var _indexes_OR  = SHINKEN.TOOLS.STRING.indexesOfNotBetween( value, PROPERTY.CONST.VALIDATOR.COMPLEX.OR, _indexes_QUOTES );
        if ( _indexes_parenthesis.length ) {
            _indexes_AND = SHINKEN.TOOLS.STRING.splicesindexesOfNotBetween( _indexes_AND, _indexes_parenthesis );
            _indexes_OR  = SHINKEN.TOOLS.STRING.splicesindexesOfNotBetween( _indexes_OR, _indexes_parenthesis );
        }
        var _indexes         = SHINKEN.TOOLS.ARRAY.concat( _indexes_AND, _indexes_OR );
        _indexes             = SHINKEN.TOOLS.ARRAY.sortNumber( _indexes );
        var _splitted_values = SHINKEN.TOOLS.STRING.splitWithIndexes( value, _indexes );
        var _size_i          = _splitted_values.length;
        if ( _size_i > 1 ) {
            for ( var i = 0; i < _size_i; i++ ) {
                if ( !_splitted_values[ i ] ) {
                    messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, _( "validator.filter.expression_two_successive_operators" ) ) );
                }
                else {
                    this._parse_filter_expression( messages, _splitted_values[ i ] );
                }
            }
            //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[7]", value );
            return;
        }
        else {
            if ( this.countOperators( messages, value ) > 1 ) {
                messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_multiple_modifiers" ), value ) ) );
                //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[8]", value );
                return;
            }
            else {
                if ( this.cleanOperator( messages, value ) ) {
                    //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[9]", value );
                    return;
                    
                }
                else if ( _size_QUOTES >= 2 && !SHINKEN.TOOLS.STRING.contains( value, PROPERTY.CONST.VALIDATOR.COMPLEX.STAR ) ) {
                    messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_syntax_error_quote" ), value ) ) );
                }
            }
        }
        if ( this.countOperators( messages, value ) ) {
            messages.push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "validator.filter.expression_middle_operator" ), "xxxx", _original_value ) ) );
        }
        this.containsUnexpectedOperators( messages, value );
        //console.log( "GSOU", "[SHINKEN_VALIDATOR_COMPLEX - _parse_filter_expression]", "[10]", value );
    }
};


