#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

### Will be populated by the UI with it's own value
app = None


def forge_response(callback, status, text):
    if callback:
        return "%s({'status':%s,'text':'%s'})" % (callback, status, text)
    else:
        return "{'status':%s,'text':'%s'}" % (status, text)


# We will always answer pong to a ping.
def get_ping():
    app.response.content_type = 'application/json'
    callback = app.request.query.get('callback', None)
    
    # We do not need to look at the user, should be public
    return forge_response(callback, 200, 'Pong')


# We will say if we got at least the first data, like contacts
# so the UI can refresh without breaking all.
def get_gotfirstdata():
    app.response.content_type = 'application/json'
    callback = app.request.query.get('callback', None)
    
    if len(app.datamgr.get_contacts()) > 0:
        return forge_response(callback, 200, '1')
    else:
        return forge_response(callback, 200, '0')


pages = {
    get_ping        : {'routes': ['/ping'], 'static': True, 'wrappers': []},
    get_gotfirstdata: {'routes': ['/gotfirstdata']},
}
