
try:
    import ssl
except ImportError:
    ssl = None

try:
    # Note: the cherrypy lib in ssl have a bug where socket_errors_to_ignore is not available
    # in the ssl part, so link it to the lib before load the ssl part
    from cherrypy.wsgiserver import wsgiserver2
    from cherrypy import wsgiserver as cheery_wsgiserver
    cheery_wsgiserver.socket_errors_to_ignore = wsgiserver2.socket_errors_to_ignore
except ImportError:
    cheery_wsgiserver = None

import shinken.webui.bottlewebui as bottle
from shinken.log import logger



# CherryPy is allowing us to have a HTTP 1.1 server, and so have a KeepAlive
class CherryPyServerHTTP(bottle.ServerAdapter):
    def run(self, handler):  # pragma: no cover
        daemon_thread_pool_size = 64
        server = cheery_wsgiserver.CherryPyWSGIServer((self.host, self.port), handler, numthreads=daemon_thread_pool_size, shutdown_timeout=1)
        logger.info('Initializing a CherryPy backend with %d threads' % daemon_thread_pool_size)
        use_ssl = self.options['use_ssl']
        ssl_cert = self.options['ssl_cert']
        ssl_key = self.options['ssl_key']

        if use_ssl:
            server.ssl_certificate = ssl_cert
            server.ssl_private_key = ssl_key

        return server

