#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.counter import Counter
from shinken.misc.type_hint import Callable, NoReturn
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.shinken_object import ShinkenObject


class InputStringComp(ShinkenObject):
    def __init__(self, translate, parent_name=""):
        # type: (Callable, str)-> None
        super(InputStringComp, self).__init__(translate)
        self.parent_name = parent_name
        self.type = "text"
        self.value = ""
        self.place_holder = ""
        self.is_protected = False
        self.data_type = False
        self.is_lock = False
        self.extra_class = ""
        self.extra_class_table = ""
        self.extra_attribute = ""
        self.extra_attribute_input = ""
        self.warning_counter = Counter("shinken-error-counter shinicon-cross-circle")
        self.error_counter = Counter("shinken-warning-counter shinicon-cross-circle")
    
    
    def set_value(self, to_set):
        # type: (str)-> NoReturn
        self.value = to_set
    
    
    def set_type(self, to_set):
        # type: (str)-> NoReturn
        self.type = to_set
    
    
    def set_place_holder(self, to_set):
        # type: (str)-> NoReturn
        self.place_holder = to_set
    
    
    def get_html(self, extra_content=""):
        # type: ()-> str
        # def get_input_html(self, input_type, value, data_type='', data_unit='', item_prop='', autocomplete='', placeholder='', type='', add_lock=False, add_attribute="", is_protected=False, extra_class_input="", extra_class_table="",
        #                    with_helper_tip=False):
        focus_html = ''
        if self.is_protected:
            focus_html = ' onfocus="MANAGER.EventManager.onFocus(this)" onfocusout="MANAGER.EventManager.onFocusOut(event)"'
        value = self.value.replace("'", "&apos;")
        _to_return = []
        
        if value == "":
            self.extra_class_table += ' shinken-empty-input'
        
        _to_return.append('''<table class="shinken-input-table shinken-width-100 %s" %s><tr>''' % (self.extra_class_table, self.get_html_tooltip()))
        
        if self.is_lock:
            _to_return.append('''    <td class="shinken-lock-cell"><span class="shinkon-lock"></span></td>''')
        _to_return.append('''   <td class="shinken-input-container-cell" %s>''' % self.extra_attribute)
        _to_return.append('''       <div class="shinken-input-container">''')
        if self.type == 'text':
            _to_return.append('''<input class="shinken-input %s" type="text" value='%s' ''' % (self.extra_class, self.value))
            _to_return.append('''placeholder="%s" %s onkeyup="MANAGER.EventManager.onChangeOnInput(event)" %s ''' % (self.place_holder, self.extra_attribute_input, focus_html))
            _to_return.append('''onclick="MANAGER.EventManager.clickOnInput(event)"> ''')
        elif self.type == 'textarea':
            _to_return.append('''<textarea rows="5" cols="80" class="shinken-input %s" data-name="%s" data-type="string" ''' % (self.extra_class, self.parent_name))
            _to_return.append('''type="text" value='%s' onkeyup="MANAGER.EventManager.onChangeOnInput(event)" shi-tip-placement="float-top-left"''' % self.value)
            _to_return.append('''placeholder="%s" %s>%s</textarea >''' % (self.place_holder, focus_html, self.value))
        # _to_return.append('''%s''' % self.error_counter.get_html())
        # _to_return.append('''%s''' % self.warning_counter.get_html())
        _to_return.append('''%s''' % extra_content)
        _to_return.append('''</div></td>''')
        _to_return.append('''</tr></table>''')
        return ' '.join(_to_return)
