#!/usr/bin/python

# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

"""
This module is to allow specific views that are using Glances daemon in the WebUI.
"""

import os

from shinken.basemodule import BaseModule
from shinken.log import logger

properties = {
    'daemons' : ['webui'],
    'type'    : 'webui_enterprise',
    'external': False,
}


# called by the plugin manager to get a broker
def get_instance(mod_conf):
    logger.info("[WebUI enterprise] Get an Enterprise WebUI module for plugin %s" % mod_conf.get_name())
    instance = WebUIEnterprise(mod_conf)
    return instance


class WebUIEnterprise(BaseModule):
    def __init__(self, mod_conf):
        BaseModule.__init__(self, mod_conf)
        self.webui = None


    # Called by Broker to say 'let's prepare yourself guy'
    def init(self):
        pass


    # Callbed by the webui module to load it
    def load(self, mod):
        self.webui = mod
        
        # We wil hook the webui to insert into it key things
        from shinkensolutions.crypto import are_keys_valid
        
        d = are_keys_valid()
        # (are_valid, nodes_limit, is_powerful, customer, customer_email, testing) = are_keys_valid()
        self.webui.enterprise_valid = d['are_valid']
        self.webui.enterprise_testing = d['testing']
        self.webui.enterprise_nodes_limit = d['nodes_limit']
        self.webui.customer = d['customer']
        self.webui.customer_email = d['customer_email']
        self.webui.key_duration = d['duration']
        self.webui.key_creation_time = d['creation_time']
        self.webui.is_duplicated_trial = d['is_duplicated_trial']
        self.webui.is_format_valid = d['is_format_valid']
        self.webui.is_present = d['is_present']
        
        logger.debug("[enterprise] webui hooked done")


    # Ok We got some plugins for WebUI, so give the info at WebUI :)
    def get_webui_plugins_path(self, webui):
        my_dir = os.path.os.path.dirname(__file__)
        plugins_dir = os.path.join(my_dir, 'plugins')
        return plugins_dir
