%img_sun = '/static/%s/sla/img/sun.svg' % app.http_start_time
%img_cloud = '/static/%s/sla/img/cloud.svg' % app.http_start_time
%img_storm = '/static/%s/sla/img/storm.svg' % app.http_start_time

%sla_value = item['sla'].get('ok', 0) * 100
%thresholds = item['sla']['thresholds']
%display_report_threshold = current_search['display_report_threshold']
%display_element_threshold = current_search['display_element_threshold']

%warn_threshold = '%.3f %%' % thresholds[0]
%crit_threshold = '%.3f %%' % thresholds[1]

<div class="{{_class}}">
    <div class="display-sla-percent-container">
        <span class="display-sla-percent-text">{{app._('reporting.sla')}} : {{"%.2f" % sla_value}}% </span>
        %if 99 <= sla_value:
            %img_sla = img_sun
        %elif 97 <= sla_value < 99:
            %img_sla = img_cloud
        %else:
            %img_sla = img_storm
        %end
        <img class="display-sla-percent-icon" src="{{img_sla}}">
    </div>
</div>
<div class="shinken-sla-threshold-container">
    <div>
        %if _type == 'sla-percent-report' and display_report_threshold:
            <div class="shinken-threshold-label">{{app._('reporting.report_threshold_label')}}</div>
        %end
        %if _type == 'sla-percent-range' and display_element_threshold:
            <div class="shinken-threshold-label">{{app._('reporting.period_threshold_label') % last_day}}</div>
        %end
        %if (_type == 'sla-percent-report' and display_report_threshold ) or (_type != 'sla-percent-report' and display_element_threshold ):
            <table>
                <tr>
                    <td><div class="shinken-threshold"><img class="shinken-sla-threshold-icon" src="{{img_storm}}">  SLA &lt; {{crit_threshold}} </div></td>
                </tr>
                <tr>
                    <td><div class="shinken-threshold"><img class="shinken-sla-threshold-icon" src="{{img_cloud}}"> {{crit_threshold}} &le; SLA &lt; {{warn_threshold}}  </div></td>
                </tr>
                <tr>
                    <td><div class="shinken-threshold"><img class="shinken-sla-threshold-icon" src="{{img_sun}}">  SLA &ge; {{warn_threshold}} </div></td>
                </tr>
            </table>
        %end
    </div>
</div>