%import time
%import json
%loop_time=10
%loop=False

%if code_http != 200:
    <head>
        <style type="text/css">
            @font-face {
                font-family : "shinkenicons";
                src         :
                        url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
                        url("/static/{{app.http_start_time}}/font/shinkenicons.ttf") format("truetype");
                font-weight : normal;
                font-style  : normal;
            }
        </style>
        <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinkon.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/unauthorized.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/graphs/css/widget_graphs.css" rel="stylesheet">

        <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/en.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/fr.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/main.js"></script>
        <script>function refresh(){location.reload();}</script>

        %if code_http == 403:
            <title>{{app._('unauthorized.403_title')}}</title>
        %elif code_http == 404:
            <title>{{app._('unauthorized.404_title')}}</title>
        %elif code_http == 401:
            <title>{{app._('unauthorized.401_title')}}</title>
        %elif code_http == 500:
            <title>{{app._('unauthorized.500_title')}}</title>
        %end
    </head>

    <body>
        <div class="unauthorized">
            %if code_http == 403:
                <div>{{app._('unauthorized.403_text')}}</div>
                <i class="shinkon-lock"></i>
            %elif code_http == 404:
                <div>{{app._('unauthorized.404_text')}}</div>
                <i class="shinkon-warning"></i>
            %elif code_http == 401:
                <div>{{app._('unauthorized.401_text')}}</div>
                <i class="shinkon-warning"></i>
            %elif code_http == 500:
                <div>{{app._('unauthorized.500_text')}}</div>
                <i class="shinkon-warning"></i>
            %end
        </div>
        <script>
            top.postMessage ( '{"code_http":"{{code_http}}", "uuid":"{{uuid}}"}', '*' );
        </script>
    </body>
%else:
    %helper = app.helper
    %datamgr = app.datamgr
    %rebase layout globals(), refresh=False, css=['depgraph/css/eltdeps_widget.css','css/unauthorized.css']

    <style>
        *{
            -moz-user-select: none;
            -webkit-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }
        #wrap{
            overflow-y:hidden;
        }
    </style>

    %# If height is specified, we can force a full page and not limit to a simple widget with border and co
    %if height != 670:
        %__top_offset = 0

        <style>
            html, body{
                height: {{height}}px;
            }
            #wrap{
                padding-right: 0px;
                padding-left:  0px;
                height: 100%!important;
            }
        </style>
    %else: ## widget case
        %__top_offset = 0
    %end

    <script type="text/javascript">
        top.postMessage ( '{{name_elt_info}}', '*' );
        var levelDistance = {{levelDistance}};
    </script>

    <script src='/static/{{app.http_start_time}}/depgraph/js/eltdeps.js'></script>

    %# HACK: we want this image to be loaded BEFORE the canvas, so it will be cached and accessible
    %# before other images, and so the print layer will be in the good order, so state img will be UPPER than this cloud thing.

    %# If you have a better solution (real layer lib?) I take it of course :)
    %# :: Jean

    <img id='aroundcluster' src='/static/{{app.http_start_time}}/depgraph/images/cloud.png' style='display:none'/>
    <img id='imgservice' src='/static/{{app.http_start_time}}/depgraph/images/check.png' style='display:none'/>

    %for s in ['ok', 'warning', 'critical', 'unknown', 'pending', 'up', 'down', 'unreachable', 'flapping', 'downtime', 'acknowledged', 'partial-acknowledged', 'partial-flapping', 'partial-downtime', 'inherited-downtime', 'inherited-acknowledged']:
        <img id='img_state_{{s}}' src='/static/{{app.http_start_time}}/img/icons/state_{{s}}_32x32.png' style='display:none'/>
    %end

    <img id='img_unauthorized' src='/static/{{app.http_start_time}}/img/icons/unauthorized_32x32.png' style='display:none'/>

    %g = json.loads(jgraph)

    %# precache tag img
    %for d in g:
        <img id='__void__' src='{{d['data']['img_src']}}' style='display:none'/>
    %end

    <!--%# take all problems-->
    <!--% pbs = [n for n in g if n['data']['is_problem'] ]-->

    %# take all error
    % has_color_cercle = [n for n in g if n['data']['circle'] != 'none']


    %if len(has_color_cercle) == 0:
        %cheight=height - __top_offset # for the header
    %else:
        %cheight=height - __top_offset -135 # header + bottom block
    %end

    %cwidth = width


    <script type="text/javascript">

        var levelDistance = {{levelDistance}};
        var back_color = '{{back_color}}';
        var levels = '{{deep}}';

        loadjscssfile('/static/{{app.http_start_time}}/depgraph/js/jit-yc.js', 'js');
        loadjscssfile('/static/{{app.http_start_time}}/depgraph/js/excanvas.js', 'js');

        // Now we hook teh global search thing
        $('.typeahead').typeahead({
            // note that "value" is the default setting for the property option
            source: function (typeahead, query) {
                $.ajax({ url: "/lookup/"+query, success: function (data){
                    typeahead.process(data)}
                });
            },
            onselect: function(obj) {
                $("ul.typeahead.dropdown-menu").find('li.active').data(obj);
            }
        });

        var graph = {{!jgraph}};
        $(document).ready(init_graph('{{elt.get_full_name()}}', graph, {{cwidth}}, {{cheight}},'{{helper.get_html_id(elt)}}'));

        /*
        Function to loop over important elements, on a time base. Need to call the page with
        ?loop=1 and if need &loop_time=10 (10s loop time is the basic)
        The loop is random, and it will add more size for large business impact elements.
        */
        function Loop_over_elements(){
            var important_elements = [];
            console.log('Start to loop over');
            $.each(graph, function(idx, elt){
                console.log(elt);
                d = elt.data.business_impact;
                if(d > 2){
                    var i = 0;
                    for (i=2; i<d; i++){
                        important_elements.push(elt.name);
                    }
                }
            });
            var elu = important_elements[Math.floor(Math.random() * important_elements.length)];
            change_rgraph_root(elu);
        }

        <!-- {{loop_time}} -->
        %if loop:
            $(document).ready(
                setInterval(Loop_over_elements, {{loop_time*1000}})
            );
        %end

    </script>

    <div id="right-container" class="border" style='display:none'>
        <div id="inner-details-{{helper.get_html_id(elt)}}" class="inner-details"></div>
    </div>

    <div class='infoviscont' style="overflow:hidden;width: {{cwidth}}px;height: {{cheight}}px;" id="infovis-{{helper.get_html_id(elt)}}"> </div>
    <div id="log" style='position:fixed; top:0px;'>{{app._('depgraph.loadingElements')}}</div>
    <div class="clear"></div>

    <!--%is_show = 0-->
    <!--%if len(pbs) > 0:-->
        <!--%is_show = 1-->
    <!--%end-->

    %is_show = 0
    %if len(has_color_cercle) > 0:
        %is_show = 1
    %end

    <div id="container-error-panel" class="span12" data-is-show="{{is_show}}" style="
        %if height != 670:
            border-bottom-left-radius: 7px;
            border-bottom-right-radius: 7px;
        %end
        ">
        <!--%if len(pbs) > 0:-->
        
        <!--<div class="title">{{app._('screens.problems')}}:</div>-->
        <div class="title">{{app._('error.error')}}:</div>
        <div class="content">
            <!--%for n in pbs:-->
            <!--%#if not n['data']['is_problem']:-->
                <!--%#continue-->
            <!--%#end-->
            %if len(has_color_cercle) > 0:
                %for n in has_color_cercle:
                    <div class="item-container">
                        <div class="item-title" onclick="javascript:select_root('{{n["id"]}}');" >{{!n['data']['infos']}}</div>
                    </div>
                %end
            %end
        </div>
        
    </div>

    <style>
        @media (max-width: 767px){
            .span3 {
                width: 49%!important;
                float:left!important;
            }
        }
    </style>

%#End of the Host Exist or not case
%end



